/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v81.BufferPoolUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBBufferPoolUDBv81
extends AbstractSSBUDB {
    private static final String EXCEPT_ON_DBPARTITIONNUMS = "EXCEPT ON DBPARTITIONNUMS";
    private static final String PAGESIZE = "PAGESIZE";
    private static final String EXTENDED_STORAGE = "EXTENDED STORAGE";
    public static final String ALL_DBPARTITIONNUMS = "ALL DBPARTITIONNUMS";
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof BufferPoolUDBv81 && ((BufferPoolUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        BufferPoolUDBv81 bufferPoolUDBv81 = (BufferPoolUDBv81)object;
        this.storageDesign = bufferPoolUDBv81.getStorageDesign();
        this.appendCreate(stringBuffer, bufferPoolUDBv81);
        this.appendCreateImmediate(stringBuffer, bufferPoolUDBv81);
        this.appendDBPartitionGroups(stringBuffer, bufferPoolUDBv81, bl);
        this.appendSize(stringBuffer, bufferPoolUDBv81, bl);
        this.appendPageSize(stringBuffer, bufferPoolUDBv81, bl);
        this.appendExtendedStorage(stringBuffer, bufferPoolUDBv81, bl);
        SSBBufferPoolUDBv81.appendNewLine(stringBuffer, bl, 0);
        DDLFileMaker.incrementCreateBufferPool();
        this.appendLineFinisher(stringBuffer, bl);
    }

    protected void appendCreate(StringBuffer stringBuffer, BufferPoolUDBv81 bufferPoolUDBv81) {
        this.appendCreate(stringBuffer);
        SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, "BUFFERPOOL");
        SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(bufferPoolUDBv81.getName()));
    }

    private void appendCreateImmediate(StringBuffer stringBuffer, BufferPoolUDBv81 bufferPoolUDBv81) {
        if ("NO".equalsIgnoreCase(bufferPoolUDBv81.getCreateImmediate())) {
            SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, "DEFERRED");
        } else {
            SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, "IMMEDIATE");
        }
    }

    protected void appendDBPartitionGroups(StringBuffer stringBuffer, BufferPoolUDBv81 bufferPoolUDBv81, boolean bl) {
        if (!bufferPoolUDBv81.getScope().equalsIgnoreCase("")) {
            SSBBufferPoolUDBv81.appendNewLine(stringBuffer, bl, 1);
            if (bufferPoolUDBv81.getScope().equalsIgnoreCase("")) {
                SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, ALL_DBPARTITIONNUMS);
            } else {
                SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, "DATABASE");
                SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, "GROUP");
                SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, bufferPoolUDBv81.getScope());
            }
        }
    }

    protected void appendSize(StringBuffer stringBuffer, BufferPoolUDBv81 bufferPoolUDBv81, boolean bl) {
        SSBBufferPoolUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, "SIZE");
        this.appendStringWithSpace(stringBuffer, bufferPoolUDBv81.getSize());
        if (!bufferPoolUDBv81.getNodesWithDiffSize().equalsIgnoreCase("")) {
            SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, EXCEPT_ON_DBPARTITIONNUMS);
            SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, '(');
            SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, bufferPoolUDBv81.getNodesWithDiffSize());
            SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendPageSize(StringBuffer stringBuffer, BufferPoolUDBv81 bufferPoolUDBv81, boolean bl) {
        if (bufferPoolUDBv81.getPageSize() > 0) {
            SSBBufferPoolUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, PAGESIZE);
            this.appendStringWithSpace(stringBuffer, bufferPoolUDBv81.getPageSize());
            SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, 'K');
        }
    }

    protected void appendExtendedStorage(StringBuffer stringBuffer, BufferPoolUDBv81 bufferPoolUDBv81, boolean bl) {
        if (bufferPoolUDBv81.getExtendedStorage()) {
            SSBBufferPoolUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBBufferPoolUDBv81.appendStringWithSpace(stringBuffer, EXTENDED_STORAGE);
        }
    }
}

