/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import java.util.List;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.ContainerUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TableSpaceUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableSpaceUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;
    public static final String PAGESIZE = "PAGESIZE";
    public static final String MANAGED_BY = "MANAGED BY";
    public static final String EXTENTSIZE = "EXTENTSIZE";
    public static final String PREFETCHSIZE = "PREFETCHSIZE";
    public static final String OVERHEAD = "OVERHEAD";
    public static final String TRANSFERRATE = "TRANSFERRATE";
    public static final String DROPPED_TABLE_RECOVERY = "DROPPED TABLE RECOVERY";
    public static final String ON_NODE = "ON NODE";
    public static final String ON_NODES = "ON NODES";

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableSpaceUDBv71 && ((TableSpaceUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        TableSpaceUDBv71 tableSpaceUDBv71 = (TableSpaceUDBv71)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        if (!tableSpaceUDBv71.getDBDefOnly()) {
            this.appendComment(stringBuffer, tableSpaceUDBv71);
            this.appendCreate(stringBuffer, tableSpaceUDBv71);
            this.appendNodeGroup(stringBuffer, tableSpaceUDBv71, bl);
            this.appendPageSize(stringBuffer, tableSpaceUDBv71, bl);
            this.appendManagedBy(stringBuffer, tableSpaceUDBv71);
            this.appendUsingContainer(stringBuffer, tableSpaceUDBv71, bl);
            this.appendExtentSize(stringBuffer, tableSpaceUDBv71, bl);
            this.appendPrefetchSize(stringBuffer, tableSpaceUDBv71, bl);
            this.appendBufferPool(stringBuffer, tableSpaceUDBv71, bl);
            this.appendOverhead(stringBuffer, tableSpaceUDBv71, bl);
            this.appendTransferRate(stringBuffer, tableSpaceUDBv71, bl);
            this.appendDroppedTableRecovery(stringBuffer, tableSpaceUDBv71, bl);
            SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            DDLFileMaker.incrementCreateTablespace();
            if (tableSpaceUDBv71.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendCommentOn(stringBuffer, tableSpaceUDBv71, bl);
            }
        }
        this.appendUsePrivileges(stringBuffer, tableSpaceUDBv71, bl);
    }

    private void appendCommentOn(StringBuffer stringBuffer, TableSpaceUDBv71 tableSpaceUDBv71, boolean bl) {
        SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 0);
        SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "COMMENT ON");
        SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "TABLESPACE");
        SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceUDBv71.getLongName()));
        SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "IS");
        SSBTableSpaceUDBv71.appendString(stringBuffer, '\'');
        SSBTableSpaceUDBv71.appendString(stringBuffer, tableSpaceUDBv71.getCommentInRDBMS());
        SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, '\'');
        SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
    }

    protected void appendCreate(StringBuffer stringBuffer, TableSpaceUDBv71 tableSpaceUDBv71) {
        this.appendCreate(stringBuffer);
        SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, tableSpaceUDBv71.getDataType());
        SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "TABLESPACE");
        SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceUDBv71.getName()));
    }

    protected void appendNodeGroup(StringBuffer stringBuffer, TableSpaceUDBv71 tableSpaceUDBv71, boolean bl) {
        if (tableSpaceUDBv71.getNodeGroup() != null) {
            SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "IN");
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "NODEGROUP");
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceUDBv71.getNodeGroup().getName()));
        }
    }

    protected void appendPageSize(StringBuffer stringBuffer, TableSpaceUDBv71 tableSpaceUDBv71, boolean bl) {
        if (tableSpaceUDBv71.getPageSize() > 0) {
            SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, PAGESIZE);
            this.appendStringWithSpace(stringBuffer, tableSpaceUDBv71.getPageSize());
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, 'K');
        }
    }

    protected void appendManagedBy(StringBuffer stringBuffer, TableSpaceUDBv71 tableSpaceUDBv71) {
        SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, MANAGED_BY);
        SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, tableSpaceUDBv71.getManagedBy());
    }

    protected void appendExtentSize(StringBuffer stringBuffer, TableSpaceUDBv71 tableSpaceUDBv71, boolean bl) {
        if (!"".equalsIgnoreCase(tableSpaceUDBv71.getExtentSize())) {
            SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, EXTENTSIZE);
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, tableSpaceUDBv71.getExtentSize());
        }
    }

    protected void appendPrefetchSize(StringBuffer stringBuffer, TableSpaceUDBv71 tableSpaceUDBv71, boolean bl) {
        if (!"".equalsIgnoreCase(tableSpaceUDBv71.getPrefetchSize())) {
            SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, PREFETCHSIZE);
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, tableSpaceUDBv71.getPrefetchSize());
        }
    }

    protected void appendBufferPool(StringBuffer stringBuffer, TableSpaceUDBv71 tableSpaceUDBv71, boolean bl) {
        if (tableSpaceUDBv71.getBufferPool() != null) {
            SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "BUFFERPOOL");
            this.appendStringWithSpace(stringBuffer, tableSpaceUDBv71.getBufferPool());
        }
    }

    protected void appendOverhead(StringBuffer stringBuffer, TableSpaceUDBv71 tableSpaceUDBv71, boolean bl) {
        if (tableSpaceUDBv71.getOverhead() > 0.0f) {
            SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, OVERHEAD);
            this.appendStringWithSpace(stringBuffer, tableSpaceUDBv71.getOverhead());
        }
    }

    protected void appendTransferRate(StringBuffer stringBuffer, TableSpaceUDBv71 tableSpaceUDBv71, boolean bl) {
        if (tableSpaceUDBv71.getTransferRate() > 0.0f) {
            SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, TRANSFERRATE);
            this.appendStringWithSpace(stringBuffer, tableSpaceUDBv71.getTransferRate());
        }
    }

    protected void appendDroppedTableRecovery(StringBuffer stringBuffer, TableSpaceUDBv71 tableSpaceUDBv71, boolean bl) {
        if (tableSpaceUDBv71.getDataType().equalsIgnoreCase("REGULAR")) {
            SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, DROPPED_TABLE_RECOVERY);
            this.appendOnOffWithSpace(stringBuffer, tableSpaceUDBv71.getDroppedTableRecovery());
        }
    }

    protected void appendUsingContainer(StringBuffer stringBuffer, TableSpaceUDBv71 tableSpaceUDBv71, boolean bl) {
        block6: {
            ContainerUDB[] containerUDBArray = tableSpaceUDBv71.getContainers();
            if (containerUDBArray.length <= 0) break block6;
            List list = tableSpaceUDBv71.getAllNodes();
            if (tableSpaceUDBv71.getManagedBy().equalsIgnoreCase("SYSTEM")) {
                for (int i = 0; i < list.size(); ++i) {
                    SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 1);
                    String string = list.get(i).toString();
                    ContainerUDB[] containerUDBArray2 = tableSpaceUDBv71.getContainersForNode(string);
                    SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "USING");
                    SSBTableSpaceUDBv71.appendString(stringBuffer, '(');
                    for (int j = 0; j < containerUDBArray2.length; ++j) {
                        ContainerUDBv71 containerUDBv71 = (ContainerUDBv71)containerUDBArray2[j];
                        SSBTableSpaceUDBv71.appendString(stringBuffer, containerUDBv71.getContainers().trim());
                        if (j >= containerUDBArray2.length - 1) continue;
                        stringBuffer.append(", ");
                    }
                    SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, ')');
                    if (string.equalsIgnoreCase("")) continue;
                    SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, ON_NODE);
                    SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, '(');
                    SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, string.trim());
                    SSBTableSpaceUDBv71.appendString(stringBuffer, ')');
                }
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 1);
                    String string = list.get(i).toString();
                    ContainerUDB[] containerUDBArray3 = tableSpaceUDBv71.getContainersForNode(string);
                    SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "USING");
                    SSBTableSpaceUDBv71.appendString(stringBuffer, '(');
                    for (int j = 0; j < containerUDBArray3.length; ++j) {
                        ContainerUDBv71 containerUDBv71 = (ContainerUDBv71)containerUDBArray3[j];
                        SSBTableSpaceUDBv71.appendString(stringBuffer, containerUDBv71.getContainers().trim());
                        if (j >= containerUDBArray3.length - 1) continue;
                        stringBuffer.append(", ");
                    }
                    SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, ')');
                    if (string.equalsIgnoreCase("")) continue;
                    SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, ON_NODE);
                    SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, '(');
                    SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, string);
                    SSBTableSpaceUDBv71.appendString(stringBuffer, ')');
                }
            }
        }
    }

    private void appendUsePrivileges(StringBuffer stringBuffer, TableSpaceUDB tableSpaceUDB, boolean bl) {
        if (!tableSpaceUDB.getUsers().equalsIgnoreCase("") || !tableSpaceUDB.getGroups().equalsIgnoreCase("")) {
            SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 0);
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "GRANT");
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "USE");
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "OF");
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceUDB.getName()));
            SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "TO");
            if (!tableSpaceUDB.getUsers().equalsIgnoreCase("")) {
                int n;
                for (n = 0; n < tableSpaceUDB.getUserSet().size(); ++n) {
                    if (n > 0) {
                        this.appendComma(stringBuffer);
                    }
                    if (!((String)tableSpaceUDB.getUserSet().elementAt(n)).trim().equalsIgnoreCase("PUBLIC")) {
                        SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "USER");
                    }
                    this.appendStringWithSpace(stringBuffer, tableSpaceUDB.getUserSet().elementAt(n));
                }
                if (!tableSpaceUDB.getGroups().equalsIgnoreCase("")) {
                    for (n = 0; n < tableSpaceUDB.getUserGroupSet().size(); ++n) {
                        this.appendComma(stringBuffer);
                        SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "GROUP");
                        this.appendStringWithSpace(stringBuffer, tableSpaceUDB.getUserGroupSet().elementAt(n));
                    }
                }
            } else {
                for (int i = 0; i < tableSpaceUDB.getUserGroupSet().size(); ++i) {
                    if (i > 0) {
                        this.appendComma(stringBuffer);
                    }
                    SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "GROUP");
                    this.appendStringWithSpace(stringBuffer, tableSpaceUDB.getUserGroupSet().elementAt(i));
                }
            }
            if ("YES".equalsIgnoreCase(tableSpaceUDB.getGrantOption())) {
                SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 1);
                SSBTableSpaceUDBv71.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
            }
            SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            SSBTableSpaceUDBv71.appendNewLine(stringBuffer, bl, 0);
        }
    }
}

