/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFK_CheckConstr;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.exports.ddl.udb.v71.SSBIndexProxyUDBv71;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.ColumnProxyUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TableProxyUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableProxyUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDBv71 storageDesign;
    private SSBIndexProxyUDBv71 ssbIndex = new SSBIndexProxyUDBv71();
    private static final String COMPACT = "COMPACT";
    private static final String LINK_TYPE_URL = "LINKTYPE URL";
    private static final String FILE_LINK_CONTROL = "FILE LINK CONTROL";
    private static final String INTEGRITY_ALL = "INTEGRITY ALL";
    private static final String READ_PERMISSION = "READ PERMISSION";
    private static final String WRITE_PERMISSION = "WRITE PERMISSION";
    private static final String ON_UNLINK = "ON UNLINK";
    private static final String INDEX_IN = "INDEX IN";
    private static final String LONG_IN = "LONG IN";
    private static final String PARTITIONING_KEY = "PARTITIONING KEY";
    private static final String USING_HASHING = "USING HASHING";
    private static final String NOT_LOGGED_INITIALLY = "NOT LOGGED INITIALLY";
    private SSBArcFK_CheckConstr arcConstrHandler;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxyUDB;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Table table = null;
        TableProxyUDBv71 tableProxyUDBv71 = null;
        if (object == null) {
            return;
        }
        if (object instanceof Table) {
            table = (Table)object;
            this.storageDesign = (StorageDesignUDBv71)this.getStorageDesign(object);
            tableProxyUDBv71 = (TableProxyUDBv71)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object instanceof TableProxyUDB) {
            tableProxyUDBv71 = (TableProxyUDBv71)object;
            table = (Table)tableProxyUDBv71.getObject();
            this.storageDesign = (StorageDesignUDBv71)this.getStorageDesign(object);
        }
        if (tableProxyUDBv71 != null && !tableProxyUDBv71.isMarkedGenerate()) {
            this.appendIndexes(stringBuffer, tableProxyUDBv71, bl);
            if (!table.isBST() || table.isRoot()) {
                this.appendPK(stringBuffer, tableProxyUDBv71, bl);
            }
            this.appendUK(stringBuffer, tableProxyUDBv71, bl);
            return;
        }
        if (table != null) {
            if (table.isBST()) {
                if (!table.isRoot() && table.getBasedOnStructuredType().getElements().length == 0 || table.isRoot() && table.getBasedOnStructuredType().getAllElements().size() == 0) {
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "--  ERROR: Table " + table.getName() + " is based on structured type without attributes");
                    SSBTableProxyUDBv71.appendNewLine(stringBuffer, true, 0);
                    DDLFileMaker.incrementErrors();
                    return;
                }
            } else if (table.getElementsCollection().size() == 0) {
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "--  ERROR: Table " + table.getName() + " doesn't have columns");
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, true, 0);
                DDLFileMaker.incrementErrors();
                return;
            }
            if (tableProxyUDBv71 != null && tableProxyUDBv71.isCommentChanged()) {
                this.appendComment(stringBuffer, tableProxyUDBv71);
            } else {
                this.appendComment(stringBuffer, table);
            }
            if (tableProxyUDBv71 != null && this.storageDesign.getFormatedName(tableProxyUDBv71.getName()).length() > tableProxyUDBv71.getMaxNameLength()) {
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, true, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + tableProxyUDBv71.getMaxNameLength() + ")");
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, true, 0);
                DDLFileMaker.incrementErrors();
            }
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            this.appendBeforeCreateScript(stringBuffer, bl, table);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "CREATE");
            if (tableProxyUDBv71 == null) {
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "TABLE");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(table.getLongName()));
                this.appendColumns(stringBuffer, table, null, bl);
            } else {
                if ("YES".equalsIgnoreCase(tableProxyUDBv71.getSummaryQuery())) {
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "SUMMARY");
                }
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "TABLE");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyUDBv71.getLongName()));
                if (table.isBST()) {
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "OF");
                    StructuredTypeProxyUDB structuredTypeProxyUDB = (StructuredTypeProxyUDB)this.storageDesign.getStructuredTypeProxySet().getProxy(table.getBasedOnStructuredType().getObjectID());
                    if (structuredTypeProxyUDB != null) {
                        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(structuredTypeProxyUDB.getName()));
                    } else {
                        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(table.getBasedOnStructuredType().getName()));
                    }
                    if (!table.isRoot() && table.isPartOfTypeSubstHierarchy()) {
                        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "UNDER");
                        TableProxyUDB tableProxyUDB = (TableProxyUDB)this.storageDesign.getTableProxySet().getProxy(table.getTypeSubstitution().getParentContainerObject().getObjectID());
                        if (tableProxyUDB != null) {
                            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyUDB.getLongName()));
                        } else {
                            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(table.getTypeSubstitution().getParentContainerObject().getName()));
                        }
                        SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "INHERIT");
                        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "SELECT");
                        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "PRIVILEGES");
                    } else if (table.isRoot() && !"".equalsIgnoreCase(tableProxyUDBv71.getHierarchyName())) {
                        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "HIERARCHY");
                        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, tableProxyUDBv71.getHierarchyName());
                    }
                    this.appendObjectTypeColProperties(stringBuffer, table, tableProxyUDBv71, bl);
                } else {
                    this.appendColumns(stringBuffer, table, tableProxyUDBv71, bl);
                    this.appendDataCapture(stringBuffer, tableProxyUDBv71, bl);
                    this.appendFederated(stringBuffer, tableProxyUDBv71, bl);
                    this.appendTableSpace(stringBuffer, tableProxyUDBv71, bl);
                    this.appendPartitioningKey(stringBuffer, tableProxyUDBv71, bl);
                    this.appendInitialLogging(stringBuffer, tableProxyUDBv71, bl);
                }
            }
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            DDLFileMaker.incrementCreateTable();
            if (tableProxyUDBv71 != null) {
                this.appendColumnCheckConstraints(stringBuffer, tableProxyUDBv71, bl);
                if (this.getArcConstrHandler() != null) {
                    this.getArcConstrHandler().appendArcConstraints(stringBuffer, tableProxyUDBv71, bl);
                }
                if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendTableCommentOn(stringBuffer, table, tableProxyUDBv71, bl);
                }
                this.appendIndexes(stringBuffer, tableProxyUDBv71, bl);
                if (!table.isBST() || table.isBST() && table.isRoot()) {
                    this.appendPK(stringBuffer, tableProxyUDBv71, bl);
                }
                this.appendUK(stringBuffer, tableProxyUDBv71, bl);
                if (table.getDesign().getAppView().getSettings().isGenerateTypeSubstTriggers()) {
                    this.appendInsertColumnSubstitutionTrigger(stringBuffer, table, tableProxyUDBv71, bl);
                    this.appendUpdateColumnSubstitutionTrigger(stringBuffer, table, tableProxyUDBv71, bl);
                }
            }
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            this.appendAfterCreateScript(stringBuffer, bl, table);
        }
    }

    protected void appendOidColumnDefinition(StringBuffer stringBuffer, Table table, TableProxyUDBv71 tableProxyUDBv71, boolean bl) {
        ContainedObject containedObject;
        if ((table.isRoot() || !table.isPartOfTypeSubstHierarchy()) && (containedObject = table.getOidElement()) != null) {
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv71.appendString(stringBuffer, '(');
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv71.appendString(stringBuffer, ' ');
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "REF");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "IS");
            ColumnProxy columnProxy = (ColumnProxy)this.storageDesign.getColumnProxySet().getProxy(containedObject.getObjectID());
            if (columnProxy != null) {
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()));
            } else {
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(containedObject.getName()));
            }
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "USER");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "GENERATED");
            this.appendColumnConstraints(stringBuffer, (Column)containedObject, (ColumnProxyUDB)columnProxy);
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv71.appendString(stringBuffer, ')');
        }
    }

    private void appendIndexes(StringBuffer stringBuffer, TableProxyUDB tableProxyUDB, boolean bl) {
        Iterator iterator = tableProxyUDB.getIndexes().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.ssbIndex.canHandle(e)) continue;
            this.ssbIndex.doAppend(stringBuffer, e, bl);
        }
        this.appendIndexesForConstraints(stringBuffer, (Table)tableProxyUDB.getObject(), tableProxyUDB);
    }

    private void appendPK(StringBuffer stringBuffer, TableProxy tableProxy, boolean bl) {
        Index index = (Index)((Table)tableProxy.getObject()).getPK();
        if (index != null && index.isMarkedGenerate()) {
            this.storageDesign = (StorageDesignUDBv71)this.getStorageDesign(tableProxy);
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            this.appendBeforeAlterScript(stringBuffer, bl, index.getTable());
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "ALTER");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "TABLE");
            SSBTableProxyUDBv71.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "ADD");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(index.getName()));
            SSBTableProxyUDBv71.appendString(stringBuffer, "PRIMARY KEY");
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            Column[] columnArray = (Column[])index.getElements();
            if (columnArray.length > 0) {
                SSBTableProxyUDBv71.appendString(stringBuffer, '(');
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                for (int i = 0; i < columnArray.length; ++i) {
                    if (i != 0) {
                        this.appendComma(stringBuffer);
                        SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                    }
                    SSBTableProxyUDBv71.appendString(stringBuffer, this.storageDesign.getFormatedName(columnArray[i].getName()));
                }
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                SSBTableProxyUDBv71.appendString(stringBuffer, ')');
            }
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            DDLFileMaker.incrementAlterTable();
            this.appendAfterAlterScript(stringBuffer, bl, index.getTable());
        }
    }

    private void appendUK(StringBuffer stringBuffer, TableProxy tableProxy, boolean bl) {
        Index[] indexArray = (Index[])((Table)tableProxy.getObject()).getKeys();
        if (indexArray.length > 0) {
            for (int i = 0; i < indexArray.length; ++i) {
                Index index = indexArray[i];
                if (!index.getIndexState().equalsIgnoreCase("Unique Constraint") || !index.isMarkedGenerate()) continue;
                this.storageDesign = (StorageDesignUDBv71)this.getStorageDesign(tableProxy);
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                this.appendBeforeAlterScript(stringBuffer, bl, index.getTable());
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "ALTER");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "TABLE");
                SSBTableProxyUDBv71.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "ADD");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(index.getName()));
                SSBTableProxyUDBv71.appendString(stringBuffer, "UNIQUE");
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                Column[] columnArray = (Column[])index.getElements();
                if (columnArray.length > 0) {
                    SSBTableProxyUDBv71.appendString(stringBuffer, '(');
                    SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                    for (int j = 0; j < columnArray.length; ++j) {
                        if (j != 0) {
                            this.appendComma(stringBuffer);
                            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                        }
                        SSBTableProxyUDBv71.appendString(stringBuffer, this.storageDesign.getFormatedName(columnArray[j].getName()));
                    }
                    SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                    SSBTableProxyUDBv71.appendString(stringBuffer, ')');
                }
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
                DDLFileMaker.incrementAlterTable();
                this.appendAfterAlterScript(stringBuffer, bl, index.getTable());
            }
        }
    }

    protected void appendColumns(StringBuffer stringBuffer, Table table, TableProxyUDBv71 tableProxyUDBv71, boolean bl) {
        Column[] columnArray = (Column[])table.getElements();
        Column column = null;
        ColumnProxyUDBv71 columnProxyUDBv71 = null;
        boolean bl2 = true;
        if (tableProxyUDBv71.getSummaryQuery().equalsIgnoreCase("NO")) {
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            if (columnArray.length < 1) {
                stringBuffer.append("-- No columns");
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            } else {
                for (int i = 0; i < columnArray.length; ++i) {
                    if (i == 0) {
                        SSBTableProxyUDBv71.appendString(stringBuffer, '(');
                    } else {
                        stringBuffer.append(", ");
                    }
                    bl2 = false;
                    SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                    if (tableProxyUDBv71 != null) {
                        column = columnArray[i];
                        columnProxyUDBv71 = (ColumnProxyUDBv71)tableProxyUDBv71.getColumnProxy(column.getObjectID());
                        if (this.storageDesign.getFormatedName(columnProxyUDBv71.getName()).length() > columnProxyUDBv71.getMaxNameLength()) {
                            SSBTableProxyUDBv71.appendNewLine(stringBuffer, true, 0);
                            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxyUDBv71.getMaxNameLength() + ")");
                            SSBTableProxyUDBv71.appendNewLine(stringBuffer, true, 0);
                            DDLFileMaker.incrementErrors();
                        }
                        if (columnProxyUDBv71.isCommentChanged() && !"".equalsIgnoreCase(columnProxyUDBv71.getComment())) {
                            this.appendComment(stringBuffer, columnProxyUDBv71);
                        } else if (!"".equalsIgnoreCase(columnProxyUDBv71.getObject().getComment())) {
                            this.appendComment(stringBuffer, columnProxyUDBv71.getObject());
                        }
                        this.appendColumnNameAndDataType(stringBuffer, columnProxyUDBv71, bl);
                        this.appendBitDataDefinition(stringBuffer, columnProxyUDBv71);
                        this.appendColumnScope(stringBuffer, column, columnProxyUDBv71, bl);
                        this.appendColumnNullsAllowed(stringBuffer, columnProxyUDBv71);
                        this.appendWithDefaultDefinition(stringBuffer, columnProxyUDBv71);
                        this.appendColumnLobOptions(stringBuffer, columnProxyUDBv71, bl);
                        this.appendColumnDatalinkOptions(stringBuffer, columnProxyUDBv71, bl);
                    }
                    if (column != null) {
                        this.appendColumnConstraints(stringBuffer, column, columnProxyUDBv71);
                    }
                    if (columnProxyUDBv71 == null) continue;
                    this.appendIdentityDefinition(stringBuffer, columnProxyUDBv71, bl);
                }
                this.appendTableConstraintsDefinition(stringBuffer, table, bl, bl2);
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                SSBTableProxyUDBv71.appendString(stringBuffer, ')');
            }
        } else {
            this.appendSummaryQuery(stringBuffer, table, tableProxyUDBv71, bl);
        }
    }

    private void appendSummaryQuery(StringBuffer stringBuffer, Table table, TableProxyUDBv71 tableProxyUDBv71, boolean bl) {
        if (tableProxyUDBv71 != null) {
            Column[] columnArray = (Column[])table.getElements();
            Column column = null;
            ColumnProxyUDBv71 columnProxyUDBv71 = null;
            if (columnArray.length > 0) {
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                for (int i = 0; i < columnArray.length; ++i) {
                    if (i == 0) {
                        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, '(');
                    } else {
                        this.appendComma(stringBuffer);
                    }
                    SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                    column = columnArray[i];
                    columnProxyUDBv71 = (ColumnProxyUDBv71)tableProxyUDBv71.getColumnProxy(column.getObjectID());
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyUDBv71.getName()));
                }
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, ')');
            }
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "AS");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, '(');
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, tableProxyUDBv71.getSummaryQueryDefinition());
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, ')');
            if (tableProxyUDBv71.getSummaryStatus().equalsIgnoreCase(TableProxyUDB.SUMMARY_STATUS_STATES[1])) {
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "DEFINITION");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "ONLY");
                this.appendCopyOptions(stringBuffer, tableProxyUDBv71, bl);
            } else {
                this.appendRefreshableTableOptions(stringBuffer, tableProxyUDBv71, bl);
            }
        }
    }

    private void appendRefreshableTableOptions(StringBuffer stringBuffer, TableProxyUDBv71 tableProxyUDBv71, boolean bl) {
        SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "DATA");
        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "INITIALLY");
        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "DEFERRED");
        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "REFRESH");
        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, tableProxyUDBv71.getSummaryRefreshOptions());
        SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, tableProxyUDBv71.getSummaryQueryOptimization());
        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "QUERY");
        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "OPTIMIZATION");
        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "MAINTAINED");
        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, tableProxyUDBv71.getSummaryMaintenance());
    }

    private void appendCopyOptions(StringBuffer stringBuffer, TableProxyUDBv71 tableProxyUDBv71, boolean bl) {
        SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
        if (!"NONE".equalsIgnoreCase(tableProxyUDBv71.getSummaryCopyColumnDefaults())) {
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, tableProxyUDBv71.getSummaryCopyColumnDefaults());
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "DEFAULTS");
        }
        SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, tableProxyUDBv71.getSummaryIdentityColumn());
        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "IDENTITY");
    }

    private void appendColumnNameAndDataType(StringBuffer stringBuffer, ColumnProxyUDBv71 columnProxyUDBv71, boolean bl) {
        SSBTableProxyUDBv71.appendString(stringBuffer, ' ');
        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyUDBv71.getName()));
        String string = columnProxyUDBv71.getDataTypeName();
        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, string);
        if (string.equalsIgnoreCase("unknown")) {
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "--  ERROR: Datatype UNKNOWN is not allowed");
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 5);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendWithDefaultDefinition(StringBuffer stringBuffer, ColumnProxyUDBv71 columnProxyUDBv71) {
        String string = columnProxyUDBv71.getDefaultValue();
        String string2 = columnProxyUDBv71.getDefaultValueConstant();
        boolean bl = columnProxyUDBv71.getDefault();
        if (bl) {
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "WITH");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "DEFAULT");
            if (!"".equalsIgnoreCase(string)) {
                if (string.equalsIgnoreCase(ColumnProxyUDB.getDefaultValueChoices()[1])) {
                    if (!"".equalsIgnoreCase(string2)) {
                        String string3 = columnProxyUDBv71.getColumn().getDatatypeString("DB2/UDB 7.1");
                        String string4 = this.addQuotesToDefault(string3, string2);
                        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, string4);
                    }
                } else if (string.equalsIgnoreCase(ColumnProxyUDB.getDefaultValueChoices()[4])) {
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, string2);
                } else {
                    String string5 = columnProxyUDBv71.getColumn().getDatatypeString("DB2/UDB 7.1");
                    String string6 = this.addQuotesToDefault(string5, string);
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, string6);
                }
            }
        }
    }

    private void appendColumnNullsAllowed(StringBuffer stringBuffer, ColumnProxyUDBv71 columnProxyUDBv71) {
        if (!columnProxyUDBv71.getNullsAllowed()) {
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "NOT NULL");
        }
    }

    private void appendColumnLobOptions(StringBuffer stringBuffer, ColumnProxyUDBv71 columnProxyUDBv71, boolean bl) {
        if (columnProxyUDBv71.checkLobColumnTypes(columnProxyUDBv71.getDataType())) {
            if (columnProxyUDBv71.getLogging().equalsIgnoreCase("NOT LOGGED")) {
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 2);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "NOT LOGGED");
            }
            if (columnProxyUDBv71.getCompact().equalsIgnoreCase("YES")) {
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 2);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, COMPACT);
            }
        }
    }

    private void appendColumnDatalinkOptions(StringBuffer stringBuffer, ColumnProxyUDBv71 columnProxyUDBv71, boolean bl) {
        if (columnProxyUDBv71.checkDLColumnTypes(columnProxyUDBv71.getColumn().getDataType("DB2/390 7"))) {
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 2);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, LINK_TYPE_URL);
            if (columnProxyUDBv71.getLinkControl().equalsIgnoreCase("FILE")) {
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, FILE_LINK_CONTROL);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, INTEGRITY_ALL);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, READ_PERMISSION);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, columnProxyUDBv71.getReadPermission());
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 2);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, WRITE_PERMISSION);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, columnProxyUDBv71.getWritePermission());
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "RECOVERY");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, columnProxyUDBv71.getRecovery().toUpperCase());
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 2);
                if (!columnProxyUDBv71.getWritePermission().equalsIgnoreCase("FS")) {
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, ON_UNLINK);
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, columnProxyUDBv71.getOnUnlink());
                }
            }
        }
    }

    private void appendTableConstraintsDefinition(StringBuffer stringBuffer, Table table, boolean bl, boolean bl2) {
        Iterator iterator = table.getCheckConstraints().iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            TableLevelConstraint tableLevelConstraint = (TableLevelConstraint)iterator.next();
            if (!bl2 || !bl3) {
                this.appendComma(stringBuffer);
            }
            bl3 = false;
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv71.appendString(stringBuffer, ' ');
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableLevelConstraint.getName()));
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableProxyUDBv71.appendString(stringBuffer, '(');
            SSBTableProxyUDBv71.appendString(stringBuffer, tableLevelConstraint.getRule());
            SSBTableProxyUDBv71.appendString(stringBuffer, ')');
        }
    }

    private void appendColumnConstraints(StringBuffer stringBuffer, Column column, ColumnProxyUDB columnProxyUDB) {
        String string;
        if (column.hasConstraintsDefined() && !"".equals(string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxyUDB.getName())))) {
            String string2 = column.getConstraintName();
            if (!string2.equals("") && string2.length() <= 18 || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "CHECK");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, '(');
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, string);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, ')');
            }
            if ("".equals(string2) || !"".equals(string2) && string2.length() > 18 || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "CHECK");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, '(');
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, string);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    protected void appendDataCapture(StringBuffer stringBuffer, TableProxyUDB tableProxyUDB, boolean bl) {
        if (!"NONE".equalsIgnoreCase(tableProxyUDB.getDataCapture())) {
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "DATA CAPTURE");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, tableProxyUDB.getDataCapture());
        }
    }

    protected void appendFederated(StringBuffer stringBuffer, TableProxyUDB tableProxyUDB, boolean bl) {
        if (!"NONE".equalsIgnoreCase(tableProxyUDB.getFederated())) {
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, tableProxyUDB.getFederated());
        }
    }

    protected void appendTableSpace(StringBuffer stringBuffer, TableProxyUDBv71 tableProxyUDBv71, boolean bl) {
        if (tableProxyUDBv71.getTableSpace() != null && !tableProxyUDBv71.getTableSpace().getDBDefOnly()) {
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "IN");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyUDBv71.getTableSpace().getLongName()));
            this.appendTableSpaceOptions(stringBuffer, tableProxyUDBv71);
        }
    }

    protected void appendTableSpaceOptions(StringBuffer stringBuffer, TableProxyUDBv71 tableProxyUDBv71) {
        if (tableProxyUDBv71.getIndexInTableSpace() != null) {
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, INDEX_IN);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyUDBv71.getIndexInTableSpace().getLongName()));
        }
        if (tableProxyUDBv71.getLongInTableSpace() != null) {
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, LONG_IN);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyUDBv71.getLongInTableSpace().getLongName()));
        }
    }

    protected void appendPartitioningKey(StringBuffer stringBuffer, TableProxyUDBv71 tableProxyUDBv71, boolean bl) {
        if (!"".equalsIgnoreCase(tableProxyUDBv71.getPartitioningKey())) {
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, PARTITIONING_KEY);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, '(');
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, tableProxyUDBv71.getPartitioningKey());
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, ')');
            if (tableProxyUDBv71.getPartKeyHashing()) {
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, USING_HASHING);
            }
        }
    }

    protected void appendInitialLogging(StringBuffer stringBuffer, TableProxyUDBv71 tableProxyUDBv71, boolean bl) {
        if (!tableProxyUDBv71.getInitialLogging()) {
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, NOT_LOGGED_INITIALLY);
        }
    }

    private void appendColumnCheckConstraints(StringBuffer stringBuffer, TableProxy tableProxy, boolean bl) {
        ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            Column column = columnProxy.getColumn();
            if (!column.hasConstraintsDefined()) continue;
            String string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName()));
            String string2 = column.getConstraintName();
            if ("".equals(string) || "".equals(string2) || string2.length() >= 19) continue;
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "ALTER");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "TABLE");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "ADD");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, '(');
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, string);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, ')');
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendTableCommentOn(StringBuffer stringBuffer, Table table, TableProxyUDB tableProxyUDB, boolean bl) {
        block6: {
            block5: {
                if (tableProxyUDB == null) break block5;
                this.appendCommentOn(stringBuffer, tableProxyUDB, bl);
                ColumnProxy[] columnProxyArray = tableProxyUDB.getColumnProxies();
                ColumnProxy columnProxy = null;
                for (int i = 0; i < columnProxyArray.length; ++i) {
                    String string;
                    columnProxy = columnProxyArray[i];
                    String string2 = "";
                    if (columnProxy.getCommentInRDBMS() != null && columnProxy.isCommentInRDBMSChanged()) {
                        string2 = columnProxy.getCommentInRDBMS();
                        string = columnProxy.getLongName();
                    } else {
                        string2 = columnProxy.getObject().getCommentInRDBMS();
                        string = ((Column)columnProxy.getObject()).getLongName();
                    }
                    if (string2.equalsIgnoreCase("")) continue;
                    SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "COMMENT ON");
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "COLUMN");
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "IS");
                    SSBTableProxyUDBv71.appendString(stringBuffer, '\'');
                    SSBTableProxyUDBv71.appendString(stringBuffer, string2);
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, '\'');
                    SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                    this.appendLineFinisher(stringBuffer, bl);
                }
                break block6;
            }
            if (table == null) break block6;
            if (table.getCommentInRDBMS() != null && !"".equalsIgnoreCase(table.getCommentInRDBMS())) {
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "COMMENT ON");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "TABLE");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(table.getLongName()));
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "IS");
                SSBTableProxyUDBv71.appendString(stringBuffer, '\'');
                SSBTableProxyUDBv71.appendString(stringBuffer, table.getCommentInRDBMS());
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, '\'');
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
            }
            ContainedObject[] containedObjectArray = table.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Column column = (Column)containedObjectArray[i];
                if (column.getCommentInRDBMS() == null || "".equalsIgnoreCase(column.getCommentInRDBMS())) continue;
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "COMMENT ON");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "COLUMN");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(column.getLongName()));
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "IS");
                SSBTableProxyUDBv71.appendString(stringBuffer, '\'');
                SSBTableProxyUDBv71.appendString(stringBuffer, column.getCommentInRDBMS());
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, '\'');
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
            }
        }
    }

    protected void appendIdentityDefinition(StringBuffer stringBuffer, ColumnProxyUDB columnProxyUDB, boolean bl) {
        if (columnProxyUDB.getUseIdentity()) {
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "GENERATED");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, columnProxyUDB.getGenerate());
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "AS");
            if (!"".equalsIgnoreCase(columnProxyUDB.getGenerationExpression().trim())) {
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, '(');
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, columnProxyUDB.getGenerationExpression());
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, ')');
            } else {
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "IDENTITY");
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 2);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, '(');
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 2);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "START");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "WITH");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, columnProxyUDB.getStartWith());
                this.appendComma(stringBuffer);
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 2);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "INCREMENT");
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "BY");
                this.appendStringWithSpace(stringBuffer, columnProxyUDB.getIncrementBy());
                this.appendComma(stringBuffer);
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 2);
                if ("NO".equalsIgnoreCase(columnProxyUDB.getCache())) {
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "NO");
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "CACHE");
                } else {
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "CACHE");
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, columnProxyUDB.getCache());
                }
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 2);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendObjectTypeColProperties(StringBuffer stringBuffer, Table table, TableProxyUDB tableProxyUDB, boolean bl) {
        if (table.isBST() && tableProxyUDB != null) {
            ModelIDObject modelIDObject;
            int n;
            ArrayList arrayList;
            boolean bl2 = false;
            if (table.isRoot()) {
                bl2 = true;
                arrayList = new ArrayList(table.getElementsCollection());
            } else {
                arrayList = table.getElementsByStructuredType(table.getBasedOnStructuredType());
            }
            if (table.isOidIsPK() && table.getOidPKColumns().size() > 0 || table.getCheckConstraints().size() > 0) {
                bl2 = true;
            }
            if (!bl2) {
                Column column;
                for (n = 0; n < arrayList.size() && !(bl2 = this.shouldGenerateObjectPropDefinition(column = (Column)arrayList.get(n), (ColumnProxyUDB)(modelIDObject = (ColumnProxyUDB)tableProxyUDB.getColumnProxy(column.getObjectID())))); n += 1) {
                }
            }
            if (bl2) {
                ContainedObject containedObject;
                n = 1;
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, '(');
                for (int i = 0; i < arrayList.size(); ++i) {
                    ColumnProxyUDB columnProxyUDB;
                    modelIDObject = (Column)arrayList.get(i);
                    if (!this.shouldGenerateObjectPropDefinition((Column)modelIDObject, columnProxyUDB = (ColumnProxyUDB)tableProxyUDB.getColumnProxy(modelIDObject.getObjectID()))) continue;
                    if (n == 0) {
                        this.appendComma(stringBuffer);
                    } else {
                        n = 0;
                    }
                    SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyUDB.getName()) + ' ' + "WITH OPTIONS ");
                    this.appendColumnNullsAllowed(stringBuffer, (ColumnProxyUDBv71)columnProxyUDB);
                    this.appendColumnScope(stringBuffer, (Column)modelIDObject, columnProxyUDB, bl);
                    this.appendColumnConstraints(stringBuffer, (Column)modelIDObject, columnProxyUDB);
                }
                if (table.getCheckConstraints().size() > 0) {
                    if (n == 0) {
                        this.appendComma(stringBuffer);
                    } else {
                        n = 0;
                    }
                    this.appendTableConstraintsDefinition(stringBuffer, table, bl, n != 0);
                }
                if (table.isOidIsPK() && table.isRoot()) {
                    if (n == 0) {
                        this.appendComma(stringBuffer);
                    } else {
                        n = 0;
                    }
                    this.appendPK_ObjectType(stringBuffer, table, tableProxyUDB, bl, table.getOidPKColumns().size() == 0);
                }
                if (table.isRoot() && (containedObject = table.getOidElement()) != null) {
                    if (n == 0) {
                        this.appendComma(stringBuffer);
                    } else {
                        n = 0;
                    }
                    SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "REF");
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "IS");
                    modelIDObject = (ColumnProxy)this.storageDesign.getColumnProxySet().getProxy(containedObject.getObjectID());
                    if (modelIDObject != null) {
                        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(((RelationalObjectProxy)modelIDObject).getName()));
                    } else {
                        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(containedObject.getName()));
                    }
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "USER");
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "GENERATED");
                }
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private boolean shouldGenerateObjectPropDefinition(Column column, ColumnProxyUDB columnProxyUDB) {
        if (column.isOid()) {
            return false;
        }
        if (!column.getNullsAllowed()) {
            return true;
        }
        String string = columnProxyUDB.getDefaultValue();
        if (string != null && !"".equalsIgnoreCase(string)) {
            return true;
        }
        if (column.getScope() != null) {
            return true;
        }
        if (!column.getAVTs().isEmpty()) {
            return true;
        }
        ConstraintEnumeration constraintEnumeration = column.getValueList();
        if (constraintEnumeration != null && !constraintEnumeration.isEmpty()) {
            return true;
        }
        CheckConstraint checkConstraint = column.getCheck();
        return checkConstraint != null;
    }

    private void appendPK_ObjectType(StringBuffer stringBuffer, Table table, TableProxy tableProxy, boolean bl, boolean bl2) {
        String string = tableProxy.getPKName();
        if (!"".equals(string)) {
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, '(');
            if (bl2) {
                ContainedObject containedObject = table.getOidElement();
                ColumnProxy columnProxy = tableProxy.getColumnProxy(containedObject.getObjectID());
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()));
            } else {
                boolean bl3 = true;
                for (Column column : table.getOidPKColumns()) {
                    String string2 = column.getName();
                    ColumnProxy columnProxy = tableProxy.getColumnProxy(column.getObjectID());
                    if (columnProxy != null) {
                        string2 = columnProxy.getName();
                    }
                    if (bl3) {
                        SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
                        bl3 = false;
                        continue;
                    }
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, ',');
                    SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
                }
            }
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendColumnScope(StringBuffer stringBuffer, Column column, ColumnProxy columnProxy, boolean bl) {
        if (column.getScope() != null) {
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 2);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "SCOPE");
            TableProxy tableProxy = (TableProxy)this.storageDesign.getStorageObject(column.getScope().getObjectID());
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
        }
    }

    private void appendInsertColumnSubstitutionTrigger(StringBuffer stringBuffer, Table table, TableProxy tableProxy, boolean bl) {
        List list = this.getColumnsWithRestrictedSubType(table);
        if (list.size() > 0) {
            boolean bl2 = true;
            String string = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                Column column = (Column)list.get(i);
                ColumnProxy columnProxy = tableProxy.getColumnProxy(column.getObjectID());
                String string2 = this.storageDesign.getFormatedName(columnProxy == null ? column.getName() : columnProxy.getName());
                arrayList.add(string2);
                if (bl2) {
                    string = string2;
                    bl2 = false;
                    continue;
                }
                string = string + ", " + string2;
            }
            if (!"".equals(string)) {
                String string3 = this.storageDesign.getFormatedName(COLUMN_INS_SUBST_TR_PREFIX + this.getStringWithMaxLength(tableProxy.getName(), 18 - COLUMN_INS_SUBST_TR_PREFIX.length()));
                if (tableProxy.getUserSchema() != null) {
                    string3 = this.storageDesign.getFormatedName(tableProxy.getUserSchema().getName()) + "." + string3;
                }
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "CREATE TRIGGER " + string3);
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "NO CASCADE BEFORE INSERT ON " + this.storageDesign.getFormatedName(tableProxy.getLongName()));
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "REFERENCING NEW AS N");
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "FOR EACH ROW MODE DB2SQL");
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "BEGIN ATOMIC");
                this.appendCWDColumnMeta(stringBuffer, list, bl);
                this.appendTriggerConditions(stringBuffer, list, arrayList, bl);
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "END");
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            }
        }
    }

    private void appendUpdateColumnSubstitutionTrigger(StringBuffer stringBuffer, Table table, TableProxy tableProxy, boolean bl) {
        List list = this.getColumnsWithRestrictedSubType(table);
        if (list.size() > 0) {
            boolean bl2 = true;
            String string = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                Column column = (Column)list.get(i);
                ColumnProxy columnProxy = tableProxy.getColumnProxy(column.getObjectID());
                String string2 = this.storageDesign.getFormatedName(columnProxy == null ? column.getName() : columnProxy.getName());
                arrayList.add(string2);
                if (bl2) {
                    string = string2;
                    bl2 = false;
                    continue;
                }
                string = string + ", " + string2;
            }
            if (!"".equals(string)) {
                String string3 = this.storageDesign.getFormatedName(COLUMN_UPD_SUBST_TR_PREFIX + this.getStringWithMaxLength(tableProxy.getName(), 18 - COLUMN_UPD_SUBST_TR_PREFIX.length()));
                if (tableProxy.getUserSchema() != null) {
                    string3 = this.storageDesign.getFormatedName(tableProxy.getUserSchema().getName()) + "." + string3;
                }
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "CREATE TRIGGER " + string3);
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "NO CASCADE BEFORE UPDATE OF " + string + " ON " + this.storageDesign.getFormatedName(tableProxy.getLongName()));
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "REFERENCING NEW AS N");
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "FOR EACH ROW MODE DB2SQL");
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "BEGIN ATOMIC");
                this.appendCWDColumnMeta(stringBuffer, list, bl);
                this.appendTriggerConditions(stringBuffer, list, arrayList, bl);
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "END");
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            }
        }
    }

    private void appendTriggerConditions(StringBuffer stringBuffer, List list, List list2, boolean bl) {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Column column = (Column)list.get(i);
            String string = (String)list2.get(i);
            String string2 = "";
            if (column.isAllowSubtypeSubstitution()) {
                object = column.getPermittedSubTypes().iterator();
                boolean bl2 = true;
                while (object.hasNext()) {
                    StructuredType structuredType = (StructuredType)object.next();
                    StructuredTypeProxy structuredTypeProxy = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(structuredType);
                    if (structuredTypeProxy == null || !structuredType.isInstantiable()) continue;
                    if (bl2) {
                        string2 = "ONLY " + this.storageDesign.getFormatedName(structuredTypeProxy.getLongName());
                        bl2 = false;
                        continue;
                    }
                    string2 = string2 + ", " + "ONLY" + " " + this.storageDesign.getFormatedName(structuredTypeProxy.getLongName());
                }
            } else {
                object = (StructuredType)column.getDataType();
                StructuredTypeProxy structuredTypeProxy = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy((DesignObject)object);
                if (structuredTypeProxy != null) {
                    string2 = "ONLY " + this.storageDesign.getFormatedName(structuredTypeProxy.getLongName());
                }
            }
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            if (column.isReference()) {
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, " IF deref(N." + string + ") IS NOT OF ( " + string2 + " ) THEN");
            } else {
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, " IF N." + string + " IS NOT OF ( " + string2 + " ) THEN");
            }
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "  signal SQLSTATE '85000' ('Column " + string + " - Only " + string2.replaceAll("ONLY ", "") + " are permited');");
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, " END IF;");
        }
    }

    private void appendCWDColumnMeta(StringBuffer stringBuffer, List list, boolean bl) {
        if (list.size() > 0) {
            SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "-- DO NOT DELETE OR MODIFY THE FOLLOWING COMMENTS");
        }
        for (int i = 0; i < list.size(); ++i) {
            Column column = (Column)list.get(i);
            for (StructuredType structuredType : column.getPermittedSubTypes()) {
                StructuredTypeProxy structuredTypeProxy = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(structuredType);
                String string = structuredType.getName();
                if (structuredTypeProxy != null) {
                    string = structuredTypeProxy.getLongName();
                }
                SSBTableProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                SSBTableProxyUDBv71.appendStringWithSpace(stringBuffer, "-- <cwd_ts_column column=\"" + column.getName() + "\" type=\"" + string + "\" />");
            }
        }
    }

    private void appendIndexesForConstraints(StringBuffer stringBuffer, Table table, TableProxy tableProxy) {
        KeyObject[] keyObjectArray = table.getKeys();
        boolean bl = table.getDesign().getDLSettings().isAutomaticPKGeneration();
        boolean bl2 = table.getDesign().getDLSettings().isAutomaticUKGeneration();
        boolean bl3 = table.getDesign().getDLSettings().isAutomaticFKGeneration();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            Index index;
            ContainedObject[] containedObjectArray;
            Index index2 = (Index)keyObjectArray[i];
            if (!(bl && "Primary Constraint".equals(index2.getIndexState()) || bl2 && "Unique Constraint".equals(index2.getIndexState())) && (!index2.isFK() || !bl3) || (containedObjectArray = index2.getElements()).length <= 0 || (index = this.getIndexForColumns(table, index2, containedObjectArray, false)) != null) continue;
            this.ssbIndex.appendIndexForConstraint(stringBuffer, index2, tableProxy, true);
        }
    }

    private Index getIndexForColumns(Table table, Index index, ContainedObject[] containedObjectArray, boolean bl) {
        Object[] objectArray = table.getIndexes().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObjectPlaceHolder designObjectPlaceHolder = (DesignObjectPlaceHolder)objectArray[i];
            Index index2 = (Index)designObjectPlaceHolder.getDesignObject();
            ContainedObject[] containedObjectArray2 = index2.getElements();
            if (containedObjectArray.length != containedObjectArray2.length) continue;
            boolean bl2 = false;
            for (int j = 0; j < containedObjectArray.length; ++j) {
                String string;
                if (containedObjectArray[j] != containedObjectArray2[j]) {
                    bl2 = true;
                    break;
                }
                if (!bl || "ASC".equalsIgnoreCase(string = index2.getColumnSortOrder(containedObjectArray2[j]).trim()) || "".equalsIgnoreCase(string)) continue;
                bl2 = true;
                break;
            }
            if (bl2 || index2 == index) continue;
            return index2;
        }
        return null;
    }

    public SSBArcFK_CheckConstr getArcConstrHandler() {
        if (this.arcConstrHandler == null && this.storageDesign != null) {
            this.arcConstrHandler = new SSBArcFK_CheckConstr(this.storageDesign);
        }
        return this.arcConstrHandler;
    }
}

