/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.SchemaUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSchemaUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchemaUDBv71 && ((SchemaUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        SchemaUDBv71 schemaUDBv71 = (SchemaUDBv71)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendComment(stringBuffer, schemaUDBv71);
        this.appendCreate(stringBuffer, schemaUDBv71);
        this.appendAuthorizationObject(stringBuffer, schemaUDBv71, bl);
        SSBSchemaUDBv71.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        DDLFileMaker.incrementCreateSchema();
        if (schemaUDBv71.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(stringBuffer, schemaUDBv71, bl);
        }
    }

    private void appendCommentOn(StringBuffer stringBuffer, SchemaUDBv71 schemaUDBv71, boolean bl) {
        SSBSchemaUDBv71.appendNewLine(stringBuffer, bl, 0);
        SSBSchemaUDBv71.appendStringWithSpace(stringBuffer, "COMMENT ON");
        SSBSchemaUDBv71.appendStringWithSpace(stringBuffer, "SCHEMA");
        SSBSchemaUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(schemaUDBv71.getLongName()));
        SSBSchemaUDBv71.appendStringWithSpace(stringBuffer, "IS");
        SSBSchemaUDBv71.appendString(stringBuffer, '\'');
        SSBSchemaUDBv71.appendString(stringBuffer, schemaUDBv71.getCommentInRDBMS());
        SSBSchemaUDBv71.appendStringWithSpace(stringBuffer, '\'');
        SSBSchemaUDBv71.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
    }

    protected void appendCreate(StringBuffer stringBuffer, SchemaUDBv71 schemaUDBv71) {
        this.appendCreate(stringBuffer);
        SSBSchemaUDBv71.appendStringWithSpace(stringBuffer, "SCHEMA");
        SSBSchemaUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(schemaUDBv71.getName()));
    }

    protected void appendAuthorizationObject(StringBuffer stringBuffer, SchemaUDBv71 schemaUDBv71, boolean bl) {
        if (schemaUDBv71.getOwner() != null && !schemaUDBv71.getOwner().isNullInstance()) {
            SSBSchemaUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBSchemaUDBv71.appendStringWithSpace(stringBuffer, "AUTHORIZATION");
            SSBSchemaUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(schemaUDBv71.getOwner().getName()));
        }
    }
}

