/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import java.util.ArrayList;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.IndexProxyUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexProxyUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDBv71 storageDesign;
    private static final String PCTFREE = "PCTFREE";
    private static final String MINPCTUSED = "MINPCTUSED";
    private static final String REVERSE_SCAN = "REVERSE SCANS";
    private static final String CLUSTER = "CLUSTER";
    private static final String UNIQUE = "UNIQUE";
    private static final String INCLUDE = "INCLUDE";

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxyUDBv71 && ((IndexProxyUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Index index = null;
        IndexProxyUDBv71 indexProxyUDBv71 = null;
        if (object instanceof Index) {
            index = (Index)object;
            this.storageDesign = (StorageDesignUDBv71)this.getStorageDesign(object);
            indexProxyUDBv71 = (IndexProxyUDBv71)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxyUDBv71) {
            indexProxyUDBv71 = (IndexProxyUDBv71)object;
            index = (Index)indexProxyUDBv71.getObject();
            this.storageDesign = (StorageDesignUDBv71)this.getStorageDesign(object);
        }
        if (indexProxyUDBv71 != null) {
            if (indexProxyUDBv71.isCommentChanged()) {
                this.appendComment(stringBuffer, indexProxyUDBv71);
            } else {
                this.appendComment(stringBuffer, indexProxyUDBv71.getObject());
            }
            this.appendCreate(stringBuffer, indexProxyUDBv71);
            this.appendOnTable(stringBuffer, indexProxyUDBv71, bl);
            this.appendInclude(stringBuffer, indexProxyUDBv71, bl);
            this.appendCluster(stringBuffer, indexProxyUDBv71, bl);
            this.appendPctfree(stringBuffer, indexProxyUDBv71, bl);
            this.appendMinPctfree(stringBuffer, indexProxyUDBv71, bl);
            this.appendReverseScan(stringBuffer, indexProxyUDBv71, bl);
            SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            DDLFileMaker.incrementCreateIndex();
            if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendIndexComment(stringBuffer, index, indexProxyUDBv71, bl);
            }
            this.appendPrivileges(stringBuffer, indexProxyUDBv71, bl);
        } else if (index != null && index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendIndexComment(stringBuffer, index, indexProxyUDBv71, bl);
        }
    }

    private void appendIndexComment(StringBuffer stringBuffer, Index index, IndexProxyUDBv71 indexProxyUDBv71, boolean bl) {
        if (indexProxyUDBv71 != null && indexProxyUDBv71.isCommentInRDBMSChanged()) {
            SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "COMMENT ON");
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "INDEX");
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyUDBv71.getLongName()));
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "IS");
            SSBIndexProxyUDBv71.appendString(stringBuffer, '\'');
            SSBIndexProxyUDBv71.appendString(stringBuffer, indexProxyUDBv71.getCommentInRDBMS());
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
        } else if (index != null && !"".equalsIgnoreCase(index.getCommentInRDBMS().trim())) {
            SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "COMMENT ON");
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "INDEX");
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(index.getLongName()));
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "IS");
            SSBIndexProxyUDBv71.appendString(stringBuffer, '\'');
            SSBIndexProxyUDBv71.appendString(stringBuffer, index.getCommentInRDBMS());
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
        }
    }

    protected void appendCreate(StringBuffer stringBuffer, IndexProxyUDBv71 indexProxyUDBv71) {
        this.appendCreate(stringBuffer);
        if (indexProxyUDBv71.isUnique()) {
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, UNIQUE);
        }
        SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "INDEX");
        SSBIndexProxyUDBv71.appendString(stringBuffer, this.storageDesign.getFormatedName(indexProxyUDBv71.getLongName()));
    }

    protected void appendOnTable(StringBuffer stringBuffer, IndexProxyUDBv71 indexProxyUDBv71, boolean bl) {
        ColumnProxy[] columnProxyArray;
        SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "ON");
        SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyUDBv71.getTableProxy().getLongName()));
        SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, '(');
        SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
        if (indexProxyUDBv71.getIndex().hasIndexExpression()) {
            SSBIndexProxyUDBv71.appendString(stringBuffer, "     ");
            SSBIndexProxyUDBv71.appendString(stringBuffer, indexProxyUDBv71.getIndex().getIndexExpression());
        }
        if ((columnProxyArray = indexProxyUDBv71.getColumnProxies()) != null) {
            for (int i = 0; i < columnProxyArray.length; ++i) {
                SSBIndexProxyUDBv71.appendString(stringBuffer, "     ");
                SSBIndexProxyUDBv71.appendString(stringBuffer, this.storageDesign.getFormatedName(columnProxyArray[i].getName()));
                SSBIndexProxyUDBv71.appendString(stringBuffer, " ");
                SSBIndexProxyUDBv71.appendString(stringBuffer, indexProxyUDBv71.getIndex().getColumnSortOrder(columnProxyArray[i].getColumn()));
                SSBIndexProxyUDBv71.appendString(stringBuffer, " ");
                if (i >= columnProxyArray.length - 1) continue;
                SSBIndexProxyUDBv71.appendString(stringBuffer, ",\n");
            }
        }
        SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, ')');
    }

    protected void appendInclude(StringBuffer stringBuffer, IndexProxyUDBv71 indexProxyUDBv71, boolean bl) {
        if (indexProxyUDBv71.isUnique() && !indexProxyUDBv71.getColumnList().equalsIgnoreCase("")) {
            SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, INCLUDE);
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, '(');
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, indexProxyUDBv71.getColumnList());
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendCluster(StringBuffer stringBuffer, IndexProxyUDBv71 indexProxyUDBv71, boolean bl) {
        if (indexProxyUDBv71.getCluster()) {
            SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, CLUSTER);
        }
    }

    protected void appendPctfree(StringBuffer stringBuffer, IndexProxyUDBv71 indexProxyUDBv71, boolean bl) {
        if (indexProxyUDBv71.getPercentageFree() > 0) {
            SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, PCTFREE);
            this.appendStringWithSpace(stringBuffer, indexProxyUDBv71.getPercentageFree());
        }
    }

    protected void appendMinPctfree(StringBuffer stringBuffer, IndexProxyUDBv71 indexProxyUDBv71, boolean bl) {
        if (indexProxyUDBv71.getMinimumPercentageUsed() > 0) {
            SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, MINPCTUSED);
            this.appendStringWithSpace(stringBuffer, indexProxyUDBv71.getMinimumPercentageUsed());
        }
    }

    protected void appendReverseScan(StringBuffer stringBuffer, IndexProxyUDBv71 indexProxyUDBv71, boolean bl) {
        SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
        this.appendAllowDisallowWithSpace(stringBuffer, indexProxyUDBv71.getReverseScanSupport());
        SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, REVERSE_SCAN);
    }

    private void appendPrivileges(StringBuffer stringBuffer, IndexProxyUDB indexProxyUDB, boolean bl) {
        if (!indexProxyUDB.getUsers().equalsIgnoreCase("") || !indexProxyUDB.getGroups().equalsIgnoreCase("")) {
            SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "GRANT");
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "CONTROL");
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "ON");
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "INDEX");
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyUDB.getName()));
            SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "TO");
            if (!indexProxyUDB.getUsers().equalsIgnoreCase("")) {
                int n;
                for (n = 0; n < indexProxyUDB.getUserSet().size(); ++n) {
                    if (n > 0) {
                        this.appendComma(stringBuffer);
                    }
                    if (!((String)indexProxyUDB.getUserSet().elementAt(n)).trim().equalsIgnoreCase("PUBLIC")) {
                        SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "USER");
                    }
                    this.appendStringWithSpace(stringBuffer, indexProxyUDB.getUserSet().elementAt(n));
                }
                if (!indexProxyUDB.getGroups().equalsIgnoreCase("")) {
                    for (n = 0; n < indexProxyUDB.getUserGroupSet().size(); ++n) {
                        this.appendComma(stringBuffer);
                        SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "GROUP");
                        this.appendStringWithSpace(stringBuffer, indexProxyUDB.getUserGroupSet().elementAt(n));
                    }
                }
            } else {
                for (int i = 0; i < indexProxyUDB.getUserGroupSet().size(); ++i) {
                    if (i > 0) {
                        this.appendComma(stringBuffer);
                    }
                    SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "GROUP");
                    this.appendStringWithSpace(stringBuffer, indexProxyUDB.getUserGroupSet().elementAt(i));
                }
            }
            SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
        }
    }

    public void appendIndexForConstraint(StringBuffer stringBuffer, Index index, TableProxy tableProxy, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        Index index2 = null;
        IndexProxy indexProxy = null;
        index2 = index;
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.getStorageDesign(index);
        if (index2.isFK()) {
            indexProxy = (IndexProxy)storageDesignUDB.getFKProxySet().getProxy(index2.getObjectID());
        }
        if (index2 != null && !index2.isOidKey()) {
            this.storageDesign = (StorageDesignUDBv71)tableProxy.getStorageDesign();
            if (indexProxy != null && indexProxy.isMarkedGenerate() || indexProxy == null && index2.isMarkedGenerate()) {
                if (index2.getElements().length > 0) {
                    String string2;
                    if (indexProxy != null && indexProxy.isCommentChanged()) {
                        this.appendComment(stringBuffer, indexProxy);
                    } else {
                        this.appendComment(stringBuffer, index2);
                    }
                    String string3 = string2 = index2.getName();
                    if (indexProxy != null) {
                        string3 = indexProxy.getLongName();
                    }
                    if (string2.length() < 18) {
                        string2 = string2 + "X";
                        string3 = string3 + "X";
                    }
                    if (string2.length() > 18) {
                        SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                        SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "--  ERROR: Index name length exceeds maximum allowed length(18)");
                        SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer2, "CREATE");
                    if ("Primary Constraint".equals(index2.getIndexState()) || "Unique Constraint".equals(index2.getIndexState())) {
                        SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer2, UNIQUE);
                    }
                    SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer2, "INDEX");
                    SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer2, storageDesignUDB.getFormatedName(string3));
                    string = stringBuffer2.toString();
                    this.appendTable(stringBuffer2, index2, true);
                    this.appendConstraintElementList(stringBuffer2, index2, tableProxy, true);
                    SSBIndexProxyUDBv71.appendNewLine(stringBuffer2, bl, 0);
                    this.appendLineFinisher(stringBuffer2, bl);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    DDLFileMaker.incrementCreateIndex();
                } else {
                    SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                    stringBuffer.append("-- Error - Index ");
                    stringBuffer.append(storageDesignUDB.getFormatedName(index2.getName()));
                    stringBuffer.append(" has no columns");
                    SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementErrors();
                }
            }
        }
    }

    private void appendConstraintElementList(StringBuffer stringBuffer, Index index, TableProxy tableProxy, boolean bl) {
        Object object2;
        ColumnProxy columnProxy = null;
        ArrayList<ColumnProxy> arrayList = new ArrayList<ColumnProxy>();
        for (Object object2 : index.getElementsCollectionImmutable()) {
            ColumnProxy columnProxy2 = tableProxy.getColumnProxy(((ModelIDObject)object2).getObjectID());
            if (columnProxy2 == null) continue;
            arrayList.add(columnProxy2);
        }
        object2 = arrayList.toArray();
        SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
        if (((Object)object2).length < 1) {
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "-- No Columns");
            SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
        }
        SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, '(');
        for (int i = 0; i < ((Object)object2).length; ++i) {
            if (i != 0) {
                SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, ',');
            }
            columnProxy = (ColumnProxy)object2[i];
            SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBIndexProxyUDBv71.appendString(stringBuffer, ' ');
            String string = this.storageDesign.getFormatedName(columnProxy.getName());
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, string);
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(columnProxy));
        }
        SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, ')');
    }

    protected void appendTable(StringBuffer stringBuffer, Index index, boolean bl) {
        Table table = (Table)index.getTopLevelContainer();
        TableProxy tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        SSBIndexProxyUDBv71.appendNewLine(stringBuffer, bl, 1);
        if (tableProxy != null) {
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, "ON");
            SSBIndexProxyUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
        }
    }
}

