/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v71.BufferPoolUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBBufferPoolUDBv71
extends AbstractSSBUDB {
    public static final String ALL_NODES = "ALL NODES";
    private static final String SIZE = "SIZE";
    private static final String EXCEPT_ON_NODES = "EXCEPT ON NODES";
    private static final String PAGESIZE = "PAGESIZE";
    private static final String EXTENDED_STORAGE = "EXTENDED STORAGE";
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof BufferPoolUDBv71 && ((BufferPoolUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        BufferPoolUDBv71 bufferPoolUDBv71 = (BufferPoolUDBv71)object;
        this.storageDesign = bufferPoolUDBv71.getStorageDesign();
        this.appendCreate(stringBuffer, bufferPoolUDBv71);
        this.appendNodeGroups(stringBuffer, bufferPoolUDBv71, bl);
        this.appendSize(stringBuffer, bufferPoolUDBv71, bl);
        this.appendPageSize(stringBuffer, bufferPoolUDBv71, bl);
        this.appendExtendedStorage(stringBuffer, bufferPoolUDBv71, bl);
        SSBBufferPoolUDBv71.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        DDLFileMaker.incrementCreateBufferPool();
    }

    protected void appendCreate(StringBuffer stringBuffer, BufferPoolUDBv71 bufferPoolUDBv71) {
        this.appendCreate(stringBuffer);
        SSBBufferPoolUDBv71.appendStringWithSpace(stringBuffer, "BUFFERPOOL");
        SSBBufferPoolUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(bufferPoolUDBv71.getName()));
    }

    protected void appendNodeGroups(StringBuffer stringBuffer, BufferPoolUDBv71 bufferPoolUDBv71, boolean bl) {
        if (!bufferPoolUDBv71.getScope().equalsIgnoreCase("")) {
            SSBBufferPoolUDBv71.appendNewLine(stringBuffer, bl, 1);
            if (bufferPoolUDBv71.getScope().equalsIgnoreCase("")) {
                SSBBufferPoolUDBv71.appendStringWithSpace(stringBuffer, ALL_NODES);
            } else {
                SSBBufferPoolUDBv71.appendStringWithSpace(stringBuffer, "NODEGROUP");
                SSBBufferPoolUDBv71.appendStringWithSpace(stringBuffer, bufferPoolUDBv71.getScope());
            }
        }
    }

    protected void appendSize(StringBuffer stringBuffer, BufferPoolUDBv71 bufferPoolUDBv71, boolean bl) {
        SSBBufferPoolUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBBufferPoolUDBv71.appendStringWithSpace(stringBuffer, SIZE);
        this.appendStringWithSpace(stringBuffer, bufferPoolUDBv71.getSize());
        if (!bufferPoolUDBv71.getNodesWithDiffSize().equalsIgnoreCase("")) {
            SSBBufferPoolUDBv71.appendStringWithSpace(stringBuffer, EXCEPT_ON_NODES);
            SSBBufferPoolUDBv71.appendStringWithSpace(stringBuffer, '(');
            SSBBufferPoolUDBv71.appendStringWithSpace(stringBuffer, bufferPoolUDBv71.getNodesWithDiffSize());
            SSBBufferPoolUDBv71.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendPageSize(StringBuffer stringBuffer, BufferPoolUDBv71 bufferPoolUDBv71, boolean bl) {
        if (bufferPoolUDBv71.getPageSize() > 0) {
            SSBBufferPoolUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBBufferPoolUDBv71.appendStringWithSpace(stringBuffer, PAGESIZE);
            this.appendStringWithSpace(stringBuffer, bufferPoolUDBv71.getPageSize());
            SSBBufferPoolUDBv71.appendStringWithSpace(stringBuffer, 'K');
        }
    }

    protected void appendExtendedStorage(StringBuffer stringBuffer, BufferPoolUDBv71 bufferPoolUDBv71, boolean bl) {
        if (bufferPoolUDBv71.getExtendedStorage()) {
            SSBBufferPoolUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBBufferPoolUDBv71.appendStringWithSpace(stringBuffer, EXTENDED_STORAGE);
        }
    }
}

