/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.LoginSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserSetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserSqlServerv2k5;

public class SSBLoginSqlServerv2k5
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        LoginSqlServerv2k5 loginSqlServerv2k5 = (LoginSqlServerv2k5)object;
        this.storageDesign = loginSqlServerv2k5.getStorageDesign();
        this.appendComment(stringBuffer, loginSqlServerv2k5);
        if (loginSqlServerv2k5.getAuthentication().equalsIgnoreCase("WINDOWS")) {
            this.appendGrantLogin(stringBuffer, loginSqlServerv2k5, bl);
            this.appendDefaultDB(stringBuffer, loginSqlServerv2k5, bl);
            this.appendDefaultLanguage(stringBuffer, loginSqlServerv2k5, bl);
        } else {
            this.appendAddLogin(stringBuffer, loginSqlServerv2k5, bl);
        }
        this.appendGrantUsersDBAccess(stringBuffer, loginSqlServerv2k5, bl);
        UserSetSqlServerv2k5 userSetSqlServerv2k5 = (UserSetSqlServerv2k5)((StorageDesignSqlServerv2k5)loginSqlServerv2k5.getStorageDesign()).getUserSet();
        for (int i = 0; i < loginSqlServerv2k5.getUserSet().size(); ++i) {
            this.appendPrivileges(stringBuffer, (UserSqlServerv2k5)userSetSqlServerv2k5.getByName((String)loginSqlServerv2k5.getUserSet().get(i)), bl);
        }
    }

    private void appendGrantLogin(StringBuffer stringBuffer, LoginSqlServerv2k5 loginSqlServerv2k5, boolean bl) {
        SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
        SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_grantlogin");
        SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
        SSBLoginSqlServerv2k5.appendString(stringBuffer, loginSqlServerv2k5.getName());
        SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
        SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "GO");
        SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
    }

    private void appendDefaultDB(StringBuffer stringBuffer, LoginSqlServerv2k5 loginSqlServerv2k5, boolean bl) {
        if (loginSqlServerv2k5.getDefaultDatabase() != null) {
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_defaultdb");
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k5.appendString(stringBuffer, loginSqlServerv2k5.getName());
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            this.appendComma(stringBuffer);
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            this.appendString(stringBuffer, loginSqlServerv2k5.getDefaultDatabase());
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "GO");
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendDefaultLanguage(StringBuffer stringBuffer, LoginSqlServerv2k5 loginSqlServerv2k5, boolean bl) {
        if (loginSqlServerv2k5.getLanguage() != null) {
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_defaultlanguage");
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k5.appendString(stringBuffer, loginSqlServerv2k5.getName());
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            this.appendComma(stringBuffer);
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k5.appendString(stringBuffer, loginSqlServerv2k5.getLanguage());
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "GO");
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendAddLogin(StringBuffer stringBuffer, LoginSqlServerv2k5 loginSqlServerv2k5, boolean bl) {
        if (loginSqlServerv2k5.getDefaultDatabase() != null) {
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_addlogin");
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k5.appendString(stringBuffer, loginSqlServerv2k5.getName());
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            this.appendComma(stringBuffer);
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k5.appendString(stringBuffer, loginSqlServerv2k5.decodePassword());
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            this.appendComma(stringBuffer);
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k5.appendString(stringBuffer, loginSqlServerv2k5.getDefaultDatabase().getName());
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            if (loginSqlServerv2k5.getLanguage() != null) {
                this.appendComma(stringBuffer);
                SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBLoginSqlServerv2k5.appendString(stringBuffer, loginSqlServerv2k5.getLanguage());
                SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            }
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "GO");
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        } else {
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "-- Invalid login (without specified DB)");
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(loginSqlServerv2k5.getName()));
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendGrantUsersDBAccess(StringBuffer stringBuffer, LoginSqlServerv2k5 loginSqlServerv2k5, boolean bl) {
        UserSetSqlServerv2k5 userSetSqlServerv2k5 = (UserSetSqlServerv2k5)((StorageDesignSqlServerv2k5)loginSqlServerv2k5.getStorageDesign()).getUserSet();
        UserSqlServerv2k5 userSqlServerv2k5 = null;
        for (String string : loginSqlServerv2k5.getUserSet()) {
            userSqlServerv2k5 = (UserSqlServerv2k5)userSetSqlServerv2k5.getByName(string);
            if (userSqlServerv2k5 != null && userSqlServerv2k5.getDatabase() != null && !userSqlServerv2k5.getDatabase().isNullInstance()) {
                SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "USE");
                SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, userSqlServerv2k5.getDatabase().getName());
                SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "GO");
                SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            }
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_grantdbaccess");
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k5.appendString(stringBuffer, loginSqlServerv2k5.getName());
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            this.appendComma(stringBuffer);
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k5.appendString(stringBuffer, string);
            SSBLoginSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "GO");
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendPrivileges(StringBuffer stringBuffer, UserSqlServerv2k5 userSqlServerv2k5, boolean bl) {
        if (!"".equalsIgnoreCase(userSqlServerv2k5.getSystemPrivileges())) {
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            if (userSqlServerv2k5.getDatabase() != null && !userSqlServerv2k5.getDatabase().isNullInstance()) {
                SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "USE");
                this.appendStringWithSpace(stringBuffer, userSqlServerv2k5.getDatabase());
                SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                SSBLoginSqlServerv2k5.appendString(stringBuffer, "GO");
                SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            }
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "GRANT");
            if (userSqlServerv2k5.getPrivilegesSet().contains("ALL")) {
                SSBLoginSqlServerv2k5.appendString(stringBuffer, "ALL");
            } else {
                SSBLoginSqlServerv2k5.appendString(stringBuffer, userSqlServerv2k5.getSystemPrivileges());
            }
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBLoginSqlServerv2k5.appendStringWithSpace(stringBuffer, "TO");
            this.appendString(stringBuffer, userSqlServerv2k5);
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k5.appendString(stringBuffer, "GO");
            SSBLoginSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof LoginSqlServerv2k5 && ((LoginSqlServerv2k5)object).getBeforeDefaults() && ((LoginSqlServerv2k5)object).isMarkedGenerate();
    }
}

