/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexSqlServerv2k5
extends AbstractSSBSqlServer {
    StorageDesignSqlServerv2k5 storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Index index = null;
        IndexProxySqlServerv2k5 indexProxySqlServerv2k5 = null;
        if (object instanceof Index) {
            index = (Index)object;
            this.storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign(object);
            indexProxySqlServerv2k5 = (IndexProxySqlServerv2k5)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxySqlServer) {
            indexProxySqlServerv2k5 = (IndexProxySqlServerv2k5)object;
            index = (Index)indexProxySqlServerv2k5.getObject();
            this.storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign(object);
        }
        if (indexProxySqlServerv2k5 != null && indexProxySqlServerv2k5.isCommentChanged()) {
            this.appendComment(stringBuffer, indexProxySqlServerv2k5);
        } else {
            this.appendComment(stringBuffer, index);
        }
        if (indexProxySqlServerv2k5 != null) {
            if (indexProxySqlServerv2k5.isMarkedGenerate()) {
                SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "CREATE");
                this.appendUnique(stringBuffer, indexProxySqlServerv2k5);
                this.appendClustered(stringBuffer, indexProxySqlServerv2k5);
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "INDEX");
                SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxySqlServerv2k5.getLongName()));
                this.appendTable(stringBuffer, indexProxySqlServerv2k5, bl);
                this.appendIncludeColumn(stringBuffer, indexProxySqlServerv2k5, bl);
                this.appendOptions(stringBuffer, indexProxySqlServerv2k5, bl);
                this.appendFilegroup(stringBuffer, indexProxySqlServerv2k5, bl);
                SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "GO");
                DDLFileMaker.incrementCreateIndex();
                SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendIndexComment(stringBuffer, index, indexProxySqlServerv2k5, bl);
                }
                this.appendExtProperties(stringBuffer, indexProxySqlServerv2k5, bl);
            } else if (index.hasIndexExpression()) {
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, index.getIndexExpression());
            } else {
                stringBuffer.append("-- Index ").append(index.getName()).append(" on Table ").append(indexProxySqlServerv2k5.getTableName()).append(" not created in ddl");
                SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            }
        } else if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendIndexComment(stringBuffer, index, indexProxySqlServerv2k5, bl);
        }
    }

    private void appendIncludeColumn(StringBuffer stringBuffer, IndexProxySqlServerv2k5 indexProxySqlServerv2k5, boolean bl) {
        if (!indexProxySqlServerv2k5.getIncludeColumns().equalsIgnoreCase("")) {
            boolean bl2 = false;
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "INCLUDE");
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '(');
            Column[] columnArray = (Column[])indexProxySqlServerv2k5.getTable().getElements();
            for (int i = 0; i < columnArray.length; ++i) {
                if (!indexProxySqlServerv2k5.getIncludeColumnsSet().contains(columnArray[i].getObjectID())) continue;
                if (bl2) {
                    this.appendComma(stringBuffer);
                }
                this.appendStringWithSpace(stringBuffer, columnArray[i]);
                bl2 = true;
            }
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendIndexComment(StringBuffer stringBuffer, Index index, IndexProxySqlServer indexProxySqlServer, boolean bl) {
        String string = null;
        String string2 = null;
        if (indexProxySqlServer != null && indexProxySqlServer.isCommentInRDBMSChanged()) {
            string = indexProxySqlServer.getCommentInRDBMS();
            string2 = indexProxySqlServer.getTableProxy().getName();
        } else if (index != null) {
            string = index.getCommentInRDBMS();
            string2 = index.getContainerObject().getName();
        }
        if (string != null && !string.trim().equalsIgnoreCase("")) {
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBIndexSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBIndexSqlServerv2k5.appendString(stringBuffer, string);
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            if (indexProxySqlServer != null && ((TableProxySqlServer)indexProxySqlServer.getTableProxy()).getUser() != null) {
                SSBIndexSqlServerv2k5.appendString(stringBuffer, "'user'");
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                SSBIndexSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBIndexSqlServerv2k5.appendString(stringBuffer, ((TableProxySqlServer)indexProxySqlServer.getTableProxy()).getUser().getName());
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            }
            SSBIndexSqlServerv2k5.appendString(stringBuffer, "'table'");
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBIndexSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBIndexSqlServerv2k5.appendString(stringBuffer, string2);
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBIndexSqlServerv2k5.appendString(stringBuffer, "'index'");
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBIndexSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBIndexSqlServerv2k5.appendString(stringBuffer, index.getName());
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBIndexSqlServerv2k5.appendString(stringBuffer, "GO");
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendUnique(StringBuffer stringBuffer, IndexProxySqlServerv2k5 indexProxySqlServerv2k5) {
        if (indexProxySqlServerv2k5.getUnique().equalsIgnoreCase("YES")) {
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "UNIQUE");
        }
    }

    private void appendClustered(StringBuffer stringBuffer, IndexProxySqlServerv2k5 indexProxySqlServerv2k5) {
        if (indexProxySqlServerv2k5.isClustered()) {
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "CLUSTERED");
        } else {
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "NONCLUSTERED");
        }
    }

    private void appendTable(StringBuffer stringBuffer, IndexProxy indexProxy, boolean bl) {
        SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "ON");
        SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxy.getTableProxy().getLongName()));
        SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
        SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '(');
        SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
        if (indexProxy.getIndex().hasIndexExpression()) {
            SSBIndexSqlServerv2k5.appendString(stringBuffer, ' ');
            SSBIndexSqlServerv2k5.appendString(stringBuffer, indexProxy.getIndex().getIndexExpression());
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
        }
        ColumnProxy[] columnProxyArray = indexProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            String string = "";
            if (columnProxyArray[i].getObject() != null) {
                string = ((Index)indexProxy.getObject()).getColumnSortOrder(columnProxyArray[i].getObject());
            }
            SSBIndexSqlServerv2k5.appendString(stringBuffer, ' ');
            if ("DESC".equalsIgnoreCase(string)) {
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyArray[i].getName()) + " " + string);
            } else {
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyArray[i].getName()));
            }
            if (i != columnProxyArray.length - 1) {
                this.appendComma(stringBuffer);
            }
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
        }
        SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, ')');
    }

    private void appendOptions(StringBuffer stringBuffer, IndexProxySqlServerv2k5 indexProxySqlServerv2k5, boolean bl) {
        if (indexProxySqlServerv2k5.getFillFactor() > 0 || indexProxySqlServerv2k5.getIgnoreDupKey().equalsIgnoreCase("YES") || indexProxySqlServerv2k5.getRecomputeStatistics().equalsIgnoreCase("OFF") || indexProxySqlServerv2k5.getSortInTempDB().equalsIgnoreCase("YES")) {
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "WITH");
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '(');
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBIndexSqlServerv2k5.appendSpace(stringBuffer);
            boolean bl2 = false;
            if (indexProxySqlServerv2k5.getFillFactor() > 0) {
                if (indexProxySqlServerv2k5.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "PAD_INDEX");
                    SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '=');
                    SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "ON");
                    this.appendComma(stringBuffer);
                    SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                    SSBIndexSqlServerv2k5.appendSpace(stringBuffer);
                }
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "FILLFACTOR");
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '=');
                this.appendStringWithSpace(stringBuffer, indexProxySqlServerv2k5.getFillFactor());
                bl2 = true;
            }
            if (bl2) {
                this.appendComma(stringBuffer);
                SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                SSBIndexSqlServerv2k5.appendSpace(stringBuffer);
            }
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "IGNORE_DUP_KEY");
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '=');
            if (indexProxySqlServerv2k5.getIgnoreDupKey().equalsIgnoreCase("YES")) {
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "ON");
            } else {
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "OFF");
            }
            this.appendComma(stringBuffer);
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBIndexSqlServerv2k5.appendSpace(stringBuffer);
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "STATISTICS_NORECOMPUTE");
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '=');
            if (indexProxySqlServerv2k5.getRecomputeStatistics().equalsIgnoreCase("OFF")) {
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "ON");
            } else {
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "OFF");
            }
            this.appendComma(stringBuffer);
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBIndexSqlServerv2k5.appendSpace(stringBuffer);
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "SORT_IN_TEMPDB");
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '=');
            if (indexProxySqlServerv2k5.getSortInTempDB().equalsIgnoreCase("YES")) {
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "ON");
            } else {
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "OFF");
            }
            this.appendComma(stringBuffer);
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBIndexSqlServerv2k5.appendSpace(stringBuffer);
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "ALLOW_ROW_LOCKS");
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '=');
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, indexProxySqlServerv2k5.getAllowRowLocks());
            this.appendComma(stringBuffer);
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBIndexSqlServerv2k5.appendSpace(stringBuffer);
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "ALLOW_PAGE_LOCKS");
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '=');
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, indexProxySqlServerv2k5.getAllowPageLocks());
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBIndexSqlServerv2k5.appendString(stringBuffer, ')');
        }
    }

    private void appendFilegroup(StringBuffer stringBuffer, IndexProxySqlServerv2k5 indexProxySqlServerv2k5, boolean bl) {
        SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
        SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "ON");
        if (indexProxySqlServerv2k5.getPartitionScheme() != null) {
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxySqlServerv2k5.getPartitionScheme().getName()));
            if (indexProxySqlServerv2k5.getPartitioningColumn() != null) {
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '(');
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxySqlServerv2k5.getPartitioningColumn().getName()));
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, ')');
            }
        } else if (indexProxySqlServerv2k5.getFilegroup() != null && indexProxySqlServerv2k5.getPartitionScheme() == null) {
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxySqlServerv2k5.getFilegroup().getName()));
        } else {
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "\"default\"");
        }
    }

    private void appendExtProperties(StringBuffer stringBuffer, IndexProxySqlServerv2k5 indexProxySqlServerv2k5, boolean bl) {
        if (!indexProxySqlServerv2k5.getProps().trim().equalsIgnoreCase("") && ((TableProxySqlServer)indexProxySqlServerv2k5.getTableProxy()).getUser() != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(indexProxySqlServerv2k5.getProps().trim(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, string);
                this.appendComma(stringBuffer);
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, string2);
                String string3 = "";
                string3 = ((TableProxySqlServer)indexProxySqlServerv2k5.getTableProxy()).getUser().getName();
                this.appendComma(stringBuffer);
                SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "'user'");
                this.appendComma(stringBuffer);
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string3));
                this.appendComma(stringBuffer);
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "'table'");
                this.appendComma(stringBuffer);
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxySqlServerv2k5.getTableProxy().getName()));
                this.appendComma(stringBuffer);
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "'index'");
                this.appendComma(stringBuffer);
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxySqlServerv2k5.getName()));
                SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                SSBIndexSqlServerv2k5.appendString(stringBuffer, "GO");
                SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxySqlServerv2k5 && ((TableProxySqlServerv2k5)((IndexProxySqlServerv2k5)object).getTableProxy()).getDatabase() != null && !((TableProxySqlServerv2k5)((IndexProxySqlServerv2k5)object).getTableProxy()).getDatabase().isNullInstance() && ((IndexProxy)object).isMarkedGenerate() && !((IndexProxySqlServerv2k5)object).isPrimaryXmlIndex();
    }

    public void appendIndexForConstraint(StringBuffer stringBuffer, Index index, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        Index index2 = null;
        IndexProxy indexProxy = null;
        index2 = index;
        StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)this.getStorageDesign(index);
        if ("Primary Constraint".equals(index2.getIndexState())) {
            indexProxy = (IndexProxy)storageDesignSqlServerv2k5.getPKProxySet().getProxy(index2.getObjectID());
        } else if ("Unique Constraint".equals(index2.getIndexState())) {
            indexProxy = (IndexProxy)storageDesignSqlServerv2k5.getUniqueProxySet().getProxy(index2.getObjectID());
        } else if (index2.isFK()) {
            indexProxy = (IndexProxy)storageDesignSqlServerv2k5.getFKProxySet().getProxy(index2.getObjectID());
        }
        if (index2 != null && !index2.isOidKey() && indexProxy != null) {
            this.storageDesign = (StorageDesignSqlServerv2k5)indexProxy.getStorageDesign();
            if (indexProxy.isMarkedGenerate()) {
                if (index2.getElements().length > 0) {
                    if (indexProxy.isCommentChanged()) {
                        this.appendComment(stringBuffer, indexProxy);
                    } else {
                        this.appendComment(stringBuffer, index2);
                    }
                    String string2 = indexProxy.getName();
                    String string3 = indexProxy.getLongName();
                    if (string2.length() < indexProxy.getMaxNameLength()) {
                        string2 = string2 + "X";
                        string3 = string3 + "X";
                    }
                    if (string2.length() > indexProxy.getMaxNameLength()) {
                        SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                        SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "--  ERROR: Index name length exceeds maximum allowed length(" + indexProxy.getMaxNameLength() + ")");
                        SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer2, "CREATE");
                    if ("Primary Constraint".equals(index2.getIndexState()) || "Unique Constraint".equals(index2.getIndexState())) {
                        SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer2, "UNIQUE");
                    }
                    SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer2, "INDEX");
                    SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer2, storageDesignSqlServerv2k5.getFormatedName(string3));
                    string = stringBuffer2.toString();
                    SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer2, "ON");
                    SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer2, storageDesignSqlServerv2k5.getFormatedName(indexProxy.getTableProxy().getLongName()));
                    this.appendConstraintElementList(stringBuffer2, index2, indexProxy, true);
                    SSBIndexSqlServerv2k5.appendNewLine(stringBuffer2, bl, 0);
                    this.appendLineFinisher(stringBuffer2, bl);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    DDLFileMaker.incrementCreateIndex();
                } else {
                    SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                    stringBuffer.append("-- Error - Index ");
                    stringBuffer.append(storageDesignSqlServerv2k5.getFormatedName(index2.getName()));
                    stringBuffer.append(" has no columns");
                    SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementErrors();
                }
            }
        }
    }

    private void appendConstraintElementList(StringBuffer stringBuffer, Index index, IndexProxy indexProxy, boolean bl) {
        ColumnProxy columnProxy = null;
        ColumnProxy[] columnProxyArray = indexProxy.getColumnProxies();
        SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
        if (columnProxyArray.length < 1) {
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, "-- No Columns");
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
        }
        SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, '(');
        for (int i = 0; i < columnProxyArray.length; ++i) {
            if (i != 0) {
                SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            }
            columnProxy = columnProxyArray[i];
            SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBIndexSqlServerv2k5.appendString(stringBuffer, ' ');
            String string = this.storageDesign.getFormatedName(columnProxy.getName());
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, string);
            SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(columnProxy));
        }
        SSBIndexSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
        SSBIndexSqlServerv2k5.appendStringWithSpace(stringBuffer, ')');
    }
}

