/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDataBaseSqlServerv2kv5
extends AbstractSSBSqlServer {
    private StorageDesignSqlServer storageDesign;
    boolean existsPrimary = false;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        DataBaseSqlServerv2k5 dataBaseSqlServerv2k5 = (DataBaseSqlServerv2k5)object;
        this.storageDesign = (StorageDesignSqlServer)this.getStorageDesign(object);
        this.appendComment(stringBuffer, dataBaseSqlServerv2k5);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 0);
        this.appendCreate(stringBuffer, dataBaseSqlServerv2k5, bl);
        this.appendFileSpec(stringBuffer, dataBaseSqlServerv2k5, bl);
        this.appendFileGroup(stringBuffer, dataBaseSqlServerv2k5, bl);
        this.appendLogOn(stringBuffer, dataBaseSqlServerv2k5, bl);
        this.appendCollate(stringBuffer, dataBaseSqlServerv2k5, bl);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 0);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "GO");
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 0);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 0);
        DDLFileMaker.incrementCreateDatabase();
        this.appendAlterDatabase(stringBuffer, dataBaseSqlServerv2k5, bl);
    }

    protected void appendCreate(StringBuffer stringBuffer, DataBaseSqlServerv2k5 dataBaseSqlServerv2k5, boolean bl) {
        this.appendCreate(stringBuffer);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "DATABASE");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(dataBaseSqlServerv2k5.getName()));
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
    }

    protected void appendFileSpec(StringBuffer stringBuffer, DataBaseSqlServerv2k5 dataBaseSqlServerv2k5, boolean bl) {
        StorageObjectCollection storageObjectCollection = dataBaseSqlServerv2k5.getFilegroups();
        if (storageObjectCollection.containsName("PRIMARY")) {
            FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)storageObjectCollection.getByName("PRIMARY");
            if (fileGroupSqlServer != null && fileGroupSqlServer.getDatafiles() != null) {
                if (this.checkFileGroupValidity(fileGroupSqlServer)) {
                    StorageObjectCollection storageObjectCollection2 = fileGroupSqlServer.getDatafiles();
                    if (storageObjectCollection2.size() > 0) {
                        this.existsPrimary = true;
                        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "ON");
                        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "PRIMARY");
                        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
                        this.appendDataFiles(stringBuffer, storageObjectCollection2, bl);
                    }
                } else {
                    SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
                    SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "-- Invalid filegroup");
                    SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fileGroupSqlServer.getName()));
                }
            }
        } else {
            this.existsPrimary = false;
        }
    }

    protected void appendFileGroup(StringBuffer stringBuffer, DataBaseSqlServerv2k5 dataBaseSqlServerv2k5, boolean bl) {
        if (this.existsPrimary) {
            StorageObjectCollection storageObjectCollection = dataBaseSqlServerv2k5.getFilegroups();
            Iterator iterator = storageObjectCollection.iterator();
            while (iterator.hasNext()) {
                FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)iterator.next();
                if (fileGroupSqlServer.getName().equalsIgnoreCase("PRIMARY")) continue;
                if (this.checkFileGroupValidity(fileGroupSqlServer)) {
                    this.appendComma(stringBuffer);
                    SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
                    this.appendGroup(stringBuffer, fileGroupSqlServer, bl);
                    continue;
                }
                SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
                SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "-- Invalid filegroup");
                SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fileGroupSqlServer.getName()));
            }
        }
    }

    protected void appendCollate(StringBuffer stringBuffer, DataBaseSqlServerv2k5 dataBaseSqlServerv2k5, boolean bl) {
        String string = dataBaseSqlServerv2k5.getCollationName();
        if (string != null && !string.trim().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "COLLATE");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, string);
        }
    }

    protected void appendLogOn(StringBuffer stringBuffer, DataBaseSqlServerv2k5 dataBaseSqlServerv2k5, boolean bl) {
        if (this.existsPrimary) {
            StorageObjectCollection storageObjectCollection = dataBaseSqlServerv2k5.getTransactionLogs();
            Iterator iterator = storageObjectCollection.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)iterator.next();
                if (dataFileSqlServer.getDataBase() != null && this.checkDataFileValidity(dataFileSqlServer)) {
                    if (!bl2) {
                        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
                        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "LOG ON");
                        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
                    }
                    bl2 = true;
                    this.appendDataFile(stringBuffer, dataFileSqlServer, bl);
                    continue;
                }
                if (dataFileSqlServer.getDataBase() == null || this.checkDataFileValidity(dataFileSqlServer)) continue;
                SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
                SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "-- Invalid datafile name");
                SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(dataFileSqlServer.getName()));
            }
            this.deleteLastComma(stringBuffer, bl, bl2);
        }
    }

    protected void appendAlterDatabase(StringBuffer stringBuffer, DataBaseSqlServerv2k5 dataBaseSqlServerv2k5, boolean bl) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "ALTER");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "DATABASE");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(dataBaseSqlServerv2k5.getLongName()));
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "SET");
        this.appendStateOption(stringBuffer, dataBaseSqlServerv2k5, bl);
        this.appendCursorOption(stringBuffer, dataBaseSqlServerv2k5, bl);
        this.appendAutoOption(stringBuffer, dataBaseSqlServerv2k5, bl);
        this.appendSqlOption(stringBuffer, dataBaseSqlServerv2k5, bl);
        this.appendRecoveryOption(stringBuffer, dataBaseSqlServerv2k5, bl);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "GO");
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 0);
    }

    protected void appendStateOption(StringBuffer stringBuffer, DataBaseSqlServerv2k5 dataBaseSqlServerv2k5, boolean bl) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getUserState());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
    }

    protected void appendCursorOption(StringBuffer stringBuffer, DataBaseSqlServerv2k5 dataBaseSqlServerv2k5, boolean bl) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "CURSOR_CLOSE_ON_COMMIT");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getCursorCloseOnCommit());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "CURSOR_DEFAULT");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getCursorDefault());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
    }

    protected void appendAutoOption(StringBuffer stringBuffer, DataBaseSqlServerv2k5 dataBaseSqlServerv2k5, boolean bl) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "AUTO_CLOSE");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getAutoClose());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "AUTO_CREATE_STATISTICS");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getAutoCreateStatistics());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "AUTO_SHRINK");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getAutoShrink());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "AUTO_UPDATE_STATISTICS");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getAutoUpdateStatistics());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
    }

    protected void appendSqlOption(StringBuffer stringBuffer, DataBaseSqlServerv2k5 dataBaseSqlServerv2k5, boolean bl) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "ANSI_NULLS");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getAnsiNulls());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        if (!dataBaseSqlServerv2k5.getAnsiPadding().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "ANSI_PADDING");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getAnsiPadding());
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        }
        if (!dataBaseSqlServerv2k5.getAnsiWarnings().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "ANSI_WARNINGS");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getAnsiWarnings());
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        }
        if (!dataBaseSqlServerv2k5.getArithabort().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "ARITHABORT");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getArithabort());
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        }
        if (!dataBaseSqlServerv2k5.getConcatNullYieldsNull().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "CONCAT_NULL_YIELDS_NULL");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getConcatNullYieldsNull());
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        }
        if (!dataBaseSqlServerv2k5.getNumericRoundabort().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "NUMERIC_ROUNDABORT");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getNumericRoundabort());
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        }
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "QUOTED_IDENTIFIER");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getQuotedIdentifier());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        if (!dataBaseSqlServerv2k5.getRecursiveTriggers().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "RECURSIVE_TRIGGERS");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getRecursiveTriggers());
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        }
    }

    protected void appendRecoveryOption(StringBuffer stringBuffer, DataBaseSqlServerv2k5 dataBaseSqlServerv2k5, boolean bl) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "RECOVERY");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getRecovery());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "TORN_PAGE_DETECTION");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k5.getTornPageDetection());
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 0);
    }

    private boolean checkFileGroupValidity(FileGroupSqlServer fileGroupSqlServer) {
        StorageObjectCollection storageObjectCollection = fileGroupSqlServer.getDatafiles();
        if (storageObjectCollection == null || storageObjectCollection.size() == 0) {
            return false;
        }
        Iterator iterator = storageObjectCollection.iterator();
        while (iterator.hasNext()) {
            DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)iterator.next();
            if (dataFileSqlServer.getFileName() != null && !dataFileSqlServer.getFileName().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    private boolean checkDataFileValidity(DataFileSqlServer dataFileSqlServer) {
        return dataFileSqlServer.getFileName() != null && !dataFileSqlServer.getFileName().trim().equalsIgnoreCase("");
    }

    protected void appendGroup(StringBuffer stringBuffer, FileGroupSqlServer fileGroupSqlServer, boolean bl) {
        StorageObjectCollection storageObjectCollection = fileGroupSqlServer.getDatafiles();
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "FILEGROUP");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fileGroupSqlServer.getName()));
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        this.appendDataFiles(stringBuffer, storageObjectCollection, bl);
    }

    protected void appendDataFiles(StringBuffer stringBuffer, StorageObjectCollection storageObjectCollection, boolean bl) {
        Iterator iterator = storageObjectCollection.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            bl2 = true;
            DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)iterator.next();
            this.appendDataFile(stringBuffer, dataFileSqlServer, bl);
        }
        if (bl2) {
            int n = bl ? NEWLINE.length() + "    ".length() : 1;
            stringBuffer = stringBuffer.delete(stringBuffer.length() - n - 2, stringBuffer.length() - 1);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DataBaseSqlServerv2k5 && ((DataBaseSqlServerv2k5)object).isMarkedGenerate();
    }

    protected void appendDataFile(StringBuffer stringBuffer, DataFileSqlServer dataFileSqlServer, boolean bl) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, '(');
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        this.appendNameWithQuotes(stringBuffer, bl, dataFileSqlServer);
        this.appendFilename(stringBuffer, bl, dataFileSqlServer);
        this.appendInitialSize(stringBuffer, bl, dataFileSqlServer);
        this.appendMaxSize(stringBuffer, dataFileSqlServer);
        this.appendGrowthValue(stringBuffer, bl, dataFileSqlServer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        SSBDataBaseSqlServerv2kv5.appendString(stringBuffer, ')');
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
    }

    private void deleteLastComma(StringBuffer stringBuffer, boolean bl, boolean bl2) {
        int n = bl ? NEWLINE.length() + "    ".length() : 1;
        if (bl2) {
            stringBuffer = stringBuffer.delete(stringBuffer.length() - n - 2, stringBuffer.length());
        }
    }

    private void appendNameWithQuotes(StringBuffer stringBuffer, boolean bl, DataFileSqlServer dataFileSqlServer) {
        if (!dataFileSqlServer.getName().trim().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "NAME");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, '=');
            SSBDataBaseSqlServerv2kv5.appendString(stringBuffer, '\'');
            this.appendString(stringBuffer, dataFileSqlServer);
            SSBDataBaseSqlServerv2kv5.appendString(stringBuffer, '\'');
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        }
    }

    private void appendFilename(StringBuffer stringBuffer, boolean bl, DataFileSqlServer dataFileSqlServer) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "FILENAME");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, '=');
        SSBDataBaseSqlServerv2kv5.appendString(stringBuffer, '\'');
        SSBDataBaseSqlServerv2kv5.appendString(stringBuffer, dataFileSqlServer.getFileName());
        SSBDataBaseSqlServerv2kv5.appendString(stringBuffer, '\'');
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
    }

    private void appendInitialSize(StringBuffer stringBuffer, boolean bl, DataFileSqlServer dataFileSqlServer) {
        if (dataFileSqlServer.getInitialSize() != 0) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "SIZE");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, '=');
            this.appendString(stringBuffer, dataFileSqlServer.getInitialSize());
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
        }
    }

    private void appendMaxSize(StringBuffer stringBuffer, DataFileSqlServer dataFileSqlServer) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "MAXSIZE");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, '=');
        if (dataFileSqlServer.getIsUnlimited()) {
            SSBDataBaseSqlServerv2kv5.appendString(stringBuffer, "UNLIMITED");
        } else {
            this.appendString(stringBuffer, dataFileSqlServer.getMaxSize());
        }
    }

    private void appendGrowthValue(StringBuffer stringBuffer, boolean bl, DataFileSqlServer dataFileSqlServer) {
        if (dataFileSqlServer.getGrowthValue() != 0) {
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, "FILEGROWTH");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, '=');
            this.appendString(stringBuffer, dataFileSqlServer.getGrowthValue());
            if (dataFileSqlServer.getGrowthMethod().equalsIgnoreCase("By Percent")) {
                SSBDataBaseSqlServerv2kv5.appendStringWithSpace(stringBuffer, '%');
            }
        }
    }
}

