/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.TriggerSqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTriggerSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        TriggerSqlServerv2k triggerSqlServerv2k = (TriggerSqlServerv2k)object;
        this.storageDesign = triggerSqlServerv2k.getStorageDesign();
        this.appendComment(stringBuffer, triggerSqlServerv2k);
        if (!triggerSqlServerv2k.getActions().trim().equalsIgnoreCase("")) {
            SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            this.appendCreate(stringBuffer, triggerSqlServerv2k);
            this.appendOnTable(stringBuffer, triggerSqlServerv2k);
            this.appendWithEncription(stringBuffer, triggerSqlServerv2k, bl);
            this.appendTriggeringTime(stringBuffer, triggerSqlServerv2k, bl);
            this.appendAction(stringBuffer, triggerSqlServerv2k);
            this.appendReplication(stringBuffer, triggerSqlServerv2k, bl);
            SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, "AS");
            this.appendTriggeredAction(stringBuffer, triggerSqlServerv2k, bl);
            SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
            SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            DDLFileMaker.incrementCreateTrigger();
            this.appendSetTriggerOrder(stringBuffer, triggerSqlServerv2k, bl);
            if (triggerSqlServerv2k.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendTriggerComment(stringBuffer, triggerSqlServerv2k, bl);
            }
        } else {
            SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, "-- invalid trigger: without action");
        }
    }

    private void appendTriggerComment(StringBuffer stringBuffer, TriggerSqlServerv2k triggerSqlServerv2k, boolean bl) {
        String string = triggerSqlServerv2k.getCommentInRDBMS();
        if (string != null && !string.trim().equalsIgnoreCase("")) {
            SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTriggerSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTriggerSqlServerv2k.appendString(stringBuffer, string);
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            if (triggerSqlServerv2k != null && triggerSqlServerv2k.getOwner() != null) {
                SSBTriggerSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTriggerSqlServerv2k.appendString(stringBuffer, "USER");
                SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                SSBTriggerSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTriggerSqlServerv2k.appendString(stringBuffer, triggerSqlServerv2k.getOwner().getName());
                SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            }
            if (triggerSqlServerv2k.getTable() != null) {
                SSBTriggerSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTriggerSqlServerv2k.appendString(stringBuffer, "TABLE");
                SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                SSBTriggerSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTriggerSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(triggerSqlServerv2k.getTable().getLongName()));
                SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            } else if (triggerSqlServerv2k.getView() != null) {
                SSBTriggerSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTriggerSqlServerv2k.appendString(stringBuffer, "VIEW");
                SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                SSBTriggerSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTriggerSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(triggerSqlServerv2k.getView().getLongName()));
                SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            }
            SSBTriggerSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTriggerSqlServerv2k.appendString(stringBuffer, "TRIGGER");
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTriggerSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTriggerSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(triggerSqlServerv2k.getName()));
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTriggerSqlServerv2k.appendString(stringBuffer, "GO");
            SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendCreate(StringBuffer stringBuffer, TriggerSqlServerv2k triggerSqlServerv2k) {
        this.appendCreate(stringBuffer);
        SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, "TRIGGER");
        if (triggerSqlServerv2k.getOwner() != null) {
            SSBTriggerSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(triggerSqlServerv2k.getOwner().getName()));
            SSBTriggerSqlServerv2k.appendString(stringBuffer, '.');
        }
        SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(triggerSqlServerv2k.getName()));
    }

    private void appendOnTable(StringBuffer stringBuffer, TriggerSqlServerv2k triggerSqlServerv2k) {
        SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, "ON");
        if (triggerSqlServerv2k.getTable() != null) {
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(triggerSqlServerv2k.getTable().getName()));
        } else {
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(triggerSqlServerv2k.getView().getName()));
        }
    }

    private void appendWithEncription(StringBuffer stringBuffer, TriggerSqlServerv2k triggerSqlServerv2k, boolean bl) {
        if (triggerSqlServerv2k.getEncription().equalsIgnoreCase("YES")) {
            SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, "WITH");
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, "ENCRYPTION");
        }
    }

    private void appendTriggeringTime(StringBuffer stringBuffer, TriggerSqlServerv2k triggerSqlServerv2k, boolean bl) {
        SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, triggerSqlServerv2k.getTriggerTime());
    }

    private void appendAction(StringBuffer stringBuffer, TriggerSqlServerv2k triggerSqlServerv2k) {
        for (int i = 0; i < triggerSqlServerv2k.getActionSet().size(); ++i) {
            if (i > 0) {
                this.appendComma(stringBuffer);
            }
            this.appendStringWithSpace(stringBuffer, triggerSqlServerv2k.getActionSet().elementAt(i));
        }
    }

    private void appendReplication(StringBuffer stringBuffer, TriggerSqlServerv2k triggerSqlServerv2k, boolean bl) {
        if (triggerSqlServerv2k.getForReplication().equalsIgnoreCase("NO")) {
            SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, "NOT FOR REPLICATION");
        }
    }

    private void appendTriggeredAction(StringBuffer stringBuffer, TriggerSqlServerv2k triggerSqlServerv2k, boolean bl) {
        SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        if (triggerSqlServerv2k.getBody().equalsIgnoreCase("")) {
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, "-- Empty body");
        } else {
            SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, triggerSqlServerv2k.getBody());
        }
    }

    private void appendSetTriggerOrder(StringBuffer stringBuffer, TriggerSqlServerv2k triggerSqlServerv2k, boolean bl) {
        if (!triggerSqlServerv2k.getExecutionOrder().equalsIgnoreCase(TriggerSqlServer.EXECUTION_ORDERS[0])) {
            Iterator iterator = triggerSqlServerv2k.getActionSet().iterator();
            while (iterator.hasNext()) {
                SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_settriggerorder");
                SSBTriggerSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTriggerSqlServerv2k.appendString(stringBuffer, triggerSqlServerv2k.getName());
                SSBTriggerSqlServerv2k.appendString(stringBuffer, '\'');
                this.appendComma(stringBuffer);
                SSBTriggerSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTriggerSqlServerv2k.appendString(stringBuffer, triggerSqlServerv2k.getExecutionOrder());
                SSBTriggerSqlServerv2k.appendString(stringBuffer, '\'');
                this.appendComma(stringBuffer);
                SSBTriggerSqlServerv2k.appendString(stringBuffer, '\'');
                this.appendString(stringBuffer, iterator.next());
                SSBTriggerSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBTriggerSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
                SSBTriggerSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TriggerSqlServerv2k && ((TriggerSqlServerv2k)object).isMarkedGenerate() && (((TriggerSqlServer)object).getTable() != null || ((TriggerSqlServer)object).getView() != null);
    }
}

