/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.LoginSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.UserSqlServerv2k;

public class SSBLoginSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        LoginSqlServerv2k loginSqlServerv2k = (LoginSqlServerv2k)object;
        this.storageDesign = loginSqlServerv2k.getStorageDesign();
        this.appendComment(stringBuffer, loginSqlServerv2k);
        if (loginSqlServerv2k.getAuthentication().equalsIgnoreCase("WINDOWS")) {
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            this.appendGrantLogin(stringBuffer, loginSqlServerv2k, bl);
            this.appendDefaultDB(stringBuffer, loginSqlServerv2k, bl);
            this.appendDefaultLanguage(stringBuffer, loginSqlServerv2k, bl);
        } else {
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            this.appendAddLogin(stringBuffer, loginSqlServerv2k, bl);
        }
        this.appendGrantUsersDBAccess(stringBuffer, loginSqlServerv2k, bl);
        UserSetSqlServer userSetSqlServer = ((StorageDesignSqlServer)this.storageDesign).getUserSet();
        for (int i = 0; i < loginSqlServerv2k.getUserSet().size(); ++i) {
            this.appendPrivileges(stringBuffer, (UserSqlServerv2k)userSetSqlServer.getByName((String)loginSqlServerv2k.getUserSet().get(i)), bl);
        }
    }

    private void appendGrantLogin(StringBuffer stringBuffer, LoginSqlServerv2k loginSqlServerv2k, boolean bl) {
        SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
        SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_grantlogin");
        SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
        SSBLoginSqlServerv2k.appendString(stringBuffer, loginSqlServerv2k.getName());
        SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
        SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
        SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
    }

    private void appendDefaultDB(StringBuffer stringBuffer, LoginSqlServerv2k loginSqlServerv2k, boolean bl) {
        if (loginSqlServerv2k.getDefaultDatabase() != null) {
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_defaultdb");
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k.appendString(stringBuffer, loginSqlServerv2k.getName());
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            this.appendComma(stringBuffer);
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            this.appendString(stringBuffer, loginSqlServerv2k.getDefaultDatabase());
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendDefaultLanguage(StringBuffer stringBuffer, LoginSqlServerv2k loginSqlServerv2k, boolean bl) {
        if (loginSqlServerv2k.getLanguage() != null) {
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_defaultlanguage");
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k.appendString(stringBuffer, loginSqlServerv2k.getName());
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            this.appendComma(stringBuffer);
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k.appendString(stringBuffer, loginSqlServerv2k.getLanguage());
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendAddLogin(StringBuffer stringBuffer, LoginSqlServerv2k loginSqlServerv2k, boolean bl) {
        if (loginSqlServerv2k.getDefaultDatabase() != null) {
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addlogin");
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k.appendString(stringBuffer, loginSqlServerv2k.getName());
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            this.appendComma(stringBuffer);
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k.appendString(stringBuffer, loginSqlServerv2k.decodePassword());
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            this.appendComma(stringBuffer);
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k.appendString(stringBuffer, loginSqlServerv2k.getDefaultDatabase().getName());
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            if (loginSqlServerv2k.getLanguage() != null) {
                this.appendComma(stringBuffer);
                SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
                SSBLoginSqlServerv2k.appendString(stringBuffer, loginSqlServerv2k.getLanguage());
                SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            }
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        } else {
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "-- Invalid login (without specified DB)");
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(loginSqlServerv2k.getName()));
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendGrantUsersDBAccess(StringBuffer stringBuffer, LoginSqlServerv2k loginSqlServerv2k, boolean bl) {
        UserSetSqlServer userSetSqlServer = ((StorageDesignSqlServer)loginSqlServerv2k.getStorageDesign()).getUserSet();
        UserSqlServer userSqlServer = null;
        for (String string : loginSqlServerv2k.getUserSet()) {
            userSqlServer = (UserSqlServer)userSetSqlServer.getByName(string);
            if (userSqlServer.getDatabase() != null && !userSqlServer.getDatabase().isNullInstance()) {
                SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "USE");
                SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(userSqlServer.getDatabase().getName()));
                SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
                SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            }
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_grantdbaccess");
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k.appendString(stringBuffer, loginSqlServerv2k.getName());
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            this.appendComma(stringBuffer);
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k.appendString(stringBuffer, string);
            SSBLoginSqlServerv2k.appendString(stringBuffer, '\'');
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendPrivileges(StringBuffer stringBuffer, UserSqlServerv2k userSqlServerv2k, boolean bl) {
        if (!"".equalsIgnoreCase(userSqlServerv2k.getSystemPrivileges())) {
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            if (userSqlServerv2k.getDatabase() != null && !userSqlServerv2k.getDatabase().isNullInstance()) {
                SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "USE");
                this.appendStringWithSpace(stringBuffer, userSqlServerv2k.getDatabase());
                SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBLoginSqlServerv2k.appendString(stringBuffer, "GO");
                SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            }
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "GRANT");
            if (userSqlServerv2k.getPrivilegesSet().contains("ALL")) {
                SSBLoginSqlServerv2k.appendString(stringBuffer, "ALL");
            } else {
                SSBLoginSqlServerv2k.appendString(stringBuffer, userSqlServerv2k.getSystemPrivileges());
            }
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBLoginSqlServerv2k.appendStringWithSpace(stringBuffer, "TO");
            this.appendString(stringBuffer, userSqlServerv2k);
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBLoginSqlServerv2k.appendString(stringBuffer, "GO");
            SSBLoginSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof LoginSqlServerv2k && ((LoginSqlServerv2k)object).getBeforeDefaults() && ((LoginSqlServerv2k)object).isMarkedGenerate();
    }
}

