/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;

public class SSBDropViewSqlServer
extends SQLStatementBuilder {
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof TableView && ((TableView)object).isDropEnabled()) {
            return true;
        }
        return object instanceof TableViewProxySqlServer && ((TableViewProxySqlServer)object).isDropEnabled() && !((TableViewProxySqlServer)object).shouldBeDroppedIndirectly();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (object == null) {
            return;
        }
        TableView tableView = null;
        TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)object;
        tableView = (TableView)tableViewProxySqlServer.getObject();
        this.appendBeforeDropScript(stringBuffer2, bl, tableView);
        DataBaseSqlServer dataBaseSqlServer = tableViewProxySqlServer.getDataBase();
        this.storageDesign = tableViewProxySqlServer.getStorageDesign();
        if (dataBaseSqlServer != null && !dataBaseSqlServer.isNullInstance()) {
            SSBDropViewSqlServer.appendStringWithSpace(stringBuffer2, "USE");
            SSBDropViewSqlServer.appendString(stringBuffer2, this.storageDesign.getFormatedName(dataBaseSqlServer.getName()));
            SSBDropViewSqlServer.appendNewLine(stringBuffer2, bl, 0);
            SSBDropViewSqlServer.appendStringWithSpace(stringBuffer2, "GO");
            SSBDropViewSqlServer.appendNewLine(stringBuffer2, bl, 0);
        }
        this.appendDrop(stringBuffer2);
        SSBDropViewSqlServer.appendStringWithSpace(stringBuffer2, "VIEW");
        if (tableViewProxySqlServer.getStorageDesign() instanceof StorageDesignSqlServerv2k) {
            UserSqlServer userSqlServer = tableViewProxySqlServer.getUser();
            if (userSqlServer != null) {
                SSBDropViewSqlServer.appendString(stringBuffer2, this.storageDesign.getFormatedName(userSqlServer.getName()));
                SSBDropViewSqlServer.appendString(stringBuffer2, '.');
                SSBDropViewSqlServer.appendString(stringBuffer2, this.storageDesign.getFormatedName(tableView.getName()));
            } else {
                SSBDropViewSqlServer.appendString(stringBuffer2, this.storageDesign.getFormatedName(tableView.getName()));
            }
        } else if (tableViewProxySqlServer.getStorageDesign() instanceof StorageDesignSqlServerv2k5) {
            SchemaSqlServer schemaSqlServer = tableViewProxySqlServer.getSchema();
            if (schemaSqlServer != null) {
                SSBDropViewSqlServer.appendString(stringBuffer2, this.storageDesign.getFormatedName(schemaSqlServer.getName()));
                SSBDropViewSqlServer.appendString(stringBuffer2, '.');
                SSBDropViewSqlServer.appendString(stringBuffer2, this.storageDesign.getFormatedName(tableView.getName()));
            } else {
                SSBDropViewSqlServer.appendString(stringBuffer2, this.storageDesign.getFormatedName(tableView.getName()));
            }
        }
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        SSBDropViewSqlServer.appendNewLine(stringBuffer2, bl, 0);
        SSBDropViewSqlServer.appendString(stringBuffer2, "GO");
        SSBDropViewSqlServer.appendNewLine(stringBuffer2, bl, 0);
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
    }
}

