/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver;

import oracle.dbtools.crest.exports.ddl.DDLConstants;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;

public abstract class AbstractSSBSqlServer
extends SQLStatementBuilder
implements DDLConstants {
    private StorageDesign storageDesign;

    @Override
    protected void appendCommentOn(StringBuffer stringBuffer, StorageObject storageObject, boolean bl) {
        String string = "";
        if (storageObject instanceof TableProxy) {
            Table table = (Table)((TableProxy)storageObject).getObject();
            string = table.getCommentInRDBMS();
        } else if (storageObject instanceof IndexProxy) {
            Index index = (Index)((IndexProxy)storageObject).getObject();
            string = index.getCommentInRDBMS();
        } else if (storageObject instanceof TableViewProxy) {
            TableView tableView = (TableView)((TableViewProxy)storageObject).getObject();
            string = tableView.getCommentInRDBMS();
        } else if (storageObject != null) {
            string = storageObject.getCommentInRDBMS();
        } else {
            return;
        }
        this.storageDesign = storageObject.getStorageDesign();
        if (this.isNotEmpty(string)) {
            if (bl) {
                stringBuffer.append(NEWLINE).append("    ");
            }
            stringBuffer.append("COMMENT ON ").append(this.storageDesign.getFormatedName(storageObject.getName())).append(" IS '").append(string).append('\'');
            stringBuffer.append(NEWLINE);
            stringBuffer.append("GO");
        }
        stringBuffer.append(NEWLINE);
    }

    protected void appendViewElementComment(StringBuffer stringBuffer, DesignObject designObject, TableView tableView, boolean bl) {
        if (!designObject.getCommentInRDBMS().equalsIgnoreCase("")) {
            AbstractSSBSqlServer.appendNewLine(stringBuffer, bl, 0);
            AbstractSSBSqlServer.appendNewLine(stringBuffer, bl, 0);
            AbstractSSBSqlServer.appendNewLine(stringBuffer, bl, 0);
            AbstractSSBSqlServer.appendStringWithSpace(stringBuffer, "EXEC");
            AbstractSSBSqlServer.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            AbstractSSBSqlServer.appendStringWithSpace(stringBuffer, "'MS_Description'");
            AbstractSSBSqlServer.appendStringWithSpace(stringBuffer, ',');
            AbstractSSBSqlServer.appendString(stringBuffer, '\'');
            AbstractSSBSqlServer.appendString(stringBuffer, designObject.getCommentInRDBMS());
            AbstractSSBSqlServer.appendStringWithSpace(stringBuffer, '\'');
            AbstractSSBSqlServer.appendStringWithSpace(stringBuffer, ',');
            AbstractSSBSqlServer.appendString(stringBuffer, '\'');
            AbstractSSBSqlServer.appendString(stringBuffer, "VIEW");
            AbstractSSBSqlServer.appendStringWithSpace(stringBuffer, '\'');
            AbstractSSBSqlServer.appendStringWithSpace(stringBuffer, ',');
            AbstractSSBSqlServer.appendString(stringBuffer, '\'');
            AbstractSSBSqlServer.appendString(stringBuffer, tableView.getName());
            AbstractSSBSqlServer.appendStringWithSpace(stringBuffer, '\'');
            AbstractSSBSqlServer.appendStringWithSpace(stringBuffer, ',');
            AbstractSSBSqlServer.appendString(stringBuffer, '\'');
            AbstractSSBSqlServer.appendString(stringBuffer, "COLUMN");
            AbstractSSBSqlServer.appendStringWithSpace(stringBuffer, '\'');
            AbstractSSBSqlServer.appendStringWithSpace(stringBuffer, ',');
            AbstractSSBSqlServer.appendString(stringBuffer, '\'');
            AbstractSSBSqlServer.appendString(stringBuffer, designObject.getName());
            AbstractSSBSqlServer.appendStringWithSpace(stringBuffer, '\'');
            AbstractSSBSqlServer.appendNewLine(stringBuffer, bl, 0);
            AbstractSSBSqlServer.appendString(stringBuffer, "GO");
            AbstractSSBSqlServer.appendNewLine(stringBuffer, bl, 0);
        }
    }

    @Override
    protected boolean isNotEmpty(String string) {
        return string != null && !"".equals(string) && !"".equals(string.trim());
    }

    protected void appendDataBase(StringBuffer stringBuffer, DataBaseSqlServer dataBaseSqlServer, boolean bl) {
        if (dataBaseSqlServer != null && !dataBaseSqlServer.isNullInstance()) {
            this.storageDesign = dataBaseSqlServer.getStorageDesign();
            AbstractSSBSqlServer.appendStringWithSpace(stringBuffer, "USE");
            AbstractSSBSqlServer.appendString(stringBuffer, this.storageDesign.getFormatedName(dataBaseSqlServer.getName()));
            AbstractSSBSqlServer.appendNewLine(stringBuffer, bl, 0);
            AbstractSSBSqlServer.appendStringWithSpace(stringBuffer, "GO");
            AbstractSSBSqlServer.appendNewLine(stringBuffer, bl, 0);
        }
    }

    @Override
    protected String addQuotesToDefault(String string, String string2) {
        String string3 = string2.trim();
        if (("TRUE".equalsIgnoreCase(string3) || "FALSE".equalsIgnoreCase(string3)) && "BIT".equalsIgnoreCase(string)) {
            return "TRUE".equalsIgnoreCase(string3) ? "1" : "0";
        }
        if ("CURRENT_TIMESTAMP".equalsIgnoreCase(string3) || "CURRENT_USER".equalsIgnoreCase(string3)) {
            return string3;
        }
        if ("CURRENT_DATE".equalsIgnoreCase(string3) || "SYSDATE".equalsIgnoreCase(string3)) {
            return "GETDATE()";
        }
        if ("CURRENT_TIMESTAMP".equalsIgnoreCase(string3) || "LOCALTIMESTAMP".equalsIgnoreCase(string3) || "SYSTIMESTAMP".equalsIgnoreCase(string3)) {
            return "CURRENT_TIMESTAMP";
        }
        if ("SESSIONTIMEZONE".equalsIgnoreCase(string3) || "DBTIMEZONE".equalsIgnoreCase(string3)) {
            return "";
        }
        if ("USER".equalsIgnoreCase(string3)) {
            return "CURRENT_USER";
        }
        string3 = super.addQuotesToDefault(string, string2);
        return string3;
    }
}

