/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableSpaceOraclev9i
extends AbstractSSBOracle {
    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableSpaceOraclev9i && ((TableSpaceOraclev9i)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        TableSpaceOraclev9i tableSpaceOraclev9i = (TableSpaceOraclev9i)object;
        if (!tableSpaceOraclev9i.isNullInstance()) {
            List list = tableSpaceOraclev9i.getDataFiles();
            this.appendComment(stringBuffer, tableSpaceOraclev9i);
            this.appendCreate(stringBuffer2, tableSpaceOraclev9i);
            string = stringBuffer2.toString();
            this.appendDataFiles(stringBuffer2, tableSpaceOraclev9i, list);
            this.appendMinimumExtent(stringBuffer2, tableSpaceOraclev9i);
            this.appendBlockSize(stringBuffer2, tableSpaceOraclev9i);
            this.appendLogging(stringBuffer2, tableSpaceOraclev9i);
            this.appendForceLogging(stringBuffer2, tableSpaceOraclev9i, bl);
            this.appendStatus(stringBuffer2, tableSpaceOraclev9i);
            this.appendContents(stringBuffer2, tableSpaceOraclev9i);
            this.appendDefaultStorage(stringBuffer2, tableSpaceOraclev9i);
            this.appendExtentManagement(stringBuffer2, tableSpaceOraclev9i);
            this.appendLocalSubType(stringBuffer2, tableSpaceOraclev9i);
            this.appendUniformSize(stringBuffer2, tableSpaceOraclev9i);
            this.appendSegmentManagement(stringBuffer2, tableSpaceOraclev9i);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBTableSpaceOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            SSBTableSpaceOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            DDLFileMaker.incrementCreateTablespace();
        }
    }

    private void appendCreate(StringBuffer stringBuffer, TableSpaceOraclev9i tableSpaceOraclev9i) {
        stringBuffer.append("CREATE TABLESPACE ").append(tableSpaceOraclev9i.getStorageDesign().getFormatedName(tableSpaceOraclev9i.getName())).append(' ');
    }

    private void appendSegmentManagement(StringBuffer stringBuffer, TableSpaceOraclev9i tableSpaceOraclev9i) {
        String string;
        String string2 = tableSpaceOraclev9i.getContents();
        String string3 = tableSpaceOraclev9i.getExtentManagement();
        if (string2.equalsIgnoreCase("PERMANENT") && string3.equalsIgnoreCase("LOCAL") && !"".equals(string = tableSpaceOraclev9i.getSegmentManagement())) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append("    ").append("SEGMENT SPACE MANAGEMENT ").append(string);
        }
    }

    private void appendBlockSize(StringBuffer stringBuffer, TableSpaceOraclev9i tableSpaceOraclev9i) {
        int n = tableSpaceOraclev9i.getBlockSize();
        if (n > 0) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append("    ").append("BLOCKSIZE ").append(n);
        }
    }

    private void appendDataFiles(StringBuffer stringBuffer, TableSpaceOraclev9i tableSpaceOraclev9i, List list) {
        Iterator iterator = list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            DataFileOracle dataFileOracle = (DataFileOracle)iterator.next();
            if (!bl) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append("    ");
                SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, "DATAFILE");
                bl = true;
            } else {
                SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, ',');
            }
            String string = dataFileOracle.getFileName().trim();
            if (!string.equals("")) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append("    ").append("    ");
                SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, this.addQuotes(string, true));
            }
            if (dataFileOracle.getSize() > 0L) {
                SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, "SIZE");
                this.appendStringWithSpace(stringBuffer, dataFileOracle.getSize());
                SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, dataFileOracle.getMeasureUnit());
            }
            if (dataFileOracle.getReuse().equalsIgnoreCase("YES") && !string.equals("")) {
                SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, "REUSE");
            }
            if (!"ON".equalsIgnoreCase(dataFileOracle.getAutoextend()) && !"OFF".equalsIgnoreCase(dataFileOracle.getAutoextend())) continue;
            SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, "AUTOEXTEND");
            SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, dataFileOracle.getAutoextend());
            if (!dataFileOracle.getAutoextend().equalsIgnoreCase("ON")) continue;
            SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, "NEXT");
            this.appendStringWithSpace(stringBuffer, dataFileOracle.getNextBlockSize());
            SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, "K");
            SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, "MAXSIZE");
            if (dataFileOracle.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, "UNLIMITED");
                continue;
            }
            SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, dataFileOracle.getMaxSize());
            SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, "K");
        }
    }

    private void appendMinimumExtent(StringBuffer stringBuffer, TableSpaceOraclev9i tableSpaceOraclev9i) {
        int n;
        if ("DICTIONARY".equalsIgnoreCase(tableSpaceOraclev9i.getExtentManagement()) && (n = tableSpaceOraclev9i.getMinExtLen()) > 0) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append("    ").append("MINIMUM EXTENT ").append(n);
        }
    }

    private void appendLogging(StringBuffer stringBuffer, TableSpaceOraclev9i tableSpaceOraclev9i) {
        String string = tableSpaceOraclev9i.getLogging();
        stringBuffer.append(NEWLINE);
        stringBuffer.append("    ").append(string);
    }

    private void appendForceLogging(StringBuffer stringBuffer, TableSpaceOraclev9i tableSpaceOraclev9i, boolean bl) {
        if ("YES".equalsIgnoreCase(tableSpaceOraclev9i.getForceLogging())) {
            SSBTableSpaceOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, "FORCE");
            SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
        }
    }

    private void appendStatus(StringBuffer stringBuffer, TableSpaceOraclev9i tableSpaceOraclev9i) {
        String string = tableSpaceOraclev9i.getStatus();
        stringBuffer.append(NEWLINE);
        stringBuffer.append("    ").append(string);
    }

    private void appendContents(StringBuffer stringBuffer, TableSpaceOraclev9i tableSpaceOraclev9i) {
        String string = tableSpaceOraclev9i.getContents();
        stringBuffer.append(NEWLINE);
        stringBuffer.append("    ").append(string);
    }

    private void appendDefaultStorage(StringBuffer stringBuffer, TableSpaceOraclev9i tableSpaceOraclev9i) {
        if ("DICTIONARY".equalsIgnoreCase(tableSpaceOraclev9i.getExtentManagement())) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append("    ").append("DEFAULT STORAGE (");
            long l = tableSpaceOraclev9i.getDSInitialExtent();
            long l2 = tableSpaceOraclev9i.getDSNextExtent();
            int n = tableSpaceOraclev9i.getDSMinExtents();
            String string = tableSpaceOraclev9i.getDSMaxExtents();
            int n2 = tableSpaceOraclev9i.getDSPctIncrease();
            if (l > 0L) {
                stringBuffer.append("INITIAL ").append(l).append(' ');
            }
            if (l2 > 0L) {
                stringBuffer.append("NEXT ").append(l2).append(' ');
            }
            if (n > 1) {
                stringBuffer.append("MINEXTENTS ").append(n).append(' ');
            }
            stringBuffer.append("MAXEXTENTS ").append(string).append(" PCTINCREASE ").append(n2);
            stringBuffer.append(")");
        }
    }

    private void appendExtentManagement(StringBuffer stringBuffer, TableSpaceOraclev9i tableSpaceOraclev9i) {
        String string = tableSpaceOraclev9i.getExtentManagement();
        stringBuffer.append(NEWLINE);
        stringBuffer.append("    ").append("EXTENT MANAGEMENT ").append(string);
    }

    private void appendLocalSubType(StringBuffer stringBuffer, TableSpaceOraclev9i tableSpaceOraclev9i) {
        String string;
        if ("LOCAL".equalsIgnoreCase(tableSpaceOraclev9i.getExtentManagement()) && "UNIFORM".equalsIgnoreCase(string = tableSpaceOraclev9i.getEMLocalSubtype())) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append("    ");
            SSBTableSpaceOraclev9i.appendStringWithSpace(stringBuffer, string);
        }
    }

    private void appendUniformSize(StringBuffer stringBuffer, TableSpaceOraclev9i tableSpaceOraclev9i) {
        int n;
        if ("LOCAL".equalsIgnoreCase(tableSpaceOraclev9i.getExtentManagement()) && "UNIFORM".equalsIgnoreCase(tableSpaceOraclev9i.getEMLocalSubtype()) && (n = tableSpaceOraclev9i.getEMUniformSize()) > 0) {
            stringBuffer.append(" SIZE ").append(n);
        }
    }
}

