/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFK_CheckConstr;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBTableOraclev10g;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBIndexOraclev9i;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.LobStorageOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxySetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueSetOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableOraclev9i
extends AbstractSSBOracle {
    private SSBIndexOraclev9i ssbIndex = null;
    private PKProxyOraclev9i pk = null;
    private StorageDesignOraclev9i storageDesign;
    private Table table;
    private TableProxyOraclev9i tableProxy = null;
    private SSBArcFK_CheckConstr arcConstrHandler;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxyOraclev9i && ((TableProxyOracle)object).getSnapshot() == null;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        ModelIDObject modelIDObject;
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        this.table = null;
        if (object == null) {
            return;
        }
        if (object instanceof Table) {
            this.table = (Table)object;
            modelIDObject = this.table.getDesign();
            RDBMSSite rDBMSSite = this.table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev9i)((Design)modelIDObject).getStorageDesign(rDBMSSite, this.table);
            this.tableProxy = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        } else if (object instanceof TableProxyOraclev9i) {
            this.tableProxy = (TableProxyOraclev9i)object;
            this.table = (Table)this.tableProxy.getObject();
            modelIDObject = this.table.getDesign();
            this.storageDesign = (StorageDesignOraclev9i)((Design)modelIDObject).getStorageDesign(this.table.getSelectedRDBMSSite(), this.table);
        } else {
            return;
        }
        if (this.tableProxy != null && !this.tableProxy.isMarkedGenerate()) {
            this.appendIndexes(stringBuffer, this.tableProxy, bl);
            return;
        }
        if (this.table.getTypeSubstitution() == null) {
            if (this.table != null) {
                if (this.tableProxy != null && this.tableProxy.isCommentChanged()) {
                    this.appendComment(stringBuffer, this.tableProxy);
                } else {
                    this.appendComment(stringBuffer, this.table);
                }
                if (this.tableProxy != null && this.tableProxy.getName().length() > this.tableProxy.getMaxNameLength()) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + this.tableProxy.getMaxNameLength() + ")");
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementErrors();
                }
                this.appendBeforeCreateScript(stringBuffer, bl, this.table);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "CREATE");
                if (this.tableProxy == null) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "TABLE");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(this.table.getLongName()));
                    string = stringBuffer2.toString();
                    this.appendElementList(stringBuffer2, this.table, null, bl);
                    this.appendOid(stringBuffer2, this.table, null, bl);
                } else if ("YES".equalsIgnoreCase(this.tableProxy.getTemporary())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "GLOBAL");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "TEMPORARY");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "TABLE");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(this.tableProxy.getLongName()));
                    string = stringBuffer2.toString();
                    this.appendElementList(stringBuffer2, this.table, this.tableProxy, bl);
                    SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "ON");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "COMMIT");
                    if ("YES".equalsIgnoreCase(this.tableProxy.getTempPreserveRows())) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "PRESERVE ROWS");
                    } else {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "DELETE ROWS");
                    }
                    this.appendOid(stringBuffer2, this.table, null, bl);
                    if ("YES".equalsIgnoreCase(this.tableProxy.getCache())) {
                        SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 1);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "CACHE");
                    }
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "TABLE");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(this.tableProxy.getLongName()));
                    string = stringBuffer2.toString();
                    this.appendElementList(stringBuffer2, this.table, this.tableProxy, bl);
                    this.appendOid(stringBuffer2, this.table, this.tableProxy, bl);
                    this.appendCluster(stringBuffer2, this.tableProxy, bl);
                    this.appendColumnProperties(stringBuffer2, this.table, this.tableProxy, bl);
                    this.appendPartitionList(stringBuffer2, this.tableProxy, bl);
                    if ("YES".equalsIgnoreCase(this.tableProxy.getCache())) {
                        SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 1);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "CACHE");
                    }
                    if ("YES".equalsIgnoreCase(this.tableProxy.getRowDependency())) {
                        SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 1);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "ROWDEPENDENCIES");
                        modelIDObject = this.tableProxy.getCluster();
                        if (modelIDObject != null && !((ClusterOracle)modelIDObject).getRowDependency().equalsIgnoreCase("YES")) {
                            SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "--  ERROR: Cluster has different ROWDEPENDENCIES setting");
                            DDLFileMaker.incrementErrors();
                        }
                    }
                    if ("YES".equalsIgnoreCase(this.tableProxy.getMonitoring())) {
                        SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 1);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "MONITORING");
                    }
                    if ("YES".equalsIgnoreCase(this.tableProxy.getParallel())) {
                        SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 1);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "PARALLEL");
                        if (!"".equalsIgnoreCase(this.tableProxy.getDegree())) {
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, this.tableProxy.getDegree());
                        }
                    }
                }
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                this.appendLineFinisher(stringBuffer2, bl);
                SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                DDLFileMaker.incrementCreateTable();
                if (this.tableProxy != null) {
                    this.appendColumnCheckConstraints(stringBuffer, this.tableProxy, bl);
                    this.appendTableLevelCheckConstraints(stringBuffer, this.tableProxy, bl);
                    if (this.getArcConstrHandler() != null) {
                        this.getArcConstrHandler().appendArcConstraints(stringBuffer, this.tableProxy, bl);
                    }
                }
                if (this.table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendTableCommentOn(stringBuffer, this.table, this.tableProxy, bl);
                }
                if (this.tableProxy != null) {
                    this.appendIndexes(stringBuffer, this.tableProxy, bl);
                    this.appendPermissions(stringBuffer, this.tableProxy, bl);
                    if (this.table.getDesign().getAppView().getSettings().isGenerateTypeSubstTriggers()) {
                        this.appendSubstitutionTrigger(stringBuffer, this.table, this.tableProxy, bl);
                        this.appendColumnSubstitutionTrigger(stringBuffer, this.table, this.tableProxy, bl);
                    }
                }
                this.appendAfterCreateScript(stringBuffer, bl, this.table);
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
            }
        } else {
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "-- Table " + this.table.getName() + ": is a part of type substitution hierarchy");
        }
        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
    }

    private void appendSubstitutionTrigger(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle, boolean bl) {
        if (table.isBST() && table.getSubTypeSubstitutions().size() > 0) {
            Object object;
            String string = "";
            Iterator iterator = table.getAllowedStrTypeInstances().iterator();
            boolean bl2 = true;
            while (iterator.hasNext()) {
                object = (StructuredType)iterator.next();
                StructuredTypeProxyOracle structuredTypeProxyOracle = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy((DesignObject)object);
                if (structuredTypeProxyOracle == null || !structuredTypeProxyOracle.getStructuredType().isInstantiable()) continue;
                String string2 = this.storageDesign.getFormatedName(structuredTypeProxyOracle.getLongName());
                if (bl2) {
                    string = ((StructuredType)object).getAllSubTypes().size() > 0 ? "ONLY " + string2 : string2;
                    bl2 = false;
                    continue;
                }
                string = string + ", " + (((StructuredType)object).getAllSubTypes().size() > 0 ? "ONLY " + string2 : string2);
            }
            if (!"".equals(string)) {
                object = this.storageDesign.getFormatedName("OBJ_SUBS_TR_" + this.getStringWithMaxLength(tableProxyOracle.getName(), 18));
                if (tableProxyOracle.getUser() != null) {
                    object = this.storageDesign.getFormatedName(tableProxyOracle.getUser().getName()) + "." + (String)object;
                }
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "CREATE OR REPLACE TRIGGER " + (String)object);
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BEFORE INSERT ON " + this.storageDesign.getFormatedName(tableProxyOracle.getLongName()));
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "FOR EACH ROW");
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BEGIN");
                this.appendCWDTableMeta(stringBuffer, table, tableProxyOracle, bl);
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, " IF :new.sys_nc_rowinfo$ IS NOT OF ( " + string + " ) THEN");
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "  raise_application_error(-20222,' Only instances of " + string.replaceAll("ONLY ", "") + " are permited');");
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, " END IF;");
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "END;");
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "/");
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
            }
        }
    }

    private void appendColumnSubstitutionTrigger(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle, boolean bl) {
        List list = this.getColumnsWithManyRestrictedSubType(table);
        if (list.size() > 0) {
            String string;
            ModelIDObject modelIDObject;
            boolean bl2 = true;
            boolean bl3 = false;
            String string2 = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                Column column = (Column)list.get(i);
                modelIDObject = tableProxyOracle.getColumnProxy(column.getObjectID());
                string = modelIDObject == null ? column.getName() : ((RelationalObjectProxy)modelIDObject).getName();
                arrayList.add(string);
                if (bl2) {
                    string2 = this.storageDesign.getFormatedName(string);
                    bl2 = false;
                } else {
                    string2 = string2 + ", " + this.storageDesign.getFormatedName(string);
                }
                if (!column.isReference()) continue;
                bl3 = true;
            }
            if (!"".equals(string2)) {
                ModelIDObject modelIDObject2;
                Object object;
                Object object2;
                String string3 = this.storageDesign.getFormatedName(COLUMN_SUBST_TR_PREFIX + this.getStringWithMaxLength(tableProxyOracle.getName(), 30 - COLUMN_SUBST_TR_PREFIX.length()));
                if (tableProxyOracle.getUser() != null) {
                    string3 = this.storageDesign.getFormatedName(tableProxyOracle.getUser().getName()) + "." + string3;
                }
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "CREATE OR REPLACE TRIGGER " + string3);
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BEFORE INSERT OR UPDATE OF " + string2 + " ON " + this.storageDesign.getFormatedName(tableProxyOracle.getLongName()));
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "FOR EACH ROW");
                if (bl3) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "DECLARE ");
                    for (int i = 0; i < list.size(); ++i) {
                        modelIDObject = (Column)list.get(i);
                        if (!((ContainedObjectWithDomain)modelIDObject).isReference()) continue;
                        string = (String)arrayList.get(i);
                        object2 = (StructuredType)((Column)modelIDObject).getDataType();
                        object = "";
                        modelIDObject2 = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy((DesignObject)object2);
                        object = modelIDObject2 != null ? ((StructuredTypeProxyOracle)modelIDObject2).getLongName() : ((DesignObject)object2).getName();
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, " " + this.storageDesign.getFormatedName(string + "$inst"));
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName((String)object) + ";");
                    }
                }
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BEGIN");
                this.appendCWDColumnMeta(stringBuffer, list, bl);
                for (int i = 0; i < list.size(); ++i) {
                    modelIDObject = (Column)list.get(i);
                    string = (String)arrayList.get(i);
                    object2 = "";
                    object = ((ContainedObjectWithDomain)modelIDObject).getPermittedSubTypes().iterator();
                    bl2 = true;
                    while (object.hasNext()) {
                        modelIDObject2 = (StructuredType)object.next();
                        StructuredTypeProxyOracle structuredTypeProxyOracle = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy((DesignObject)modelIDObject2);
                        if (structuredTypeProxyOracle == null || !structuredTypeProxyOracle.getStructuredType().isInstantiable()) continue;
                        String string4 = this.storageDesign.getFormatedName(structuredTypeProxyOracle.getLongName());
                        if (bl2) {
                            object2 = ((StructuredType)modelIDObject2).getAllSubTypes().size() > 0 ? "ONLY " + string4 : string4;
                            bl2 = false;
                            continue;
                        }
                        object2 = (String)object2 + ", " + (((StructuredType)modelIDObject2).getAllSubTypes().size() > 0 ? "ONLY " + string4 : string4);
                    }
                    if (((ContainedObjectWithDomain)modelIDObject).isReference()) {
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, " SELECT deref(:new." + string + ") INTO " + string + "$inst FROM DUAL;");
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, " IF " + string + "$inst IS NOT OF ( " + (String)object2 + " ) THEN");
                    } else {
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, " IF :new." + string + " IS NOT OF ( " + (String)object2 + " ) THEN");
                    }
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "  raise_application_error(-20222,'Column " + string + " - Only instances of " + ((String)object2).replaceAll("ONLY ", "") + " are permited');");
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, " END IF;");
                }
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "END;");
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "/");
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
            }
        }
    }

    private void appendColumnProperties(StringBuffer stringBuffer, Table table, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            ColumnProxyOraclev9i columnProxyOraclev9i = (ColumnProxyOraclev9i)tableProxyOraclev9i.getColumnProxy(column.getObjectID());
            Datatype datatype = columnProxyOraclev9i.getDataType();
            if (datatype.toString().equals("XMLTYPE")) {
                this.appendXMLTypeColumnProps(stringBuffer, columnProxyOraclev9i, bl);
                continue;
            }
            if (datatype instanceof CollectionType) {
                CollectionType collectionType = (CollectionType)datatype;
                if (collectionType.isArrayType()) {
                    this.appendVarrayColumnProp(stringBuffer, columnProxyOraclev9i, bl);
                    continue;
                }
                this.appendNestedTableColumnProp(stringBuffer, columnProxyOraclev9i, bl);
                continue;
            }
            if (!(datatype instanceof StructuredType)) continue;
            this.appendSubstitutableColumnClause(stringBuffer, columnProxyOraclev9i, bl, true);
        }
    }

    private void appendXMLTypeColumnProps(StringBuffer stringBuffer, ColumnProxyOraclev9i columnProxyOraclev9i, boolean bl) {
        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "XMLTYPE");
        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "COLUMN");
        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getName()));
        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "STORE AS");
        if (columnProxyOraclev9i.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "OBJECT RELATIONAL");
        } else {
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "CLOB");
            String string = columnProxyOraclev9i.getLobSegmentName();
            if (string != null && string.length() > 0) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
            }
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (columnProxyOraclev9i.getTablespace() != null) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getTablespace().getName()));
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            }
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "STORAGE");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
            if (columnProxyOraclev9i.getSCInitialExtent() > 0L) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCInitialExtent());
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
            }
            if (columnProxyOraclev9i.getSCNextExtent() > 0L) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCNextExtent());
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
            }
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCPctIncrease());
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCMinExtents());
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCMaxExtents());
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCFreeLists());
            if (columnProxyOraclev9i.getSCFreelistGroups() > 1) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "FREELIST");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "GROUPS");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCFreelistGroups());
            }
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCBufferPool());
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (columnProxyOraclev9i.getChunk() > 0) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "CHUNK");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getChunk());
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            }
            if (columnProxyOraclev9i.getOldVersions().equalsIgnoreCase("RETENTION")) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "RETENTION");
            } else {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PCTVERSION");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getPCTVersion());
            }
            if (columnProxyOraclev9i.getSCFreelistGroups() <= 1 && columnProxyOraclev9i.getFreepools() > 0) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "FREEPOOLS");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getFreepools());
            }
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if ("ENABLE".equalsIgnoreCase(columnProxyOraclev9i.getStorageInRow())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "ENABLE");
            } else {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "DISABLE");
            }
            stringBuffer.append("STORAGE IN ROW");
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getCache());
            if (!"CACHE".equalsIgnoreCase(columnProxyOraclev9i.getCache())) {
                if ("YES".equalsIgnoreCase(columnProxyOraclev9i.getLogging())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(columnProxyOraclev9i.getLogging())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOLOGGING");
                }
            }
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
        this.appendXMLSchemaSpec(stringBuffer, columnProxyOraclev9i.getXmlSchemaUrl(), columnProxyOraclev9i.getXmlSchemaElement(), bl);
    }

    private void appendXMLSchemaSpec(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        if (string2 != null && string2.length() > 0) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (string != null && string.length() > 0) {
                stringBuffer.append("XMLSCHEMA").append(' ').append('\"').append(string).append('\"');
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            }
            stringBuffer.append("ELEMENT").append(' ').append('\"').append(string2).append('\"').append(' ');
        }
    }

    private void appendVarrayColumnProp(StringBuffer stringBuffer, ColumnProxyOraclev9i columnProxyOraclev9i, boolean bl) {
        if (this.hasVarrayClause(columnProxyOraclev9i)) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "VARRAY");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getName()));
            this.appendSubstitutableColumnClause(stringBuffer, columnProxyOraclev9i, bl, false);
            if (!columnProxyOraclev9i.getLobSegname().equals("")) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "STORE AS");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOB");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getLobSegname()));
            }
        }
    }

    private void appendOid(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle, boolean bl) {
        if (table.isRoot()) {
            if (table.isOidIsPK() && table.getOidPKColumns().size() > 0) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "OBJECT");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "IDENTIFIER");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "IS");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
            }
            if (!(tableProxyOracle == null || tableProxyOracle.getOidIndexSegment() == null && "".equalsIgnoreCase(tableProxyOracle.getOidIndexName()))) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "OIDINDEX");
                if (!"".equalsIgnoreCase(tableProxyOracle.getOidIndexName())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOracle.getOidIndexName()));
                }
                if (tableProxyOracle.getOidIndexSegment() != null) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    this.appendSegment(stringBuffer, (SegmentOraclev9i)tableProxyOracle.getOidIndexSegment(), false, bl, null, "");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                }
            }
        }
    }

    private void appendObjectTypeColProperties(StringBuffer stringBuffer, Table table, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        if (table.isBST() && tableProxyOraclev9i != null) {
            ModelIDObject modelIDObject;
            int n;
            Column[] columnArray = (Column[])table.getElements();
            boolean bl2 = false;
            if (table.getOidPKColumns().size() > 0 || tableProxyOraclev9i.getTableCheckConstraints().size() > 0) {
                bl2 = true;
            }
            if (!bl2) {
                Column column;
                for (n = 0; n < columnArray.length && !(bl2 = this.shouldGenerateObjectPropDefinition(column = columnArray[n], (ColumnProxyOracle)(modelIDObject = (ColumnProxyOracle)tableProxyOraclev9i.getColumnProxy(column.getObjectID())))); ++n) {
                }
            }
            if (bl2) {
                n = 1;
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                for (int i = 0; i < columnArray.length; ++i) {
                    modelIDObject = columnArray[i];
                    ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)tableProxyOraclev9i.getColumnProxy(modelIDObject.getObjectID());
                    if (!this.shouldGenerateObjectPropDefinition((Column)modelIDObject, columnProxyOracle)) continue;
                    if (n == 0) {
                        this.appendComma(stringBuffer);
                    } else {
                        n = 0;
                    }
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOracle.getStorageDesign().getFormatedName(columnProxyOracle.getName()));
                    this.appendColumnOptions(stringBuffer, (Column)modelIDObject, columnProxyOracle, bl);
                    this.appendColumnRefConstraint(stringBuffer, (Column)modelIDObject, columnProxyOracle, bl);
                    this.appendColumnConstraints(stringBuffer, (Column)modelIDObject, columnProxyOracle, bl);
                }
                n = this.appendTableConstraintsDefinition(stringBuffer, tableProxyOraclev9i, bl, n != 0) ? 1 : 0;
                if (table.getOidPKColumns().size() > 0) {
                    if (n == 0) {
                        this.appendComma(stringBuffer);
                    } else {
                        n = 0;
                    }
                    this.appendPK_ObjectType(stringBuffer, table, tableProxyOraclev9i, bl);
                }
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private boolean shouldGenerateObjectPropDefinition(Column column, ColumnProxyOracle columnProxyOracle) {
        if (column.isOid()) {
            return false;
        }
        if (!column.getNullsAllowed()) {
            return true;
        }
        String string = columnProxyOracle.getDefaultValue();
        if (string != null && !"".equalsIgnoreCase(string)) {
            return true;
        }
        if (column.isReference() && "YES".equalsIgnoreCase(columnProxyOracle.getWithRowId())) {
            return true;
        }
        return SSBTableOraclev10g.willGenerateInlineColumnConstrOra(column, columnProxyOracle);
    }

    private void appendPK_ObjectType(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle, boolean bl) {
        String string = this.storageDesign.getFormatedName(tableProxyOracle.getPKName());
        if (!"".equals(string)) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, string);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            boolean bl2 = true;
            for (Column column : table.getOidPKColumns()) {
                ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)tableProxyOracle.getColumnProxy(column.getObjectID());
                if (bl2) {
                    bl2 = false;
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
                }
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOracle.getStorageDesign().getFormatedName(columnProxyOracle.getName()));
            }
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendElementList(StringBuffer stringBuffer, Table table, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        Column[] columnArray = (Column[])table.getElements();
        Column column = null;
        RelationalObjectProxy relationalObjectProxy = null;
        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
        if (table.getBasedOnStructuredType() != null) {
            Object object;
            StructuredType structuredType = table.getBasedOnStructuredType();
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "OF");
            String string = structuredType.getName();
            if (tableProxyOraclev9i != null && (object = (StructuredTypeProxyOracle)tableProxyOraclev9i.getStorageDesign().getProxy(structuredType)) != null) {
                if (((StructuredTypeProxyOracle)object).getOwner() != null) {
                    SSBTableOraclev9i.appendString(stringBuffer, this.storageDesign.getFormatedName(((StructuredTypeProxyOracle)object).getOwner().getName()));
                    SSBTableOraclev9i.appendString(stringBuffer, '.');
                }
                string = ((RelationalObjectProxy)object).getName();
            }
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
            if (string.equalsIgnoreCase("XMLTYPE")) {
                this.appendObjectTypeColProperties(stringBuffer, table, tableProxyOraclev9i, bl);
                if (tableProxyOraclev9i != null) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "XMLTYPE");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "STORE AS");
                    if (tableProxyOraclev9i.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "OBJECT RELATIONAL");
                    } else {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "CLOB");
                        object = tableProxyOraclev9i.getLobSegmentName();
                        if (object != null && ((String)object).length() > 0) {
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName((String)object));
                        }
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
                        if (tableProxyOraclev9i.getXmlTypeTableSpace() != null) {
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOraclev9i.getXmlTypeTableSpace().getName()));
                            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
                        }
                        if (tableProxyOraclev9i.getChunk() > 0) {
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "CHUNK");
                            this.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getChunk());
                            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
                        }
                        if (tableProxyOraclev9i.getOldVersions().equalsIgnoreCase("RETENTION")) {
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "RETENTION");
                        } else {
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PCTVERSION");
                            this.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getPCTVersion());
                        }
                        if (tableProxyOraclev9i.getFreepools() > 0) {
                            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "FREEPOOLS");
                            this.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getFreepools());
                        }
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
                        if ("ENABLE".equalsIgnoreCase(tableProxyOraclev9i.getStorageInRow())) {
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "ENABLE");
                        } else {
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "DISABLE");
                        }
                        stringBuffer.append("STORAGE IN ROW");
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getXmlTypeCache());
                        if (!"CACHE".equalsIgnoreCase(tableProxyOraclev9i.getXmlTypeCache())) {
                            if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getXmlTypeLogging())) {
                                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
                            } else if ("NO".equalsIgnoreCase(tableProxyOraclev9i.getXmlTypeLogging())) {
                                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOLOGGING");
                            }
                        }
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                    }
                    this.appendXMLSchemaSpec(stringBuffer, tableProxyOraclev9i.getXmlSchemaUrl(), tableProxyOraclev9i.getXmlSchemaElement(), bl);
                }
            } else {
                if (!table.isSubstitutable()) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOT");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "SUBSTITUTABLE");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "AT");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "ALL");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LEVELS");
                }
                this.appendObjectTypeColProperties(stringBuffer, table, tableProxyOraclev9i, bl);
            }
        } else if (columnArray.length < 1) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "-- No Columns");
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
        } else {
            boolean bl2 = true;
            for (int i = 0; i < columnArray.length; ++i) {
                RelationalObjectProxy relationalObjectProxy2;
                column = columnArray[i];
                if (column.isOid()) continue;
                if (bl2) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    bl2 = false;
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
                }
                if (tableProxyOraclev9i != null) {
                    relationalObjectProxy = (ColumnProxyOraclev9i)tableProxyOraclev9i.getColumnProxy(column.getObjectID());
                }
                if (relationalObjectProxy.getName().length() > ((ColumnProxyOracle)relationalObjectProxy).getMaxNameLength()) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "--  ERROR: Column name length exceeds maximum allowed length(" + ((ColumnProxyOracle)relationalObjectProxy).getMaxNameLength() + ")");
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementErrors();
                }
                if (relationalObjectProxy.isCommentChanged() && !"".equalsIgnoreCase(relationalObjectProxy.getComment())) {
                    this.appendComment(stringBuffer, relationalObjectProxy);
                } else if (!"".equalsIgnoreCase(relationalObjectProxy.getObject().getComment())) {
                    this.appendComment(stringBuffer, relationalObjectProxy.getObject());
                }
                if (this.endsWithNewline(stringBuffer)) {
                    this.appendTab(stringBuffer, bl, 1);
                } else {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                }
                SSBTableOraclev9i.appendString(stringBuffer, ' ');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(relationalObjectProxy.getName()));
                String string = "";
                Datatype datatype = column.getDataType();
                if ((datatype instanceof StructuredType || datatype instanceof CollectionType) && (relationalObjectProxy2 = this.storageDesign.getProxy(datatype)) != null) {
                    string = this.storageDesign.getFormatedName(relationalObjectProxy2.getLongName());
                    if (column.isReference() && datatype instanceof StructuredType) {
                        string = "REF " + string;
                    }
                }
                if (string.equals("")) {
                    string = column.getDatatypeString("Oracle9i");
                }
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, string);
                if (string.equalsIgnoreCase("unknown")) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "--  ERROR: Datatype UNKNOWN is not allowed");
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 5);
                    DDLFileMaker.incrementErrors();
                }
                if (tableProxyOraclev9i == null) continue;
                this.appendColumnOptions(stringBuffer, column, (ColumnProxyOracle)relationalObjectProxy, bl);
                this.appendInlineRefConstraint(stringBuffer, column, (ColumnProxyOraclev9i)relationalObjectProxy, bl);
                this.appendColumnConstraints(stringBuffer, column, (ColumnProxyOracle)relationalObjectProxy, bl);
            }
            if ("INDEX".equalsIgnoreCase(tableProxyOraclev9i.getOrganization())) {
                this.appendPKDefinitionConstraint(stringBuffer, tableProxyOraclev9i, bl);
            }
            this.appendTableConstraintsDefinition(stringBuffer, tableProxyOraclev9i, bl, false);
            this.appendSupplementalLoggings(stringBuffer, tableProxyOraclev9i, bl);
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendInlineRefConstraint(StringBuffer stringBuffer, Column column, ColumnProxyOraclev9i columnProxyOraclev9i, boolean bl) {
        this.appendWithRowid(stringBuffer, column, columnProxyOraclev9i, bl);
    }

    private void appendColumnRefConstraint(StringBuffer stringBuffer, Column column, ColumnProxyOracle columnProxyOracle, boolean bl) {
        this.appendWithRowid(stringBuffer, column, columnProxyOracle, bl);
    }

    private void appendWithRowid(StringBuffer stringBuffer, Column column, ColumnProxyOracle columnProxyOracle, boolean bl) {
        if (column.isReference() && "YES".equalsIgnoreCase(columnProxyOracle.getWithRowId())) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "WITH");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "ROWID");
        }
    }

    private void appendColumnOptions(StringBuffer stringBuffer, Column column, ColumnProxyOracle columnProxyOracle, boolean bl) {
        this.appendWithDefaultDefinition(stringBuffer, columnProxyOracle);
        if (!column.getNullsAllowed()) {
            this.appendNotNullDefinition(stringBuffer, columnProxyOracle, bl);
        }
    }

    private void appendWithDefaultDefinition(StringBuffer stringBuffer, ColumnProxyOracle columnProxyOracle) {
        boolean bl = columnProxyOracle.getStorageDesign().isOpen();
        String string = "";
        Column column = columnProxyOracle.getColumn();
        string = !bl ? column.getDefaultValue() : columnProxyOracle.getDefaultValue();
        if (string != null && !"".equalsIgnoreCase(string)) {
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "DEFAULT");
            String string2 = column.getDatatypeString("Oracle9i");
            String string3 = this.addQuotesToDefault(string2, string);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, string3);
        }
    }

    private void appendColumnConstraints(StringBuffer stringBuffer, Column column, ColumnProxyOracle columnProxyOracle, boolean bl) {
        if (SSBTableOraclev10g.willGenerateInlineColumnConstrOra(column, columnProxyOracle)) {
            String string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxyOracle.getName()));
            String string2 = column.getConstraintName();
            if (!string2.equals("") && !string2.toUpperCase().startsWith("SYS_") && string2.length() <= 30) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
            }
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev9i.appendString(stringBuffer, string);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            SSBTableOraclev10g.appendConstraintState(stringBuffer, columnProxyOracle, true, bl);
        }
    }

    private PKProxyOraclev9i getPKProxy(TableProxyOracle tableProxyOracle) {
        PKProxySetOraclev9i pKProxySetOraclev9i = (PKProxySetOraclev9i)((StorageDesignOraclev9i)tableProxyOracle.getStorageDesign()).getPKProxySet();
        if (pKProxySetOraclev9i != null) {
            Iterator iterator = pKProxySetOraclev9i.iterator();
            while (iterator.hasNext()) {
                PKProxyOraclev9i pKProxyOraclev9i = (PKProxyOraclev9i)iterator.next();
                if (pKProxyOraclev9i.getTable() == null || pKProxyOraclev9i.getTable() != tableProxyOracle.getObject()) continue;
                return pKProxyOraclev9i;
            }
        }
        return null;
    }

    private void appendPKDefinition(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        if (tableProxyOracle != null) {
            this.pk = this.getPKProxy(tableProxyOracle);
            if (this.pk != null && this.pk.isMarkedGenerate()) {
                Index index = (Index)this.pk.getObject();
                if (!"".equalsIgnoreCase(this.pk.getColumns()) || !"".equals(index.getIndexExpression())) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                    if (this.pk.isCommentChanged() && !"".equalsIgnoreCase(this.pk.getComment())) {
                        this.appendComment(stringBuffer, this.pk);
                    } else if (!"".equalsIgnoreCase(this.pk.getObject().getComment())) {
                        this.appendComment(stringBuffer, this.pk.getObject());
                    }
                    String string2 = this.pk.getName();
                    if (string2.length() > tableProxyOracle.getMaxNameLength()) {
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "--  ERROR: PK name length exceeds maximum allowed length(" + tableProxyOracle.getMaxNameLength() + ")");
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "ALTER");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "TABLE");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(tableProxyOracle.getLongName()));
                    string = stringBuffer2.toString();
                    SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "ADD");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string2));
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "PRIMARY KEY");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, '(');
                    if (!"".equals(index.getIndexExpression())) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, index.getIndexExpression());
                    } else {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, this.pk.getColumns(this.storageDesign));
                    }
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, ')');
                    if (!"NO".equalsIgnoreCase(this.pk.getDeferrable())) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "DEFERRABLE");
                        if ("DEFERRED".equalsIgnoreCase(this.pk.getInitially())) {
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "INITIALLY");
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "DEFERRED");
                        }
                    }
                    if (!"YES".equalsIgnoreCase(this.pk.getEnable())) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "DISABLE");
                        if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "VALIDATE");
                        }
                    }
                    if (!"YES".equalsIgnoreCase(this.pk.getValidate())) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "NOVALIDATE");
                    }
                    if (!"NO".equalsIgnoreCase(this.pk.getUsingIndex())) {
                        this.appendUsingIndex(stringBuffer2, this.pk, bl);
                    }
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    this.appendLineFinisher(stringBuffer2, bl);
                    SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    DDLFileMaker.incrementAlterTable();
                }
            }
        }
    }

    private void appendPKDefinitionConstraint(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl) {
        if (tableProxyOracle != null) {
            this.pk = this.getPKProxy(tableProxyOracle);
            if (this.pk != null) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendString(stringBuffer, ' ');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(this.pk.getName()));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.pk.getColumns(this.storageDesign));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                if (!"YES".equalsIgnoreCase(this.pk.getEnable())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(this.pk.getValidate())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOVALIDATE");
                }
                if (!"NO".equalsIgnoreCase(this.pk.getUsingIndex())) {
                    this.appendUsingIndex(stringBuffer, this.pk, bl);
                }
            }
        }
    }

    private void appendSupplementalLoggings(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        if (!"".equalsIgnoreCase(tableProxyOraclev9i.getSuplementalLogGroupName())) {
            this.appendComma(stringBuffer);
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "SUPPLEMENTAL");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOG");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "GROUP");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOraclev9i.getSuplementalLogGroupName()));
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(tableProxyOraclev9i.getAllSuplementalLogColumns()));
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            if (tableProxyOraclev9i.getSuplementalLogConditions().equalsIgnoreCase("ALWAYS")) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "ALWAYS");
            }
        }
    }

    private boolean appendTableConstraintsDefinition(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl, boolean bl2) {
        Iterator iterator = tableProxyOraclev9i.getTableCheckConstraints().iterator();
        while (iterator.hasNext()) {
            TableCheckConstraintOracle tableCheckConstraintOracle = (TableCheckConstraintOracle)iterator.next();
            String string = tableCheckConstraintOracle.getTableConstraint().getRule();
            String string2 = tableCheckConstraintOracle.getName();
            if (string2.toUpperCase().startsWith("SYS_")) {
                string2 = "";
            }
            if (!"".equals(string2) || "".equals(string)) continue;
            if (bl2) {
                bl2 = false;
            } else {
                this.appendComma(stringBuffer);
            }
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableOraclev9i.appendString(stringBuffer, '(');
            SSBTableOraclev9i.appendString(stringBuffer, string);
            SSBTableOraclev9i.appendString(stringBuffer, ')');
            this.appendTableConstraintState(stringBuffer, tableCheckConstraintOracle, bl);
        }
        return bl2;
    }

    private void appendTableConstraintState(StringBuffer stringBuffer, TableCheckConstraintOracle tableCheckConstraintOracle, boolean bl) {
        if (!"NO".equalsIgnoreCase(tableCheckConstraintOracle.getDeferrable())) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(tableCheckConstraintOracle.getInitially())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "INITIALLY");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "DEFERRED");
            }
        }
        if ("NO".equalsIgnoreCase(tableCheckConstraintOracle.getEnable())) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "DISABLE");
            if ("YES".equalsIgnoreCase(tableCheckConstraintOracle.getValidate())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "VALIDATE");
            }
        }
        if ("NO".equalsIgnoreCase(tableCheckConstraintOracle.getValidate())) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOVALIDATE");
        }
        if (tableCheckConstraintOracle.getExceptionsTable() != null) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "EXCEPTIONS");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "INTO");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableCheckConstraintOracle.getExceptionsTable().getName()));
        }
    }

    private void appendUsingIndex(StringBuffer stringBuffer, PKProxyOraclev9i pKProxyOraclev9i, boolean bl) {
        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "USING INDEX");
        if ("BY INDEX NAME".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex()) && pKProxyOraclev9i.getExistingIndex() != null) {
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(pKProxyOraclev9i.getExistingIndex().getUserNameAndName()));
        } else {
            if ("LOCAL PARTITIONED".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOCAL");
            } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, pKProxyOraclev9i.getCreateIndexStatement());
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            } else if ("GLOBAL PARTITIONED".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex())) {
                this.appendGlobalIndex(stringBuffer, pKProxyOraclev9i, bl);
            }
            if (pKProxyOraclev9i.getIndexSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)pKProxyOraclev9i.getIndexSegment(), false, bl, pKProxyOraclev9i.getTableSpace(), pKProxyOraclev9i.getLogging());
            } else {
                if (pKProxyOraclev9i.getTableSpace() != null) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(pKProxyOraclev9i.getTableSpace().getName()));
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                }
                if (this.storageDesign.isOpen()) {
                    if ("YES".equalsIgnoreCase(pKProxyOraclev9i.getLogging())) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    } else if ("NO".equalsIgnoreCase(pKProxyOraclev9i.getLogging())) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOLOGGING");
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    }
                }
            }
            if (pKProxyOraclev9i.getIndexSort().equalsIgnoreCase("NO")) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOSORT");
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            } else if (pKProxyOraclev9i.getIndexSort().equalsIgnoreCase("REVERSE")) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "REVERSE");
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            }
            if (pKProxyOraclev9i.getComputeStatistics().equalsIgnoreCase("YES")) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
            }
        }
    }

    private void appendUniqueUsingIndex(StringBuffer stringBuffer, UniqueOraclev9i uniqueOraclev9i, boolean bl) {
        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "USING INDEX");
        if ("BY INDEX NAME".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex()) && uniqueOraclev9i.getExistingIndex() != null) {
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(uniqueOraclev9i.getExistingIndex().getUserNameAndName()));
        } else {
            if ("LOCAL PARTITIONED".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOCAL");
            } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, uniqueOraclev9i.getCreateIndexStatement());
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            } else if (uniqueOraclev9i.getUsingIndex().equalsIgnoreCase("GLOBAL PARTITIONED")) {
                this.appendUniqueGlobalIndex(stringBuffer, uniqueOraclev9i, bl);
            }
            if (uniqueOraclev9i.getIndexSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)uniqueOraclev9i.getIndexSegment(), false, bl, uniqueOraclev9i.getTableSpace(), uniqueOraclev9i.getLogging());
            } else {
                if (uniqueOraclev9i.getTableSpace() != null) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(uniqueOraclev9i.getTableSpace().getName()));
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                }
                if (this.storageDesign.isOpen()) {
                    if ("YES".equalsIgnoreCase(uniqueOraclev9i.getLogging())) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    } else if ("NO".equalsIgnoreCase(uniqueOraclev9i.getLogging())) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOLOGGING");
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    }
                }
            }
            if (this.storageDesign.isOpen()) {
                if (uniqueOraclev9i.getIndexSort().equalsIgnoreCase("NO")) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOSORT");
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                } else if (uniqueOraclev9i.getIndexSort().equalsIgnoreCase("REVERSE")) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "REVERSE");
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                }
                if (uniqueOraclev9i.getComputeStatistics().equalsIgnoreCase("YES")) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
                }
            }
        }
    }

    private void appendUniqueGlobalIndex(StringBuffer stringBuffer, UniqueOraclev9i uniqueOraclev9i, boolean bl) {
        if (uniqueOraclev9i.getUsingIndexGlobalPL() != null) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "GLOBAL");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BY");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "RANGE");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(uniqueOraclev9i.getUsingIndexGlobalPL().getAllGlobalPartColumns()));
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            this.appendGlobalPartitions(stringBuffer, (IndexGlobalPartitionsListOraclev9i)uniqueOraclev9i.getUsingIndexGlobalPL(), bl);
        }
    }

    private void appendGlobalIndex(StringBuffer stringBuffer, PKProxyOraclev9i pKProxyOraclev9i, boolean bl) {
        if (pKProxyOraclev9i.getIndexGlobalPL() != null) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "GLOBAL");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BY");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "RANGE");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(pKProxyOraclev9i.getIndexGlobalPL().getAllGlobalPartColumns()));
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            this.appendGlobalPartitions(stringBuffer, (IndexGlobalPartitionsListOraclev9i)pKProxyOraclev9i.getIndexGlobalPL(), bl);
        }
    }

    private void appendGlobalPartitions(StringBuffer stringBuffer, IndexGlobalPartitionsListOraclev9i indexGlobalPartitionsListOraclev9i, boolean bl) {
        IndexGlobalPartitionSetOraclev9i indexGlobalPartitionSetOraclev9i = (IndexGlobalPartitionSetOraclev9i)((StorageDesignOraclev9i)indexGlobalPartitionsListOraclev9i.getStorageDesign()).getIndexGlobalPartitionSet();
        Object[] objectArray = indexGlobalPartitionSetOraclev9i.toArray();
        Arrays.sort(objectArray, new GlobalPossitionComparator());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        Iterator iterator = arrayList.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            IndexGlobalPartitionOraclev9i indexGlobalPartitionOraclev9i = (IndexGlobalPartitionOraclev9i)iterator.next();
            if (indexGlobalPartitionOraclev9i.getIndexGlobalPartList() == null || !indexGlobalPartitionOraclev9i.getIndexGlobalPartList().toString().equalsIgnoreCase(indexGlobalPartitionsListOraclev9i.toString())) continue;
            if (bl2) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                bl2 = false;
            } else {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            }
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexGlobalPartitionOraclev9i.getName()));
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, indexGlobalPartitionOraclev9i.getValueList());
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            if (indexGlobalPartitionOraclev9i.getSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)indexGlobalPartitionOraclev9i.getSegment(), false, bl, indexGlobalPartitionOraclev9i.getTableSpace(), indexGlobalPartitionOraclev9i.getLogging());
                continue;
            }
            if (indexGlobalPartitionOraclev9i.getTableSpace() != null) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexGlobalPartitionOraclev9i.getTableSpace().getName()));
            }
            if (!this.storageDesign.isOpen()) continue;
            if ("YES".equalsIgnoreCase(indexGlobalPartitionOraclev9i.getLogging())) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(indexGlobalPartitionOraclev9i.getLogging())) continue;
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOLOGGING");
        }
        if (!bl2) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendTableCommentOn(StringBuffer stringBuffer, Table table, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        block4: {
            Object object;
            Object object2;
            block3: {
                if (tableProxyOraclev9i == null) break block3;
                this.appendCommentOn(stringBuffer, tableProxyOraclev9i, bl);
                ColumnProxy[] columnProxyArray = tableProxyOraclev9i.getColumnProxies();
                ColumnProxy columnProxy = null;
                for (int i = 0; i < columnProxyArray.length; ++i) {
                    columnProxy = columnProxyArray[i];
                    String string = "";
                    String string2 = this.storageDesign.getFormatedName(tableProxyOraclev9i.getLongName()) + '.' + this.storageDesign.getFormatedName(columnProxy.getName());
                    string = columnProxy.getCommentInRDBMS() != null && columnProxy.isCommentInRDBMSChanged() ? columnProxy.getCommentInRDBMS() : columnProxy.getColumn().getCommentInRDBMS();
                    if (string.equalsIgnoreCase("")) continue;
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                    StringBuffer stringBuffer2 = new StringBuffer();
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "COMMENT ON");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "COLUMN");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, string2);
                    String string3 = stringBuffer2.toString();
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "IS");
                    SSBTableOraclev9i.appendString(stringBuffer2, '\'');
                    SSBTableOraclev9i.appendString(stringBuffer2, this.replaceSingleQuote(string));
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, '\'');
                    this.appendToBuffer(stringBuffer, stringBuffer2, string3);
                    SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                    this.appendLineFinisher(stringBuffer2, bl);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string3);
                }
                break block4;
            }
            if (table == null) break block4;
            String string = table.getCommentInRDBMS();
            if (string != null && !"".equalsIgnoreCase(string)) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                object2 = new StringBuffer();
                SSBTableOraclev9i.appendStringWithSpace((StringBuffer)object2, "COMMENT ON");
                SSBTableOraclev9i.appendStringWithSpace((StringBuffer)object2, "TABLE");
                SSBTableOraclev9i.appendStringWithSpace((StringBuffer)object2, this.storageDesign.getFormatedName(table.getLongName()));
                object = ((StringBuffer)object2).toString();
                SSBTableOraclev9i.appendStringWithSpace((StringBuffer)object2, "IS");
                SSBTableOraclev9i.appendString((StringBuffer)object2, '\'');
                SSBTableOraclev9i.appendString((StringBuffer)object2, this.replaceSingleQuote(string));
                SSBTableOraclev9i.appendStringWithSpace((StringBuffer)object2, '\'');
                this.appendToBuffer(stringBuffer, (StringBuffer)object2, (String)object);
                SSBTableOraclev9i.appendNewLine((StringBuffer)object2, bl, 0);
                this.appendLineFinisher((StringBuffer)object2, bl);
                this.appendToBuffer(stringBuffer, (StringBuffer)object2, (String)object);
            }
            object2 = table.getElements();
            for (int i = 0; i < ((ContainedObject[])object2).length; ++i) {
                object = (Column)object2[i];
                String string4 = ((ModelIDObject)object).getCommentInRDBMS();
                if (string4 == null || "".equalsIgnoreCase(string4)) continue;
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                StringBuffer stringBuffer3 = new StringBuffer();
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer3, "COMMENT ON");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer3, "COLUMN");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer3, this.storageDesign.getFormatedName(((ContainedObject)object).getLongName()));
                String string5 = stringBuffer3.toString();
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer3, "IS");
                SSBTableOraclev9i.appendString(stringBuffer3, '\'');
                SSBTableOraclev9i.appendString(stringBuffer3, this.replaceSingleQuote(string4));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer3, '\'');
                this.appendToBuffer(stringBuffer, stringBuffer3, string5);
                SSBTableOraclev9i.appendNewLine(stringBuffer3, bl, 0);
                this.appendLineFinisher(stringBuffer3, bl);
                this.appendToBuffer(stringBuffer, stringBuffer3, string5);
            }
        }
    }

    public void appendPartitionList(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        PartitionListOraclev9i partitionListOraclev9i = (PartitionListOraclev9i)tableProxyOraclev9i.getPartitionList();
        if (partitionListOraclev9i != null) {
            this.tableProxy = tableProxyOraclev9i;
            this.table = (Table)tableProxyOraclev9i.getObject();
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignOraclev9i)tableProxyOraclev9i.getStorageDesign();
            }
            String string = partitionListOraclev9i.getPartitionType();
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            if ("RANGE".equalsIgnoreCase(string)) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "RANGE");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                this.appendPartitions(stringBuffer, partitionListOraclev9i, false, bl);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(string)) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "RANGE");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "HASH");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getSubPartitionsColumnList()));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                if ("NO".equals(partitionListOraclev9i.getUseSubpartStorageTemplate())) {
                    if (partitionListOraclev9i.getSubPartitionsQuantity() > 1 || !"".equals(partitionListOraclev9i.getSubPartitionsTableSpaces())) {
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                        this.appendStringWithSpace(stringBuffer, partitionListOraclev9i.getSubPartitionsQuantity());
                        if (!"".equals(partitionListOraclev9i.getSubPartitionsTableSpaces())) {
                            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "STORE IN");
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getAllSubPartitionsTableSpaces()));
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                        }
                    }
                } else {
                    this.appendHashSubPartitionTemplates(stringBuffer, tableProxyOraclev9i, bl);
                }
                this.appendPartitions(stringBuffer, partitionListOraclev9i, true, bl);
            } else if ("COMPOSITE BY LIST".equalsIgnoreCase(string)) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "RANGE");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LIST");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getSubPartitionsColumnList()));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                this.appendListSubPartitionTemplates(stringBuffer, tableProxyOraclev9i, bl);
                this.appendPartitions(stringBuffer, partitionListOraclev9i, true, bl);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(string)) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "HASH");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PARTITIONS");
                this.appendStringWithSpace(stringBuffer, partitionListOraclev9i.getHashPQuantity());
                if (!"".equals(partitionListOraclev9i.getHashPTableSpaces())) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "STORE IN");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getAllHashPTableSpaces()));
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                }
                if (!"".equals(partitionListOraclev9i.getIOTOverflowHashPTS())) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "OVERFLOW");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "STORE IN");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getAllIOTOverflowHashPTS()));
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(string)) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "HASH");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                this.appendHashPartitions(stringBuffer, tableProxyOraclev9i, bl);
            } else if ("LIST".equalsIgnoreCase(string)) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LIST");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                this.appendListPartitions(stringBuffer, tableProxyOraclev9i, bl);
            }
        }
    }

    private void appendListSubPartitionTemplates(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        StorageObjectCollection storageObjectCollection = tableProxyOraclev9i.getListStorageTemplates();
        if (storageObjectCollection.size() > 0) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TEMPLATE");
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            for (int i = 0; i < storageObjectCollection.size(); ++i) {
                ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i = (ListStorageTemplatePartitionOraclev9i)storageObjectCollection.getElement(i);
                if (i > 0) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
                }
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listStorageTemplatePartitionOraclev9i.getName()));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "VALUES");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                if (!"".equalsIgnoreCase(listStorageTemplatePartitionOraclev9i.getValueList())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, listStorageTemplatePartitionOraclev9i.getValueList());
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "DEFAULT");
                }
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                this.appendPartStorage(stringBuffer, listStorageTemplatePartitionOraclev9i, bl);
            }
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendHashSubPartitionTemplates(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        if (tableProxyOraclev9i.getListStorageTemplates().size() > 0) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TEMPLATE");
            Iterator iterator = tableProxyOraclev9i.getListStorageTemplates().iterator();
            boolean bl2 = true;
            while (iterator.hasNext()) {
                HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)iterator.next();
                if (bl2) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    bl2 = false;
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
                }
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev9i.getName()));
                this.appendPartStorage(stringBuffer, hashPartitionOraclev9i, bl);
            }
            if (!bl2) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendPartStorage(StringBuffer stringBuffer, AbstractStorageObjectOracle abstractStorageObjectOracle, boolean bl) {
        TableSpaceOracle tableSpaceOracle = null;
        TableSpaceOracle tableSpaceOracle2 = null;
        StorageObjectCollection storageObjectCollection = null;
        if (abstractStorageObjectOracle instanceof HashPartitionOraclev9i) {
            tableSpaceOracle = ((HashPartitionOraclev9i)abstractStorageObjectOracle).getTableSpace();
            tableSpaceOracle2 = ((HashPartitionOraclev9i)abstractStorageObjectOracle).getIotOverflowTablespace();
            storageObjectCollection = ((HashPartitionOraclev9i)abstractStorageObjectOracle).getLobs();
        } else if (abstractStorageObjectOracle instanceof ListStorageTemplatePartitionOraclev9i) {
            tableSpaceOracle = ((ListStorageTemplatePartitionOraclev9i)abstractStorageObjectOracle).getTablespace();
            storageObjectCollection = ((ListStorageTemplatePartitionOraclev9i)abstractStorageObjectOracle).getLobs();
        }
        if (tableSpaceOracle != null) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
        if (tableSpaceOracle2 != null) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "OVERFLOW");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle2.getName()));
        }
        if (storageObjectCollection != null) {
            Iterator iterator = storageObjectCollection.iterator();
            while (iterator.hasNext()) {
                AbstractStorageObjectOracle abstractStorageObjectOracle2;
                Object e = iterator.next();
                if (e instanceof LobStorageOraclev9i) {
                    abstractStorageObjectOracle2 = (LobStorageOraclev9i)e;
                    if (((LobStorageOracle)abstractStorageObjectOracle2).getTableSpace() == null && ((LobStorageOracle)abstractStorageObjectOracle2).getLobSegmentName().trim().equals("")) continue;
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
                    this.appendLobPartitioningStorage(stringBuffer, abstractStorageObjectOracle2.getName(), ((LobStorageOracle)abstractStorageObjectOracle2).getColumn(), ((LobStorageOracle)abstractStorageObjectOracle2).getLobSegmentName(), ((LobStorageOracle)abstractStorageObjectOracle2).getTableSpace(), bl);
                    continue;
                }
                if (!(e instanceof HashPartitionLobItemOraclev9i) || ((HashPartitionLobItemOracle)(abstractStorageObjectOracle2 = (HashPartitionLobItemOraclev9i)e)).getTableSpace() == null) continue;
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
                this.appendLobPartitioningStorage(stringBuffer, abstractStorageObjectOracle2.getName(), ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).getLobColumn(), "", ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).getTableSpace(), bl);
            }
        }
    }

    private void appendListPartitions(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        Iterator iterator = tableProxyOraclev9i.getPartitions().iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            Object object;
            ListPartitionOraclev9i listPartitionOraclev9i = (ListPartitionOraclev9i)iterator.next();
            if (bl2) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                bl2 = false;
            } else {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            }
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev9i.getName()));
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "VALUES");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            if (!"".equalsIgnoreCase(listPartitionOraclev9i.getColumns())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, listPartitionOraclev9i.getColumns());
            } else {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "DEFAULT");
            }
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            if (listPartitionOraclev9i.getSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)listPartitionOraclev9i.getSegment(), true, bl, listPartitionOraclev9i.getTablespace(), listPartitionOraclev9i.getLogging());
            } else {
                if (listPartitionOraclev9i.getTablespace() != null) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev9i.getTablespace().getName()));
                }
                if (this.storageDesign.isOpen() && ((String)(object = listPartitionOraclev9i.getLogging())).length() > 0) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    if (((String)object).equalsIgnoreCase("YES")) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
                    } else if (((String)object).equalsIgnoreCase("NO")) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOLOGGING");
                    }
                }
            }
            if (listPartitionOraclev9i.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOCOMPRESS");
            } else if (listPartitionOraclev9i.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "COMPRESS");
            }
            if (this.table.isSpatialTable()) continue;
            object = listPartitionOraclev9i.getLobStorages().iterator();
            while (object.hasNext()) {
                LobStorageOracle lobStorageOracle = (LobStorageOracle)object.next();
                this.appendLobStorage(stringBuffer, (LobStorageOraclev9i)lobStorageOracle, bl);
            }
        }
        if (!bl2) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendPartitions(StringBuffer stringBuffer, PartitionListOraclev9i partitionListOraclev9i, boolean bl, boolean bl2) {
        StorageObjectCollection storageObjectCollection = this.tableProxy.getPartitions();
        if (storageObjectCollection.size() > 0) {
            Object[] objectArray = storageObjectCollection.toArray();
            Arrays.sort(objectArray, new PossitionComparator());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(objectArray[i]);
            }
            Iterator iterator = arrayList.iterator();
            boolean bl3 = true;
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                Object e = iterator.next();
                if (!(e instanceof PartitionOracle)) continue;
                PartitionOracle partitionOracle = (PartitionOracle)e;
                if (bl3) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    bl3 = false;
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
                }
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOracle.getName()));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, partitionOracle.getValueList());
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                if (partitionOracle.getSegment() != null) {
                    this.appendSegment(stringBuffer, (SegmentOraclev9i)partitionOracle.getSegment(), true, bl2, partitionOracle.getTableSpace(), partitionOracle.getLogging());
                } else {
                    if (partitionOracle.getTableSpace() != null) {
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOracle.getTableSpace().getName()));
                    }
                    if (partitionOracle.getLogging().equalsIgnoreCase("NO")) {
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOLOGGING");
                    } else if (partitionOracle.getLogging().equalsIgnoreCase("YES")) {
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
                    }
                }
                if (partitionOracle.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOCOMPRESS");
                } else if (partitionOracle.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "COMPRESS");
                }
                SegmentOracle segmentOracle = partitionOracle.getIOTOverflowSegment();
                if (segmentOracle != null) {
                    object2 = segmentOracle.getTableSpace();
                    if (object2 == null) {
                        object2 = partitionOracle.getTableSpace();
                    }
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "OVERFLOW");
                    this.appendSegment(stringBuffer, (SegmentOraclev9i)segmentOracle, true, bl2, (TableSpaceOracle)object2, partitionOracle.getLogging());
                }
                if (!this.table.isSpatialTable()) {
                    object2 = partitionOracle.getLobs().iterator();
                    while (object2.hasNext()) {
                        object = (LobStorageOracle)object2.next();
                        this.appendLobStorage(stringBuffer, (LobStorageOraclev9i)object, bl2);
                    }
                }
                if (!bl) continue;
                if (partitionListOraclev9i.getPartitionType().equalsIgnoreCase("COMPOSITE BY HASH")) {
                    if (this.appendHashSubPartitions(stringBuffer, (PartitionOraclev9i)partitionOracle, partitionListOraclev9i, bl2) || partitionOracle.getSubPartitionsQuantity() <= 0) continue;
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                    this.appendStringWithSpace(stringBuffer, partitionOracle.getSubPartitionsQuantity());
                    if ("".equalsIgnoreCase(partitionOracle.getSubPartitionsTableSpaces())) continue;
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "STORE IN");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionOracle.getAllSubPartitionsTableSpaces()));
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                    continue;
                }
                if (partitionOracle.getListPartitions().size() <= 0) continue;
                boolean bl4 = true;
                object = partitionOracle.getListPartitions().iterator();
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                while (object.hasNext()) {
                    ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i = (ListStorageTemplatePartitionOraclev9i)object.next();
                    if (!bl4) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
                    } else {
                        bl4 = false;
                    }
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listStorageTemplatePartitionOraclev9i.getName()));
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "VALUES");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, listStorageTemplatePartitionOraclev9i.getValueList());
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                    this.appendPartStorage(stringBuffer, listStorageTemplatePartitionOraclev9i, bl2);
                }
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            }
            if (!bl3) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private boolean appendHashSubPartitions(StringBuffer stringBuffer, PartitionOraclev9i partitionOraclev9i, PartitionListOraclev9i partitionListOraclev9i, boolean bl) {
        boolean bl2 = false;
        if (partitionListOraclev9i.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
            HashPartitionSetOracle hashPartitionSetOracle = ((StorageDesignOracle)partitionOraclev9i.getStorageDesign()).getHashPartitionSet();
            Iterator iterator = hashPartitionSetOracle.iterator();
            boolean bl3 = true;
            while (iterator.hasNext()) {
                HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)iterator.next();
                if (hashPartitionOraclev9i.getSubPartitionOf() != partitionOraclev9i) continue;
                if (bl3) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    bl3 = false;
                    bl2 = true;
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                }
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev9i.getName()));
                this.appendPartStorage(stringBuffer, hashPartitionOraclev9i, bl);
            }
            if (!bl3) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            }
        }
        return bl2;
    }

    private boolean appendHashPartitions(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        boolean bl2 = false;
        Iterator iterator = tableProxyOraclev9i.getPartitions().iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)iterator.next();
            if (bl3) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                bl3 = false;
                bl2 = true;
            } else {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            }
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev9i.getName()));
            if (hashPartitionOraclev9i.getTableSpace() != null) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev9i.getTableSpace().getName()));
            }
            this.appendHashPLobItems(stringBuffer, hashPartitionOraclev9i, bl);
        }
        if (!bl3) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
        return bl2;
    }

    private void appendHashPLobItems(StringBuffer stringBuffer, HashPartitionOraclev9i hashPartitionOraclev9i, boolean bl) {
        HashPartitionLobItemSetOraclev9i hashPartitionLobItemSetOraclev9i = (HashPartitionLobItemSetOraclev9i)((StorageDesignOraclev9i)hashPartitionOraclev9i.getStorageDesign()).getHashPartitionLobItemSet();
        Iterator iterator = hashPartitionLobItemSetOraclev9i.iterator();
        while (iterator.hasNext()) {
            HashPartitionLobItemOraclev9i hashPartitionLobItemOraclev9i = (HashPartitionLobItemOraclev9i)iterator.next();
            if (hashPartitionLobItemOraclev9i.getHashPartition() == null || !hashPartitionLobItemOraclev9i.getHashPartition().toString().equalsIgnoreCase(hashPartitionOraclev9i.toString())) continue;
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            this.appendLobPartitioningStorage(stringBuffer, hashPartitionLobItemOraclev9i.getName(), hashPartitionLobItemOraclev9i.getLobColumn(), "", hashPartitionLobItemOraclev9i.getTableSpace(), bl);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer stringBuffer, String string, Object object, String string2, TableSpaceOracle tableSpaceOracle, boolean bl) {
        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOB");
        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
        String string3 = "";
        if (object != null) {
            string3 = object.toString();
        }
        if (string3.length() > 0) {
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string3));
        } else {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("--  ERROR: Lob ");
            stringBuffer.append(string);
            stringBuffer.append(" has no Column specified");
            DDLFileMaker.incrementErrors();
        }
        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "STORE AS");
        if (!string2.equalsIgnoreCase("")) {
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
        } else if (tableSpaceOracle == null) {
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
        }
        if (tableSpaceOracle != null) {
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendLobStorage(StringBuffer stringBuffer, LobStorageOraclev9i lobStorageOraclev9i, boolean bl) {
        if (lobStorageOraclev9i != null) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOB");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOraclev9i.getColumn()));
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "STORE AS");
            if (!lobStorageOraclev9i.getLobSegmentName().equalsIgnoreCase("")) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOraclev9i.getLobSegmentName()));
            }
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (lobStorageOraclev9i.getTableSpace() != null) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOraclev9i.getTableSpace().getName()));
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            }
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "STORAGE");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
            if (lobStorageOraclev9i.getSCInitialExtent() > 0L) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCInitialExtent());
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
            }
            if (lobStorageOraclev9i.getSCNextExtent() > 0L) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCNextExtent());
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
            }
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCPctIncrease());
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCMinExtents());
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCMaxExtents());
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCFreeLists());
            if (lobStorageOraclev9i.getSCFreelistGroups() > 1) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "FREELIST");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "GROUPS");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCFreelistGroups());
            }
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCBufferPool());
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (lobStorageOraclev9i.getChunk() > 0) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "CHUNK");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getChunk());
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            }
            if (lobStorageOraclev9i.getOldVersions().equalsIgnoreCase("RETENTION")) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "RETENTION");
            } else {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PCTVERSION");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getPCTVersion());
            }
            if (lobStorageOraclev9i.getSCFreelistGroups() <= 1 && lobStorageOraclev9i.getFreepools() > 0) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "FREEPOOLS");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getFreepools());
            }
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if ("ENABLE".equalsIgnoreCase(lobStorageOraclev9i.getStorageInRow())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "ENABLE");
            } else {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "DISABLE");
            }
            stringBuffer.append("STORAGE IN ROW");
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getCache());
            if (!"CACHE".equalsIgnoreCase(lobStorageOraclev9i.getCache())) {
                if ("YES".equalsIgnoreCase(lobStorageOraclev9i.getLogging())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(lobStorageOraclev9i.getLogging())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOLOGGING");
                }
            }
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendSegment(StringBuffer stringBuffer, SegmentOraclev9i segmentOraclev9i, boolean bl, boolean bl2, TableSpaceOracle tableSpaceOracle, String string) {
        if (segmentOraclev9i != null) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getPCTFree());
            if (bl) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PCTUSED");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getPCTUsed());
            }
            if (segmentOraclev9i.getInitrans() > 1) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "INITRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getInitrans());
            }
            if (segmentOraclev9i.getMaxTrans() > 1) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "MAXTRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getMaxTrans());
            }
            if (tableSpaceOracle != null) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            } else if (segmentOraclev9i.getTableSpace() != null) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(segmentOraclev9i.getTableSpace().getName()));
            }
            if (!"".equals(string)) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
                if (string.equalsIgnoreCase("NO")) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOLOGGING");
                } else {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
                }
            }
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "STORAGE");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            if (segmentOraclev9i.getSCInitialExtent() > 0L) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCInitialExtent());
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            }
            if (segmentOraclev9i.getSCNextExtent() > 0L) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCNextExtent());
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            }
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCPctIncrease());
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCMinExtents());
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCMaxExtents());
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCFreeLists());
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "FREELIST");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "GROUPS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCFreelistGroups());
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCBufferPool());
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl2, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendTableSpace(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        TableSpaceOracle tableSpaceOracle = tableProxyOraclev9i.getTableSpace();
        if (tableSpaceOracle != null && !"[NONE]".equalsIgnoreCase(tableSpaceOracle.getName())) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
    }

    private void appendOrganization(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        boolean bl2 = "INDEX".equalsIgnoreCase(tableProxyOraclev9i.getOrganization());
        if (bl2) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "ORGANIZATION");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "INDEX");
        }
        if (tableProxyOraclev9i.getSegment() == null) {
            this.appendTableSpace(stringBuffer, tableProxyOraclev9i, bl);
            if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getLogging())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(tableProxyOraclev9i.getLogging())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOLOGGING");
            }
        } else {
            this.appendSegment(stringBuffer, (SegmentOraclev9i)tableProxyOraclev9i.getSegment(), !bl2, bl, tableProxyOraclev9i.getTableSpace(), tableProxyOraclev9i.getLogging());
        }
        if ("INDEX".equalsIgnoreCase(tableProxyOraclev9i.getOrganization())) {
            SegmentOraclev9i segmentOraclev9i;
            if (tableProxyOraclev9i.getIOTMappingTable().equalsIgnoreCase("YES")) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "MAPPING TABLE");
            }
            if (tableProxyOraclev9i.getIotPctThreshold() > 0) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PCTTHRESHOLD");
                this.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getIotPctThreshold());
            }
            if (tableProxyOraclev9i.getIotCompress() > 0) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "COMPRESS");
                this.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getIotCompress());
            }
            if ((segmentOraclev9i = (SegmentOraclev9i)tableProxyOraclev9i.getIotOverflowSegment()) != null || tableProxyOraclev9i.getIotIncluding() != null) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                if (tableProxyOraclev9i.getIotIncluding() != null) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "INCLUDING");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOraclev9i.getIotIncluding().getName()));
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                }
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "OVERFLOW");
                if (segmentOraclev9i != null) {
                    TableSpaceOracle tableSpaceOracle = segmentOraclev9i.getTableSpace();
                    if (tableSpaceOracle == null) {
                        tableSpaceOracle = tableProxyOraclev9i.getTableSpace();
                    }
                    this.appendSegment(stringBuffer, segmentOraclev9i, true, bl, tableSpaceOracle, tableProxyOraclev9i.getLogging());
                }
            }
        } else if (tableProxyOraclev9i.getDataSegmentCompression().equalsIgnoreCase("YES")) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "COMPRESS");
        }
        if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getPartitioned())) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            if ("ENABLE".equalsIgnoreCase(tableProxyOraclev9i.getParttitionedRowMovement())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "ENABLE");
            } else {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "DISABLE");
            }
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "ROW MOVEMENT");
        }
    }

    private void appendCluster(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        ClusterOraclev9i clusterOraclev9i = (ClusterOraclev9i)tableProxyOraclev9i.getCluster();
        if (clusterOraclev9i != null) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "CLUSTER");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(clusterOraclev9i.getLongName()));
            if (!"".equalsIgnoreCase(tableProxyOraclev9i.getClusterColumns())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(tableProxyOraclev9i.getAllClusterColumns()));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            }
        } else {
            this.appendOrganization(stringBuffer, tableProxyOraclev9i, bl);
            if (!this.table.isSpatialTable()) {
                for (int i = 0; i < tableProxyOraclev9i.getLobStorages().size(); ++i) {
                    this.appendLobStorage(stringBuffer, (LobStorageOraclev9i)tableProxyOraclev9i.getLobStorages().getElement(i), bl);
                }
            }
        }
    }

    private void appendUniqueDefinition(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        if (tableProxyOracle != null) {
            UniqueSetOraclev9i uniqueSetOraclev9i = (UniqueSetOraclev9i)((StorageDesignOraclev9i)tableProxyOracle.getStorageDesign()).getUniqueSet();
            Iterator iterator = uniqueSetOraclev9i.iterator();
            while (iterator.hasNext()) {
                UniqueOraclev9i uniqueOraclev9i = (UniqueOraclev9i)iterator.next();
                Index index = (Index)uniqueOraclev9i.getObject();
                if (uniqueOraclev9i.getTable() == null || !uniqueOraclev9i.getTable().equals(tableProxyOracle.getObject()) || !uniqueOraclev9i.isMarkedGenerate()) continue;
                if (uniqueOraclev9i.getColumnProxies().length == 0 && "".equals(index.getIndexExpression())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "-- Error - Unique Constraint " + uniqueOraclev9i.getTable() + "." + uniqueOraclev9i.getName() + " doesn't have columns");
                    DDLFileMaker.incrementErrors();
                    continue;
                }
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                if (uniqueOraclev9i.isCommentChanged() && !"".equalsIgnoreCase(uniqueOraclev9i.getComment())) {
                    this.appendComment(stringBuffer, uniqueOraclev9i);
                } else if (!"".equalsIgnoreCase(uniqueOraclev9i.getObject().getComment())) {
                    this.appendComment(stringBuffer, uniqueOraclev9i.getObject());
                }
                String string2 = uniqueOraclev9i.getName();
                if (string2.length() > tableProxyOracle.getMaxNameLength()) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "--  ERROR: UK name length exceeds maximum allowed length(" + tableProxyOracle.getMaxNameLength() + ")");
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementErrors();
                }
                ColumnProxy[] columnProxyArray = uniqueOraclev9i.getColumnProxies();
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "ALTER");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "TABLE");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(tableProxyOracle.getLongName()));
                string = stringBuffer2.toString();
                SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "ADD");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string2));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "UNIQUE");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, '(');
                if (!"".equals(index.getIndexExpression())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, index.getIndexExpression());
                } else {
                    for (int i = 0; i < columnProxyArray.length; ++i) {
                        ColumnProxy columnProxy = columnProxyArray[i];
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(columnProxy.getName()));
                        if (i >= columnProxyArray.length - 1) continue;
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, ',');
                    }
                }
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, ')');
                if (!"NO".equalsIgnoreCase(uniqueOraclev9i.getDeferrable())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "DEFERRABLE");
                    if ("DEFERRED".equalsIgnoreCase(uniqueOraclev9i.getInitially())) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "INITIALLY");
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "DEFERRED");
                    }
                }
                if (!"YES".equalsIgnoreCase(uniqueOraclev9i.getEnable())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "DISABLE");
                    if ("YES".equalsIgnoreCase(uniqueOraclev9i.getValidate())) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(uniqueOraclev9i.getValidate())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "NOVALIDATE");
                }
                if (!"NO".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex())) {
                    this.appendUniqueUsingIndex(stringBuffer2, uniqueOraclev9i, bl);
                }
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                this.appendLineFinisher(stringBuffer2, bl);
                SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                DDLFileMaker.incrementAlterTable();
            }
        }
    }

    private void appendNotNullDefinition(StringBuffer stringBuffer, ColumnProxyOracle columnProxyOracle, boolean bl) {
        String string;
        String string2 = string = columnProxyOracle.isNotNullConstraintNameChanged() ? columnProxyOracle.getNncName() : columnProxyOracle.getColumn().getNotNullConstraintName();
        if (!"NO".equalsIgnoreCase(columnProxyOracle.getNncDeferrable()) || !"YES".equalsIgnoreCase(columnProxyOracle.getNncEnable()) || !"YES".equalsIgnoreCase(columnProxyOracle.getNncValidate()) || string != null && !"".equals(string)) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendString(stringBuffer, ' ');
            if (!this.table.getDesign().getAppView().getSettings().notNullShortFormGeneration() && string != null && !"".equals(string)) {
                string = this.storageDesign.getFormatedName(string);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, string);
            }
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOT");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NULL");
            if (!"NO".equalsIgnoreCase(columnProxyOracle.getNncDeferrable())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(columnProxyOracle.getNncInitially())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "INITIALLY");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "DEFERRED");
                }
            }
            if (!"YES".equalsIgnoreCase(columnProxyOracle.getNncEnable())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "DISABLE");
                if ("YES".equalsIgnoreCase(columnProxyOracle.getNncValidate())) {
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(columnProxyOracle.getNncValidate())) {
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOVALIDATE");
            }
        } else {
            SSBTableOraclev9i.appendString(stringBuffer, ' ');
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOT");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NULL");
        }
    }

    private String getPermissionsON(PermissionsOracle permissionsOracle) {
        if (permissionsOracle.getTable() != null) {
            return this.storageDesign.getFormatedName(permissionsOracle.getTable().getLongName());
        }
        if (permissionsOracle.getView() != null) {
            return this.storageDesign.getFormatedName(permissionsOracle.getView().getLongName());
        }
        if (permissionsOracle.getSequence() != null) {
            return this.storageDesign.getFormatedName(permissionsOracle.getSequence().getLongName());
        }
        if (permissionsOracle.getSnapshot() != null) {
            return this.storageDesign.getFormatedName(permissionsOracle.getSnapshot().getLongName());
        }
        if (permissionsOracle.getProc() != null) {
            return this.storageDesign.getFormatedName(permissionsOracle.getProc().getLongName());
        }
        if (permissionsOracle.getDirectoryOracle() != null) {
            return this.storageDesign.getFormatedName(permissionsOracle.getDirectoryOracle().getLongName());
        }
        if (permissionsOracle.getStructuredTypeOracle() != null) {
            return this.storageDesign.getFormatedName(permissionsOracle.getStructuredTypeOracle().getLongName());
        }
        if (permissionsOracle.getCollectionTypeOracle() != null) {
            return this.storageDesign.getFormatedName(permissionsOracle.getCollectionTypeOracle().getLongName());
        }
        if (permissionsOracle.getExternalTableOracle() != null) {
            return this.storageDesign.getFormatedName(permissionsOracle.getExternalTableOracle().getLongName());
        }
        return "";
    }

    private String getPermissionsTO(PermissionsOracle permissionsOracle) {
        if (permissionsOracle.getUser() != null) {
            return permissionsOracle.getUser().getLongName();
        }
        if (permissionsOracle.getRole() != null) {
            return permissionsOracle.getRole().getLongName();
        }
        return "";
    }

    private void appendPrivileges(StringBuffer stringBuffer, PermissionsOracle permissionsOracle) {
        stringBuffer.append(permissionsOracle.getPrivileges());
    }

    private void appendPrivilegesWithGrantOption(StringBuffer stringBuffer, PermissionsOracle permissionsOracle) {
        stringBuffer.append(permissionsOracle.getPrivilegesWithGrantOption());
    }

    private void appendPermissions(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        PermissionsSetOracle permissionsSetOracle = ((StorageDesignOracle)tableProxyOraclev9i.getStorageDesign()).getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        while (iterator.hasNext()) {
            int n;
            PermissionsOraclev9i permissionsOraclev9i = (PermissionsOraclev9i)iterator.next();
            if (permissionsOraclev9i.getTable() != null && permissionsOraclev9i.getTable().equals(tableProxyOraclev9i) && !permissionsOraclev9i.getPrivileges().equalsIgnoreCase("")) {
                SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                this.appendComment(stringBuffer2, permissionsOraclev9i);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "GRANT");
                this.appendPrivileges(stringBuffer2, permissionsOraclev9i);
                this.appendObject(stringBuffer2, permissionsOraclev9i, bl);
                this.appendTo(stringBuffer2, permissionsOraclev9i);
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev9i, bl);
                string = "GRANT ON " + this.getPermissionsON(permissionsOraclev9i) + " TO " + this.getPermissionsTO(permissionsOraclev9i);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
            if (permissionsOraclev9i.getTable() != null && permissionsOraclev9i.getTable().equals(tableProxyOraclev9i) && !permissionsOraclev9i.getPrivilegesWithGrantOption().equalsIgnoreCase("")) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, permissionsOraclev9i);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "GRANT");
                this.appendPrivilegesWithGrantOption(stringBuffer2, permissionsOraclev9i);
                this.appendObject(stringBuffer2, permissionsOraclev9i, bl);
                this.appendTo(stringBuffer2, permissionsOraclev9i);
                this.appendGrantOption(stringBuffer2, permissionsOraclev9i);
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev9i, bl);
                string = "GRANT ON " + this.getPermissionsON(permissionsOraclev9i) + " TO " + this.getPermissionsTO(permissionsOraclev9i);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
            if (permissionsOraclev9i.getColumnsTable() == null || !permissionsOraclev9i.getColumnsTable().equals(tableProxyOraclev9i) || permissionsOraclev9i.getColumns().isEmpty()) continue;
            ArrayList arrayList = permissionsOraclev9i.getColumns();
            for (n = 0; n < arrayList.size(); ++n) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, permissionsOraclev9i);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "GRANT");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, permissionsOraclev9i.getPrivileges());
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(arrayList.get(n).toString()));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, ')');
                this.appendObject(stringBuffer2, permissionsOraclev9i, bl);
                this.appendTo(stringBuffer2, permissionsOraclev9i);
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev9i, bl);
                string = "GRANT ON " + this.getPermissionsON(permissionsOraclev9i) + " TO " + this.getPermissionsTO(permissionsOraclev9i);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
            if (permissionsOraclev9i.getColumnWithGrantOptionList().equals("") || permissionsOraclev9i.getColumnWithGrantOptionList() == null) continue;
            arrayList = permissionsOraclev9i.getColumns();
            for (n = 0; n < arrayList.size(); ++n) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, permissionsOraclev9i);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "GRANT");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, permissionsOraclev9i.getPrivsWithGrantOption(arrayList.get(n).toString()));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(arrayList.get(n).toString()));
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, ')');
                this.appendObject(stringBuffer2, permissionsOraclev9i, bl);
                this.appendTo(stringBuffer2, permissionsOraclev9i);
                this.appendGrantOption(stringBuffer2, permissionsOraclev9i);
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev9i, bl);
                string = "GRANT ON " + this.getPermissionsON(permissionsOraclev9i) + " TO " + this.getPermissionsTO(permissionsOraclev9i);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
        }
    }

    private void appendObject(StringBuffer stringBuffer, PermissionsOracle permissionsOracle, boolean bl) {
        if (permissionsOracle.getTable() != null) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "ON");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOracle.getTable().getLongName()));
        }
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOracle permissionsOracle) {
        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TO");
        if ("YES".equalsIgnoreCase(permissionsOracle.getPublic())) {
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else if (permissionsOracle.getUser() != null) {
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOracle.getUser().getName()));
        } else if (permissionsOracle.getRole() != null) {
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOracle.getRole().getName()));
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOracle permissionsOracle) {
        if (permissionsOracle.getRole() == null) {
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i, boolean bl) {
        if ("YES".equalsIgnoreCase(permissionsOraclev9i.getHierarchyOption())) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "WITH HIERARCHY OPTION");
        }
    }

    public void appendIndexes(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl) {
        Object object;
        Object object2;
        if (this.storageDesign == null) {
            this.storageDesign = (StorageDesignOraclev9i)tableProxyOracle.getStorageDesign();
        }
        Iterator iterator = tableProxyOracle.getIndexes().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object2 instanceof IndexProxyOracle && ((IndexProxyOracle)object2).getIndex().isSpatialIndex() || !((SSBIndexOraclev9i)(object = this.getSSBIndex())).canHandle(object2)) continue;
            ((SSBIndexOraclev9i)object).doAppend(stringBuffer, object2, bl);
        }
        object2 = (Table)tableProxyOracle.getObject();
        if (!((ContainerObject)object2).isBST()) {
            this.appendIndexesForConstraints(stringBuffer, (Table)object2, tableProxyOracle);
        }
        if (!(tableProxyOracle == null || ((Table)tableProxyOracle.getObject()).isBST() || "INDEX".equalsIgnoreCase(tableProxyOracle.getOrganization()) || (object = tableProxyOracle.getSnapshot()) != null && !((SnapshotOracle)object).getWith().equalsIgnoreCase("ROWID") && ((SnapshotOracle)object).getRefresh().equals("YES"))) {
            this.appendPKDefinition(stringBuffer, tableProxyOracle, bl);
        }
        this.appendUniqueDefinition(stringBuffer, tableProxyOracle, bl);
    }

    private void appendNestedTableColumnProp(StringBuffer stringBuffer, ColumnProxyOraclev9i columnProxyOraclev9i, boolean bl) {
        if (!columnProxyOraclev9i.getNtStorageTable().equals("")) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NESTED");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLE");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getName()));
            this.appendSubstitutableColumnClause(stringBuffer, columnProxyOraclev9i, bl, false);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "STORE AS");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getNtStorageTable());
            if (!columnProxyOraclev9i.getAdditionalNTS().equals("")) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getAdditionalNTS());
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            }
            if (!columnProxyOraclev9i.getNtReturn().equals("")) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "RETURN");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "AS");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getNtReturn());
            }
        }
    }

    private void appendSubstitutableColumnClause(StringBuffer stringBuffer, ColumnProxyOraclev9i columnProxyOraclev9i, boolean bl, boolean bl2) {
        Column column = columnProxyOraclev9i.getColumn();
        Table table = (Table)column.getContainerWithKeyObject();
        if (table.isBST() && !table.isSubstitutable()) {
            return;
        }
        if (!column.isReference()) {
            if (column.isAllowSubtypeSubstitution()) {
                if (bl2 && (column.isRestrictedTypeSubstitution() && column.getPermittedSubTypes().size() == 1 || columnProxyOraclev9i.getSubtitutable().equals("ONLY FOR TYPE"))) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "COLUMN");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getName()));
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "IS");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "OF");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "TYPE");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "ONLY");
                    if (column.isRestrictedTypeSubstitution() && column.getPermittedSubTypes().size() == 1) {
                        StructuredType structuredType = (StructuredType)column.getPermittedSubTypes().get(0);
                        StructuredTypeProxyOracle structuredTypeProxyOracle = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(structuredType);
                        if (structuredTypeProxyOracle != null) {
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(structuredTypeProxyOracle.getLongName()));
                        } else {
                            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(structuredType.getName()));
                        }
                    } else {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getElementType());
                    }
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                } else if (columnProxyOraclev9i.getSubtitutable().equals("YES") || columnProxyOraclev9i.getSubtitutable().equals("NO")) {
                    if (bl2) {
                        SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "COLUMN");
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getName()));
                    }
                    if (columnProxyOraclev9i.getSubtitutable().equals("NO")) {
                        SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOT");
                    }
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "SUBSTITUTABLE");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "AT");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "ALL");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LEVELS");
                }
            } else {
                if (bl2) {
                    SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "COLUMN");
                    SSBTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getName()));
                }
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "NOT");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "SUBSTITUTABLE");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "AT");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "ALL");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "LEVELS");
            }
        }
    }

    private boolean hasVarrayClause(ColumnProxyOraclev9i columnProxyOraclev9i) {
        return !columnProxyOraclev9i.getSubtitutable().equals("") || !columnProxyOraclev9i.getLobSegname().equals("");
    }

    private void appendCWDTableMeta(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle, boolean bl) {
        List list = table.getAllSubstitutionTables();
        if (list.size() > 0) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "-- DO NOT DELETE OR MODIFY THE FOLLOWING COMMENTS");
        }
        for (int i = 0; i < list.size(); ++i) {
            Table table2 = (Table)list.get(i);
            StructuredType structuredType = table2.getBasedOnStructuredType();
            StructuredTypeProxyOracle structuredTypeProxyOracle = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(structuredType);
            String string = structuredType.getName();
            if (structuredTypeProxyOracle != null) {
                string = this.storageDesign.getFormatedName(structuredTypeProxyOracle.getLongName());
            }
            structuredType = table2.getBasedOnStructuredType().getParentType();
            structuredTypeProxyOracle = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(structuredType);
            String string2 = structuredType.getName();
            if (structuredTypeProxyOracle != null) {
                string2 = this.storageDesign.getFormatedName(structuredTypeProxyOracle.getLongName());
            }
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "-- <cwd_ts_tab table=\"" + table2.getName() + "\" type=\"" + string + "\" parent_type=\"" + string2 + "\" />");
        }
    }

    private void appendCWDColumnMeta(StringBuffer stringBuffer, List list, boolean bl) {
        if (list.size() > 0) {
            SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "-- DO NOT DELETE OR MODIFY THE FOLLOWING COMMENTS");
        }
        for (int i = 0; i < list.size(); ++i) {
            Column column = (Column)list.get(i);
            for (StructuredType structuredType : column.getPermittedSubTypes()) {
                StructuredTypeProxyOracle structuredTypeProxyOracle = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(structuredType);
                String string = structuredType.getName();
                if (structuredTypeProxyOracle != null) {
                    string = structuredTypeProxyOracle.getLongName();
                }
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "-- <cwd_ts_column column=\"" + column.getName() + "\" type=\"" + string + "\" />");
            }
        }
    }

    private void appendColumnCheckConstraints(StringBuffer stringBuffer, TableProxy tableProxy, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            Column column = columnProxy.getColumn();
            if (!column.hasConstraintsDefined()) continue;
            String string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName()));
            if (string.equals("")) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "--  WARNING: Column " + tableProxy.getName() + "." + columnProxy.getName() + " has no check constraint defined for this database type");
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                DDLFileMaker.incrementWarnings();
                continue;
            }
            String string2 = column.getConstraintName();
            if (string2.length() > tableProxy.getMaxNameLength()) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "--  ERROR: Column " + tableProxy.getName() + "." + columnProxy.getName() + " check constraint name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                DDLFileMaker.incrementErrors();
            }
            if (SSBTableOraclev10g.willGenerateInlineColumnConstrOra(column, columnProxy)) continue;
            SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "ALTER");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "TABLE");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(tableProxy.getLongName()));
            SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "ADD");
            if (!"".equals(string2)) {
                string2 = this.storageDesign.getFormatedName(string2);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, string2);
            }
            SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "CHECK");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, '(');
            SSBTableOraclev9i.appendString(stringBuffer2, string);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, ')');
            SSBTableOraclev10g.appendConstraintState(stringBuffer2, (ColumnProxyOracle)columnProxy, false, bl);
            String string3 = "Alter Table " + this.storageDesign.getFormatedName(tableProxy.getLongName()) + " Add Constraint " + string2;
            this.appendToBuffer(stringBuffer, stringBuffer2, string3);
            SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            stringBuffer2.append(';');
            SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, "");
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void appendTableLevelCheckConstraints(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = tableProxyOraclev9i.getTableCheckConstraints().iterator();
        while (iterator.hasNext()) {
            TableCheckConstraintOracle tableCheckConstraintOracle = (TableCheckConstraintOracle)iterator.next();
            String string = tableCheckConstraintOracle.getTableConstraint().getRule();
            String string2 = tableCheckConstraintOracle.getName();
            if (string2.toUpperCase().startsWith("SYS_")) {
                string2 = "";
            }
            if ("".equals(string2) || "".equals(string)) continue;
            SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            if (string2.length() > tableProxyOraclev9i.getMaxNameLength()) {
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev9i.appendStringWithSpace(stringBuffer, "--  ERROR: Table constraint name length exceeds maximum allowed length(" + tableProxyOraclev9i.getMaxNameLength() + ")");
                SSBTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
                DDLFileMaker.incrementErrors();
            }
            String string3 = this.storageDesign.getFormatedName(string2);
            String string4 = this.storageDesign.getFormatedName(tableProxyOraclev9i.getLongName());
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "ALTER");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "TABLE");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, string4);
            SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "ADD");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, string3);
            SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 1);
            SSBTableOraclev9i.appendStringWithSpace(stringBuffer2, "CHECK");
            SSBTableOraclev9i.appendString(stringBuffer2, '(');
            SSBTableOraclev9i.appendString(stringBuffer2, string);
            SSBTableOraclev9i.appendString(stringBuffer2, ')');
            this.appendTableConstraintState(stringBuffer2, tableCheckConstraintOracle, bl);
            String string5 = "Alter Table " + string4 + " Add Constraint " + string3;
            this.appendToBuffer(stringBuffer, stringBuffer2, string5);
            SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            stringBuffer2.append(';');
            SSBTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, "");
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void appendIndexesForConstraints(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle) {
        KeyObject[] keyObjectArray = table.getKeys();
        boolean bl = table.getDesign().getDLSettings().isAutomaticPKGeneration();
        boolean bl2 = table.getDesign().getDLSettings().isAutomaticUKGeneration();
        boolean bl3 = table.getDesign().getDLSettings().isAutomaticFKGeneration();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            Object object;
            ContainedObject[] containedObjectArray;
            Object object2;
            Index index = (Index)keyObjectArray[i];
            if (bl2 && "Unique Constraint".equals(index.getIndexState()) || index.isFK() && bl3) {
                object2 = index.getElements();
                if (((ContainedObject[])object2).length <= 0 || (containedObjectArray = SSBTableOraclev10g.getIndexUsableForColumns(table, index, (ContainedObject[])object2, true)) != null) continue;
                object = this.getSSBIndex();
                ((SSBIndexOraclev9i)object).appendIndexForConstraint(stringBuffer, index, true);
                continue;
            }
            if (!bl || !"Primary Constraint".equals(index.getIndexState()) || "INDEX".equalsIgnoreCase(tableProxyOracle.getOrganization()) || (object2 = tableProxyOracle.getSnapshot()) != null && !((SnapshotOracle)object2).getWith().equalsIgnoreCase("ROWID") && ((SnapshotOracle)object2).getRefresh().equals("YES") || (containedObjectArray = index.getElements()).length <= 0 || (object = this.getIndexForColumns(table, index, containedObjectArray, true)) != null) continue;
            SSBIndexOraclev9i sSBIndexOraclev9i = this.getSSBIndex();
            sSBIndexOraclev9i.appendIndexForConstraint(stringBuffer, index, true);
        }
    }

    private Index getIndexForColumns(Table table, Index index, ContainedObject[] containedObjectArray, boolean bl) {
        Object[] objectArray = table.getIndexes().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObjectPlaceHolder designObjectPlaceHolder = (DesignObjectPlaceHolder)objectArray[i];
            Index index2 = (Index)designObjectPlaceHolder.getDesignObject();
            ContainedObject[] containedObjectArray2 = index2.getElements();
            if (containedObjectArray.length != containedObjectArray2.length) continue;
            boolean bl2 = false;
            for (int j = 0; j < containedObjectArray.length; ++j) {
                String string;
                if (containedObjectArray[j] != containedObjectArray2[j]) {
                    bl2 = true;
                    break;
                }
                if (!bl || "ASC".equalsIgnoreCase(string = index2.getColumnSortOrder(containedObjectArray2[j]).trim()) || "".equalsIgnoreCase(string)) continue;
                bl2 = true;
                break;
            }
            if (bl2 || index2 == index) continue;
            return index2;
        }
        return null;
    }

    private SSBIndexOraclev9i getSSBIndex() {
        if (this.ssbIndex == null) {
            this.ssbIndex = new SSBIndexOraclev9i();
        }
        return this.ssbIndex;
    }

    public SSBArcFK_CheckConstr getArcConstrHandler() {
        if (this.arcConstrHandler == null && this.storageDesign != null) {
            this.arcConstrHandler = new SSBArcFK_CheckConstr(this.storageDesign);
        }
        return this.arcConstrHandler;
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((PartitionOraclev9i)object).getPosition() > ((PartitionOraclev9i)object2).getPosition()) {
                return 1;
            }
            if (((PartitionOraclev9i)object).getPosition() < ((PartitionOraclev9i)object2).getPosition()) {
                return -1;
            }
            return 0;
        }
    }

    static class GlobalPossitionComparator
    implements Comparator {
        GlobalPossitionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((IndexGlobalPartitionOraclev9i)object).getPosition() > ((IndexGlobalPartitionOraclev9i)object2).getPosition()) {
                return 1;
            }
            if (((IndexGlobalPartitionOraclev9i)object).getPosition() < ((IndexGlobalPartitionOraclev9i)object2).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

