/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.MethodParamProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.MethodProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.MethodProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StructuredTypeProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TypeElementProxyOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBStructuredTypeOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        if (object instanceof StructuredType) {
            StructuredType structuredType = (StructuredType)object;
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl, 0);
            this.appendComment(stringBuffer, structuredType);
        } else if (object instanceof StructuredTypeProxyOraclev9i) {
            StructuredTypeProxyOraclev9i structuredTypeProxyOraclev9i = (StructuredTypeProxyOraclev9i)object;
            this.storageDesign = structuredTypeProxyOraclev9i.getStorageDesign();
            if (!structuredTypeProxyOraclev9i.getStructuredType().isPredefined()) {
                SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, structuredTypeProxyOraclev9i);
                this.appendFullDefinition(stringBuffer, structuredTypeProxyOraclev9i, bl);
                this.appendCreateTypeBody(stringBuffer, structuredTypeProxyOraclev9i, bl);
                this.appendPermissions(stringBuffer, structuredTypeProxyOraclev9i);
                DDLFileMaker.incrementCreateStructuredType();
            }
        }
    }

    private void appendFullDefinition(StringBuffer stringBuffer, StructuredTypeProxyOraclev9i structuredTypeProxyOraclev9i, boolean bl) {
        String string;
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = "";
        SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl, 0);
        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "CREATE");
        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "OR");
        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "REPLACE");
        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "TYPE");
        if (structuredTypeProxyOraclev9i.getOwner() != null && !"".equals(string = structuredTypeProxyOraclev9i.getOwner().getName())) {
            SSBStructuredTypeOraclev9i.appendString(stringBuffer2, this.storageDesign.getFormatedName(string));
            SSBStructuredTypeOraclev9i.appendString(stringBuffer2, '.');
        }
        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(structuredTypeProxyOraclev9i.getName()));
        string2 = stringBuffer2.toString();
        if (!"".equalsIgnoreCase(structuredTypeProxyOraclev9i.getInvokerRights())) {
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 1);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "AUTHID");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, structuredTypeProxyOraclev9i.getInvokerRights());
        }
        if ("".equalsIgnoreCase(structuredTypeProxyOraclev9i.getSuperType())) {
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 1);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "AS");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "OBJECT");
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 1);
        } else {
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 1);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "UNDER");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, structuredTypeProxyOraclev9i.getSuperType());
        }
        this.appendSqljObjectType(stringBuffer2, structuredTypeProxyOraclev9i, bl);
        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, '(');
        SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 2);
        this.appendElements(stringBuffer2, structuredTypeProxyOraclev9i, bl);
        this.appendMethods(stringBuffer2, structuredTypeProxyOraclev9i, bl);
        SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 1);
        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, ')');
        if ("NO".equalsIgnoreCase(structuredTypeProxyOraclev9i.getFinal())) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "NOT");
        }
        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "FINAL");
        if ("NO".equalsIgnoreCase(structuredTypeProxyOraclev9i.getInstantiable())) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "NOT");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "INSTANTIABLE");
        }
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
        SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisherWithSlash(stringBuffer2, bl);
        SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 0);
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
    }

    private void appendSqljObjectType(StringBuffer stringBuffer, StructuredTypeProxyOraclev9i structuredTypeProxyOraclev9i, boolean bl) {
        if ("YES".equalsIgnoreCase(structuredTypeProxyOraclev9i.getMapToJavaClass())) {
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "EXTERNAL");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "NAME");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, structuredTypeProxyOraclev9i.getJavaClass());
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "LANGUAGE");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "JAVA");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "USING");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, structuredTypeProxyOraclev9i.getJavaInstanceUsing());
        }
    }

    private void appendElements(StringBuffer stringBuffer, StructuredTypeProxyOraclev9i structuredTypeProxyOraclev9i, boolean bl) {
        boolean bl2 = true;
        StructuredType structuredType = structuredTypeProxyOraclev9i.getStructuredType();
        TypeElement[] typeElementArray = structuredType.getElements();
        for (int i = 0; i < typeElementArray.length; ++i) {
            TypeElementProxyOraclev9i typeElementProxyOraclev9i = (TypeElementProxyOraclev9i)structuredTypeProxyOraclev9i.getElementByDesignObject(typeElementArray[i]);
            if (!bl2) {
                this.appendComma(stringBuffer);
                SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl, 2);
            } else {
                bl2 = false;
            }
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(typeElementProxyOraclev9i.getName()));
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, typeElementProxyOraclev9i.getDatatype(this.storageDesign.getRDBMSType().getName()));
            if ("".equalsIgnoreCase(typeElementProxyOraclev9i.getSqlJAttr())) continue;
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "EXTERNAL");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "NAME");
            SSBStructuredTypeOraclev9i.appendString(stringBuffer, '\'');
            SSBStructuredTypeOraclev9i.appendString(stringBuffer, typeElementProxyOraclev9i.getSqlJAttr());
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, '\'');
        }
    }

    private void appendMethods(StringBuffer stringBuffer, StructuredTypeProxyOracle structuredTypeProxyOracle, boolean bl) {
        boolean bl2;
        Iterator iterator = structuredTypeProxyOracle.getMethods().iterator();
        boolean bl3 = bl2 = structuredTypeProxyOracle.getElements().size() == 0;
        while (iterator.hasNext()) {
            MethodProxyOraclev9i methodProxyOraclev9i = (MethodProxyOraclev9i)iterator.next();
            if (!bl2) {
                this.appendComma(stringBuffer);
                SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl, 2);
            } else {
                bl2 = false;
            }
            this.appendInheritanceClauses(stringBuffer, methodProxyOraclev9i, bl);
            boolean bl4 = "YES".equalsIgnoreCase(methodProxyOraclev9i.getConstructor());
            if (!bl4) {
                if (structuredTypeProxyOracle.getMapOrderFunction() == methodProxyOraclev9i) {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, structuredTypeProxyOracle.getMapOrderType());
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "MEMBER");
                } else if ("YES".equalsIgnoreCase(methodProxyOraclev9i.getIsStatic())) {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "STATIC");
                } else {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "MEMBER");
                }
            }
            this.appendProcSpec(stringBuffer, structuredTypeProxyOracle, methodProxyOraclev9i, bl4, bl);
            this.appendPragmaClause(stringBuffer, methodProxyOraclev9i, bl);
        }
    }

    private void appendInheritanceClauses(StringBuffer stringBuffer, MethodProxyOraclev9i methodProxyOraclev9i, boolean bl) {
        if (!"NO".equalsIgnoreCase(methodProxyOraclev9i.getOverriding())) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "OVERRIDING");
        }
        if ("NO".equalsIgnoreCase(methodProxyOraclev9i.getInstantiable())) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "NOT");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "INSTANTIABLE");
        } else if ("YES".equalsIgnoreCase(methodProxyOraclev9i.getIsFinal())) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "FINAL");
        }
    }

    private void appendProcSpec(StringBuffer stringBuffer, StructuredTypeProxyOracle structuredTypeProxyOracle, MethodProxyOraclev9i methodProxyOraclev9i, boolean bl, boolean bl2) {
        if (bl) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "CONSTRUCTOR");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "FUNCTION");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(structuredTypeProxyOracle.getName()));
        } else {
            if ("PROCEDURE".equalsIgnoreCase(methodProxyOraclev9i.getMethodType())) {
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "PROCEDURE");
            } else {
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "FUNCTION");
            }
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(methodProxyOraclev9i.getName()));
        }
        if (methodProxyOraclev9i.getParams().size() > 0 || "NO".equalsIgnoreCase(methodProxyOraclev9i.getCopySelf())) {
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            boolean bl3 = true;
            if ("NO".equalsIgnoreCase(methodProxyOraclev9i.getCopySelf()) && "NO".equalsIgnoreCase(methodProxyOraclev9i.getIsStatic())) {
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "SELF");
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "IN");
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "OUT");
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "NOCOPY");
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(structuredTypeProxyOracle.getName()));
                bl3 = false;
            }
            Iterator iterator = methodProxyOraclev9i.getParams().iterator();
            while (iterator.hasNext()) {
                MethodParamProxyOracle methodParamProxyOracle = (MethodParamProxyOracle)iterator.next();
                if (bl3) {
                    bl3 = false;
                } else {
                    this.appendComma(stringBuffer);
                    SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl2, 2);
                }
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(methodParamProxyOracle.getName()));
                if (!"".equalsIgnoreCase(methodParamProxyOracle.getDirectionType())) {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, methodParamProxyOracle.getDirectionType());
                }
                if ("NO".equalsIgnoreCase(methodParamProxyOracle.getCopyArgument())) {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "NOCOPY");
                }
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, methodParamProxyOracle.getDatatype(this.storageDesign.getRDBMSType().getName()));
            }
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
        if (bl) {
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "RETURN");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "SELF");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "AS");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "RESULT");
        } else if (((Method)methodProxyOraclev9i.getObject()).getReturnValue() != null) {
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "RETURN");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, ((Method)methodProxyOraclev9i.getObject()).getReturnValue().getDataType(this.storageDesign.getRDBMSType().getName()));
        }
        if (methodProxyOraclev9i.getDeterministic().equalsIgnoreCase("YES")) {
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "DETERMINISTIC");
        }
        if (methodProxyOraclev9i.getParallel().equalsIgnoreCase("YES")) {
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "PARALLEL_ENABLE");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, methodProxyOraclev9i.getPartitioningAndStreaming());
        }
        if (methodProxyOraclev9i.getPipeliningAndAggregation().equalsIgnoreCase("Pipelined")) {
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "PIPELINED");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, methodProxyOraclev9i.getPipeliningAndAggregationImpl());
        } else if (methodProxyOraclev9i.getPipeliningAndAggregation().equalsIgnoreCase("Pipelined Using")) {
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "PIPELINED USING");
        } else if (methodProxyOraclev9i.getPipeliningAndAggregation().equalsIgnoreCase("Aggregate Using")) {
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "AGGREGATE USING");
        }
        if (!"PL/SQL".equalsIgnoreCase(methodProxyOraclev9i.getImplLanguage())) {
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "AS");
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "LANGUAGE");
            if ("Java".equalsIgnoreCase(methodProxyOraclev9i.getImplLanguage())) {
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "JAVA");
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "NAME");
                SSBStructuredTypeOraclev9i.appendString(stringBuffer, '\'');
                SSBStructuredTypeOraclev9i.appendString(stringBuffer, methodProxyOraclev9i.getJavaName());
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, '\'');
            } else if ("C".equalsIgnoreCase(methodProxyOraclev9i.getImplLanguage())) {
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "C");
                if (!"".equalsIgnoreCase(methodProxyOraclev9i.getCName())) {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "NAME");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, methodProxyOraclev9i.getCName());
                }
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "LIBRARY");
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, methodProxyOraclev9i.getCLibrary());
                if ("YES".equalsIgnoreCase(methodProxyOraclev9i.getWithContext())) {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "WITH");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "CONTEXT");
                }
                if (!"".equalsIgnoreCase(methodProxyOraclev9i.getCPartemeters())) {
                    SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl2, 2);
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "PARAMETERS");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, methodProxyOraclev9i.getCPartemeters());
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, ')');
                }
            }
        }
    }

    private void appendPragmaClause(StringBuffer stringBuffer, MethodProxyOracle methodProxyOracle, boolean bl) {
        if (!"".equalsIgnoreCase(methodProxyOracle.getPragmaClause())) {
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "PRAGMA");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "RESTRICT_REFERENCES");
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, methodProxyOracle.getPragmaClause());
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendCreateTypeBody(StringBuffer stringBuffer, StructuredTypeProxyOracle structuredTypeProxyOracle, boolean bl) {
        if (this.hasPLSQLMethod(structuredTypeProxyOracle)) {
            Object object;
            StringBuffer stringBuffer2 = new StringBuffer();
            String string = "";
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "CREATE");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "OR");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "REPLACE");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "TYPE");
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "BODY");
            if (structuredTypeProxyOracle.getOwner() != null && !"".equals(object = structuredTypeProxyOracle.getOwner().getName())) {
                SSBStructuredTypeOraclev9i.appendString(stringBuffer2, this.storageDesign.getFormatedName(structuredTypeProxyOracle.getOwner().getName()));
                SSBStructuredTypeOraclev9i.appendString(stringBuffer2, '.');
            }
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(structuredTypeProxyOracle.getName()));
            string = stringBuffer2.toString();
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 1);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "AS");
            object = structuredTypeProxyOracle.getMethods().iterator();
            while (object.hasNext()) {
                MethodProxyOraclev9i methodProxyOraclev9i = (MethodProxyOraclev9i)object.next();
                boolean bl2 = "YES".equalsIgnoreCase(methodProxyOraclev9i.getConstructor());
                if (!bl2 && "NO".equalsIgnoreCase(methodProxyOraclev9i.getInstantiable())) continue;
                SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 1);
                if (!bl2) {
                    if (structuredTypeProxyOracle.getMapOrderFunction() == methodProxyOraclev9i) {
                        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, structuredTypeProxyOracle.getMapOrderType());
                        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "MEMBER");
                    } else if ("YES".equalsIgnoreCase(methodProxyOraclev9i.getIsStatic())) {
                        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "STATIC");
                        if ("YES".equalsIgnoreCase(methodProxyOraclev9i.getIsFinal())) {
                            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "FINAL");
                        }
                    } else {
                        if ("YES".equalsIgnoreCase(methodProxyOraclev9i.getOverriding())) {
                            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "OVERRIDING");
                        }
                        if ("YES".equalsIgnoreCase(methodProxyOraclev9i.getIsFinal())) {
                            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "FINAL");
                        }
                        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "MEMBER");
                    }
                    if ("PROCEDURE".equalsIgnoreCase(methodProxyOraclev9i.getMethodType())) {
                        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "PROCEDURE");
                    } else {
                        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "FUNCTION");
                    }
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(methodProxyOraclev9i.getName()));
                } else {
                    if ("YES".equalsIgnoreCase(methodProxyOraclev9i.getIsFinal())) {
                        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "FINAL");
                    }
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "CONSTRUCTOR");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "FUNCTION");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(structuredTypeProxyOracle.getName()));
                }
                if (methodProxyOraclev9i.getParams().size() > 0 || "NO".equalsIgnoreCase(methodProxyOraclev9i.getCopySelf())) {
                    SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 2);
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, '(');
                    SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 2);
                    boolean bl3 = true;
                    if ("NO".equalsIgnoreCase(methodProxyOraclev9i.getCopySelf()) && "NO".equalsIgnoreCase(methodProxyOraclev9i.getIsStatic())) {
                        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "SELF");
                        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "IN");
                        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "OUT");
                        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "NOCOPY");
                        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(structuredTypeProxyOracle.getName()));
                        bl3 = false;
                    }
                    Iterator iterator = methodProxyOraclev9i.getParams().iterator();
                    while (iterator.hasNext()) {
                        MethodParamProxyOracle methodParamProxyOracle = (MethodParamProxyOracle)iterator.next();
                        if (bl3) {
                            bl3 = false;
                        } else {
                            this.appendComma(stringBuffer2);
                            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 2);
                        }
                        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(methodParamProxyOracle.getName()));
                        if (!"".equalsIgnoreCase(methodParamProxyOracle.getDirectionType())) {
                            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, methodParamProxyOracle.getDirectionType());
                        }
                        if ("NO".equalsIgnoreCase(methodParamProxyOracle.getCopyArgument())) {
                            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "NOCOPY");
                        }
                        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, methodParamProxyOracle.getDatatype(this.storageDesign.getRDBMSType().getName()));
                    }
                    SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 2);
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, ')');
                }
                if (bl2) {
                    SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 2);
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "RETURN");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "SELF");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "AS");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "RESULT");
                } else if (((Method)methodProxyOraclev9i.getObject()).getReturnValue() != null) {
                    SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 2);
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "RETURN");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, ((Method)methodProxyOraclev9i.getObject()).getReturnValue().getDataType(this.storageDesign.getRDBMSType().getName()));
                }
                SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 1);
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "AS");
                SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 1);
                if ("PL/SQL".equalsIgnoreCase(methodProxyOraclev9i.getImplLanguage())) {
                    if (!"".equalsIgnoreCase(methodProxyOraclev9i.getPLSQLBody().trim())) {
                        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, methodProxyOraclev9i.getPLSQLBody());
                        continue;
                    }
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "-- Empty PL/SQL Body");
                    SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 1);
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "BEGIN NULL; END;");
                    continue;
                }
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "LANGUAGE");
                if ("Java".equalsIgnoreCase(methodProxyOraclev9i.getImplLanguage())) {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "JAVA");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "NAME");
                    SSBStructuredTypeOraclev9i.appendString(stringBuffer2, '\'');
                    SSBStructuredTypeOraclev9i.appendString(stringBuffer2, methodProxyOraclev9i.getJavaName());
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, '\'');
                    continue;
                }
                if (!"C".equalsIgnoreCase(methodProxyOraclev9i.getImplLanguage())) continue;
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "C");
                if (!"".equalsIgnoreCase(methodProxyOraclev9i.getCName())) {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "NAME");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, methodProxyOraclev9i.getCName());
                }
                SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 2);
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "LIBRARY");
                if ("".equalsIgnoreCase(methodProxyOraclev9i.getCLibrary())) {
                    SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 2);
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "-- Empty library");
                } else {
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, methodProxyOraclev9i.getCLibrary());
                }
                if (!"".equalsIgnoreCase(methodProxyOraclev9i.getAgentArguments())) {
                    SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 2);
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "AGENT");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "IN");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, '(');
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, methodProxyOraclev9i.getAgentArguments());
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, ')');
                }
                if ("YES".equalsIgnoreCase(methodProxyOraclev9i.getWithContext())) {
                    SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 2);
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "WITH");
                    SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "CONTEXT");
                }
                if ("".equalsIgnoreCase(methodProxyOraclev9i.getCPartemeters())) continue;
                SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 2);
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "PARAMETERS");
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, '(');
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, methodProxyOraclev9i.getCPartemeters());
                SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, ')');
            }
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 1);
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "END");
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisherWithSlash(stringBuffer2, bl);
            SSBStructuredTypeOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
    }

    private boolean hasPLSQLMethod(StructuredTypeProxyOracle structuredTypeProxyOracle) {
        Iterator iterator = structuredTypeProxyOracle.getMethods().iterator();
        while (iterator.hasNext()) {
            MethodProxyOraclev9i methodProxyOraclev9i = (MethodProxyOraclev9i)iterator.next();
            if (!"PL/SQL".equalsIgnoreCase(methodProxyOraclev9i.getImplLanguage()) || !"YES".equalsIgnoreCase(methodProxyOraclev9i.getInstantiable())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof StructuredTypeProxyOraclev9i && ((StructuredTypeProxyOraclev9i)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof StructuredType && ((StructuredType)object).isMarkedGenerate();
    }

    protected void appendPermissions(StringBuffer stringBuffer, StructuredTypeProxyOracle structuredTypeProxyOracle) {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)structuredTypeProxyOracle.getStorageDesign();
        StringBuffer stringBuffer2 = new StringBuffer();
        PermissionsSetOracle permissionsSetOracle = storageDesignOracle.getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (!structuredTypeProxyOracle.equals(permissionsOracle.getStructuredTypeOracle()) || permissionsOracle.getUser() == null && permissionsOracle.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissionsOracle.getPrivileges())) {
                this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, structuredTypeProxyOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissionsOracle.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, structuredTypeProxyOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer stringBuffer, StringBuffer stringBuffer2, PermissionsOracle permissionsOracle, StructuredTypeProxyOracle structuredTypeProxyOracle, StorageDesignOracle storageDesignOracle, boolean bl) {
        stringBuffer2.append(NEWLINE);
        this.appendComment(stringBuffer2, permissionsOracle);
        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer2, "GRANT");
        if (bl) {
            stringBuffer2.append(permissionsOracle.getPrivilegesWithGrantOption());
        } else {
            stringBuffer2.append(permissionsOracle.getPrivileges());
        }
        this.appendObject(stringBuffer2, structuredTypeProxyOracle, storageDesignOracle);
        this.appendTo(stringBuffer2, permissionsOracle, storageDesignOracle);
        if (bl) {
            this.appendGrantOption(stringBuffer2, permissionsOracle);
        }
        String string = stringBuffer2.toString();
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(';');
        stringBuffer2.append(NEWLINE);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
    }

    private void appendObject(StringBuffer stringBuffer, StructuredTypeProxyOracle structuredTypeProxyOracle, StorageDesign storageDesign) {
        stringBuffer.append(NEWLINE);
        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "ON");
        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(structuredTypeProxyOracle.getLongName()));
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOracle permissionsOracle, StorageDesign storageDesign) {
        SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "TO");
        if ("YES".equalsIgnoreCase(permissionsOracle.getPublic())) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else if (permissionsOracle.getUser() != null) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getUser().getName()));
        } else if (permissionsOracle.getRole() != null) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getRole().getName()));
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOracle permissionsOracle) {
        if (permissionsOracle.getRole() == null) {
            SSBStructuredTypeOraclev9i.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }
}

