/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBTableOraclev9i;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.LobStorageOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SnapshotOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSnapshotOraclev9i
extends AbstractSSBOracle {
    SSBTableOraclev9i ssbTableOraclev9i;
    private StorageDesignOraclev9i storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        SnapshotOraclev9i snapshotOraclev9i = (SnapshotOraclev9i)object;
        TableProxyOracle tableProxyOracle = snapshotOraclev9i.getImplementedTable();
        if (!snapshotOraclev9i.isMarkedGenerate()) {
            if (tableProxyOracle != null && this.ssbTableOraclev9i != null) {
                this.ssbTableOraclev9i.appendIndexes(stringBuffer, tableProxyOracle, bl);
            }
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        this.storageDesign = (StorageDesignOraclev9i)snapshotOraclev9i.getStorageDesign();
        this.appendComment(stringBuffer, snapshotOraclev9i);
        this.appendCreateSnapshot(stringBuffer2, snapshotOraclev9i);
        String string = stringBuffer2.toString();
        if (tableProxyOracle != null || snapshotOraclev9i.getOnPrebuildTable() == null) {
            if (snapshotOraclev9i.getCluster() != null) {
                this.appendCluster(stringBuffer2, snapshotOraclev9i, bl);
            } else {
                this.appendSegment(stringBuffer2, snapshotOraclev9i, bl);
            }
            if (tableProxyOracle != null && this.ssbTableOraclev9i != null) {
                this.ssbTableOraclev9i.appendPartitionList(stringBuffer2, (TableProxyOraclev9i)tableProxyOracle, bl);
            } else {
                this.appendPartitioning(stringBuffer2, snapshotOraclev9i, bl);
            }
            this.appendParallelClause(stringBuffer2, snapshotOraclev9i, bl);
            if (!snapshotOraclev9i.getBuild().equals("IMMEDIATE")) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer2, "BUILD");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer2, snapshotOraclev9i.getBuild());
            }
        } else {
            this.appendPrebuild(stringBuffer2, snapshotOraclev9i, bl);
        }
        this.appendUsingIndex(stringBuffer2, snapshotOraclev9i, bl);
        this.appendRefreshClause(stringBuffer2, snapshotOraclev9i, bl);
        this.appendForUpdate(stringBuffer2, snapshotOraclev9i, bl);
        this.appendQueryRewrite(stringBuffer2, snapshotOraclev9i, bl);
        this.appendSubquery(stringBuffer2, snapshotOraclev9i, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        SSBSnapshotOraclev9i.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        DDLFileMaker.incrementCreateSnapshot();
        SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 0);
        this.appendCommentOn(stringBuffer2, snapshotOraclev9i, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        if (tableProxyOracle != null && this.ssbTableOraclev9i != null) {
            this.ssbTableOraclev9i.appendIndexes(stringBuffer, tableProxyOracle, bl);
        }
        this.appendPermissions(stringBuffer, snapshotOraclev9i, bl);
        SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 0);
    }

    private void appendCreateSnapshot(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i) {
        this.appendCreate(stringBuffer);
        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "MATERIALIZED");
        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "VIEW");
        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(snapshotOraclev9i.getLongName()));
    }

    private void appendSegment(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        this.appendPhysicalAttributes(stringBuffer, snapshotOraclev9i.getSegment(), bl);
        this.appendTableSpace(stringBuffer, snapshotOraclev9i, bl);
        this.appendLobStorage(stringBuffer, snapshotOraclev9i.getLobStorage(), bl);
        this.appendAttributes(stringBuffer, snapshotOraclev9i, bl);
    }

    private void appendParallelClause(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        if ("YES".equalsIgnoreCase(snapshotOraclev9i.getParalelClause())) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PARALLEL");
        }
    }

    private void appendPrebuild(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        if (snapshotOraclev9i.getImplementedTable() != null || snapshotOraclev9i.getOnPrebuildTable() == null) {
            if (!snapshotOraclev9i.getBuild().equals("IMMEDIATE")) {
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "BUILD");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getBuild());
            }
        } else {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "ON");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PREBUILT");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "TABLE");
            if ("NO".equalsIgnoreCase(snapshotOraclev9i.getReducedPrecision())) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "WITHOUT REDUCED PRECISION");
            }
        }
    }

    private void appendUsingIndex(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        if (snapshotOraclev9i.getUseIndex().equals("YES")) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "USING");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "INDEX");
            if (snapshotOraclev9i.getIndexTablespace() != null) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(snapshotOraclev9i.getIndexTablespace().getName()));
            } else if (snapshotOraclev9i.getIndexSegment() != null) {
                this.appendPhysicalAttributes(stringBuffer, snapshotOraclev9i.getIndexSegment(), bl);
            }
        } else if (snapshotOraclev9i.getUseIndex().equals("NO")) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "USING");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "NO");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "INDEX");
        }
    }

    private void appendRefreshClause(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        if ("NEVER".equalsIgnoreCase(snapshotOraclev9i.getRefresh())) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "NEVER");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "REFRESH");
        } else if ("YES".equals(snapshotOraclev9i.getRefresh())) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "REFRESH");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getRefreshType());
            if (!"".equalsIgnoreCase(snapshotOraclev9i.getAction())) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getAction());
            } else {
                if (!"".equalsIgnoreCase(snapshotOraclev9i.getStartDate())) {
                    SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "START DATE");
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getStartDate());
                }
                if (!"".equalsIgnoreCase(snapshotOraclev9i.getNextDate())) {
                    SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "NEXT");
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getNextDate());
                }
            }
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "WITH");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getWith());
            if ("YES".equalsIgnoreCase(snapshotOraclev9i.getDefaultSegment())) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "USING");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "DEFAULT");
                if (!"LOCAL".equalsIgnoreCase(snapshotOraclev9i.getSegmentType())) {
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getSegmentType());
                }
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "ROLLBACK");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "SEGMENT");
            } else if (snapshotOraclev9i.getRollbackSegment() != null) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "USING");
                if (!"LOCAL".equalsIgnoreCase(snapshotOraclev9i.getSegmentType())) {
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getSegmentType());
                }
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "ROLLBACK");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "SEGMENT");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(snapshotOraclev9i.getRollbackSegment().getName()));
            }
        }
    }

    private void appendForUpdate(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        if ("YES".equalsIgnoreCase(snapshotOraclev9i.getForUpdate())) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "FOR");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "UPDATE");
        }
    }

    private void appendQueryRewrite(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        if ("ENABLE".equalsIgnoreCase(snapshotOraclev9i.getQueryRewrite())) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "ENABLE");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "QUERY REWRITE");
        }
    }

    private void appendSubquery(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "AS");
        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getSubquery().trim());
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SnapshotOraclev9i;
    }

    private void appendLobStorage(StringBuffer stringBuffer, LobStorageOracle lobStorageOracle, boolean bl) {
        if (lobStorageOracle != null) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "LOB");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOracle.getColumn()));
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "STORE AS");
            if (!lobStorageOracle.getLobSegmentName().equalsIgnoreCase("")) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOracle.getLobSegmentName()));
            }
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (lobStorageOracle.getTableSpace() != null) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOracle.getTableSpace().getName()));
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            }
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "STORAGE");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
            if (lobStorageOracle.getSCInitialExtent() > 0L) {
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 3);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCInitialExtent());
            }
            if (lobStorageOracle.getSCNextExtent() > 0L) {
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 3);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCNextExtent());
            }
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 3);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCPctIncrease());
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 3);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCMinExtents());
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 3);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCMaxExtents());
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 3);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCFreeLists());
            if (lobStorageOracle.getSCFreelistGroups() > 1) {
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 3);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "FREELIST");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "GROUPS");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCFreelistGroups());
            }
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 3);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCBufferPool());
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (lobStorageOracle.getChunk() > 0) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "CHUNK");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getChunk());
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            }
            if (lobStorageOracle.getOldVersions().equalsIgnoreCase("RETENTION")) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "RETENTION");
            } else {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PCTVERSION");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getPCTVersion());
            }
            if (lobStorageOracle.getFreepools() > 0 && lobStorageOracle.getSCFreelistGroups() <= 1) {
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "FREEPOOLS");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getFreepools());
            }
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if ("ENABLE".equalsIgnoreCase(lobStorageOracle.getStorageInRow())) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "ENABLE");
            } else {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "DISABLE");
            }
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "STORAGE IN ROW");
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, lobStorageOracle.getCache());
            if (!"CACHE".equalsIgnoreCase(lobStorageOracle.getCache())) {
                if ("YES".equalsIgnoreCase(lobStorageOracle.getLogging())) {
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(lobStorageOracle.getLogging())) {
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "NOLOGGING");
                }
            }
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendTableSpace(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        TableSpaceOracle tableSpaceOracle = snapshotOraclev9i.getTablespace();
        if (tableSpaceOracle != null && !"[NONE]".equalsIgnoreCase(tableSpaceOracle.getName())) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        } else if (snapshotOraclev9i.getSegment() != null && snapshotOraclev9i.getSegment().getTableSpace() != null) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(snapshotOraclev9i.getSegment().getTableSpace().getName()));
        }
    }

    private void appendAttributes(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        if ("YES".equalsIgnoreCase(snapshotOraclev9i.getLogging())) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
        } else if ("NO".equalsIgnoreCase(snapshotOraclev9i.getLogging())) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "NOLOGGING");
        }
        if ("YES".equalsIgnoreCase(snapshotOraclev9i.getCache())) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "CACHE");
        } else if ("NO".equalsIgnoreCase(snapshotOraclev9i.getCache())) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "NOCACHE");
        }
    }

    private void appendCluster(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        ClusterOracle clusterOracle = snapshotOraclev9i.getCluster();
        if (clusterOracle != null) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "CLUSTER");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, clusterOracle.getStorageDesign().getFormatedName(clusterOracle.getLongName()));
            if (!"".equalsIgnoreCase(snapshotOraclev9i.getClusterColumns())) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getClusterColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendPhysicalAttributes(StringBuffer stringBuffer, SegmentOracle segmentOracle, boolean bl) {
        if (segmentOracle != null) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getPCTFree());
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PCTUSED");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getPCTUsed());
            if (segmentOracle.getInitrans() > 1) {
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "INITRANS");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getInitrans());
            }
            if (segmentOracle.getMaxTrans() > 1) {
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "MAXTRANS");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getMaxTrans());
            }
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "STORAGE");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (segmentOracle.getSCInitialExtent() > 0L) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getSCInitialExtent());
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            }
            if (segmentOracle.getSCNextExtent() > 0L) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getSCNextExtent());
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            }
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCPctIncrease());
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCMinExtents());
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, segmentOracle.getSCMaxExtents());
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCFreeLists());
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "FREELIST");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "GROUPS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCFreelistGroups());
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, segmentOracle.getSCBufferPool());
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendPartitioning(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        PartitionListOraclev9i partitionListOraclev9i = (PartitionListOraclev9i)snapshotOraclev9i.getPartitionList();
        if (partitionListOraclev9i != null) {
            String string = partitionListOraclev9i.getPartitionType();
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            if ("RANGE".equalsIgnoreCase(string)) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION BY RANGE");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
                this.appendPartitions(stringBuffer, partitionListOraclev9i, false, bl);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(string)) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION BY RANGE");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "BY");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "HASH");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getSubPartColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
                if ("NO".equals(partitionListOraclev9i.getUseSubpartStorageTemplate()) && (partitionListOraclev9i.getSubPartitionsQuantity() > 1 || !"".equals(partitionListOraclev9i.getSubPartitionsTableSpaces()))) {
                    SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                    this.appendStringWithSpace(stringBuffer, partitionListOraclev9i.getSubPartitionsQuantity());
                    if (!"".equals(partitionListOraclev9i.getSubPartitionsTableSpaces())) {
                        SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "STORE IN");
                        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getAllSubPartitionsTableSpaces()));
                        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
                    }
                }
                this.appendPartitions(stringBuffer, partitionListOraclev9i, true, bl);
            } else if ("COMPOSITE BY LIST".equalsIgnoreCase(string)) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION BY RANGE");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "BY");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "LIST");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getSubPartColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
                this.appendPartitions(stringBuffer, partitionListOraclev9i, true, bl);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(string)) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "BY");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "HASH");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PARTITIONS");
                this.appendStringWithSpace(stringBuffer, partitionListOraclev9i.getHashPQuantity());
                if (!"".equals(partitionListOraclev9i.getHashPTableSpaces())) {
                    SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "STORE IN");
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getAllHashPTableSpaces()));
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
                }
                if (!"".equals(partitionListOraclev9i.getIOTOverflowHashPTS())) {
                    SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "OVERFLOW");
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "STORE IN");
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getAllIOTOverflowHashPTS()));
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(string)) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "BY");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "HASH");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
                this.appendHashPartitions(stringBuffer, partitionListOraclev9i, bl);
            } else if ("LIST".equalsIgnoreCase(string)) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "BY");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "LIST");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
                this.appendListPartitions(stringBuffer, snapshotOraclev9i, bl);
            }
        }
    }

    private void appendPartStorage(StringBuffer stringBuffer, AbstractStorageObjectOracle abstractStorageObjectOracle, boolean bl) {
        TableSpaceOracle tableSpaceOracle = null;
        TableSpaceOracle tableSpaceOracle2 = null;
        StorageObjectCollection storageObjectCollection = null;
        if (abstractStorageObjectOracle instanceof HashPartitionOraclev9i) {
            tableSpaceOracle = ((HashPartitionOraclev9i)abstractStorageObjectOracle).getTableSpace();
            tableSpaceOracle2 = ((HashPartitionOraclev9i)abstractStorageObjectOracle).getIotOverflowTablespace();
            storageObjectCollection = ((HashPartitionOraclev9i)abstractStorageObjectOracle).getLobs();
        } else if (abstractStorageObjectOracle instanceof ListStorageTemplatePartitionOraclev9i) {
            tableSpaceOracle = ((ListStorageTemplatePartitionOraclev9i)abstractStorageObjectOracle).getTablespace();
            storageObjectCollection = ((ListStorageTemplatePartitionOraclev9i)abstractStorageObjectOracle).getLobs();
        }
        if (tableSpaceOracle != null) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
        if (tableSpaceOracle2 != null) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "OVERFLOW");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle2.getName()));
        }
        if (storageObjectCollection != null) {
            Iterator iterator = storageObjectCollection.iterator();
            while (iterator.hasNext()) {
                AbstractStorageObjectOracle abstractStorageObjectOracle2;
                Object e = iterator.next();
                if (e instanceof LobStorageOraclev9i) {
                    abstractStorageObjectOracle2 = (LobStorageOraclev9i)e;
                    if (((LobStorageOracle)abstractStorageObjectOracle2).getTableSpace() == null && ((LobStorageOracle)abstractStorageObjectOracle2).getLobSegmentName().trim().equals("")) continue;
                    SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
                    this.appendLobPartitioningStorage(stringBuffer, abstractStorageObjectOracle2.getName(), ((LobStorageOracle)abstractStorageObjectOracle2).getColumn(), ((LobStorageOracle)abstractStorageObjectOracle2).getLobSegmentName(), ((LobStorageOracle)abstractStorageObjectOracle2).getTableSpace(), bl);
                    continue;
                }
                if (!(e instanceof HashPartitionLobItemOraclev9i) || ((HashPartitionLobItemOracle)(abstractStorageObjectOracle2 = (HashPartitionLobItemOraclev9i)e)).getTableSpace() == null) continue;
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
                this.appendLobPartitioningStorage(stringBuffer, abstractStorageObjectOracle2.getName(), ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).getLobColumn(), "", ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).getTableSpace(), bl);
            }
        }
    }

    private void appendListPartitions(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        Iterator iterator = snapshotOraclev9i.getPartitions().iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            ListPartitionOraclev9i listPartitionOraclev9i = (ListPartitionOraclev9i)iterator.next();
            if (bl2) {
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                bl2 = false;
            } else {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ',');
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            }
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev9i.getName()));
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "VALUES");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
            if (!"".equalsIgnoreCase(listPartitionOraclev9i.getColumns())) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, listPartitionOraclev9i.getColumns());
            } else {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "DEFAULT");
            }
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
            if (listPartitionOraclev9i.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "NOCOMPRESS");
            } else if (listPartitionOraclev9i.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "COMPRESS");
            }
            if (listPartitionOraclev9i.getSegment() == null) {
                if (listPartitionOraclev9i.getTablespace() != null) {
                    SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev9i.getTablespace().getName()));
                }
                if (this.storageDesign.isOpen()) {
                    if (listPartitionOraclev9i.getLogging().equalsIgnoreCase("YES")) {
                        SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
                    } else if (listPartitionOraclev9i.getLogging().equalsIgnoreCase("NO")) {
                        SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "NOLOGGING");
                    }
                }
            }
            Iterator iterator2 = listPartitionOraclev9i.getLobStorages().iterator();
            while (iterator2.hasNext()) {
                LobStorageOracle lobStorageOracle = (LobStorageOracle)iterator2.next();
                this.appendLobStorage(stringBuffer, lobStorageOracle, bl);
            }
        }
        if (!bl2) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendPartitions(StringBuffer stringBuffer, PartitionListOracle partitionListOracle, boolean bl, boolean bl2) {
        StorageObjectCollection storageObjectCollection = partitionListOracle.getSnapshot().getPartitionsCollection();
        if (storageObjectCollection.size() > 0) {
            Object[] objectArray = storageObjectCollection.toArray();
            Arrays.sort(objectArray, new PossitionComparator());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(objectArray[i]);
            }
            Iterator iterator = arrayList.iterator();
            boolean bl3 = true;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof PartitionOracle)) continue;
                PartitionOracle partitionOracle = (PartitionOracle)e;
                if (bl3) {
                    SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    bl3 = false;
                } else {
                    this.appendComma(stringBuffer);
                }
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOracle.getName()));
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, partitionOracle.getValueList());
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
                this.appendPhysicalAttributes(stringBuffer, partitionOracle.getSegment(), bl2);
                Iterator iterator2 = partitionOracle.getLobs().iterator();
                while (iterator2.hasNext()) {
                    LobStorageOracle lobStorageOracle = (LobStorageOracle)iterator2.next();
                    this.appendLobStorage(stringBuffer, lobStorageOracle, bl2);
                }
                if (!bl) continue;
                if (partitionListOracle.getPartitionType().equalsIgnoreCase("COMPOSITE BY HASH")) {
                    if (this.appendHashSubPartitions(stringBuffer, partitionOracle, bl2) || partitionOracle.getSubPartitionsQuantity() <= 0) continue;
                    SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                    this.appendStringWithSpace(stringBuffer, partitionOracle.getSubPartitionsQuantity());
                    if ("".equalsIgnoreCase(partitionOracle.getSubPartitionsTableSpaces())) continue;
                    SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "STORE IN");
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionOracle.getAllSubPartitionsTableSpaces()));
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
                    continue;
                }
                if (partitionOracle.getListPartitions().size() <= 0) continue;
                boolean bl4 = true;
                Iterator iterator3 = partitionOracle.getListPartitions().iterator();
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                while (iterator3.hasNext()) {
                    ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i = (ListStorageTemplatePartitionOraclev9i)iterator3.next();
                    if (!bl4) {
                        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ',');
                    } else {
                        bl4 = false;
                    }
                    SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl2, 2);
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listStorageTemplatePartitionOraclev9i.getName()));
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "VALUES");
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, listStorageTemplatePartitionOraclev9i.getValueList());
                    SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
                    this.appendPartStorage(stringBuffer, listStorageTemplatePartitionOraclev9i, bl2);
                }
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
            }
            if (!bl3) {
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl2, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private boolean appendHashSubPartitions(StringBuffer stringBuffer, PartitionOracle partitionOracle, boolean bl) {
        boolean bl2 = false;
        HashPartitionSetOracle hashPartitionSetOracle = ((StorageDesignOracle)partitionOracle.getStorageDesign()).getHashPartitionSet();
        Iterator iterator = hashPartitionSetOracle.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)iterator.next();
            if (hashPartitionOracle.getSubPartitionOf() != partitionOracle) continue;
            if (bl3) {
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                bl3 = false;
                bl2 = true;
            } else {
                this.appendComma(stringBuffer);
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            }
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOracle.getName()));
            this.appendPartStorage(stringBuffer, hashPartitionOracle, bl);
        }
        if (!bl3) {
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
        return bl2;
    }

    private boolean appendHashPartitions(StringBuffer stringBuffer, PartitionListOracle partitionListOracle, boolean bl) {
        boolean bl2 = false;
        SnapshotOracle snapshotOracle = partitionListOracle.getSnapshot();
        Iterator iterator = snapshotOracle.getPartitions().iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)iterator.next();
            if (bl3) {
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
                bl3 = false;
                bl2 = true;
            } else {
                this.appendComma(stringBuffer);
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            }
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOracle.getName()));
            if (hashPartitionOracle.getTableSpace() != null) {
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOracle.getTableSpace().getName()));
            }
            this.appendHashPLobItems(stringBuffer, hashPartitionOracle, bl);
        }
        if (!bl3) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
        return bl2;
    }

    private void appendHashPLobItems(StringBuffer stringBuffer, HashPartitionOracle hashPartitionOracle, boolean bl) {
        HashPartitionLobItemSetOracle hashPartitionLobItemSetOracle = ((StorageDesignOracle)hashPartitionOracle.getStorageDesign()).getHashPartitionLobItemSet();
        Iterator iterator = hashPartitionLobItemSetOracle.iterator();
        while (iterator.hasNext()) {
            HashPartitionLobItemOracle hashPartitionLobItemOracle = (HashPartitionLobItemOracle)iterator.next();
            if (hashPartitionLobItemOracle.getHashPartition() == null || !hashPartitionLobItemOracle.getHashPartition().toString().equalsIgnoreCase(hashPartitionOracle.toString())) continue;
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 2);
            this.appendLobPartitioningStorage(stringBuffer, hashPartitionLobItemOracle.getName(), hashPartitionLobItemOracle.getLobColumn(), "", hashPartitionLobItemOracle.getTableSpace(), bl);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer stringBuffer, String string, Object object, String string2, TableSpaceOracle tableSpaceOracle, boolean bl) {
        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "LOB");
        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
        String string3 = "";
        if (object != null) {
            string3 = object.toString();
        }
        if (string3.length() > 0) {
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string3));
        } else {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("--  ERROR: Lob ");
            stringBuffer.append(string);
            stringBuffer.append(" has no Column specified");
            DDLFileMaker.incrementErrors();
        }
        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "STORE AS");
        if (!string2.equalsIgnoreCase("")) {
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
        } else if (tableSpaceOracle == null) {
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
        }
        if (tableSpaceOracle != null) {
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendObject(StringBuffer stringBuffer, PermissionsOracle permissionsOracle, boolean bl) {
        if (permissionsOracle.getSnapshot() != null) {
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "ON");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, permissionsOracle.getStorageDesign().getFormatedName(permissionsOracle.getSnapshot().getLongName()));
        }
    }

    private void appendPermissions(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        PermissionsSetOracle permissionsSetOracle = ((StorageDesignOracle)snapshotOraclev9i.getStorageDesign()).getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        while (iterator.hasNext()) {
            PermissionsOraclev9i permissionsOraclev9i = (PermissionsOraclev9i)iterator.next();
            if (permissionsOraclev9i.getSnapshot() != null && permissionsOraclev9i.getSnapshot().equals(snapshotOraclev9i) && !permissionsOraclev9i.getPrivileges().equalsIgnoreCase("")) {
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, permissionsOraclev9i);
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer2, "GRANT");
                SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer2, permissionsOraclev9i.getPrivileges());
                this.appendObject(stringBuffer2, permissionsOraclev9i, bl);
                this.appendTo(stringBuffer2, permissionsOraclev9i);
                string = stringBuffer2.toString();
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev9i);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                SSBSnapshotOraclev9i.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
            if (permissionsOraclev9i.getSnapshot() == null || !permissionsOraclev9i.getSnapshot().equals(snapshotOraclev9i) || permissionsOraclev9i.getPrivilegesWithGrantOption().equalsIgnoreCase("")) continue;
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer, bl, 0);
            this.appendComment(stringBuffer, permissionsOraclev9i);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer2, "GRANT");
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer2, permissionsOraclev9i.getPrivilegesWithGrantOption());
            this.appendObject(stringBuffer2, permissionsOraclev9i, bl);
            this.appendTo(stringBuffer2, permissionsOraclev9i);
            string = stringBuffer2.toString();
            this.appendHierrarchyOption(stringBuffer2, permissionsOraclev9i);
            this.appendGrantOption(stringBuffer2, permissionsOraclev9i);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            stringBuffer2.append(';');
            SSBSnapshotOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOracle permissionsOracle) {
        SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "TO");
        if ("YES".equalsIgnoreCase(permissionsOracle.getPublic())) {
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else if (permissionsOracle.getUser() != null) {
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOracle.getUser().getName()));
        } else if (permissionsOracle.getRole() != null) {
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOracle.getRole().getName()));
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        if (permissionsOraclev9i.getRole() == null) {
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        if ("YES".equalsIgnoreCase(permissionsOraclev9i.getHierarchyOption())) {
            stringBuffer.append(NEWLINE);
            SSBSnapshotOraclev9i.appendStringWithSpace(stringBuffer, "WITH HIERARCHY OPTION");
        }
    }

    public SSBTableOraclev9i getSSBTableOraclev9i() {
        return this.ssbTableOraclev9i;
    }

    public void setSSBTableOraclev9i(SSBTableOraclev9i sSBTableOraclev9i) {
        this.ssbTableOraclev9i = sSBTableOraclev9i;
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((PartitionOracle)object).getPosition() > ((PartitionOracle)object2).getPosition()) {
                return 1;
            }
            if (((PartitionOracle)object).getPosition() < ((PartitionOracle)object2).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

