/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ExternalTableColumnOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ExternalTableOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBExternalTableOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        ExternalTableOraclev9i externalTableOraclev9i = (ExternalTableOraclev9i)object;
        this.storageDesign = externalTableOraclev9i.getStorageDesign();
        if (externalTableOraclev9i.getColumns().size() != 0) {
            this.appendComment(stringBuffer, externalTableOraclev9i);
            this.appendCreate(stringBuffer2, externalTableOraclev9i);
            string = stringBuffer2.toString();
            this.appendElementList(stringBuffer2, externalTableOraclev9i, bl);
            this.appendExternalTableClause(stringBuffer2, externalTableOraclev9i, bl);
            this.appendRejectLimit(stringBuffer2, externalTableOraclev9i, bl);
            this.appendParallel(stringBuffer2, externalTableOraclev9i, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBExternalTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            this.appendPermissions(stringBuffer, externalTableOraclev9i);
            DDLFileMaker.incrementCreateTable();
        } else {
            SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("-- Error - External table ");
            stringBuffer.append(this.storageDesign.getFormatedName(externalTableOraclev9i.getName()));
            stringBuffer.append(" has no columns");
            DDLFileMaker.incrementErrors();
            SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendCreate(StringBuffer stringBuffer, ExternalTableOraclev9i externalTableOraclev9i) {
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "CREATE");
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLE");
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, externalTableOraclev9i.getStorageDesign().getFormatedName(externalTableOraclev9i.getLongName()));
    }

    private void appendElementList(StringBuffer stringBuffer, ExternalTableOraclev9i externalTableOraclev9i, boolean bl) {
        SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
        StorageObjectCollection storageObjectCollection = externalTableOraclev9i.getColumns();
        ExternalTableColumnOraclev9i externalTableColumnOraclev9i = null;
        for (int i = 0; i < storageObjectCollection.size(); ++i) {
            if (i == 0) {
                SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            } else {
                SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
                SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            }
            externalTableColumnOraclev9i = (ExternalTableColumnOraclev9i)storageObjectCollection.getElement(i);
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(externalTableColumnOraclev9i.getName()));
            String string = externalTableColumnOraclev9i.getDatatype();
            if (string.startsWith("TIMESTAMP")) {
                SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "TIMESTAMP");
                if (externalTableColumnOraclev9i.getPrecision() > 0) {
                    stringBuffer.append('(').append(externalTableColumnOraclev9i.getPrecision());
                    SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                }
                if (string.indexOf("WITH") <= -1) continue;
                SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, string.substring(10));
                continue;
            }
            if (string.equalsIgnoreCase("INTERVAL YEAR TO MONTH")) {
                SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "INTERVAL YEAR");
                if (externalTableColumnOraclev9i.getPrecision() > 0) {
                    stringBuffer.append('(').append(externalTableColumnOraclev9i.getPrecision());
                    SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                }
                SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "TO MONTH");
                continue;
            }
            if (string.equalsIgnoreCase("INTERVAL DAY TO SECOND")) {
                SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "INTERVAL DAY");
                if (externalTableColumnOraclev9i.getPrecision() > 0) {
                    stringBuffer.append('(').append(externalTableColumnOraclev9i.getPrecision());
                    SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                }
                SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "TO SECOND");
                if (externalTableColumnOraclev9i.getScale() <= 0) continue;
                stringBuffer.append('(').append(externalTableColumnOraclev9i.getScale());
                SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                continue;
            }
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, string);
            if (string.indexOf("CHAR") > -1 || string.equals("RAW") || string.equals("UROWID")) {
                if (externalTableColumnOraclev9i.getSize() <= 0) continue;
                stringBuffer.append('(').append(externalTableColumnOraclev9i.getSize());
                if (!externalTableColumnOraclev9i.getUnits().equalsIgnoreCase("") && (string.equalsIgnoreCase("CHAR") || string.equalsIgnoreCase("VARCHAR2") || string.equalsIgnoreCase("VARCHAR"))) {
                    stringBuffer.append(' ').append(externalTableColumnOraclev9i.getUnits());
                }
                SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
                continue;
            }
            if (externalTableColumnOraclev9i.getPrecision() <= 0) continue;
            stringBuffer.append('(').append(externalTableColumnOraclev9i.getPrecision());
            if (externalTableColumnOraclev9i.getScale() != 0) {
                SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
                stringBuffer.append(externalTableColumnOraclev9i.getScale());
            }
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
        SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
    }

    private void appendExternalTableClause(StringBuffer stringBuffer, ExternalTableOraclev9i externalTableOraclev9i, boolean bl) {
        SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "ORGANIZATION");
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "EXTERNAL");
        SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
        if (!"".equalsIgnoreCase(externalTableOraclev9i.getAccessDriverType().trim())) {
            SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "TYPE");
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, externalTableOraclev9i.getAccessDriverType());
        }
        if (externalTableOraclev9i.getDefaultDir() != null) {
            SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "DEFAULT");
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "DIRECTORY");
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(externalTableOraclev9i.getDefaultDir().getName()));
        }
        if (externalTableOraclev9i.getAccessParametersType().equalsIgnoreCase("Opaque Format Spec")) {
            SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "ACCESS");
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "PARAMETERS");
            SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, externalTableOraclev9i.getOpaqueFormatSpec());
            SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
        } else if (externalTableOraclev9i.getAccessParametersType().equalsIgnoreCase("CLOB Subquery")) {
            SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "ACCESS");
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "PARAMETERS");
            SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "USING");
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "CLOB");
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, externalTableOraclev9i.getClobSubquery());
        }
        SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "LOCATION");
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
        if (!externalTableOraclev9i.getLocation().startsWith("'")) {
            SSBExternalTableOraclev9i.appendString(stringBuffer, '\'');
        }
        SSBExternalTableOraclev9i.appendString(stringBuffer, externalTableOraclev9i.getLocation());
        if (!externalTableOraclev9i.getLocation().endsWith("'")) {
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, '\'');
        }
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
        SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
    }

    private void appendParallel(StringBuffer stringBuffer, ExternalTableOraclev9i externalTableOraclev9i, boolean bl) {
        if (externalTableOraclev9i.getParallel().equalsIgnoreCase("PARALLEL")) {
            SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, externalTableOraclev9i.getParallel());
            this.appendStringWithSpace(stringBuffer, externalTableOraclev9i.getParallelNum());
        }
    }

    private void appendRejectLimit(StringBuffer stringBuffer, ExternalTableOraclev9i externalTableOraclev9i, boolean bl) {
        SSBExternalTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "REJECT");
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "LIMIT");
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, externalTableOraclev9i.getRejectLimit());
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof ExternalTableOraclev9i && ((ExternalTableOraclev9i)object).isMarkedGenerate();
    }

    protected void appendPermissions(StringBuffer stringBuffer, ExternalTableOracle externalTableOracle) {
        StorageDesignOracle storageDesignOracle = externalTableOracle.getStorageDesignOracle();
        StringBuffer stringBuffer2 = new StringBuffer();
        PermissionsSetOracle permissionsSetOracle = storageDesignOracle.getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (!externalTableOracle.equals(permissionsOracle.getExternalTableOracle()) || permissionsOracle.getUser() == null && permissionsOracle.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissionsOracle.getPrivileges())) {
                this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, externalTableOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissionsOracle.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, externalTableOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer stringBuffer, StringBuffer stringBuffer2, PermissionsOracle permissionsOracle, ExternalTableOracle externalTableOracle, StorageDesignOracle storageDesignOracle, boolean bl) {
        stringBuffer2.append(NEWLINE);
        this.appendComment(stringBuffer2, permissionsOracle);
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer2, "GRANT");
        if (bl) {
            stringBuffer2.append(permissionsOracle.getPrivilegesWithGrantOption());
        } else {
            stringBuffer2.append(permissionsOracle.getPrivileges());
        }
        this.appendObject(stringBuffer2, externalTableOracle, storageDesignOracle);
        this.appendTo(stringBuffer2, permissionsOracle, storageDesignOracle);
        if (bl) {
            this.appendGrantOption(stringBuffer2, permissionsOracle);
        }
        String string = stringBuffer2.toString();
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(';');
        stringBuffer2.append(NEWLINE);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
    }

    private void appendObject(StringBuffer stringBuffer, ExternalTableOracle externalTableOracle, StorageDesign storageDesign) {
        stringBuffer.append(NEWLINE);
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "ON");
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(externalTableOracle.getLongName()));
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOracle permissionsOracle, StorageDesign storageDesign) {
        SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "TO");
        if ("YES".equalsIgnoreCase(permissionsOracle.getPublic())) {
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else if (permissionsOracle.getUser() != null) {
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getUser().getName()));
        } else if (permissionsOracle.getRole() != null) {
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getRole().getName()));
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOracle permissionsOracle) {
        if (permissionsOracle.getRole() == null) {
            SSBExternalTableOraclev9i.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }
}

