/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DirectoryOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBDirectoryOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        DirectoryOraclev9i directoryOraclev9i = (DirectoryOraclev9i)object;
        this.storageDesign = directoryOraclev9i.getStorageDesign();
        this.appendComment(stringBuffer, directoryOraclev9i);
        this.appendCreateDir(stringBuffer2, directoryOraclev9i);
        string = stringBuffer2.toString();
        this.appendDirPath(stringBuffer2, directoryOraclev9i, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        SSBDirectoryOraclev9i.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        SSBDirectoryOraclev9i.appendNewLine(stringBuffer2, bl, 0);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        this.appendPermissions(stringBuffer, directoryOraclev9i);
        DDLFileMaker.incrementCreateDirectory();
    }

    private void appendCreateDir(StringBuffer stringBuffer, DirectoryOraclev9i directoryOraclev9i) {
        this.appendCreateOrReplace(stringBuffer);
        SSBDirectoryOraclev9i.appendStringWithSpace(stringBuffer, "DIRECTORY");
        SSBDirectoryOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(directoryOraclev9i.getName()));
    }

    private void appendDirPath(StringBuffer stringBuffer, DirectoryOraclev9i directoryOraclev9i, boolean bl) {
        SSBDirectoryOraclev9i.appendNewLine(stringBuffer, bl, 1);
        SSBDirectoryOraclev9i.appendStringWithSpace(stringBuffer, "AS");
        SSBDirectoryOraclev9i.appendString(stringBuffer, '\'');
        SSBDirectoryOraclev9i.appendString(stringBuffer, directoryOraclev9i.getDirPath());
        SSBDirectoryOraclev9i.appendStringWithSpace(stringBuffer, '\'');
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DirectoryOraclev9i && ((DirectoryOraclev9i)object).isMarkedGenerate();
    }

    protected void appendPermissions(StringBuffer stringBuffer, DirectoryOracle directoryOracle) {
        StorageDesignOracle storageDesignOracle = directoryOracle.getStorageDesignOracle();
        StringBuffer stringBuffer2 = new StringBuffer();
        PermissionsSetOracle permissionsSetOracle = storageDesignOracle.getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (!directoryOracle.equals(permissionsOracle.getDirectoryOracle()) || permissionsOracle.getUser() == null && permissionsOracle.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissionsOracle.getPrivileges())) {
                this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, directoryOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissionsOracle.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, directoryOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer stringBuffer, StringBuffer stringBuffer2, PermissionsOracle permissionsOracle, DirectoryOracle directoryOracle, StorageDesignOracle storageDesignOracle, boolean bl) {
        stringBuffer2.append(NEWLINE);
        this.appendComment(stringBuffer2, permissionsOracle);
        SSBDirectoryOraclev9i.appendStringWithSpace(stringBuffer2, "GRANT");
        if (bl) {
            stringBuffer2.append(permissionsOracle.getPrivilegesWithGrantOption());
        } else {
            stringBuffer2.append(permissionsOracle.getPrivileges());
        }
        this.appendObject(stringBuffer2, directoryOracle, storageDesignOracle);
        this.appendTo(stringBuffer2, permissionsOracle, storageDesignOracle);
        if (bl) {
            this.appendGrantOption(stringBuffer2, permissionsOracle);
        }
        String string = stringBuffer2.toString();
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(';');
        stringBuffer2.append(NEWLINE);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
    }

    private void appendObject(StringBuffer stringBuffer, DirectoryOracle directoryOracle, StorageDesign storageDesign) {
        stringBuffer.append(NEWLINE);
        SSBDirectoryOraclev9i.appendStringWithSpace(stringBuffer, "ON");
        SSBDirectoryOraclev9i.appendStringWithSpace(stringBuffer, "DIRECTORY");
        SSBDirectoryOraclev9i.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(directoryOracle.getLongName()));
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOracle permissionsOracle, StorageDesign storageDesign) {
        SSBDirectoryOraclev9i.appendStringWithSpace(stringBuffer, "TO");
        if ("YES".equalsIgnoreCase(permissionsOracle.getPublic())) {
            SSBDirectoryOraclev9i.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else if (permissionsOracle.getUser() != null) {
            SSBDirectoryOraclev9i.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getUser().getName()));
        } else if (permissionsOracle.getRole() != null) {
            SSBDirectoryOraclev9i.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getRole().getName()));
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOracle permissionsOracle) {
        if (permissionsOracle.getRole() == null) {
            SSBDirectoryOraclev9i.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }
}

