/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.CollectionTypeProxyOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBCollectionTypeOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        if (object instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)object;
            SSBCollectionTypeOraclev9i.appendNewLine(stringBuffer, bl, 0);
            this.appendComment(stringBuffer, collectionType);
        } else if (object instanceof CollectionTypeProxyOraclev9i) {
            CollectionTypeProxyOraclev9i collectionTypeProxyOraclev9i = (CollectionTypeProxyOraclev9i)object;
            this.storageDesign = collectionTypeProxyOraclev9i.getStorageDesign();
            SSBCollectionTypeOraclev9i.appendNewLine(stringBuffer, bl, 0);
            this.appendComment(stringBuffer, collectionTypeProxyOraclev9i);
            this.appendFullDefinition(stringBuffer, collectionTypeProxyOraclev9i, bl);
            this.appendPermissions(stringBuffer, collectionTypeProxyOraclev9i);
            DDLFileMaker.incrementCreateCollectionType();
        }
    }

    private void appendFullDefinition(StringBuffer stringBuffer, CollectionTypeProxyOraclev9i collectionTypeProxyOraclev9i, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        SSBCollectionTypeOraclev9i.appendNewLine(stringBuffer, bl, 0);
        SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer2, "CREATE");
        SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer2, "OR");
        SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer2, "REPLACE");
        SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer2, "TYPE");
        if (collectionTypeProxyOraclev9i.getOwner() != null) {
            SSBCollectionTypeOraclev9i.appendString(stringBuffer2, this.storageDesign.getFormatedName(collectionTypeProxyOraclev9i.getOwner().getName()));
            SSBCollectionTypeOraclev9i.appendString(stringBuffer2, '.');
        }
        SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(collectionTypeProxyOraclev9i.getName()));
        string = stringBuffer2.toString();
        if (!"".equalsIgnoreCase(collectionTypeProxyOraclev9i.getType())) {
            SSBCollectionTypeOraclev9i.appendNewLine(stringBuffer2, bl, 1);
            SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer2, "IS");
            if (collectionTypeProxyOraclev9i.isArrayType(collectionTypeProxyOraclev9i.getType())) {
                SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer2, "VARRAY");
                SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer2, '(');
                this.appendStringWithSpace(stringBuffer2, collectionTypeProxyOraclev9i.getMaxElement());
                SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer2, ')');
            } else {
                SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer2, "TABLE");
            }
        }
        SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer2, "OF");
        SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer2, collectionTypeProxyOraclev9i.getDataType("Oracle9i"));
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        SSBCollectionTypeOraclev9i.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisherWithSlash(stringBuffer2, bl);
        SSBCollectionTypeOraclev9i.appendNewLine(stringBuffer2, bl, 0);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof CollectionTypeProxyOraclev9i && ((CollectionTypeProxyOraclev9i)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof CollectionType && ((CollectionType)object).isMarkedGenerate();
    }

    protected void appendPermissions(StringBuffer stringBuffer, CollectionTypeProxyOracle collectionTypeProxyOracle) {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)collectionTypeProxyOracle.getStorageDesign();
        StringBuffer stringBuffer2 = new StringBuffer();
        PermissionsSetOracle permissionsSetOracle = storageDesignOracle.getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (!collectionTypeProxyOracle.equals(permissionsOracle.getCollectionTypeOracle()) || permissionsOracle.getUser() == null && permissionsOracle.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissionsOracle.getPrivileges())) {
                this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, collectionTypeProxyOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissionsOracle.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, collectionTypeProxyOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer stringBuffer, StringBuffer stringBuffer2, PermissionsOracle permissionsOracle, CollectionTypeProxyOracle collectionTypeProxyOracle, StorageDesignOracle storageDesignOracle, boolean bl) {
        stringBuffer2.append(NEWLINE);
        this.appendComment(stringBuffer2, permissionsOracle);
        SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer2, "GRANT");
        if (bl) {
            stringBuffer2.append(permissionsOracle.getPrivilegesWithGrantOption());
        } else {
            stringBuffer2.append(permissionsOracle.getPrivileges());
        }
        this.appendObject(stringBuffer2, collectionTypeProxyOracle, storageDesignOracle);
        this.appendTo(stringBuffer2, permissionsOracle, storageDesignOracle);
        if (bl) {
            this.appendGrantOption(stringBuffer2, permissionsOracle);
        }
        String string = stringBuffer2.toString();
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(';');
        stringBuffer2.append(NEWLINE);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
    }

    private void appendObject(StringBuffer stringBuffer, CollectionTypeProxyOracle collectionTypeProxyOracle, StorageDesign storageDesign) {
        stringBuffer.append(NEWLINE);
        SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer, "ON");
        SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(collectionTypeProxyOracle.getLongName()));
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOracle permissionsOracle, StorageDesign storageDesign) {
        SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer, "TO");
        if ("YES".equalsIgnoreCase(permissionsOracle.getPublic())) {
            SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else if (permissionsOracle.getUser() != null) {
            SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getUser().getName()));
        } else if (permissionsOracle.getRole() != null) {
            SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getRole().getName()));
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOracle permissionsOracle) {
        if (permissionsOracle.getRole() == null) {
            SSBCollectionTypeOraclev9i.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }
}

