/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBUserOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        UserOraclev10g userOraclev10g = (UserOraclev10g)object;
        this.storageDesign = userOraclev10g.getStorageDesign();
        this.appendComment(stringBuffer, userOraclev10g);
        SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, "CREATE");
        SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, "USER");
        SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(userOraclev10g.getName()));
        string = stringBuffer2.toString();
        this.appendAuthenticationType(stringBuffer2, userOraclev10g, bl);
        this.appendDefaultTableSpace(stringBuffer2, userOraclev10g, bl);
        this.appendTempTableSpace(stringBuffer2, userOraclev10g, bl);
        this.appendQuotaItems(stringBuffer2, userOraclev10g, bl);
        this.appendProfile(stringBuffer2, userOraclev10g, bl);
        this.appendPasswordExpire(stringBuffer2, userOraclev10g, bl);
        this.appendAccountLock(stringBuffer2, userOraclev10g, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        SSBUserOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        SSBUserOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        DDLFileMaker.incrementCreateUser();
        this.appendRolesAndPrivileges(stringBuffer, userOraclev10g, bl);
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof UserOraclev10g && ((UserOraclev10g)object).isMarkedGenerate();
    }

    private void appendAuthenticationType(StringBuffer stringBuffer, UserOraclev10g userOraclev10g, boolean bl) {
        String string = userOraclev10g.getAuthType();
        SSBUserOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "IDENTIFIED");
        if (string.equalsIgnoreCase("BY_PASSWORD")) {
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, userOraclev10g.decodeIdentifier());
        } else if (string.equalsIgnoreCase("EXTERNALLY")) {
            if (userOraclev10g.decodeIdentifier().trim().equals("")) {
                SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "EXTERNALLY");
            } else {
                SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "EXTERNALLY AS ");
                SSBUserOraclev10g.appendStringWithSpace(stringBuffer, userOraclev10g.decodeIdentifier());
            }
        } else if (userOraclev10g.decodeIdentifier().trim().equals("")) {
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "GLOBALLY");
        } else {
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "GLOBALLY AS ");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, userOraclev10g.decodeIdentifier());
        }
    }

    private void appendDefaultTableSpace(StringBuffer stringBuffer, UserOraclev10g userOraclev10g, boolean bl) {
        if (userOraclev10g.getDefTableSpace() != null) {
            String string = this.storageDesign.getFormatedName(userOraclev10g.getDefTableSpace().getName());
            SSBUserOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "DEFAULT");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, string);
        }
    }

    private void appendTempTableSpace(StringBuffer stringBuffer, UserOraclev10g userOraclev10g, boolean bl) {
        if (userOraclev10g.getTempTableSpace() != null) {
            SSBUserOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "TEMPORARY");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(userOraclev10g.getTempTableSpace().getName()));
        } else if (!"".equalsIgnoreCase(userOraclev10g.getTempTSGroupName())) {
            SSBUserOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "TEMPORARY");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, userOraclev10g.getTempTSGroupName());
        }
    }

    private void appendQuotaItems(StringBuffer stringBuffer, UserOraclev10g userOraclev10g, boolean bl) {
        QuotaItemSetOracle quotaItemSetOracle = ((StorageDesignOracle)userOraclev10g.getStorageDesign()).getQuotaItemSet();
        List list = quotaItemSetOracle.getElementsList();
        for (QuotaItemOracle quotaItemOracle : list) {
            if (quotaItemOracle.getUser() == null || quotaItemOracle.getTableSpace() == null || !quotaItemOracle.getUser().toString().equalsIgnoreCase(userOraclev10g.toString())) continue;
            SSBUserOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "QUOTA");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, quotaItemOracle.getSize());
            if (!quotaItemOracle.getSize().equalsIgnoreCase("UNLIMITED")) {
                SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "K");
            }
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(quotaItemOracle.getTableSpace().getName()));
        }
    }

    private void appendProfile(StringBuffer stringBuffer, UserOraclev10g userOraclev10g, boolean bl) {
        String string = userOraclev10g.getProfile();
        if (!"".equalsIgnoreCase(string)) {
            SSBUserOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "PROFILE");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, string);
        }
    }

    private void appendPasswordExpire(StringBuffer stringBuffer, UserOraclev10g userOraclev10g, boolean bl) {
        String string = userOraclev10g.getPasswordExpire();
        if (string.equalsIgnoreCase("YES")) {
            SSBUserOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "PASSWORD EXPIRE");
        }
    }

    private void appendAccountLock(StringBuffer stringBuffer, UserOraclev10g userOraclev10g, boolean bl) {
        String string = userOraclev10g.getAccountLock();
        SSBUserOraclev10g.appendNewLine(stringBuffer, bl, 1);
        if (string.equalsIgnoreCase("YES")) {
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "ACCOUNT LOCK");
        } else {
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer, "ACCOUNT UNLOCK");
        }
    }

    private void appendRolesAndPrivileges(StringBuffer stringBuffer, UserOracle userOracle, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        String string2 = userOracle.getRolesNames().trim();
        String string3 = userOracle.getRolesWithAdminOptionNames().trim();
        String string4 = userOracle.getPrivileges();
        String string5 = userOracle.getPrivilegesWithAdminOption();
        if (!"".equalsIgnoreCase(string2)) {
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, "GRANT");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, string2);
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, "TO");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(userOracle.getName()));
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBUserOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            SSBUserOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
        if (!"".equalsIgnoreCase(string3)) {
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, "GRANT");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, string3);
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, "TO");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(userOracle.getName()));
            stringBuffer2.append(" WITH ADMIN OPTION");
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBUserOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            SSBUserOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
        if (!"".equalsIgnoreCase(string4)) {
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, "GRANT");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, string4);
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, "TO");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(userOracle.getName()));
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBUserOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            SSBUserOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
        if (!"".equalsIgnoreCase(string5)) {
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, "GRANT");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, string5);
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, "TO");
            SSBUserOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(userOracle.getName()));
            stringBuffer2.append(" WITH ADMIN OPTION");
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBUserOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            SSBUserOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
    }
}

