/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFK_CheckConstr;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBIndexOraclev10g;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionLobItemSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxySetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PermissionsOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PermissionsSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.LobStorageOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableOraclev10g
extends AbstractSSBOracle {
    private SSBIndexOraclev10g ssbIndex = null;
    private PKProxyOraclev10g pk = null;
    protected StorageDesignOraclev10g storageDesign;
    protected Table table;
    protected TableProxyOraclev10g tableProxy = null;
    private SSBArcFK_CheckConstr arcConstrHandler;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxyOraclev10g && ((TableProxyOracle)object).getSnapshot() == null;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        ModelIDObject modelIDObject;
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        this.table = null;
        if (object == null) {
            return;
        }
        if (object instanceof Table) {
            this.table = (Table)object;
            modelIDObject = this.table.getDesign();
            RDBMSSite rDBMSSite = this.table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)((Design)modelIDObject).getStorageDesign(rDBMSSite, this.table);
            this.tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        } else if (object instanceof TableProxyOraclev10g) {
            this.tableProxy = (TableProxyOraclev10g)object;
            this.table = (Table)this.tableProxy.getObject();
            modelIDObject = this.table.getDesign();
            this.storageDesign = (StorageDesignOraclev10g)((Design)modelIDObject).getStorageDesign(this.table.getSelectedRDBMSSite(), this.table);
        } else {
            return;
        }
        if (this.tableProxy != null && !this.tableProxy.isMarkedGenerate()) {
            this.appendIndexes(stringBuffer, this.tableProxy, bl);
            return;
        }
        if (this.table.getTypeSubstitution() == null) {
            if (this.table != null) {
                if (this.tableProxy != null && this.tableProxy.isCommentChanged()) {
                    this.appendComment(stringBuffer, this.tableProxy);
                } else {
                    this.appendComment(stringBuffer, this.table);
                }
                if (this.tableProxy != null && this.tableProxy.getName().length() > this.tableProxy.getMaxNameLength()) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + this.tableProxy.getMaxNameLength() + ")");
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementErrors();
                }
                this.appendBeforeCreateScript(stringBuffer, bl, this.table);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "CREATE");
                if (this.tableProxy == null) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(this.table.getLongName()));
                    string = stringBuffer2.toString();
                    this.appendElementList(stringBuffer2, this.table, null, bl);
                    this.appendOid(stringBuffer2, this.table, null, bl);
                } else if ("YES".equalsIgnoreCase(this.tableProxy.getTemporary())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "GLOBAL");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "TEMPORARY");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(this.tableProxy.getLongName()));
                    string = stringBuffer2.toString();
                    this.appendElementList(stringBuffer2, this.table, this.tableProxy, bl);
                    SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "ON");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "COMMIT");
                    if ("YES".equalsIgnoreCase(this.tableProxy.getTempPreserveRows())) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "PRESERVE ROWS");
                    } else {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "DELETE ROWS");
                    }
                    this.appendOid(stringBuffer2, this.table, null, bl);
                    if ("YES".equalsIgnoreCase(this.tableProxy.getCache())) {
                        SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "CACHE");
                    }
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(this.tableProxy.getLongName()));
                    string = stringBuffer2.toString();
                    this.appendElementList(stringBuffer2, this.table, this.tableProxy, bl);
                    this.appendOid(stringBuffer2, this.table, this.tableProxy, bl);
                    this.appendCluster(stringBuffer2, this.tableProxy, bl);
                    this.appendColumnProperties(stringBuffer2, this.table, this.tableProxy, bl);
                    this.appendPartitionList(stringBuffer2, this.tableProxy, bl);
                    if (this.tableProxy.getCluster() == null) {
                        if ("YES".equalsIgnoreCase(this.tableProxy.getCache())) {
                            SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "CACHE");
                        }
                        if ("YES".equalsIgnoreCase(this.tableProxy.getParallel())) {
                            SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "PARALLEL");
                            if (!"".equalsIgnoreCase(this.tableProxy.getDegree())) {
                                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, this.tableProxy.getDegree());
                            }
                        }
                    }
                    if ("YES".equalsIgnoreCase(this.tableProxy.getRowDependency())) {
                        SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "ROWDEPENDENCIES");
                        modelIDObject = this.tableProxy.getCluster();
                        if (modelIDObject != null && !((ClusterOracle)modelIDObject).getRowDependency().equalsIgnoreCase("YES")) {
                            SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "--  ERROR: Cluster has different ROWDEPENDENCIES setting");
                            DDLFileMaker.incrementErrors();
                        }
                    }
                }
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                this.appendLineFinisher(stringBuffer2, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                DDLFileMaker.incrementCreateTable();
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                if (this.tableProxy != null) {
                    this.appendColumnCheckConstraints(stringBuffer, this.tableProxy, bl);
                    this.appendTableLevelCheckConstraints(stringBuffer, this.tableProxy, bl);
                    if (this.getArcConstrHandler() != null) {
                        this.getArcConstrHandler().appendArcConstraints(stringBuffer, this.tableProxy, bl);
                    }
                }
                if (this.table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendTableCommentOn(stringBuffer, this.table, this.tableProxy, bl);
                }
                if (this.tableProxy != null) {
                    this.appendIndexes(stringBuffer, this.tableProxy, bl);
                    this.appendPermissions(stringBuffer, this.tableProxy, bl);
                    if (this.table.getDesign().getAppView().getSettings().isGenerateTypeSubstTriggers()) {
                        this.appendSubstitutionTrigger(stringBuffer, this.table, this.tableProxy, bl);
                        this.appendColumnSubstitutionTrigger(stringBuffer, this.table, this.tableProxy, bl);
                    }
                }
                this.appendAfterCreateScript(stringBuffer, bl, this.table);
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
            }
        } else {
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "-- Table " + this.table.getName() + ": is part of type substitution hierarchy");
        }
        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
    }

    private void appendSubstitutionTrigger(StringBuffer stringBuffer, Table table, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        if (table.isBST() && table.getSubTypeSubstitutions().size() > 0) {
            Object object;
            String string = "";
            Iterator iterator = table.getAllowedStrTypeInstances().iterator();
            boolean bl2 = true;
            while (iterator.hasNext()) {
                object = (StructuredType)iterator.next();
                StructuredTypeProxyOracle structuredTypeProxyOracle = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy((DesignObject)object);
                if (structuredTypeProxyOracle == null || !structuredTypeProxyOracle.getStructuredType().isInstantiable()) continue;
                String string2 = this.storageDesign.getFormatedName(structuredTypeProxyOracle.getLongName());
                if (bl2) {
                    string = ((StructuredType)object).getAllSubTypes().size() > 0 ? "ONLY " + string2 : string2;
                    bl2 = false;
                    continue;
                }
                string = string + ", " + (((StructuredType)object).getAllSubTypes().size() > 0 ? "ONLY " + string2 : string2);
            }
            if (!"".equals(string)) {
                object = this.storageDesign.getFormatedName("OBJ_SUBS_TR_" + this.getStringWithMaxLength(tableProxyOraclev10g.getName(), 18));
                if (tableProxyOraclev10g.getUser() != null) {
                    object = this.storageDesign.getFormatedName(tableProxyOraclev10g.getUser().getName()) + '.' + (String)object;
                }
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "CREATE OR REPLACE TRIGGER " + (String)object);
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BEFORE INSERT ON " + this.storageDesign.getFormatedName(tableProxyOraclev10g.getLongName()));
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "FOR EACH ROW");
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BEGIN");
                this.appendCWDTableMeta(stringBuffer, table, tableProxyOraclev10g, bl);
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, " IF :new.object_value IS NOT OF ( " + string + " ) THEN");
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "  raise_application_error(-20222,' Only instances of " + string.replaceAll("ONLY ", "") + " are permited');");
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, " END IF;");
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "END;");
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "/");
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
            }
        }
    }

    private void appendCWDTableMeta(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle, boolean bl) {
        List list = table.getAllSubstitutionTables();
        if (list.size() > 0) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "-- DO NOT DELETE OR MODIFY THE FOLLOWING COMMENTS");
        }
        for (int i = 0; i < list.size(); ++i) {
            Table table2 = (Table)list.get(i);
            StructuredType structuredType = table2.getBasedOnStructuredType();
            StructuredTypeProxy structuredTypeProxy = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(structuredType);
            String string = structuredType.getName();
            if (structuredTypeProxy != null) {
                string = structuredTypeProxy.getLongName();
            }
            structuredType = table2.getBasedOnStructuredType().getParentType();
            structuredTypeProxy = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(structuredType);
            String string2 = structuredType.getName();
            if (structuredTypeProxy != null) {
                string2 = structuredTypeProxy.getLongName();
            }
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "-- <cwd_ts_tab table=\"" + table2.getName() + "\" type=\"" + string + "\" parent_type=\"" + string2 + "\" />");
        }
    }

    private void appendColumnSubstitutionTrigger(StringBuffer stringBuffer, Table table, TableProxy tableProxy, boolean bl) {
        List list = this.getColumnsWithManyRestrictedSubType(table);
        if (list.size() > 0) {
            Object object;
            ModelIDObject modelIDObject;
            boolean bl2 = false;
            boolean bl3 = true;
            String string = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                Column column = (Column)list.get(i);
                modelIDObject = tableProxy.getColumnProxy(column.getObjectID());
                object = this.storageDesign.getFormatedName(modelIDObject == null ? column.getName() : ((RelationalObjectProxy)modelIDObject).getName());
                arrayList.add((String)object);
                if (bl3) {
                    string = object;
                    bl3 = false;
                } else {
                    string = string + ", " + (String)object;
                }
                if (!column.isReference()) continue;
                bl2 = true;
            }
            if (!"".equals(string)) {
                Object object2;
                Object object3;
                Object object4;
                String string2 = this.storageDesign.getFormatedName(COLUMN_SUBST_TR_PREFIX + this.getStringWithMaxLength(tableProxy.getName(), 30 - COLUMN_SUBST_TR_PREFIX.length()));
                if (tableProxy.getUserSchema() != null) {
                    string2 = this.storageDesign.getFormatedName(tableProxy.getUserSchema().getName()) + '.' + this.storageDesign.getFormatedName(string2);
                }
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "CREATE OR REPLACE TRIGGER " + string2);
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BEFORE INSERT OR UPDATE OF " + string + " ON " + this.storageDesign.getFormatedName(tableProxy.getLongName()));
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "FOR EACH ROW");
                if (bl2) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DECLARE ");
                    for (int i = 0; i < list.size(); ++i) {
                        modelIDObject = (Column)list.get(i);
                        if (!((ContainedObjectWithDomain)modelIDObject).isReference()) continue;
                        object = (StructuredType)((Column)modelIDObject).getDataType();
                        object4 = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy((DesignObject)object);
                        object3 = this.storageDesign.getFormatedName(object4 != null ? ((StructuredTypeProxyOracle)object4).getLongName() : ((DesignObject)object).getName());
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                        object2 = this.storageDesign.getFormatedName((String)arrayList.get(i) + "$inst");
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, " " + (String)object2);
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, (String)object3 + ";");
                    }
                }
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BEGIN");
                this.appendCWDColumnMeta(stringBuffer, list, bl);
                for (int i = 0; i < list.size(); ++i) {
                    modelIDObject = (Column)list.get(i);
                    object = (String)arrayList.get(i);
                    object4 = "";
                    object3 = ((ContainedObjectWithDomain)modelIDObject).getPermittedSubTypes().iterator();
                    bl3 = true;
                    while (object3.hasNext()) {
                        object2 = (StructuredType)object3.next();
                        StructuredTypeProxyOracle structuredTypeProxyOracle = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy((DesignObject)object2);
                        if (structuredTypeProxyOracle == null || !structuredTypeProxyOracle.getStructuredType().isInstantiable()) continue;
                        String string3 = this.storageDesign.getFormatedName(structuredTypeProxyOracle.getLongName());
                        if (bl3) {
                            object4 = ((StructuredType)object2).getAllSubTypes().size() > 0 ? "ONLY " + string3 : string3;
                            bl3 = false;
                            continue;
                        }
                        object4 = (String)object4 + ", " + (((StructuredType)object2).getAllSubTypes().size() > 0 ? "ONLY " + string3 : string3);
                    }
                    if (((ContainedObjectWithDomain)modelIDObject).isReference()) {
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, " SELECT deref(:new." + (String)object + ") INTO " + (String)object + "$inst FROM DUAL;");
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, " IF " + (String)object + "$inst IS NOT OF ( " + (String)object4 + " ) THEN");
                    } else {
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, " IF :new." + (String)object + " IS NOT OF ( " + (String)object4 + " ) THEN");
                    }
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "  raise_application_error(-20222,'Column " + (String)object + " - Only instances of " + ((String)object4).replaceAll("ONLY ", "") + " are permited');");
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, " END IF;");
                }
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "END;");
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "/");
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
            }
        }
    }

    private void appendCWDColumnMeta(StringBuffer stringBuffer, List list, boolean bl) {
        if (list.size() > 0) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "-- DO NOT DELETE OR MODIFY THE FOLLOWING COMMENTS");
        }
        for (int i = 0; i < list.size(); ++i) {
            Column column = (Column)list.get(i);
            for (StructuredType structuredType : column.getPermittedSubTypes()) {
                StructuredTypeProxy structuredTypeProxy = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(structuredType);
                String string = structuredType.getName();
                if (structuredTypeProxy != null) {
                    string = structuredTypeProxy.getLongName();
                }
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "-- <cwd_ts_column column=\"" + column.getName() + "\" type=\"" + string + "\" />");
            }
        }
    }

    private void appendColumnProperties(StringBuffer stringBuffer, Table table, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            ColumnProxyOraclev10g columnProxyOraclev10g = (ColumnProxyOraclev10g)tableProxyOraclev10g.getColumnProxy(column.getObjectID());
            Datatype datatype = columnProxyOraclev10g.getDataType();
            if (datatype.toString().equals("XMLTYPE")) {
                this.appendXMLTypeColumnProps(stringBuffer, columnProxyOraclev10g, bl);
                continue;
            }
            if (datatype instanceof CollectionType) {
                CollectionType collectionType = (CollectionType)datatype;
                if (collectionType.isArrayType()) {
                    this.appendVarrayColumnProp(stringBuffer, columnProxyOraclev10g, bl);
                    continue;
                }
                this.appendNestedTableColumnProp(stringBuffer, columnProxyOraclev10g, bl);
                continue;
            }
            if (!(datatype instanceof StructuredType)) continue;
            this.appendSubstitutableColumnClause(stringBuffer, columnProxyOraclev10g, bl, true);
        }
    }

    private void appendXMLTypeColumnProps(StringBuffer stringBuffer, ColumnProxyOraclev10g columnProxyOraclev10g, boolean bl) {
        boolean bl2 = false;
        String string = "";
        String string2 = "";
        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "XMLTYPE");
        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "COLUMN");
        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev10g.getName()));
        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORE AS");
        if (columnProxyOraclev10g.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "OBJECT RELATIONAL");
        } else {
            if (columnProxyOraclev10g instanceof ColumnProxyOraclev11g) {
                if (((ColumnProxyOraclev11g)columnProxyOraclev10g).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SECUREFILE");
                } else if (((ColumnProxyOraclev11g)columnProxyOraclev10g).getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BASICFILE");
                }
                string = ((ColumnProxyOraclev11g)columnProxyOraclev10g).getAllowAnySchema();
                string2 = ((ColumnProxyOraclev11g)columnProxyOraclev10g).getAllowNonSchema();
                bl2 = columnProxyOraclev10g.getStoreAs().equalsIgnoreCase("BINARY XML");
            }
            if (bl2) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BINARY XML");
            } else {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "CLOB");
            }
            String string3 = columnProxyOraclev10g.getLobSegmentName();
            if (string3 != null && string3.length() > 0) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string3));
            }
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            if (columnProxyOraclev10g.getTablespace() != null) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev10g.getTablespace().getName()));
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            }
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORAGE");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
            if (columnProxyOraclev10g.getSCInitialExtent() > 0L) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getSCInitialExtent());
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
            }
            if (columnProxyOraclev10g.getSCNextExtent() > 0L) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getSCNextExtent());
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
            }
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getSCPctIncrease());
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getSCMinExtents());
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getSCMaxExtents());
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getSCFreeLists());
            if (columnProxyOraclev10g.getSCFreelistGroups() > 1) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "FREELIST");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "GROUPS");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getSCFreelistGroups());
            }
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getSCBufferPool());
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            if (columnProxyOraclev10g.getChunk() > 0) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "CHUNK");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getChunk());
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            }
            if (columnProxyOraclev10g.getOldVersions().equalsIgnoreCase("RETENTION")) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "RETENTION");
            } else {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PCTVERSION");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getPCTVersion());
            }
            if (columnProxyOraclev10g.getSCFreelistGroups() <= 1 && columnProxyOraclev10g.getFreepools() > 0) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "FREEPOOLS");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getFreepools());
            }
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            if ("ENABLE".equalsIgnoreCase(columnProxyOraclev10g.getStorageInRow())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ENABLE");
            } else {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DISABLE");
            }
            stringBuffer.append("STORAGE IN ROW");
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getCache());
            if ("FILESYSTEM_LIKE_LOGGING".equalsIgnoreCase(columnProxyOraclev10g.getLogging()) && ((ColumnProxyOraclev11g)columnProxyOraclev10g).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "FILESYSTEM_LIKE_LOGGING");
            } else if (!"CACHE".equalsIgnoreCase(columnProxyOraclev10g.getCache())) {
                if ("YES".equalsIgnoreCase(columnProxyOraclev10g.getLogging())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(columnProxyOraclev10g.getLogging())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                }
            }
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
        this.appendXMLSchemaSpec(stringBuffer, columnProxyOraclev10g.getXmlSchemaUrl(), columnProxyOraclev10g.getXmlSchemaElement(), bl2, string, string2, bl);
    }

    private void appendXMLSchemaSpec(StringBuffer stringBuffer, String string, String string2, boolean bl, String string3, String string4, boolean bl2) {
        if (string2 != null && string2.length() > 0) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            if (string != null && string.length() > 0) {
                stringBuffer.append("XMLSCHEMA").append(' ').append('\"').append(string).append('\"');
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            }
            stringBuffer.append("ELEMENT").append(' ').append('\"').append(string2).append('\"').append(' ');
        }
        if (bl) {
            if (string3.equals("YES")) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ALLOW");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ANYSCHEMA");
            }
            if (string4.equals("YES")) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ALLOW");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NONSCHEMA");
            } else if (string4.equals("NO")) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DISALLOW");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NONSCHEMA");
            }
        }
    }

    private void appendVarrayColumnProp(StringBuffer stringBuffer, ColumnProxyOraclev10g columnProxyOraclev10g, boolean bl) {
        if (this.hasVarrayClause(columnProxyOraclev10g)) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "VARRAY");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev10g.getName()));
            this.appendSubstitutableColumnClause(stringBuffer, columnProxyOraclev10g, bl, false);
            if (!columnProxyOraclev10g.getLobSegname().equals("")) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORE AS");
                if (columnProxyOraclev10g instanceof ColumnProxyOraclev11g) {
                    if (((ColumnProxyOraclev11g)columnProxyOraclev10g).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SECUREFILE");
                    } else if (((ColumnProxyOraclev11g)columnProxyOraclev10g).getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BASICFILE");
                    }
                }
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOB");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev10g.getLobSegname()));
            }
        }
    }

    private void appendOid(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle, boolean bl) {
        if (table.isRoot()) {
            if (table.isOidIsPK() && table.getOidPKColumns().size() > 0) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "OBJECT");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "IDENTIFIER");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "IS");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
            }
            if (!(tableProxyOracle == null || tableProxyOracle.getOidIndexSegment() == null && "".equalsIgnoreCase(tableProxyOracle.getOidIndexName()))) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "OIDINDEX");
                if (!"".equalsIgnoreCase(tableProxyOracle.getOidIndexName())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOracle.getOidIndexName()));
                }
                if (tableProxyOracle.getOidIndexSegment() != null) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    this.appendSegment(stringBuffer, (SegmentOraclev10g)tableProxyOracle.getOidIndexSegment(), false, bl, null, "");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
            }
        }
    }

    private void appendObjectTypeColProperties(StringBuffer stringBuffer, Table table, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        if (table.isBST() && tableProxyOraclev10g != null) {
            ModelIDObject modelIDObject;
            int n;
            Column[] columnArray = (Column[])table.getElements();
            boolean bl2 = false;
            if (table.getOidPKColumns().size() > 0 || tableProxyOraclev10g.getTableCheckConstraints().size() > 0) {
                bl2 = true;
            }
            if (!bl2) {
                Column column;
                for (n = 0; n < columnArray.length && !(bl2 = this.shouldGenerateObjectPropDefinition(column = columnArray[n], (ColumnProxyOraclev10g)(modelIDObject = (ColumnProxyOraclev10g)tableProxyOraclev10g.getColumnProxy(column.getObjectID())))); ++n) {
                }
            }
            if (bl2) {
                n = 1;
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                for (int i = 0; i < columnArray.length; ++i) {
                    modelIDObject = columnArray[i];
                    ColumnProxyOraclev10g columnProxyOraclev10g = (ColumnProxyOraclev10g)tableProxyOraclev10g.getColumnProxy(modelIDObject.getObjectID());
                    if (!this.shouldGenerateObjectPropDefinition((Column)modelIDObject, columnProxyOraclev10g)) continue;
                    if (n == 0) {
                        this.appendComma(stringBuffer);
                    } else {
                        n = 0;
                    }
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev10g.getName()));
                    this.appendColumnOptions(stringBuffer, tableProxyOraclev10g, (Column)modelIDObject, columnProxyOraclev10g, bl);
                    this.appendColumnRefConstraint(stringBuffer, (Column)modelIDObject, columnProxyOraclev10g, bl);
                    this.appendColumnConstraints(stringBuffer, (Column)modelIDObject, columnProxyOraclev10g, bl);
                }
                n = this.appendTableConstraintsDefinition(stringBuffer, tableProxyOraclev10g, bl, n != 0) ? 1 : 0;
                if (table.getOidPKColumns().size() > 0) {
                    if (n == 0) {
                        this.appendComma(stringBuffer);
                    } else {
                        n = 0;
                    }
                    this.appendPK_ObjectType(stringBuffer, table, tableProxyOraclev10g, bl);
                }
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private boolean shouldGenerateObjectPropDefinition(Column column, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (column.isOid()) {
            return false;
        }
        if (!column.getNullsAllowed()) {
            return true;
        }
        String string = columnProxyOraclev10g.getDefaultValue();
        if (string != null && !"".equalsIgnoreCase(string)) {
            return true;
        }
        if (column.isReference() && "YES".equalsIgnoreCase(columnProxyOraclev10g.getWithRowId())) {
            return true;
        }
        return SSBTableOraclev10g.willGenerateInlineColumnConstrOra(column, columnProxyOraclev10g);
    }

    private void appendPK_ObjectType(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle, boolean bl) {
        String string = this.storageDesign.getFormatedName(tableProxyOracle.getPKName());
        if (!"".equals(string)) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, string);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            boolean bl2 = true;
            for (Column column : table.getOidPKColumns()) {
                ColumnProxyOraclev10g columnProxyOraclev10g = (ColumnProxyOraclev10g)tableProxyOracle.getColumnProxy(column.getObjectID());
                String string2 = this.storageDesign.getFormatedName(columnProxyOraclev10g.getName());
                if (bl2) {
                    bl2 = false;
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ',');
                }
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, string2);
            }
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendElementList(StringBuffer stringBuffer, Table table, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        Column[] columnArray = (Column[])table.getElements();
        Column column = null;
        RelationalObjectProxy relationalObjectProxy = null;
        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
        if (table.getBasedOnStructuredType() != null) {
            StructuredTypeProxyOracle structuredTypeProxyOracle;
            StructuredType structuredType = table.getBasedOnStructuredType();
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "OF");
            String string = structuredType.getName();
            if (tableProxyOraclev10g != null && (structuredTypeProxyOracle = (StructuredTypeProxyOracle)tableProxyOraclev10g.getStorageDesign().getProxy(structuredType)) != null) {
                if (structuredTypeProxyOracle.getOwner() != null) {
                    SSBTableOraclev10g.appendString(stringBuffer, this.storageDesign.getFormatedName(structuredTypeProxyOracle.getOwner().getName()));
                    SSBTableOraclev10g.appendString(stringBuffer, '.');
                }
                string = structuredTypeProxyOracle.getName();
            }
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
            if (string.equalsIgnoreCase("XMLTYPE")) {
                this.appendObjectTypeColProperties(stringBuffer, table, tableProxyOraclev10g, bl);
                if (tableProxyOraclev10g != null) {
                    boolean bl2 = false;
                    String string2 = "";
                    String string3 = "";
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "XMLTYPE");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORE AS");
                    if (tableProxyOraclev10g.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "OBJECT RELATIONAL");
                    } else {
                        if (tableProxyOraclev10g instanceof TableProxyOraclev11g) {
                            if (((TableProxyOraclev11g)tableProxyOraclev10g).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SECUREFILE");
                            } else if (((TableProxyOraclev11g)tableProxyOraclev10g).getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BASICFILE");
                            }
                            string2 = ((TableProxyOraclev11g)tableProxyOraclev10g).getAllowAnySchema();
                            string3 = ((TableProxyOraclev11g)tableProxyOraclev10g).getAllowNonSchema();
                            bl2 = tableProxyOraclev10g.getStoreAs().equalsIgnoreCase("BINARY XML");
                        }
                        if (bl2) {
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BINARY XML");
                        } else {
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "CLOB");
                        }
                        String string4 = tableProxyOraclev10g.getLobSegmentName();
                        if (string4 != null && string4.length() > 0) {
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string4));
                        }
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
                        if (tableProxyOraclev10g.getXmlTypeTableSpace() != null) {
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOraclev10g.getXmlTypeTableSpace().getName()));
                            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
                        }
                        if (tableProxyOraclev10g.getChunk() > 0) {
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "CHUNK");
                            this.appendStringWithSpace(stringBuffer, tableProxyOraclev10g.getChunk());
                            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
                        }
                        if (tableProxyOraclev10g.getOldVersions().equalsIgnoreCase("RETENTION")) {
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "RETENTION");
                        } else {
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PCTVERSION");
                            this.appendStringWithSpace(stringBuffer, tableProxyOraclev10g.getPCTVersion());
                        }
                        if (tableProxyOraclev10g.getFreepools() > 0) {
                            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "FREEPOOLS");
                            this.appendStringWithSpace(stringBuffer, tableProxyOraclev10g.getFreepools());
                        }
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
                        if ("ENABLE".equalsIgnoreCase(tableProxyOraclev10g.getStorageInRow())) {
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ENABLE");
                        } else {
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DISABLE");
                        }
                        stringBuffer.append("STORAGE IN ROW");
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, tableProxyOraclev10g.getXmlTypeCache());
                        if ("FILESYSTEM_LIKE_LOGGING".equalsIgnoreCase(tableProxyOraclev10g.getXmlTypeLogging()) && ((TableProxyOraclev11g)tableProxyOraclev10g).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "FILESYSTEM_LIKE_LOGGING");
                        } else if (!"CACHE".equalsIgnoreCase(tableProxyOraclev10g.getXmlTypeCache())) {
                            if ("YES".equalsIgnoreCase(tableProxyOraclev10g.getXmlTypeLogging())) {
                                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                            } else if ("NO".equalsIgnoreCase(tableProxyOraclev10g.getXmlTypeLogging())) {
                                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                            }
                        }
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                    }
                    this.appendXMLSchemaSpec(stringBuffer, tableProxyOraclev10g.getXmlSchemaUrl(), tableProxyOraclev10g.getXmlSchemaElement(), bl2, string2, string3, bl);
                }
            } else {
                if (!table.isSubstitutable()) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOT");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SUBSTITUTABLE");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "AT");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ALL");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LEVELS");
                }
                this.appendObjectTypeColProperties(stringBuffer, table, tableProxyOraclev10g, bl);
            }
        } else if (columnArray.length < 1) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "-- No Columns");
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
        } else {
            boolean bl3 = true;
            for (int i = 0; i < columnArray.length; ++i) {
                RelationalObjectProxy relationalObjectProxy2;
                column = columnArray[i];
                if (column.isOid()) continue;
                if (bl3) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    bl3 = false;
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ',');
                }
                if (tableProxyOraclev10g != null) {
                    relationalObjectProxy = (ColumnProxyOraclev10g)tableProxyOraclev10g.getColumnProxy(column.getObjectID());
                }
                if (relationalObjectProxy.getName().length() > ((ColumnProxyOracle)relationalObjectProxy).getMaxNameLength()) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "--  ERROR: Column name length exceeds maximum allowed length(" + ((ColumnProxyOracle)relationalObjectProxy).getMaxNameLength() + ")");
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementErrors();
                }
                if (relationalObjectProxy.isCommentChanged() && !"".equalsIgnoreCase(relationalObjectProxy.getComment())) {
                    this.appendComment(stringBuffer, relationalObjectProxy);
                } else if (!"".equalsIgnoreCase(relationalObjectProxy.getObject().getComment())) {
                    this.appendComment(stringBuffer, relationalObjectProxy.getObject());
                }
                if (this.endsWithNewline(stringBuffer)) {
                    this.appendTab(stringBuffer, bl, 1);
                } else {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                }
                SSBTableOraclev10g.appendString(stringBuffer, ' ');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(relationalObjectProxy.getName()));
                String string = "";
                Datatype datatype = column.getDataType();
                if ((datatype instanceof StructuredType || datatype instanceof CollectionType) && (relationalObjectProxy2 = this.storageDesign.getProxy(datatype)) != null) {
                    string = this.storageDesign.getFormatedName(relationalObjectProxy2.getLongName());
                    if (column.isReference() && datatype instanceof StructuredType) {
                        string = "REF " + string;
                    }
                }
                if (string.equals("")) {
                    string = column.getDatatypeString(this.storageDesign.getRDBMSType().getName());
                }
                this.appendDatatype(stringBuffer, string, (ColumnProxyOraclev10g)relationalObjectProxy, bl);
                if (tableProxyOraclev10g == null) continue;
                this.appendColumnOptions(stringBuffer, tableProxyOraclev10g, column, (ColumnProxyOraclev10g)relationalObjectProxy, bl);
                this.appendColumnRefConstraint(stringBuffer, column, (ColumnProxyOraclev10g)relationalObjectProxy, bl);
                this.appendColumnConstraints(stringBuffer, column, (ColumnProxyOracle)relationalObjectProxy, bl);
            }
            if ("INDEX".equalsIgnoreCase(tableProxyOraclev10g.getOrganization())) {
                this.appendPKDefinitionConstraint(stringBuffer, tableProxyOraclev10g, bl);
            }
            this.appendTableConstraintsDefinition(stringBuffer, tableProxyOraclev10g, bl, false);
            this.appendRefPartitionFK(stringBuffer, tableProxyOraclev10g, bl);
            this.appendSupplementalLoggings(stringBuffer, tableProxyOraclev10g, bl);
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendRefPartitionFK(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
    }

    protected void appendDatatype(StringBuffer stringBuffer, String string, ColumnProxyOraclev10g columnProxyOraclev10g, boolean bl) {
        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, string);
        if (string.equalsIgnoreCase("unknown")) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "--  ERROR: Datatype UNKNOWN is not allowed");
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 5);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendColumnRefConstraint(StringBuffer stringBuffer, Column column, ColumnProxyOraclev10g columnProxyOraclev10g, boolean bl) {
        this.appendWithRowid(stringBuffer, column, columnProxyOraclev10g, bl);
    }

    private void appendWithRowid(StringBuffer stringBuffer, Column column, ColumnProxyOraclev10g columnProxyOraclev10g, boolean bl) {
        if (column.isReference() && "YES".equalsIgnoreCase(columnProxyOraclev10g.getWithRowId())) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "WITH");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ROWID");
        }
    }

    protected void appendColumnOptions(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, Column column, ColumnProxyOraclev10g columnProxyOraclev10g, boolean bl) {
        this.appendWithDefaultDefinition(stringBuffer, columnProxyOraclev10g);
        if (!column.getNullsAllowed()) {
            this.appendNotNullDefinition(stringBuffer, columnProxyOraclev10g, bl);
        }
    }

    protected void appendWithDefaultDefinition(StringBuffer stringBuffer, ColumnProxyOracle columnProxyOracle) {
        boolean bl = columnProxyOracle.getStorageDesign().isOpen();
        String string = "";
        Column column = columnProxyOracle.getColumn();
        string = !bl ? column.getDefaultValue() : columnProxyOracle.getDefaultValue();
        if (string != null && !"".equalsIgnoreCase(string)) {
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DEFAULT");
            String string2 = column.getDatatypeString(this.storageDesign.getRDBMSType().getName());
            String string3 = this.addQuotesToDefault(string2, string);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, string3);
        }
    }

    private void appendColumnConstraints(StringBuffer stringBuffer, Column column, ColumnProxyOracle columnProxyOracle, boolean bl) {
        if (SSBTableOraclev10g.willGenerateInlineColumnConstrOra(column, columnProxyOracle)) {
            String string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxyOracle.getName()));
            String string2 = column.getConstraintName();
            if (!string2.equals("") && !string2.toUpperCase().startsWith("SYS_") && string2.length() <= 30) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
            }
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendString(stringBuffer, string);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            SSBTableOraclev10g.appendConstraintState(stringBuffer, columnProxyOracle, true, bl);
        }
    }

    public static void appendConstraintState(StringBuffer stringBuffer, ColumnProxyOracle columnProxyOracle, boolean bl, boolean bl2) {
        if (!"NO".equalsIgnoreCase(columnProxyOracle.getDeferrable())) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(columnProxyOracle.getInitially())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "INITIALLY");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DEFERRED");
            }
        }
        if ("NO".equalsIgnoreCase(columnProxyOracle.getEnable())) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DISABLE");
            if ("YES".equalsIgnoreCase(columnProxyOracle.getValidate())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "VALIDATE");
            }
        }
        if ("NO".equalsIgnoreCase(columnProxyOracle.getValidate())) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOVALIDATE");
        }
        if (columnProxyOracle.getExceptionsTable() != null && !bl) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "EXCEPTIONS");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "INTO");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, columnProxyOracle.getStorageDesign().getFormatedName(columnProxyOracle.getExceptionsTable().getName()));
        }
    }

    private PKProxyOraclev10g getPKProxy(TableProxyOracle tableProxyOracle) {
        PKProxySetOraclev10g pKProxySetOraclev10g = (PKProxySetOraclev10g)((StorageDesignOraclev10g)tableProxyOracle.getStorageDesign()).getPKProxySet();
        if (pKProxySetOraclev10g != null) {
            Iterator iterator = pKProxySetOraclev10g.iterator();
            while (iterator.hasNext()) {
                PKProxyOraclev10g pKProxyOraclev10g = (PKProxyOraclev10g)iterator.next();
                if (pKProxyOraclev10g.getTable() == null || pKProxyOraclev10g.getTable() != tableProxyOracle.getObject()) continue;
                return pKProxyOraclev10g;
            }
        }
        return null;
    }

    private void appendPKDefinition(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        if (tableProxyOracle != null) {
            this.pk = this.getPKProxy(tableProxyOracle);
            if (this.pk != null && this.pk.isMarkedGenerate()) {
                Index index = (Index)this.pk.getObject();
                if (!"".equalsIgnoreCase(this.pk.getColumns()) || !"".equals(index.getIndexExpression())) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                    if (this.pk.isCommentChanged() && !"".equalsIgnoreCase(this.pk.getComment())) {
                        this.appendComment(stringBuffer, this.pk);
                    } else if (!"".equalsIgnoreCase(this.pk.getObject().getComment())) {
                        this.appendComment(stringBuffer, this.pk.getObject());
                    }
                    String string2 = this.pk.getName();
                    if (string2.length() > tableProxyOracle.getMaxNameLength()) {
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "--  ERROR: PK name length exceeds maximum allowed length(" + tableProxyOracle.getMaxNameLength() + ")");
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(tableProxyOracle.getLongName()));
                    SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "ADD");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string2));
                    string = stringBuffer2.toString();
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "PRIMARY KEY");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, '(');
                    if (!"".equals(index.getIndexExpression())) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, index.getIndexExpression());
                    } else {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, this.pk.getColumns(this.storageDesign));
                    }
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, ')');
                    if (!"NO".equalsIgnoreCase(this.pk.getDeferrable())) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "DEFERRABLE");
                        if ("DEFERRED".equalsIgnoreCase(this.pk.getInitially())) {
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "INITIALLY");
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "DEFERRED");
                        }
                    }
                    if (!"YES".equalsIgnoreCase(this.pk.getEnable())) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "DISABLE");
                        if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "VALIDATE");
                        }
                    }
                    if (!"YES".equalsIgnoreCase(this.pk.getValidate())) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "NOVALIDATE");
                    }
                    if (!"NO".equalsIgnoreCase(this.pk.getUsingIndex())) {
                        this.appendUsingIndex(stringBuffer2, this.pk, bl);
                    }
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    this.appendLineFinisher(stringBuffer2, bl);
                    SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    DDLFileMaker.incrementAlterTable();
                }
            }
        }
    }

    private void appendPKDefinitionConstraint(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl) {
        if (tableProxyOracle != null) {
            this.pk = this.getPKProxy(tableProxyOracle);
            if (this.pk != null) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ',');
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendString(stringBuffer, ' ');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(this.pk.getName()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.pk.getColumns(this.storageDesign));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                if (!"YES".equalsIgnoreCase(this.pk.getEnable())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(this.pk.getValidate())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOVALIDATE");
                }
                if (!"NO".equalsIgnoreCase(this.pk.getUsingIndex())) {
                    this.appendUsingIndex(stringBuffer, this.pk, bl);
                }
            }
        }
    }

    private void appendSupplementalLoggings(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        if (!"".equalsIgnoreCase(tableProxyOraclev10g.getSuplementalLogGroupName())) {
            this.appendComma(stringBuffer);
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SUPPLEMENTAL");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOG");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "GROUP");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOraclev10g.getSuplementalLogGroupName()));
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(tableProxyOraclev10g.getAllSuplementalLogColumns()));
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            if (tableProxyOraclev10g.getSuplementalLogConditions().equalsIgnoreCase("ALWAYS")) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ALWAYS");
            }
        }
    }

    private boolean appendTableConstraintsDefinition(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, boolean bl, boolean bl2) {
        Iterator iterator = tableProxyOraclev10g.getTableCheckConstraints().iterator();
        while (iterator.hasNext()) {
            TableCheckConstraintOracle tableCheckConstraintOracle = (TableCheckConstraintOracle)iterator.next();
            String string = tableCheckConstraintOracle.getTableConstraint().getRule();
            String string2 = tableCheckConstraintOracle.getName();
            if (string2.toUpperCase().startsWith("SYS_")) {
                string2 = "";
            }
            if (!"".equals(string2) || "".equals(string)) continue;
            if (bl2) {
                bl2 = false;
            } else {
                this.appendComma(stringBuffer);
            }
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableOraclev10g.appendString(stringBuffer, '(');
            SSBTableOraclev10g.appendString(stringBuffer, string);
            SSBTableOraclev10g.appendString(stringBuffer, ')');
            this.appendTableConstraintState(stringBuffer, tableCheckConstraintOracle, bl);
        }
        return bl2;
    }

    private void appendTableConstraintState(StringBuffer stringBuffer, TableCheckConstraintOracle tableCheckConstraintOracle, boolean bl) {
        if (!"NO".equalsIgnoreCase(tableCheckConstraintOracle.getDeferrable())) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(tableCheckConstraintOracle.getInitially())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "INITIALLY");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DEFERRED");
            }
        }
        if ("NO".equalsIgnoreCase(tableCheckConstraintOracle.getEnable())) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DISABLE");
            if ("YES".equalsIgnoreCase(tableCheckConstraintOracle.getValidate())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "VALIDATE");
            }
        }
        if ("NO".equalsIgnoreCase(tableCheckConstraintOracle.getValidate())) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOVALIDATE");
        }
        if (tableCheckConstraintOracle.getExceptionsTable() != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "EXCEPTIONS");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "INTO");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableCheckConstraintOracle.getExceptionsTable().getName()));
        }
    }

    private void appendUsingIndex(StringBuffer stringBuffer, PKProxyOraclev10g pKProxyOraclev10g, boolean bl) {
        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "USING INDEX");
        if ("BY INDEX NAME".equalsIgnoreCase(pKProxyOraclev10g.getUsingIndex()) && pKProxyOraclev10g.getExistingIndex() != null) {
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(pKProxyOraclev10g.getExistingIndex().getUserNameAndName()));
        } else {
            if ("LOCAL".equalsIgnoreCase(pKProxyOraclev10g.getUsingIndex())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOCAL");
                this.getSSBIndex().appendPartitionList(stringBuffer, pKProxyOraclev10g, this.tableProxy, bl);
            } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(pKProxyOraclev10g.getUsingIndex())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, pKProxyOraclev10g.getCreateIndexStatement());
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            } else if (pKProxyOraclev10g.getUsingIndex().equalsIgnoreCase("GLOBAL BY RANGE")) {
                this.appendGlobalIndex(stringBuffer, pKProxyOraclev10g, bl);
            } else if (pKProxyOraclev10g.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY QUANTITY")) {
                this.appendGlobalIndexByHashQuantity(stringBuffer, pKProxyOraclev10g, bl);
            } else if (pKProxyOraclev10g.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY LIST")) {
                this.appendGlobalIndexByHashList(stringBuffer, pKProxyOraclev10g, bl);
            }
            if (pKProxyOraclev10g.getIndexSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev10g)pKProxyOraclev10g.getIndexSegment(), false, bl, pKProxyOraclev10g.getTableSpace(), pKProxyOraclev10g.getLogging());
            } else {
                if (pKProxyOraclev10g.getTableSpace() != null) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(pKProxyOraclev10g.getTableSpace().getName()));
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                }
                if (this.storageDesign.isOpen()) {
                    if ("YES".equalsIgnoreCase(pKProxyOraclev10g.getLogging())) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    } else if ("NO".equalsIgnoreCase(pKProxyOraclev10g.getLogging())) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    }
                }
            }
            if (this.storageDesign.isOpen()) {
                if (pKProxyOraclev10g.getIndexSort().equalsIgnoreCase("NO")) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOSORT");
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                } else if (pKProxyOraclev10g.getIndexSort().equalsIgnoreCase("REVERSE")) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "REVERSE");
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                }
                if (pKProxyOraclev10g.getComputeStatistics().equalsIgnoreCase("YES")) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
                }
            }
        }
    }

    private void appendUniqueUsingIndex(StringBuffer stringBuffer, UniqueOraclev10g uniqueOraclev10g, boolean bl) {
        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "USING INDEX");
        if ("BY INDEX NAME".equalsIgnoreCase(uniqueOraclev10g.getUsingIndex()) && uniqueOraclev10g.getExistingIndex() != null) {
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(uniqueOraclev10g.getExistingIndex().getUserNameAndName()));
        } else {
            if ("LOCAL".equalsIgnoreCase(uniqueOraclev10g.getUsingIndex())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOCAL");
                this.getSSBIndex().appendPartitionList(stringBuffer, uniqueOraclev10g, this.tableProxy, bl);
            } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(uniqueOraclev10g.getUsingIndex())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, uniqueOraclev10g.getCreateIndexStatement());
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            } else if (uniqueOraclev10g.getUsingIndex().equalsIgnoreCase("GLOBAL BY RANGE")) {
                this.appendGlobalIndex(stringBuffer, uniqueOraclev10g, bl);
            } else if (uniqueOraclev10g.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY QUANTITY")) {
                this.appendGlobalIndexByHashQuantity(stringBuffer, uniqueOraclev10g, bl);
            } else if (uniqueOraclev10g.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY LIST")) {
                this.appendGlobalIndexByHashList(stringBuffer, uniqueOraclev10g, bl);
            }
            if (uniqueOraclev10g.getIndexSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev10g)uniqueOraclev10g.getIndexSegment(), false, bl, uniqueOraclev10g.getTableSpace(), uniqueOraclev10g.getLogging());
            } else {
                if (uniqueOraclev10g.getTableSpace() != null) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(uniqueOraclev10g.getTableSpace().getName()));
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                }
                if (this.storageDesign.isOpen()) {
                    if ("YES".equalsIgnoreCase(uniqueOraclev10g.getLogging())) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    } else if ("NO".equalsIgnoreCase(uniqueOraclev10g.getLogging())) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    }
                }
            }
            if (this.storageDesign.isOpen()) {
                if (uniqueOraclev10g.getIndexSort().equalsIgnoreCase("NO")) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOSORT");
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                } else if (uniqueOraclev10g.getIndexSort().equalsIgnoreCase("REVERSE")) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "REVERSE");
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                }
                if (uniqueOraclev10g.getComputeStatistics().equalsIgnoreCase("YES")) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
                }
            }
        }
    }

    private void appendGlobalIndex(StringBuffer stringBuffer, PKProxyOraclev10g pKProxyOraclev10g, boolean bl) {
        if (pKProxyOraclev10g.getIndexGlobalPL() != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "GLOBAL");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "RANGE");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(pKProxyOraclev10g.getIndexGlobalPL().getAllGlobalPartColumns()));
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            this.appendGlobalPartitions(stringBuffer, (IndexGlobalPartitionsListOraclev10g)pKProxyOraclev10g.getIndexGlobalPL(), bl);
        }
    }

    private void appendGlobalIndexByHashQuantity(StringBuffer stringBuffer, PKProxyOraclev10g pKProxyOraclev10g, boolean bl) {
        if (pKProxyOraclev10g.getIndexGlobalPL() != null) {
            IndexGlobalPartitionsListOraclev10g indexGlobalPartitionsListOraclev10g = (IndexGlobalPartitionsListOraclev10g)pKProxyOraclev10g.getIndexGlobalPL();
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "GLOBAL");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "HASH");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllGlobalPartColumns()));
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITIONS");
            this.appendStringWithSpace(stringBuffer, indexGlobalPartitionsListOraclev10g.getHashPQuantity());
            if (!"".equals(indexGlobalPartitionsListOraclev10g.getHashPTableSpaces())) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllHashPTS()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
            if (!"".equals(indexGlobalPartitionsListOraclev10g.getIOTOverflowHashPTS())) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "OVERFLOW");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllIOTOverflowHashPTS()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendGlobalIndexByHashList(StringBuffer stringBuffer, PKProxyOraclev10g pKProxyOraclev10g, boolean bl) {
        if (pKProxyOraclev10g.getIndexGlobalPL() != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "GLOBAL");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "HASH");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(pKProxyOraclev10g.getIndexGlobalPL().getAllGlobalPartColumns()));
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            this.appendHashPartitions(stringBuffer, (IndexGlobalPartitionsListOraclev10g)pKProxyOraclev10g.getIndexGlobalPL(), bl);
        }
    }

    private boolean appendHashPartitions(StringBuffer stringBuffer, IndexGlobalPartitionsListOraclev10g indexGlobalPartitionsListOraclev10g, boolean bl) {
        boolean bl2 = false;
        IndexHashPartitionSetOraclev10g indexHashPartitionSetOraclev10g = (IndexHashPartitionSetOraclev10g)((StorageDesignOraclev10g)indexGlobalPartitionsListOraclev10g.getStorageDesign()).getIndexHashPartitionSet();
        Iterator iterator = indexHashPartitionSetOraclev10g.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            IndexHashPartitionOraclev10g indexHashPartitionOraclev10g = (IndexHashPartitionOraclev10g)iterator.next();
            if (indexHashPartitionOraclev10g.getIndexGlobalPartList() == null || !indexHashPartitionOraclev10g.getIndexGlobalPartList().toString().equalsIgnoreCase(indexGlobalPartitionsListOraclev10g.toString())) continue;
            if (bl3) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                bl3 = false;
                bl2 = true;
            } else {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ',');
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            }
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexHashPartitionOraclev10g.getName()));
            if (indexHashPartitionOraclev10g.getTableSpace() != null) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexHashPartitionOraclev10g.getTableSpace().getName()));
            }
            if (indexHashPartitionOraclev10g.getOverflowTableSpace() != null) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "OVERFLOW");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexHashPartitionOraclev10g.getOverflowTableSpace().getName()));
            }
            this.appendHashPLobItems(stringBuffer, indexHashPartitionOraclev10g, bl);
        }
        if (!bl3) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
        return bl2;
    }

    private void appendHashPLobItems(StringBuffer stringBuffer, IndexHashPartitionOraclev10g indexHashPartitionOraclev10g, boolean bl) {
        IndexHashPartitionLobItemSetOraclev10g indexHashPartitionLobItemSetOraclev10g = (IndexHashPartitionLobItemSetOraclev10g)((StorageDesignOraclev10g)indexHashPartitionOraclev10g.getStorageDesign()).getIndexHashPartitionLobItemSet();
        Iterator iterator = indexHashPartitionLobItemSetOraclev10g.iterator();
        while (iterator.hasNext()) {
            IndexHashPartitionLobItemOraclev10g indexHashPartitionLobItemOraclev10g = (IndexHashPartitionLobItemOraclev10g)iterator.next();
            if (indexHashPartitionLobItemOraclev10g.getIndexHashPartition() == null || !indexHashPartitionLobItemOraclev10g.getIndexHashPartition().toString().equalsIgnoreCase(indexHashPartitionOraclev10g.toString())) continue;
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            this.appendLobPartitioningStorage(stringBuffer, indexHashPartitionLobItemOraclev10g.getName(), indexHashPartitionLobItemOraclev10g.getLobColumn(), "", indexHashPartitionLobItemOraclev10g.getTableSpace(), bl);
        }
    }

    private void appendGlobalIndex(StringBuffer stringBuffer, UniqueOraclev10g uniqueOraclev10g, boolean bl) {
        if (uniqueOraclev10g.getUsingIndexGlobalPL() != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "GLOBAL");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "RANGE");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(uniqueOraclev10g.getUsingIndexGlobalPL().getAllGlobalPartColumns()));
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            this.appendGlobalPartitions(stringBuffer, (IndexGlobalPartitionsListOraclev10g)uniqueOraclev10g.getUsingIndexGlobalPL(), bl);
        }
    }

    private void appendGlobalIndexByHashQuantity(StringBuffer stringBuffer, UniqueOraclev10g uniqueOraclev10g, boolean bl) {
        if (uniqueOraclev10g.getUsingIndexGlobalPL() != null) {
            IndexGlobalPartitionsListOraclev10g indexGlobalPartitionsListOraclev10g = (IndexGlobalPartitionsListOraclev10g)uniqueOraclev10g.getUsingIndexGlobalPL();
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "GLOBAL");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "HASH");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllGlobalPartColumns()));
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITIONS");
            this.appendStringWithSpace(stringBuffer, indexGlobalPartitionsListOraclev10g.getHashPQuantity());
            if (!"".equals(indexGlobalPartitionsListOraclev10g.getHashPTableSpaces())) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllHashPTS()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
            if (!"".equals(indexGlobalPartitionsListOraclev10g.getIOTOverflowHashPTS())) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "OVERFLOW");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllIOTOverflowHashPTS()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendGlobalIndexByHashList(StringBuffer stringBuffer, UniqueOraclev10g uniqueOraclev10g, boolean bl) {
        if (uniqueOraclev10g.getUsingIndexGlobalPL() != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "GLOBAL");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "HASH");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(uniqueOraclev10g.getUsingIndexGlobalPL().getAllGlobalPartColumns()));
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            this.appendHashPartitions(stringBuffer, (IndexGlobalPartitionsListOraclev10g)uniqueOraclev10g.getUsingIndexGlobalPL(), bl);
        }
    }

    private void appendGlobalPartitions(StringBuffer stringBuffer, IndexGlobalPartitionsListOraclev10g indexGlobalPartitionsListOraclev10g, boolean bl) {
        IndexGlobalPartitionSetOraclev10g indexGlobalPartitionSetOraclev10g = (IndexGlobalPartitionSetOraclev10g)((StorageDesignOraclev10g)indexGlobalPartitionsListOraclev10g.getStorageDesign()).getIndexGlobalPartitionSet();
        Object[] objectArray = indexGlobalPartitionSetOraclev10g.toArray();
        Arrays.sort(objectArray, new GlobalPossitionComparator());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        Iterator iterator = arrayList.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            IndexGlobalPartitionOraclev10g indexGlobalPartitionOraclev10g = (IndexGlobalPartitionOraclev10g)iterator.next();
            if (indexGlobalPartitionOraclev10g.getIndexGlobalPartList() == null || !indexGlobalPartitionOraclev10g.getIndexGlobalPartList().toString().equalsIgnoreCase(indexGlobalPartitionsListOraclev10g.toString())) continue;
            if (bl2) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                bl2 = false;
            } else {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ',');
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            }
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexGlobalPartitionOraclev10g.getName()));
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, indexGlobalPartitionOraclev10g.getValueList());
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            if (indexGlobalPartitionOraclev10g.getSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev10g)indexGlobalPartitionOraclev10g.getSegment(), false, bl, indexGlobalPartitionOraclev10g.getTableSpace(), indexGlobalPartitionOraclev10g.getLogging());
                continue;
            }
            if (indexGlobalPartitionOraclev10g.getTableSpace() != null) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexGlobalPartitionOraclev10g.getTableSpace().getName()));
            }
            if (!this.storageDesign.isOpen()) continue;
            if ("YES".equalsIgnoreCase(indexGlobalPartitionOraclev10g.getLogging())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(indexGlobalPartitionOraclev10g.getLogging())) continue;
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
        }
        if (!bl2) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendTableCommentOn(StringBuffer stringBuffer, Table table, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        block4: {
            Object object;
            Object object2;
            block3: {
                if (tableProxyOraclev10g == null) break block3;
                this.appendCommentOn(stringBuffer, tableProxyOraclev10g, bl);
                ColumnProxy[] columnProxyArray = tableProxyOraclev10g.getColumnProxies();
                ColumnProxy columnProxy = null;
                for (int i = 0; i < columnProxyArray.length; ++i) {
                    columnProxy = columnProxyArray[i];
                    String string = "";
                    String string2 = this.storageDesign.getFormatedName(tableProxyOraclev10g.getLongName()) + '.' + this.storageDesign.getFormatedName(columnProxy.getName());
                    string = columnProxy.getCommentInRDBMS() != null && columnProxy.isCommentInRDBMSChanged() ? columnProxy.getCommentInRDBMS() : columnProxy.getColumn().getCommentInRDBMS();
                    if (string.equalsIgnoreCase("")) continue;
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                    StringBuffer stringBuffer2 = new StringBuffer();
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "COMMENT ON");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "COLUMN");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, string2);
                    String string3 = stringBuffer2.toString();
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "IS");
                    SSBTableOraclev10g.appendString(stringBuffer2, '\'');
                    SSBTableOraclev10g.appendString(stringBuffer2, this.replaceSingleQuote(string));
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, '\'');
                    this.appendToBuffer(stringBuffer, stringBuffer2, string3);
                    SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                    this.appendLineFinisher(stringBuffer2, bl);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string3);
                }
                break block4;
            }
            if (table == null) break block4;
            String string = table.getCommentInRDBMS();
            if (string != null && !"".equalsIgnoreCase(string)) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                object2 = new StringBuffer();
                SSBTableOraclev10g.appendStringWithSpace((StringBuffer)object2, "COMMENT ON");
                SSBTableOraclev10g.appendStringWithSpace((StringBuffer)object2, "TABLE");
                SSBTableOraclev10g.appendStringWithSpace((StringBuffer)object2, this.storageDesign.getFormatedName(table.getLongName()));
                object = ((StringBuffer)object2).toString();
                SSBTableOraclev10g.appendStringWithSpace((StringBuffer)object2, "IS");
                SSBTableOraclev10g.appendString((StringBuffer)object2, '\'');
                SSBTableOraclev10g.appendString((StringBuffer)object2, this.replaceSingleQuote(string));
                SSBTableOraclev10g.appendStringWithSpace((StringBuffer)object2, '\'');
                this.appendToBuffer(stringBuffer, (StringBuffer)object2, (String)object);
                SSBTableOraclev10g.appendNewLine((StringBuffer)object2, bl, 0);
                this.appendLineFinisher((StringBuffer)object2, bl);
                this.appendToBuffer(stringBuffer, (StringBuffer)object2, (String)object);
            }
            object2 = table.getElements();
            for (int i = 0; i < ((ContainedObject[])object2).length; ++i) {
                object = (Column)object2[i];
                String string4 = ((ModelIDObject)object).getCommentInRDBMS();
                if (string4 == null || "".equalsIgnoreCase(string4)) continue;
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                StringBuffer stringBuffer3 = new StringBuffer();
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer3, "COMMENT ON");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer3, "COLUMN");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer3, this.storageDesign.getFormatedName(((ContainedObject)object).getLongName()));
                String string5 = stringBuffer3.toString();
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer3, "IS");
                SSBTableOraclev10g.appendString(stringBuffer3, '\'');
                SSBTableOraclev10g.appendString(stringBuffer3, this.replaceSingleQuote(string4));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer3, '\'');
                this.appendToBuffer(stringBuffer, stringBuffer3, string5);
                SSBTableOraclev10g.appendNewLine(stringBuffer3, bl, 0);
                this.appendLineFinisher(stringBuffer3, bl);
                this.appendToBuffer(stringBuffer, stringBuffer3, string5);
            }
        }
    }

    public void appendPartitionList(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        PartitionListOraclev10g partitionListOraclev10g = (PartitionListOraclev10g)tableProxyOraclev10g.getPartitionList();
        if (partitionListOraclev10g != null) {
            this.tableProxy = tableProxyOraclev10g;
            this.table = (Table)tableProxyOraclev10g.getObject();
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignOraclev10g)tableProxyOraclev10g.getStorageDesign();
            }
            String string = partitionListOraclev10g.getPartitionType();
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            if ("RANGE".equalsIgnoreCase(string)) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "RANGE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev10g.getColumnList()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                this.appendPartitions(stringBuffer, partitionListOraclev10g, true, false, bl);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(string)) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "RANGE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev10g.getColumnList()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "HASH");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev10g.getSubPartitionsColumnList()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                if (partitionListOraclev10g.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
                    if (partitionListOraclev10g.getSubPartitionsQuantity() > 1 || !"".equals(partitionListOraclev10g.getSubPartitionsTableSpaces())) {
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                        this.appendStringWithSpace(stringBuffer, partitionListOraclev10g.getSubPartitionsQuantity());
                        if (!"".equals(partitionListOraclev10g.getSubPartitionsTableSpaces())) {
                            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev10g.getAllSubPartitionsTableSpaces()));
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                        }
                    }
                } else {
                    this.appendHashSubPartitionTemplates(stringBuffer, tableProxyOraclev10g, bl);
                }
                this.appendPartitions(stringBuffer, partitionListOraclev10g, true, true, bl);
            } else if ("COMPOSITE BY LIST".equalsIgnoreCase(string)) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "RANGE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev10g.getColumnList()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LIST");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev10g.getSubPartitionsColumnList()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                this.appendListSubPartitionTemplates(stringBuffer, tableProxyOraclev10g, bl);
                this.appendPartitions(stringBuffer, partitionListOraclev10g, true, true, bl);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(string)) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "HASH");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev10g.getColumnList()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITIONS");
                this.appendStringWithSpace(stringBuffer, partitionListOraclev10g.getHashPQuantity());
                if (!"".equals(partitionListOraclev10g.getHashPTableSpaces())) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev10g.getAllHashPTableSpaces()));
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
                if (!"".equals(partitionListOraclev10g.getIOTOverflowHashPTS())) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "OVERFLOW");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev10g.getAllIOTOverflowHashPTS()));
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(string)) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "HASH");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev10g.getColumnList()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                this.appendHashPartitions(stringBuffer, partitionListOraclev10g, bl);
            } else if ("LIST".equalsIgnoreCase(string)) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LIST");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev10g.getColumnList()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                this.appendListPartitions(stringBuffer, partitionListOraclev10g, bl);
            }
        }
    }

    protected void appendListSubPartitionTemplates(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        StorageObjectCollection storageObjectCollection = tableProxyOraclev10g.getListStorageTemplates();
        if (storageObjectCollection.size() > 0) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TEMPLATE");
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            for (int i = 0; i < storageObjectCollection.size(); ++i) {
                ListStorageTemplatePartitionOraclev10g listStorageTemplatePartitionOraclev10g = (ListStorageTemplatePartitionOraclev10g)storageObjectCollection.getElement(i);
                if (i > 0) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ',');
                }
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listStorageTemplatePartitionOraclev10g.getName()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "VALUES");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                if (!"".equalsIgnoreCase(listStorageTemplatePartitionOraclev10g.getValueList())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, listStorageTemplatePartitionOraclev10g.getValueList());
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DEFAULT");
                }
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                this.appendPartStorage(stringBuffer, listStorageTemplatePartitionOraclev10g, bl);
            }
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendHashSubPartitionTemplates(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        if (tableProxyOraclev10g.getListStorageTemplates().size() > 0) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TEMPLATE");
            Iterator iterator = tableProxyOraclev10g.getListStorageTemplates().iterator();
            boolean bl2 = true;
            while (iterator.hasNext()) {
                HashPartitionOraclev10g hashPartitionOraclev10g = (HashPartitionOraclev10g)iterator.next();
                if (bl2) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    bl2 = false;
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ',');
                }
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev10g.getName()));
                this.appendPartStorage(stringBuffer, hashPartitionOraclev10g, bl);
            }
            if (!bl2) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    protected void appendPartStorage(StringBuffer stringBuffer, AbstractStorageObjectOracle abstractStorageObjectOracle, boolean bl) {
        TableSpaceOracle tableSpaceOracle = null;
        TableSpaceOracle tableSpaceOracle2 = null;
        String string = "";
        StorageObjectCollection storageObjectCollection = null;
        if (abstractStorageObjectOracle instanceof PartitionOraclev10g) {
            tableSpaceOracle = ((PartitionOraclev10g)abstractStorageObjectOracle).getTableSpace();
            string = ((PartitionOraclev10g)abstractStorageObjectOracle).getDataSegmentCompression();
            storageObjectCollection = ((PartitionOraclev10g)abstractStorageObjectOracle).getLobs();
        } else if (abstractStorageObjectOracle instanceof HashPartitionOraclev10g) {
            tableSpaceOracle = ((HashPartitionOraclev10g)abstractStorageObjectOracle).getTableSpace();
            tableSpaceOracle2 = ((HashPartitionOraclev10g)abstractStorageObjectOracle).getIotOverflowTablespace();
            storageObjectCollection = ((HashPartitionOraclev10g)abstractStorageObjectOracle).getLobs();
        } else if (abstractStorageObjectOracle instanceof ListStorageTemplatePartitionOraclev10g) {
            tableSpaceOracle = ((ListStorageTemplatePartitionOraclev10g)abstractStorageObjectOracle).getTablespace();
            string = ((ListStorageTemplatePartitionOraclev10g)abstractStorageObjectOracle).getDataSegmentCompression();
            storageObjectCollection = ((ListStorageTemplatePartitionOraclev10g)abstractStorageObjectOracle).getLobs();
        }
        if (tableSpaceOracle != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
        if (tableSpaceOracle2 != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "OVERFLOW");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle2.getName()));
        }
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            if (string.equalsIgnoreCase("NO")) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOCOMPRESS");
            } else if (string.equalsIgnoreCase("YES")) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
            }
        }
        if (storageObjectCollection != null) {
            Iterator iterator = storageObjectCollection.iterator();
            while (iterator.hasNext()) {
                AbstractStorageObjectOracle abstractStorageObjectOracle2;
                Object e = iterator.next();
                if (e instanceof LobStorageOraclev10g) {
                    abstractStorageObjectOracle2 = (LobStorageOraclev10g)e;
                    if (((LobStorageOracle)abstractStorageObjectOracle2).getTableSpace() == null && ((LobStorageOracle)abstractStorageObjectOracle2).getLobSegmentName().trim().equals("")) continue;
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
                    this.appendLobPartitioningStorage(stringBuffer, abstractStorageObjectOracle2.getName(), ((LobStorageOracle)abstractStorageObjectOracle2).getColumn(), abstractStorageObjectOracle2, ((LobStorageOracle)abstractStorageObjectOracle2).getTableSpace(), bl);
                    continue;
                }
                if (!(e instanceof HashPartitionLobItemOraclev10g) || ((HashPartitionLobItemOracle)(abstractStorageObjectOracle2 = (HashPartitionLobItemOraclev10g)e)).getTableSpace() == null) continue;
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
                this.appendLobPartitioningStorage(stringBuffer, abstractStorageObjectOracle2.getName(), ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).getLobColumn(), "", ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).getTableSpace(), bl);
            }
        }
    }

    protected void appendListPartitions(StringBuffer stringBuffer, PartitionListOraclev10g partitionListOraclev10g, boolean bl) {
        Iterator iterator = this.tableProxy.getPartitions().iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            Object object;
            ListPartitionOraclev10g listPartitionOraclev10g = (ListPartitionOraclev10g)iterator.next();
            if (bl2) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                bl2 = false;
            } else {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ',');
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            }
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev10g.getName()));
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "VALUES");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            if (!"".equalsIgnoreCase(listPartitionOraclev10g.getColumns())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, listPartitionOraclev10g.getColumns());
            } else {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DEFAULT");
            }
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            if (listPartitionOraclev10g.getSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev10g)listPartitionOraclev10g.getSegment(), true, bl, listPartitionOraclev10g.getTablespace(), listPartitionOraclev10g.getLogging());
            } else {
                if (listPartitionOraclev10g.getTablespace() != null) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev10g.getTablespace().getName()));
                }
                if (this.storageDesign.isOpen() && ((String)(object = listPartitionOraclev10g.getLogging())).length() > 0) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    if (((String)object).equalsIgnoreCase("YES")) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                    } else if (((String)object).equalsIgnoreCase("NO")) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                    }
                }
            }
            if (listPartitionOraclev10g.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOCOMPRESS");
            } else if (listPartitionOraclev10g.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
            }
            if (!this.table.isSpatialTable()) {
                object = listPartitionOraclev10g.getLobStorages().iterator();
                while (object.hasNext()) {
                    LobStorageOracle lobStorageOracle = (LobStorageOracle)object.next();
                    this.appendLobStorage(stringBuffer, (LobStorageOraclev10g)lobStorageOracle, bl);
                }
            }
            if (partitionListOraclev10g.getSubpartitionType().length() <= 0) continue;
            this.appendSubPartitions(stringBuffer, listPartitionOraclev10g, partitionListOraclev10g, bl);
        }
        if (!bl2) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendPartitions(StringBuffer stringBuffer, PartitionListOraclev10g partitionListOraclev10g, boolean bl, boolean bl2, boolean bl3) {
        StorageObjectCollection storageObjectCollection = this.tableProxy.getPartitions();
        if (storageObjectCollection.size() > 0) {
            Object[] objectArray = storageObjectCollection.toArray();
            Arrays.sort(objectArray, new PossitionComparator());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(objectArray[i]);
            }
            Iterator iterator = arrayList.iterator();
            boolean bl4 = true;
            while (iterator.hasNext()) {
                Object object;
                Object e = iterator.next();
                if (!(e instanceof PartitionOracle)) continue;
                PartitionOracle partitionOracle = (PartitionOracle)e;
                if (bl4) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl3, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    bl4 = false;
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ',');
                }
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl3, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOracle.getName()));
                if (bl) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, partitionOracle.getValueList());
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
                if (partitionOracle.getSegment() != null) {
                    this.appendSegment(stringBuffer, (SegmentOraclev10g)partitionOracle.getSegment(), true, bl3, partitionOracle.getTableSpace(), partitionOracle.getLogging());
                } else {
                    if (partitionOracle.getTableSpace() != null) {
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl3, 2);
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOracle.getTableSpace().getName()));
                    }
                    if (this.storageDesign.isOpen()) {
                        if (partitionOracle.getLogging().equalsIgnoreCase("NO")) {
                            SSBTableOraclev10g.appendNewLine(stringBuffer, bl3, 2);
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                        } else if (partitionOracle.getLogging().equalsIgnoreCase("YES")) {
                            SSBTableOraclev10g.appendNewLine(stringBuffer, bl3, 2);
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                        }
                    }
                }
                if (partitionOracle.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl3, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOCOMPRESS");
                } else if (partitionOracle.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl3, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
                }
                SegmentOracle segmentOracle = partitionOracle.getIOTOverflowSegment();
                if (segmentOracle != null) {
                    object = segmentOracle.getTableSpace();
                    if (object == null) {
                        object = partitionOracle.getTableSpace();
                    }
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "OVERFLOW");
                    this.appendSegment(stringBuffer, (SegmentOraclev10g)segmentOracle, true, bl3, (TableSpaceOracle)object, partitionOracle.getLogging());
                }
                if (!this.table.isSpatialTable()) {
                    object = partitionOracle.getLobs().iterator();
                    while (object.hasNext()) {
                        LobStorageOracle lobStorageOracle = (LobStorageOracle)object.next();
                        this.appendLobStorage(stringBuffer, (LobStorageOraclev10g)lobStorageOracle, bl3);
                    }
                }
                if (!bl2) continue;
                this.appendSubPartitions(stringBuffer, partitionOracle, partitionListOraclev10g, bl3);
            }
            if (!bl4) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl3, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    protected void appendSubPartitions(StringBuffer stringBuffer, AbstractStorageObjectOracle abstractStorageObjectOracle, PartitionListOraclev10g partitionListOraclev10g, boolean bl) {
        if (partitionListOraclev10g.getSubpartitionType().equalsIgnoreCase("HASH")) {
            PartitionOraclev10g partitionOraclev10g;
            if (abstractStorageObjectOracle instanceof PartitionOraclev10g && !this.appendHashSubPartitions(stringBuffer, (partitionOraclev10g = (PartitionOraclev10g)abstractStorageObjectOracle).getPartitions(), partitionListOraclev10g, bl) && partitionOraclev10g.getSubPartitionsQuantity() > 0) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                this.appendStringWithSpace(stringBuffer, partitionOraclev10g.getSubPartitionsQuantity());
                if (!"".equalsIgnoreCase(partitionOraclev10g.getSubPartitionsTableSpaces())) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionOraclev10g.getAllSubPartitionsTableSpaces()));
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
            }
        } else if (partitionListOraclev10g.getSubpartitionType().equalsIgnoreCase("LIST") && abstractStorageObjectOracle instanceof PartitionOraclev10g) {
            this.appendListSubPartitions(stringBuffer, ((PartitionOraclev10g)abstractStorageObjectOracle).getListPartitions(), bl);
        }
    }

    protected void appendListSubPartitions(StringBuffer stringBuffer, StorageObjectCollection storageObjectCollection, boolean bl) {
        if (storageObjectCollection.size() > 0) {
            boolean bl2 = true;
            Iterator iterator = storageObjectCollection.iterator();
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            while (iterator.hasNext()) {
                ListStorageTemplatePartitionOraclev10g listStorageTemplatePartitionOraclev10g = (ListStorageTemplatePartitionOraclev10g)iterator.next();
                if (!bl2) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ',');
                } else {
                    bl2 = false;
                }
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listStorageTemplatePartitionOraclev10g.getName()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "VALUES");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, listStorageTemplatePartitionOraclev10g.getValueList());
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                this.appendPartStorage(stringBuffer, listStorageTemplatePartitionOraclev10g, bl);
            }
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected boolean appendHashSubPartitions(StringBuffer stringBuffer, StorageObjectCollection storageObjectCollection, PartitionListOraclev10g partitionListOraclev10g, boolean bl) {
        boolean bl2 = false;
        if (partitionListOraclev10g.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
            Iterator iterator = storageObjectCollection.iterator();
            boolean bl3 = true;
            while (iterator.hasNext()) {
                HashPartitionOraclev10g hashPartitionOraclev10g = (HashPartitionOraclev10g)iterator.next();
                if (bl3) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    bl3 = false;
                    bl2 = true;
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ',');
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ' ');
                }
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev10g.getName()));
                this.appendPartStorage(stringBuffer, hashPartitionOraclev10g, bl);
            }
            if (!bl3) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        }
        return bl2;
    }

    protected boolean appendHashPartitions(StringBuffer stringBuffer, PartitionListOraclev10g partitionListOraclev10g, boolean bl) {
        boolean bl2 = false;
        Iterator iterator = this.tableProxy.getPartitions().iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            HashPartitionOraclev10g hashPartitionOraclev10g = (HashPartitionOraclev10g)iterator.next();
            if (bl3) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                bl3 = false;
                bl2 = true;
            } else {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ',');
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            }
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev10g.getName()));
            if (hashPartitionOraclev10g.getTableSpace() != null) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev10g.getTableSpace().getName()));
            }
            this.appendHashPLobItems(stringBuffer, hashPartitionOraclev10g, bl);
        }
        if (!bl3) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
        return bl2;
    }

    private void appendHashPLobItems(StringBuffer stringBuffer, HashPartitionOraclev10g hashPartitionOraclev10g, boolean bl) {
        HashPartitionLobItemSetOraclev10g hashPartitionLobItemSetOraclev10g = (HashPartitionLobItemSetOraclev10g)((StorageDesignOraclev10g)hashPartitionOraclev10g.getStorageDesign()).getHashPartitionLobItemSet();
        Iterator iterator = hashPartitionLobItemSetOraclev10g.iterator();
        while (iterator.hasNext()) {
            HashPartitionLobItemOraclev10g hashPartitionLobItemOraclev10g = (HashPartitionLobItemOraclev10g)iterator.next();
            if (hashPartitionLobItemOraclev10g.getHashPartition() == null || !hashPartitionLobItemOraclev10g.getHashPartition().toString().equalsIgnoreCase(hashPartitionOraclev10g.toString())) continue;
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            this.appendLobPartitioningStorage(stringBuffer, hashPartitionLobItemOraclev10g.getName(), hashPartitionLobItemOraclev10g.getLobColumn(), "", hashPartitionLobItemOraclev10g.getTableSpace(), bl);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer stringBuffer, String string, Object object, Object object2, TableSpaceOracle tableSpaceOracle, boolean bl) {
        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOB");
        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
        String string2 = "";
        if (object != null) {
            string2 = object.toString();
        }
        if (string2.length() > 0) {
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
        } else {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("--  ERROR: Lob ");
            stringBuffer.append(string);
            stringBuffer.append(" has no Column specified");
            DDLFileMaker.incrementErrors();
        }
        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORE AS");
        if (object2 instanceof LobStorageOraclev11g) {
            if (((LobStorageOraclev11g)object2).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SECUREFILE");
            } else if (((LobStorageOraclev11g)object2).getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BASICFILE");
            }
        }
        String string3 = "";
        if (object2 instanceof LobStorageOraclev10g) {
            string3 = ((LobStorageOraclev10g)object2).getLobSegmentName();
        }
        if (!string3.equalsIgnoreCase("")) {
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string3));
        } else if (tableSpaceOracle == null) {
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
        }
        if (tableSpaceOracle != null) {
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendLobStorage(StringBuffer stringBuffer, LobStorageOraclev10g lobStorageOraclev10g, boolean bl) {
        if (lobStorageOraclev10g != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOB");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOraclev10g.getColumn()));
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORE AS");
            if (lobStorageOraclev10g instanceof LobStorageOraclev11g) {
                if (((LobStorageOraclev11g)lobStorageOraclev10g).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SECUREFILE");
                } else if (((LobStorageOraclev11g)lobStorageOraclev10g).getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BASICFILE");
                }
            }
            if (!lobStorageOraclev10g.getLobSegmentName().equalsIgnoreCase("")) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOraclev10g.getLobSegmentName()));
            }
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            if (lobStorageOraclev10g.getTableSpace() != null) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOraclev10g.getTableSpace().getName()));
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            }
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORAGE");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
            if (lobStorageOraclev10g.getSCInitialExtent() > 0L) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev10g.getSCInitialExtent());
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
            }
            if (lobStorageOraclev10g.getSCNextExtent() > 0L) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev10g.getSCNextExtent());
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
            }
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, lobStorageOraclev10g.getSCPctIncrease());
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, lobStorageOraclev10g.getSCMinExtents());
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, lobStorageOraclev10g.getSCMaxExtents());
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, lobStorageOraclev10g.getSCFreeLists());
            if (lobStorageOraclev10g.getSCFreelistGroups() > 1) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "FREELIST");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "GROUPS");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev10g.getSCFreelistGroups());
            }
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 3);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, lobStorageOraclev10g.getSCBufferPool());
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            if (lobStorageOraclev10g.getChunk() > 0) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "CHUNK");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev10g.getChunk());
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            }
            if (lobStorageOraclev10g.getOldVersions().equalsIgnoreCase("RETENTION")) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "RETENTION");
            } else {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PCTVERSION");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev10g.getPCTVersion());
            }
            if (lobStorageOraclev10g.getSCFreelistGroups() <= 1 && lobStorageOraclev10g.getFreepools() > 0) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "FREEPOOLS");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev10g.getFreepools());
            }
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            if ("ENABLE".equalsIgnoreCase(lobStorageOraclev10g.getStorageInRow())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ENABLE");
            } else {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DISABLE");
            }
            stringBuffer.append("STORAGE IN ROW");
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, lobStorageOraclev10g.getCache());
            if ("FILESYSTEM_LIKE_LOGGING".equalsIgnoreCase(lobStorageOraclev10g.getLogging()) && lobStorageOraclev10g.getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "FILESYSTEM_LIKE_LOGGING");
            } else if (!"CACHE".equalsIgnoreCase(lobStorageOraclev10g.getCache())) {
                if ("YES".equalsIgnoreCase(lobStorageOraclev10g.getLogging())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(lobStorageOraclev10g.getLogging())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                }
            }
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendSegment(StringBuffer stringBuffer, SegmentOraclev10g segmentOraclev10g, boolean bl, boolean bl2, TableSpaceOracle tableSpaceOracle, String string) {
        if (segmentOraclev10g != null && segmentOraclev10g.isMarkedGenerate()) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getPCTFree());
            if (bl) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PCTUSED");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getPCTUsed());
            }
            if (segmentOraclev10g.getInitrans() > 1) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "INITRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getInitrans());
            }
            if (segmentOraclev10g.getMaxTrans() > 1) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "MAXTRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getMaxTrans());
            }
            if (tableSpaceOracle != null) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            } else if (segmentOraclev10g.getTableSpace() != null) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(segmentOraclev10g.getTableSpace().getName()));
            }
            if (this.storageDesign.isOpen() && !"".equals(string)) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                if (string.equalsIgnoreCase("NO")) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                }
            }
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORAGE");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            if (segmentOraclev10g.getSCInitialExtent() > 0L) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCInitialExtent());
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            }
            if (segmentOraclev10g.getSCNextExtent() > 0L) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCNextExtent());
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            }
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCPctIncrease());
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCMinExtents());
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCMaxExtents());
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCFreeLists());
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "FREELIST");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "GROUPS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCFreelistGroups());
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCBufferPool());
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        } else {
            if (tableSpaceOracle != null) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            }
            if (!"".equals(string)) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                if (string.equalsIgnoreCase("NO")) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                } else {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                }
            }
        }
    }

    private void appendOrganization(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        AbstractStorageObjectOracle abstractStorageObjectOracle;
        boolean bl2 = "INDEX".equalsIgnoreCase(tableProxyOraclev10g.getOrganization());
        if (bl2) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ORGANIZATION");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "INDEX");
        }
        if (tableProxyOraclev10g.getSegment() != null) {
            this.appendSegment(stringBuffer, (SegmentOraclev10g)tableProxyOraclev10g.getSegment(), !bl2, bl, tableProxyOraclev10g.getTableSpace(), tableProxyOraclev10g.getLogging());
        } else {
            abstractStorageObjectOracle = tableProxyOraclev10g.getTableSpace();
            if (abstractStorageObjectOracle != null && !"[NONE]".equalsIgnoreCase(abstractStorageObjectOracle.getName())) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(abstractStorageObjectOracle.getName()));
            }
            if (this.storageDesign.isOpen()) {
                if ("YES".equalsIgnoreCase(tableProxyOraclev10g.getLogging())) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(tableProxyOraclev10g.getLogging())) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                }
            }
        }
        if ("INDEX".equalsIgnoreCase(tableProxyOraclev10g.getOrganization())) {
            if (tableProxyOraclev10g.getIOTMappingTable().equalsIgnoreCase("YES")) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "MAPPING TABLE");
            }
            if (tableProxyOraclev10g.getIotPctThreshold() > 0) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PCTTHRESHOLD");
                this.appendStringWithSpace(stringBuffer, tableProxyOraclev10g.getIotPctThreshold());
            }
            if (tableProxyOraclev10g.getIotCompress() > 0) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
                this.appendStringWithSpace(stringBuffer, tableProxyOraclev10g.getIotCompress());
            }
            if ((abstractStorageObjectOracle = (SegmentOraclev10g)tableProxyOraclev10g.getIotOverflowSegment()) != null || tableProxyOraclev10g.getIotIncluding() != null) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                if (tableProxyOraclev10g.getIotIncluding() != null) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "INCLUDING");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOraclev10g.getIotIncluding().getName()));
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                }
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "OVERFLOW");
                if (abstractStorageObjectOracle != null) {
                    TableSpaceOracle tableSpaceOracle = ((SegmentOracle)abstractStorageObjectOracle).getTableSpace();
                    if (tableSpaceOracle == null) {
                        tableSpaceOracle = tableProxyOraclev10g.getTableSpace();
                    }
                    this.appendSegment(stringBuffer, (SegmentOraclev10g)abstractStorageObjectOracle, true, bl, tableSpaceOracle, tableProxyOraclev10g.getLogging());
                }
            }
        } else if (tableProxyOraclev10g.getDataSegmentCompression().equalsIgnoreCase("YES")) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
        }
        if ("YES".equalsIgnoreCase(tableProxyOraclev10g.getPartitioned())) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            if ("ENABLE".equalsIgnoreCase(tableProxyOraclev10g.getParttitionedRowMovement())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ENABLE");
            } else {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DISABLE");
            }
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ROW MOVEMENT");
        }
    }

    private void appendCluster(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        ClusterOraclev10g clusterOraclev10g = (ClusterOraclev10g)tableProxyOraclev10g.getCluster();
        if (clusterOraclev10g != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "CLUSTER");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(clusterOraclev10g.getLongName()));
            if (!"".equalsIgnoreCase(tableProxyOraclev10g.getClusterColumns())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(tableProxyOraclev10g.getAllClusterColumns()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        } else {
            this.appendOrganization(stringBuffer, tableProxyOraclev10g, bl);
            if (!this.table.isSpatialTable()) {
                for (int i = 0; i < tableProxyOraclev10g.getLobStorages().size(); ++i) {
                    this.appendLobStorage(stringBuffer, (LobStorageOraclev10g)tableProxyOraclev10g.getLobStorages().getElement(i), bl);
                }
            }
        }
    }

    private void appendUniqueDefinition(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        if (tableProxyOracle != null) {
            UniqueSetOraclev10g uniqueSetOraclev10g = (UniqueSetOraclev10g)((StorageDesignOraclev10g)tableProxyOracle.getStorageDesign()).getUniqueSet();
            Iterator iterator = uniqueSetOraclev10g.iterator();
            while (iterator.hasNext()) {
                UniqueOraclev10g uniqueOraclev10g = (UniqueOraclev10g)iterator.next();
                Index index = (Index)uniqueOraclev10g.getObject();
                if (uniqueOraclev10g.getTable() == null || !uniqueOraclev10g.getTable().equals(tableProxyOracle.getObject()) || !uniqueOraclev10g.isMarkedGenerate()) continue;
                if (uniqueOraclev10g.getColumnProxies().length == 0 && "".equals(index.getIndexExpression())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "-- Error - Unique Constraint " + uniqueOraclev10g.getTable() + '.' + uniqueOraclev10g.getName() + " doesn't have columns");
                    DDLFileMaker.incrementErrors();
                    continue;
                }
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                if (uniqueOraclev10g.isCommentChanged() && !"".equalsIgnoreCase(uniqueOraclev10g.getComment())) {
                    this.appendComment(stringBuffer, uniqueOraclev10g);
                } else if (!"".equalsIgnoreCase(uniqueOraclev10g.getObject().getComment())) {
                    this.appendComment(stringBuffer, uniqueOraclev10g.getObject());
                }
                String string2 = uniqueOraclev10g.getName();
                if (string2.length() > tableProxyOracle.getMaxNameLength()) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "--  ERROR: UK name length exceeds maximum allowed length(" + tableProxyOracle.getMaxNameLength() + ")");
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementErrors();
                }
                ColumnProxy[] columnProxyArray = uniqueOraclev10g.getColumnProxies();
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(tableProxyOracle.getLongName()));
                SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "ADD");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string2));
                string = stringBuffer2.toString();
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "UNIQUE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, '(');
                if (!"".equals(index.getIndexExpression())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, index.getIndexExpression());
                } else {
                    for (int i = 0; i < columnProxyArray.length; ++i) {
                        ColumnProxy columnProxy = columnProxyArray[i];
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(columnProxy.getName()));
                        if (i >= columnProxyArray.length - 1) continue;
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, ',');
                    }
                }
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, ')');
                if (!"NO".equalsIgnoreCase(uniqueOraclev10g.getDeferrable())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "DEFERRABLE");
                    if ("DEFERRED".equalsIgnoreCase(uniqueOraclev10g.getInitially())) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "INITIALLY");
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "DEFERRED");
                    }
                }
                if (!"YES".equalsIgnoreCase(uniqueOraclev10g.getEnable())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "DISABLE");
                    if ("YES".equalsIgnoreCase(uniqueOraclev10g.getValidate())) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(uniqueOraclev10g.getValidate())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "NOVALIDATE");
                }
                if (!"NO".equalsIgnoreCase(uniqueOraclev10g.getUsingIndex())) {
                    this.appendUniqueUsingIndex(stringBuffer2, uniqueOraclev10g, bl);
                }
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                this.appendLineFinisher(stringBuffer2, bl);
                SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                DDLFileMaker.incrementAlterTable();
            }
        }
    }

    protected void appendNotNullDefinition(StringBuffer stringBuffer, ColumnProxyOracle columnProxyOracle, boolean bl) {
        String string;
        String string2 = string = columnProxyOracle.isNotNullConstraintNameChanged() ? columnProxyOracle.getNncName() : columnProxyOracle.getColumn().getNotNullConstraintName();
        if (!"NO".equalsIgnoreCase(columnProxyOracle.getNncDeferrable()) || !"YES".equalsIgnoreCase(columnProxyOracle.getNncEnable()) || !"YES".equalsIgnoreCase(columnProxyOracle.getNncValidate()) || string != null && !"".equals(string)) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendString(stringBuffer, ' ');
            if (!this.table.getDesign().getAppView().getSettings().notNullShortFormGeneration() && string != null && !"".equals(string)) {
                string = this.storageDesign.getFormatedName(string);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, string);
            }
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOT");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NULL");
            if (!"NO".equalsIgnoreCase(columnProxyOracle.getNncDeferrable())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(columnProxyOracle.getNncInitially())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "INITIALLY");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DEFERRED");
                }
            }
            if (!"YES".equalsIgnoreCase(columnProxyOracle.getNncEnable())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "DISABLE");
                if ("YES".equalsIgnoreCase(columnProxyOracle.getNncValidate())) {
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(columnProxyOracle.getNncValidate())) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOVALIDATE");
            }
        } else {
            SSBTableOraclev10g.appendString(stringBuffer, ' ');
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOT");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NULL");
        }
    }

    private void appendPermissions(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        PermissionsSetOraclev10g permissionsSetOraclev10g = (PermissionsSetOraclev10g)((StorageDesignOraclev10g)tableProxyOraclev10g.getStorageDesign()).getPermissionsSet();
        Iterator iterator = permissionsSetOraclev10g.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            int n;
            PermissionsOraclev10g permissionsOraclev10g = (PermissionsOraclev10g)iterator.next();
            if (permissionsOraclev10g.getTable() != null && permissionsOraclev10g.getTable().equals(tableProxyOraclev10g) && !permissionsOraclev10g.getPrivileges().equalsIgnoreCase("")) {
                SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                this.appendComment(stringBuffer2, permissionsOraclev10g);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "GRANT");
                this.appendPrivileges(stringBuffer2, permissionsOraclev10g);
                this.appendObject(stringBuffer2, permissionsOraclev10g, bl);
                this.appendTo(stringBuffer2, permissionsOraclev10g);
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev10g, bl);
                string = "GRANT ON " + this.storageDesign.getFormatedName(this.getPermissionsON(permissionsOraclev10g)) + " TO " + this.storageDesign.getFormatedName(this.getPermissionsTO(permissionsOraclev10g));
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
            if (permissionsOraclev10g.getTable() != null && permissionsOraclev10g.getTable().equals(tableProxyOraclev10g) && !permissionsOraclev10g.getPrivilegesWithGrantOption().equalsIgnoreCase("")) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, permissionsOraclev10g);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "GRANT");
                this.appendPrivilegesWithGrantOption(stringBuffer2, permissionsOraclev10g);
                this.appendObject(stringBuffer2, permissionsOraclev10g, bl);
                this.appendTo(stringBuffer2, permissionsOraclev10g);
                this.appendGrantOption(stringBuffer2, permissionsOraclev10g);
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev10g, bl);
                string = "GRANT ON " + this.getPermissionsON(permissionsOraclev10g) + " TO " + this.getPermissionsTO(permissionsOraclev10g);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
            if (permissionsOraclev10g.getColumnsTable() == null || !permissionsOraclev10g.getColumnsTable().equals(tableProxyOraclev10g) || permissionsOraclev10g.getColumns().isEmpty()) continue;
            ArrayList arrayList = permissionsOraclev10g.getColumns();
            for (n = 0; n < arrayList.size(); ++n) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, permissionsOraclev10g);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "GRANT");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, permissionsOraclev10g.getPrivs((String)arrayList.get(n)).trim());
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(arrayList.get(n).toString()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, ')');
                this.appendObject(stringBuffer2, permissionsOraclev10g, bl);
                this.appendTo(stringBuffer2, permissionsOraclev10g);
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev10g, bl);
                string = "GRANT ON " + this.getPermissionsON(permissionsOraclev10g) + " TO " + this.getPermissionsTO(permissionsOraclev10g);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
            if (permissionsOraclev10g.getColumnWithGrantOptionList().equals("") || permissionsOraclev10g.getColumnWithGrantOptionList() == null) continue;
            arrayList = permissionsOraclev10g.getColumns();
            for (n = 0; n < arrayList.size(); ++n) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, permissionsOraclev10g);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "GRANT");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, permissionsOraclev10g.getPrivsWithGrantOption(arrayList.get(n).toString()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(arrayList.get(n).toString()));
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, ')');
                this.appendObject(stringBuffer2, permissionsOraclev10g, bl);
                this.appendTo(stringBuffer2, permissionsOraclev10g);
                this.appendGrantOption(stringBuffer2, permissionsOraclev10g);
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev10g, bl);
                string = "GRANT ON " + this.getPermissionsON(permissionsOraclev10g) + " TO " + this.getPermissionsTO(permissionsOraclev10g);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
        }
        if (!bl2) {
            this.appendDropPackage(stringBuffer, this.storageDesign.getFormatedName(tableProxyOraclev10g.getUser().getName()), bl);
        }
    }

    private void appendPrivileges(StringBuffer stringBuffer, PermissionsOraclev10g permissionsOraclev10g) {
        stringBuffer.append(permissionsOraclev10g.getPrivileges());
    }

    private void appendPrivilegesWithGrantOption(StringBuffer stringBuffer, PermissionsOraclev10g permissionsOraclev10g) {
        stringBuffer.append(permissionsOraclev10g.getPrivilegesWithGrantOption());
    }

    private void appendObject(StringBuffer stringBuffer, PermissionsOraclev10g permissionsOraclev10g, boolean bl) {
        if (permissionsOraclev10g.getTable() != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getTable().getLongName()));
        } else if (permissionsOraclev10g.getColumnsTable() != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getColumnsTable().getLongName()));
        } else if (permissionsOraclev10g.getView() != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getView().getLongName()));
        } else if (permissionsOraclev10g.getSequence() != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getSequence().getLongName()));
        } else if (permissionsOraclev10g.getSnapshot() != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getSnapshot().getLongName()));
        } else if (permissionsOraclev10g.getProc() != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getProc().getLongName()));
        } else if (permissionsOraclev10g.getDirectoryOracle() != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getDirectoryOracle().getLongName()));
        } else if (permissionsOraclev10g.getStructuredTypeOracle() != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getStructuredTypeOracle().getLongName()));
        } else if (permissionsOraclev10g.getCollectionTypeOracle() != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getCollectionTypeOracle().getLongName()));
        } else if (permissionsOraclev10g.getExternalTableOracle() != null) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getExternalTableOracle().getLongName()));
        }
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOraclev10g permissionsOraclev10g) {
        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TO");
        if ("YES".equalsIgnoreCase(permissionsOraclev10g.getPublic())) {
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else {
            if (permissionsOraclev10g.getUser() != null) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getUser().getName()));
            }
            if (permissionsOraclev10g.getRole() != null) {
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getRole().getName()));
            }
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOraclev10g permissionsOraclev10g) {
        if (permissionsOraclev10g.getRole() == null) {
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer stringBuffer, PermissionsOraclev10g permissionsOraclev10g, boolean bl) {
        if ("YES".equalsIgnoreCase(permissionsOraclev10g.getHierarchyOption())) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "WITH HIERARCHY OPTION");
        }
    }

    private void appendDropPackage(StringBuffer stringBuffer, String string, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
        stringBuffer2.append("DROP PACKAGE ").append(string).append(".perm_manager;");
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
    }

    public void appendIndexes(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl) {
        Object object;
        Object object2;
        if (this.storageDesign == null) {
            this.storageDesign = (StorageDesignOraclev10g)tableProxyOracle.getStorageDesign();
        }
        Iterator iterator = tableProxyOracle.getIndexes().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object2 instanceof IndexProxyOracle && ((IndexProxyOracle)object2).getIndex().isSpatialIndex() || !((SSBIndexOraclev10g)(object = this.getSSBIndex())).canHandle(object2)) continue;
            ((SSBIndexOraclev10g)object).doAppend(stringBuffer, object2, bl);
        }
        object2 = (Table)tableProxyOracle.getObject();
        if (!((ContainerObject)object2).isBST()) {
            this.appendIndexesForConstraints(stringBuffer, (Table)object2, tableProxyOracle);
        }
        if (!(tableProxyOracle == null || ((Table)tableProxyOracle.getObject()).isBST() || "INDEX".equalsIgnoreCase(tableProxyOracle.getOrganization()) || (object = tableProxyOracle.getSnapshot()) != null && !((SnapshotOracle)object).getWith().equalsIgnoreCase("ROWID") && ((SnapshotOracle)object).getRefresh().equals("YES"))) {
            this.appendPKDefinition(stringBuffer, tableProxyOracle, bl);
        }
        this.appendUniqueDefinition(stringBuffer, tableProxyOracle, bl);
    }

    private void appendNestedTableColumnProp(StringBuffer stringBuffer, ColumnProxyOraclev10g columnProxyOraclev10g, boolean bl) {
        if (!columnProxyOraclev10g.getNtStorageTable().equals("")) {
            SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NESTED");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLE");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev10g.getName()));
            this.appendSubstitutableColumnClause(stringBuffer, columnProxyOraclev10g, bl, false);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "STORE AS");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getNtStorageTable());
            if (!columnProxyOraclev10g.getAdditionalNTS().equals("")) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getAdditionalNTS());
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
            if (!columnProxyOraclev10g.getNtReturn().equals("")) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "RETURN");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "AS");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getNtReturn());
            }
        }
    }

    private void appendSubstitutableColumnClause(StringBuffer stringBuffer, ColumnProxyOraclev10g columnProxyOraclev10g, boolean bl, boolean bl2) {
        Column column = columnProxyOraclev10g.getColumn();
        Table table = (Table)column.getContainerWithKeyObject();
        if (table.isBST() && !table.isSubstitutable()) {
            return;
        }
        if (!column.isReference()) {
            if (column.isAllowSubtypeSubstitution()) {
                if (bl2 && (column.isRestrictedTypeSubstitution() && column.getPermittedSubTypes().size() == 1 || columnProxyOraclev10g.getSubtitutable().equals("ONLY FOR TYPE"))) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "COLUMN");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev10g.getName()));
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "IS");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "OF");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "TYPE");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ONLY");
                    if (column.isRestrictedTypeSubstitution() && column.getPermittedSubTypes().size() == 1) {
                        StructuredType structuredType = (StructuredType)column.getPermittedSubTypes().get(0);
                        StructuredTypeProxyOracle structuredTypeProxyOracle = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(structuredType);
                        if (structuredTypeProxyOracle != null) {
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(structuredTypeProxyOracle.getLongName()));
                        } else {
                            SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(structuredType.getName()));
                        }
                    } else {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, columnProxyOraclev10g.getElementType());
                    }
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                } else if (columnProxyOraclev10g.getSubtitutable().equals("YES") || columnProxyOraclev10g.getSubtitutable().equals("NO")) {
                    if (bl2) {
                        SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "COLUMN");
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev10g.getName()));
                    }
                    if (columnProxyOraclev10g.getSubtitutable().equals("NO")) {
                        SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOT");
                    }
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SUBSTITUTABLE");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "AT");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ALL");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LEVELS");
                }
            } else {
                if (bl2) {
                    SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "COLUMN");
                    SSBTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev10g.getName()));
                }
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "NOT");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "SUBSTITUTABLE");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "AT");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "ALL");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "LEVELS");
            }
        }
    }

    private boolean hasVarrayClause(ColumnProxyOraclev10g columnProxyOraclev10g) {
        return !columnProxyOraclev10g.getSubtitutable().equals("") || !columnProxyOraclev10g.getLobSegname().equals("");
    }

    private String getPermissionsON(PermissionsOracle permissionsOracle) {
        if (permissionsOracle.getTable() != null) {
            return permissionsOracle.getTable().getLongName();
        }
        if (permissionsOracle.getColumnsTable() != null) {
            return permissionsOracle.getColumnsTable().getLongName();
        }
        if (permissionsOracle.getView() != null) {
            return permissionsOracle.getView().getLongName();
        }
        if (permissionsOracle.getSequence() != null) {
            return permissionsOracle.getSequence().getLongName();
        }
        if (permissionsOracle.getSnapshot() != null) {
            return permissionsOracle.getSnapshot().getLongName();
        }
        if (permissionsOracle.getProc() != null) {
            return permissionsOracle.getProc().getLongName();
        }
        if (permissionsOracle.getDirectoryOracle() != null) {
            return permissionsOracle.getDirectoryOracle().getLongName();
        }
        if (permissionsOracle.getStructuredTypeOracle() != null) {
            return permissionsOracle.getStructuredTypeOracle().getLongName();
        }
        if (permissionsOracle.getCollectionTypeOracle() != null) {
            return permissionsOracle.getCollectionTypeOracle().getLongName();
        }
        if (permissionsOracle.getExternalTableOracle() != null) {
            return permissionsOracle.getExternalTableOracle().getLongName();
        }
        return "";
    }

    private String getPermissionsTO(PermissionsOracle permissionsOracle) {
        if (permissionsOracle.getUser() != null) {
            return permissionsOracle.getUser().getLongName();
        }
        if (permissionsOracle.getRole() != null) {
            return permissionsOracle.getRole().getLongName();
        }
        return "";
    }

    private void appendColumnCheckConstraints(StringBuffer stringBuffer, TableProxy tableProxy, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            Column column = columnProxy.getColumn();
            if (!column.hasConstraintsDefined()) continue;
            String string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName()));
            if (string.equals("")) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "--  WARNING: Column " + tableProxy.getName() + "." + columnProxy.getName() + " has no check constraint defined for this database type");
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                DDLFileMaker.incrementWarnings();
                continue;
            }
            String string2 = column.getConstraintName();
            if (string2.length() > tableProxy.getMaxNameLength()) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "--  ERROR: Column " + tableProxy.getName() + "." + columnProxy.getName() + " check constraint name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                DDLFileMaker.incrementErrors();
            }
            if (SSBTableOraclev10g.willGenerateInlineColumnConstrOra(column, columnProxy)) continue;
            String string3 = this.storageDesign.getFormatedName(tableProxy.getLongName());
            SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, string3);
            SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "ADD");
            if (!"".equals(string2)) {
                string2 = this.storageDesign.getFormatedName(string2);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, string2);
            }
            SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "CHECK");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, '(');
            SSBTableOraclev10g.appendString(stringBuffer2, string);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, ')');
            SSBTableOraclev10g.appendConstraintState(stringBuffer2, (ColumnProxyOracle)columnProxy, false, bl);
            String string4 = "Alter Table " + string3 + " Add Check Constraint " + string2;
            this.appendToBuffer(stringBuffer, stringBuffer2, string4);
            SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            stringBuffer2.append(';');
            SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, "");
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void appendTableLevelCheckConstraints(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = tableProxyOraclev10g.getTableCheckConstraints().iterator();
        while (iterator.hasNext()) {
            TableCheckConstraintOracle tableCheckConstraintOracle = (TableCheckConstraintOracle)iterator.next();
            String string = tableCheckConstraintOracle.getTableConstraint().getRule();
            String string2 = tableCheckConstraintOracle.getName();
            if (string2.toUpperCase().startsWith("SYS_")) {
                string2 = "";
            }
            if ("".equals(string2) || "".equals(string)) continue;
            SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            if (string2.length() > tableProxyOraclev10g.getMaxNameLength()) {
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBTableOraclev10g.appendStringWithSpace(stringBuffer, "--  ERROR: Table constraint name length exceeds maximum allowed length(" + tableProxyOraclev10g.getMaxNameLength() + ")");
                SSBTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
                DDLFileMaker.incrementErrors();
            }
            String string3 = this.storageDesign.getFormatedName(string2);
            String string4 = this.storageDesign.getFormatedName(tableProxyOraclev10g.getLongName());
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, string4);
            SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "ADD");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, string3);
            SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 1);
            SSBTableOraclev10g.appendStringWithSpace(stringBuffer2, "CHECK");
            SSBTableOraclev10g.appendString(stringBuffer2, '(');
            SSBTableOraclev10g.appendString(stringBuffer2, string);
            SSBTableOraclev10g.appendString(stringBuffer2, ')');
            this.appendTableConstraintState(stringBuffer2, tableCheckConstraintOracle, bl);
            String string5 = "Alter Table " + string4 + " Add Constraint " + string3;
            this.appendToBuffer(stringBuffer, stringBuffer2, string5);
            SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            stringBuffer2.append(';');
            SSBTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, "");
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void appendIndexesForConstraints(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle) {
        KeyObject[] keyObjectArray = table.getKeys();
        boolean bl = table.getDesign().getDLSettings().isAutomaticPKGeneration();
        boolean bl2 = table.getDesign().getDLSettings().isAutomaticUKGeneration();
        boolean bl3 = table.getDesign().getDLSettings().isAutomaticFKGeneration();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            Object object;
            ContainedObject[] containedObjectArray;
            Object object2;
            Index index = (Index)keyObjectArray[i];
            if (bl2 && "Unique Constraint".equals(index.getIndexState()) || index.isFK() && bl3) {
                object2 = index.getElements();
                if (((ContainedObject[])object2).length <= 0 || (containedObjectArray = SSBTableOraclev10g.getIndexUsableForColumns(table, index, (ContainedObject[])object2, true)) != null) continue;
                object = this.getSSBIndex();
                ((SSBIndexOraclev10g)object).appendIndexForConstraint(stringBuffer, index, true);
                continue;
            }
            if (!bl || !"Primary Constraint".equals(index.getIndexState()) || "INDEX".equalsIgnoreCase(tableProxyOracle.getOrganization()) || (object2 = tableProxyOracle.getSnapshot()) != null && !((SnapshotOracle)object2).getWith().equalsIgnoreCase("ROWID") && ((SnapshotOracle)object2).getRefresh().equals("YES") || (containedObjectArray = index.getElements()).length <= 0 || (object = this.getIndexForColumns(table, index, containedObjectArray, true)) != null) continue;
            SSBIndexOraclev10g sSBIndexOraclev10g = this.getSSBIndex();
            sSBIndexOraclev10g.appendIndexForConstraint(stringBuffer, index, true);
        }
    }

    private Index getIndexForColumns(Table table, Index index, ContainedObject[] containedObjectArray, boolean bl) {
        Object[] objectArray = table.getIndexes().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObjectPlaceHolder designObjectPlaceHolder = (DesignObjectPlaceHolder)objectArray[i];
            Index index2 = (Index)designObjectPlaceHolder.getDesignObject();
            ContainedObject[] containedObjectArray2 = index2.getElements();
            if (containedObjectArray.length != containedObjectArray2.length) continue;
            boolean bl2 = false;
            for (int j = 0; j < containedObjectArray.length; ++j) {
                String string;
                if (containedObjectArray[j] != containedObjectArray2[j]) {
                    bl2 = true;
                    break;
                }
                if (!bl || "ASC".equalsIgnoreCase(string = index2.getColumnSortOrder(containedObjectArray2[j]).trim()) || "".equalsIgnoreCase(string)) continue;
                bl2 = true;
                break;
            }
            if (bl2 || index2 == index) continue;
            return index2;
        }
        return null;
    }

    public static Index getIndexUsableForColumns(Table table, Index index, ContainedObject[] containedObjectArray, boolean bl) {
        Object[] objectArray = table.getIndexes().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObjectPlaceHolder designObjectPlaceHolder = (DesignObjectPlaceHolder)objectArray[i];
            Index index2 = (Index)designObjectPlaceHolder.getDesignObject();
            ContainedObject[] containedObjectArray2 = index2.getElements();
            if (containedObjectArray.length > containedObjectArray2.length || index2 == index) continue;
            boolean bl2 = false;
            for (int j = 0; j < containedObjectArray.length; ++j) {
                ContainedObject containedObject = null;
                for (int k = 0; k < containedObjectArray2.length; ++k) {
                    if (containedObjectArray[j] != containedObjectArray2[k]) continue;
                    containedObject = containedObjectArray2[k];
                    break;
                }
                if (containedObject != null) {
                    String string;
                    if (!bl || "ASC".equalsIgnoreCase(string = index2.getColumnSortOrder(containedObject).trim()) || "".equalsIgnoreCase(string)) continue;
                    bl2 = true;
                    break;
                }
                bl2 = true;
                break;
            }
            if (bl2 || index2 == index) continue;
            return index2;
        }
        return null;
    }

    protected SSBIndexOraclev10g getSSBIndex() {
        if (this.ssbIndex == null) {
            this.ssbIndex = new SSBIndexOraclev10g();
            this.ssbIndex.setStorageDesign(this.storageDesign);
        }
        return this.ssbIndex;
    }

    public static boolean willGenerateInlineColumnConstrOra(Column column, ColumnProxy columnProxy) {
        String string;
        String string2;
        if (column.hasConstraintsDefined() && !"".equals(string2 = column.getConstraintsText(column.getName())) && ("".equals(string = column.getConstraintName().toUpperCase()) || string.startsWith("SYS_") || string.length() > 30 || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC())) {
            if (columnProxy instanceof ColumnProxyOracle) {
                return ((ColumnProxyOracle)columnProxy).getExceptionsTable() == null;
            }
            return true;
        }
        return false;
    }

    public SSBArcFK_CheckConstr getArcConstrHandler() {
        if (this.arcConstrHandler == null && this.storageDesign != null) {
            this.arcConstrHandler = new SSBArcFK_CheckConstr(this.storageDesign);
        }
        return this.arcConstrHandler;
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((PartitionOraclev10g)object).getPosition() > ((PartitionOraclev10g)object2).getPosition()) {
                return 1;
            }
            if (((PartitionOraclev10g)object).getPosition() < ((PartitionOraclev10g)object2).getPosition()) {
                return -1;
            }
            return 0;
        }
    }

    static class GlobalPossitionComparator
    implements Comparator {
        GlobalPossitionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((IndexGlobalPartitionOraclev10g)object).getPosition() > ((IndexGlobalPartitionOraclev10g)object2).getPosition()) {
                return 1;
            }
            if (((IndexGlobalPartitionOraclev10g)object).getPosition() < ((IndexGlobalPartitionOraclev10g)object2).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

