/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PermissionsOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SequenceOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSequenceOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        SequenceOraclev10g sequenceOraclev10g = (SequenceOraclev10g)object;
        this.storageDesign = sequenceOraclev10g.getStorageDesign();
        this.appendComment(stringBuffer2, sequenceOraclev10g);
        SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer2, "CREATE");
        SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer2, "SEQUENCE");
        SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(sequenceOraclev10g.getLongName()));
        string = stringBuffer2.toString();
        this.appendStartWith(stringBuffer2, sequenceOraclev10g, bl);
        this.appendIncrementBy(stringBuffer2, sequenceOraclev10g, bl);
        this.appendMaxValue(stringBuffer2, sequenceOraclev10g, bl);
        this.appendMinValue(stringBuffer2, sequenceOraclev10g, bl);
        this.appendCycle(stringBuffer2, sequenceOraclev10g, bl);
        this.appendCache(stringBuffer2, sequenceOraclev10g, bl);
        this.appendOrder(stringBuffer2, sequenceOraclev10g, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        SSBSequenceOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        DDLFileMaker.incrementCreateSequence();
        this.appendPermissions(stringBuffer, sequenceOraclev10g, bl);
        SSBSequenceOraclev10g.appendNewLine(stringBuffer, bl, 0);
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SequenceOraclev10g && ((SequenceOraclev10g)object).isMarkedGenerate();
    }

    private void appendStartWith(StringBuffer stringBuffer, SequenceOraclev10g sequenceOraclev10g, boolean bl) {
        if (this.isNotEmpty(sequenceOraclev10g.getStartWith())) {
            SSBSequenceOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, "START");
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, "WITH");
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, sequenceOraclev10g.getStartWith());
        }
    }

    private void appendIncrementBy(StringBuffer stringBuffer, SequenceOraclev10g sequenceOraclev10g, boolean bl) {
        if (this.isNotEmpty(sequenceOraclev10g.getIncrementBy())) {
            SSBSequenceOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, "INCREMENT");
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, sequenceOraclev10g.getIncrementBy());
        }
    }

    private void appendMaxValue(StringBuffer stringBuffer, SequenceOraclev10g sequenceOraclev10g, boolean bl) {
        if (this.isNotEmpty(sequenceOraclev10g.getMaxValue())) {
            SSBSequenceOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, "MAXVALUE");
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, sequenceOraclev10g.getMaxValue());
        }
    }

    private void appendMinValue(StringBuffer stringBuffer, SequenceOraclev10g sequenceOraclev10g, boolean bl) {
        if (this.isNotEmpty(sequenceOraclev10g.getMinValue())) {
            SSBSequenceOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, "MINVALUE");
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, sequenceOraclev10g.getMinValue());
        }
    }

    private void appendCycle(StringBuffer stringBuffer, SequenceOraclev10g sequenceOraclev10g, boolean bl) {
        if ("YES".equalsIgnoreCase(sequenceOraclev10g.getCycle())) {
            SSBSequenceOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, "CYCLE");
        }
    }

    private void appendCache(StringBuffer stringBuffer, SequenceOraclev10g sequenceOraclev10g, boolean bl) {
        if ("YES".equals(sequenceOraclev10g.getNoCache())) {
            SSBSequenceOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, "NOCACHE");
        } else if (this.isNotEmpty(sequenceOraclev10g.getCache())) {
            SSBSequenceOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, "CACHE");
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, sequenceOraclev10g.getCache());
        }
    }

    private void appendOrder(StringBuffer stringBuffer, SequenceOraclev10g sequenceOraclev10g, boolean bl) {
        if ("YES".equalsIgnoreCase(sequenceOraclev10g.getOrder())) {
            SSBSequenceOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, "ORDER");
        }
    }

    private void appendPermissions(StringBuffer stringBuffer, SequenceOraclev10g sequenceOraclev10g, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        PermissionsSetOracle permissionsSetOracle = ((StorageDesignOracle)sequenceOraclev10g.getStorageDesign()).getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        while (iterator.hasNext()) {
            PermissionsOraclev10g permissionsOraclev10g = (PermissionsOraclev10g)iterator.next();
            if (permissionsOraclev10g.getSequence() != null && permissionsOraclev10g.getSequence().equals(sequenceOraclev10g) && !permissionsOraclev10g.getPrivileges().equalsIgnoreCase("")) {
                SSBSequenceOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBSequenceOraclev10g.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, permissionsOraclev10g);
                SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer2, "GRANT");
                SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer2, permissionsOraclev10g.getPrivileges());
                this.appendObject(stringBuffer2, permissionsOraclev10g, bl);
                this.appendTo(stringBuffer2, permissionsOraclev10g);
                string = stringBuffer2.toString();
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev10g, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBSequenceOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                SSBSequenceOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
            if (permissionsOraclev10g.getSequence() == null || !permissionsOraclev10g.getSequence().equals(sequenceOraclev10g) || permissionsOraclev10g.getPrivilegesWithGrantOption().equalsIgnoreCase("")) continue;
            SSBSequenceOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            SSBSequenceOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendComment(stringBuffer2, permissionsOraclev10g);
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer2, "GRANT");
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer2, permissionsOraclev10g.getPrivilegesWithGrantOption());
            this.appendObject(stringBuffer2, permissionsOraclev10g, bl);
            this.appendTo(stringBuffer2, permissionsOraclev10g);
            this.appendGrantOption(stringBuffer2, permissionsOraclev10g);
            string = stringBuffer2.toString();
            this.appendHierrarchyOption(stringBuffer2, permissionsOraclev10g, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBSequenceOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            stringBuffer2.append(';');
            SSBSequenceOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
    }

    private void appendObject(StringBuffer stringBuffer, PermissionsOraclev10g permissionsOraclev10g, boolean bl) {
        if (permissionsOraclev10g.getSequence() != null) {
            SSBSequenceOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getSequence().getLongName()));
        }
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOraclev10g permissionsOraclev10g) {
        SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, "TO");
        if ("YES".equalsIgnoreCase(permissionsOraclev10g.getPublic())) {
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else {
            if (permissionsOraclev10g.getUser() != null) {
                SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getUser().getName()));
            }
            if (permissionsOraclev10g.getRole() != null) {
                SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getRole().getName()));
            }
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOraclev10g permissionsOraclev10g) {
        if (permissionsOraclev10g.getRole() == null) {
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer stringBuffer, PermissionsOraclev10g permissionsOraclev10g, boolean bl) {
        if ("YES".equalsIgnoreCase(permissionsOraclev10g.getHierarchyOption())) {
            SSBSequenceOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSequenceOraclev10g.appendStringWithSpace(stringBuffer, "WITH HIERARCHY OPTION");
        }
    }
}

