/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ExternalTableColumnOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ExternalTableOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBExternalTableOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        ExternalTableOraclev10g externalTableOraclev10g = (ExternalTableOraclev10g)object;
        this.storageDesign = externalTableOraclev10g.getStorageDesign();
        if (externalTableOraclev10g.getColumns().size() != 0) {
            this.appendComment(stringBuffer, externalTableOraclev10g);
            this.appendCreate(stringBuffer2, externalTableOraclev10g);
            string = stringBuffer2.toString();
            this.appendElementList(stringBuffer2, externalTableOraclev10g, bl);
            this.appendExternalTableClause(stringBuffer2, externalTableOraclev10g, bl);
            this.appendRejectLimit(stringBuffer2, externalTableOraclev10g, bl);
            this.appendParallel(stringBuffer2, externalTableOraclev10g, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBExternalTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            this.appendPermissions(stringBuffer, externalTableOraclev10g);
            DDLFileMaker.incrementCreateTable();
        } else {
            SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("-- Error - External table ");
            stringBuffer.append(this.storageDesign.getFormatedName(externalTableOraclev10g.getName()));
            stringBuffer.append(" has no columns");
            DDLFileMaker.incrementErrors();
            SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendCreate(StringBuffer stringBuffer, ExternalTableOraclev10g externalTableOraclev10g) {
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "CREATE");
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "TABLE");
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(externalTableOraclev10g.getLongName()));
    }

    private void appendElementList(StringBuffer stringBuffer, ExternalTableOraclev10g externalTableOraclev10g, boolean bl) {
        SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
        StorageObjectCollection storageObjectCollection = externalTableOraclev10g.getColumns();
        ExternalTableColumnOraclev10g externalTableColumnOraclev10g = null;
        for (int i = 0; i < storageObjectCollection.size(); ++i) {
            if (i == 0) {
                SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            } else {
                SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, ',');
                SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            }
            externalTableColumnOraclev10g = (ExternalTableColumnOraclev10g)storageObjectCollection.getElement(i);
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(externalTableColumnOraclev10g.getName()));
            String string = externalTableColumnOraclev10g.getDatatype();
            if (string.startsWith("TIMESTAMP")) {
                SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "TIMESTAMP");
                if (externalTableColumnOraclev10g.getPrecision() > 0) {
                    stringBuffer.append('(').append(externalTableColumnOraclev10g.getPrecision());
                    SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
                if (string.indexOf("WITH") <= -1) continue;
                SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, string.substring(10));
                continue;
            }
            if (string.equalsIgnoreCase("INTERVAL YEAR TO MONTH")) {
                SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "INTERVAL YEAR");
                if (externalTableColumnOraclev10g.getPrecision() > 0) {
                    stringBuffer.append('(').append(externalTableColumnOraclev10g.getPrecision());
                    SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
                SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "TO MONTH");
                continue;
            }
            if (string.equalsIgnoreCase("INTERVAL DAY TO SECOND")) {
                SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "INTERVAL DAY");
                if (externalTableColumnOraclev10g.getPrecision() > 0) {
                    stringBuffer.append('(').append(externalTableColumnOraclev10g.getPrecision());
                    SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
                SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "TO SECOND");
                if (externalTableColumnOraclev10g.getScale() <= 0) continue;
                stringBuffer.append('(').append(externalTableColumnOraclev10g.getScale());
                SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                continue;
            }
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, string);
            if (string.indexOf("CHAR") > -1 || string.equals("RAW") || string.equals("UROWID")) {
                if (externalTableColumnOraclev10g.getSize() <= 0) continue;
                stringBuffer.append('(').append(externalTableColumnOraclev10g.getSize());
                if (!externalTableColumnOraclev10g.getUnits().equalsIgnoreCase("") && (string.equalsIgnoreCase("CHAR") || string.equalsIgnoreCase("VARCHAR2") || string.equalsIgnoreCase("VARCHAR"))) {
                    stringBuffer.append(' ').append(externalTableColumnOraclev10g.getUnits());
                }
                SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
                continue;
            }
            if (externalTableColumnOraclev10g.getPrecision() <= 0) continue;
            stringBuffer.append('(').append(externalTableColumnOraclev10g.getPrecision());
            if (externalTableColumnOraclev10g.getScale() != 0) {
                SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, ',');
                stringBuffer.append(externalTableColumnOraclev10g.getScale());
            }
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
        SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
    }

    private void appendExternalTableClause(StringBuffer stringBuffer, ExternalTableOraclev10g externalTableOraclev10g, boolean bl) {
        SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "ORGANIZATION");
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "EXTERNAL");
        SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
        if (!"".equalsIgnoreCase(externalTableOraclev10g.getAccessDriverType().trim())) {
            SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "TYPE");
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, externalTableOraclev10g.getAccessDriverType());
        }
        if (externalTableOraclev10g.getDefaultDir() != null) {
            SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "DEFAULT");
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "DIRECTORY");
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(externalTableOraclev10g.getDefaultDir().getName()));
        }
        if (externalTableOraclev10g.getAccessParametersType().equalsIgnoreCase("Opaque Format Spec")) {
            SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "ACCESS");
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "PARAMETERS");
            SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, externalTableOraclev10g.getOpaqueFormatSpec());
            SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        } else if (externalTableOraclev10g.getAccessParametersType().equalsIgnoreCase("CLOB Subquery")) {
            SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "ACCESS");
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "PARAMETERS");
            SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "USING");
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "CLOB");
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, externalTableOraclev10g.getClobSubquery());
        }
        SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "LOCATION");
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, '(');
        if (!externalTableOraclev10g.getLocation().startsWith("'")) {
            SSBExternalTableOraclev10g.appendString(stringBuffer, '\'');
        }
        SSBExternalTableOraclev10g.appendString(stringBuffer, externalTableOraclev10g.getLocation());
        if (!externalTableOraclev10g.getLocation().endsWith("'")) {
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, '\'');
        }
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
        SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, ')');
    }

    private void appendParallel(StringBuffer stringBuffer, ExternalTableOraclev10g externalTableOraclev10g, boolean bl) {
        if (externalTableOraclev10g.getParallel().equalsIgnoreCase("PARALLEL")) {
            SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, externalTableOraclev10g.getParallel());
            this.appendStringWithSpace(stringBuffer, externalTableOraclev10g.getParallelNum());
        }
    }

    private void appendRejectLimit(StringBuffer stringBuffer, ExternalTableOraclev10g externalTableOraclev10g, boolean bl) {
        SSBExternalTableOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "REJECT");
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "LIMIT");
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, externalTableOraclev10g.getRejectLimit());
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof ExternalTableOraclev10g && ((ExternalTableOraclev10g)object).isMarkedGenerate();
    }

    protected void appendPermissions(StringBuffer stringBuffer, ExternalTableOracle externalTableOracle) {
        StorageDesignOracle storageDesignOracle = externalTableOracle.getStorageDesignOracle();
        StringBuffer stringBuffer2 = new StringBuffer();
        PermissionsSetOracle permissionsSetOracle = storageDesignOracle.getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (!externalTableOracle.equals(permissionsOracle.getExternalTableOracle()) || permissionsOracle.getUser() == null && permissionsOracle.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissionsOracle.getPrivileges())) {
                this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, externalTableOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissionsOracle.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, externalTableOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer stringBuffer, StringBuffer stringBuffer2, PermissionsOracle permissionsOracle, ExternalTableOracle externalTableOracle, StorageDesignOracle storageDesignOracle, boolean bl) {
        stringBuffer2.append(NEWLINE);
        this.appendComment(stringBuffer2, permissionsOracle);
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer2, "GRANT");
        if (bl) {
            stringBuffer2.append(permissionsOracle.getPrivilegesWithGrantOption());
        } else {
            stringBuffer2.append(permissionsOracle.getPrivileges());
        }
        this.appendObject(stringBuffer2, externalTableOracle, storageDesignOracle);
        this.appendTo(stringBuffer2, permissionsOracle, storageDesignOracle);
        if (bl) {
            this.appendGrantOption(stringBuffer2, permissionsOracle);
        }
        String string = stringBuffer2.toString();
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(';');
        stringBuffer2.append(NEWLINE);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
    }

    private void appendObject(StringBuffer stringBuffer, ExternalTableOracle externalTableOracle, StorageDesign storageDesign) {
        stringBuffer.append(NEWLINE);
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "ON");
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(externalTableOracle.getLongName()));
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOracle permissionsOracle, StorageDesign storageDesign) {
        SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "TO");
        if ("YES".equalsIgnoreCase(permissionsOracle.getPublic())) {
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else if (permissionsOracle.getUser() != null) {
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getUser().getName()));
        } else if (permissionsOracle.getRole() != null) {
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getRole().getName()));
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOracle permissionsOracle) {
        if (permissionsOracle.getRole() == null) {
            SSBExternalTableOraclev10g.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }
}

