/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RedoLogGroupOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RedoLogGroupSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataBaseOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UndoTablespaceOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDataBaseOraclev10g
extends AbstractSSBOracle {
    public static final String COMMENT = " -- ";
    private StorageDesignOracle storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DataBaseOraclev10g && ((DataBaseOraclev10g)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        DataBaseOraclev10g dataBaseOraclev10g = (DataBaseOraclev10g)object;
        this.storageDesign = (StorageDesignOracle)dataBaseOraclev10g.getStorageDesign();
        this.appendComment(stringBuffer, dataBaseOraclev10g);
        SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, COMMENT);
        SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "CREATE");
        SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "DATABASE");
        this.appendStringWithSpace(stringBuffer, dataBaseOraclev10g);
        this.appendSysPass(stringBuffer, dataBaseOraclev10g, bl);
        this.appendSystemPass(stringBuffer, dataBaseOraclev10g, bl);
        this.appendControlFileReuse(stringBuffer, dataBaseOraclev10g);
        this.appendLogFiles(stringBuffer, dataBaseOraclev10g);
        this.appendMaxLogFiles(stringBuffer, dataBaseOraclev10g);
        this.appendMaxLogMembers(stringBuffer, dataBaseOraclev10g);
        this.appendMaxLogHistory(stringBuffer, dataBaseOraclev10g);
        this.appendMaxDataFiles(stringBuffer, dataBaseOraclev10g);
        this.appendMaxInstances(stringBuffer, dataBaseOraclev10g);
        this.appendArchiveLog(stringBuffer, dataBaseOraclev10g);
        this.appendForceLogging(stringBuffer, dataBaseOraclev10g, bl);
        this.appendCharacterSet(stringBuffer, dataBaseOraclev10g);
        this.appendNationalCharacterSet(stringBuffer, dataBaseOraclev10g);
        this.appendDataFiles(stringBuffer, dataBaseOraclev10g);
        this.appendExtentManagement(stringBuffer, dataBaseOraclev10g, bl);
        this.appendSysAuxDataFiles(stringBuffer, dataBaseOraclev10g);
        this.appendTempTablespace(stringBuffer, dataBaseOraclev10g, bl);
        this.appendUndoTablespace(stringBuffer, dataBaseOraclev10g, bl);
        this.appendTimeZone(stringBuffer, dataBaseOraclev10g, bl);
        SSBDataBaseOraclev10g.appendNewLine(stringBuffer, bl, 0);
        DDLFileMaker.incrementCreateDatabase();
    }

    private void appendSysPass(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g, boolean bl) {
        if (!"".equalsIgnoreCase(dataBaseOraclev10g.getPassForSYS())) {
            SSBDataBaseOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "USER");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "SYS");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "IDENTIFIED");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, dataBaseOraclev10g.getPassForSYS());
        }
    }

    private void appendSystemPass(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g, boolean bl) {
        if (!"".equalsIgnoreCase(dataBaseOraclev10g.getPassForSYSTEM())) {
            SSBDataBaseOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "USER");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "SYSTEM");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "IDENTIFIED");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, dataBaseOraclev10g.getPassForSYSTEM());
        }
    }

    private void appendControlFileReuse(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g) {
        String string = dataBaseOraclev10g.getControlFileReuse();
        if (string.equalsIgnoreCase("YES")) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append(COMMENT).append("    ").append("CONTROLFILE REUSE");
        }
    }

    private void appendLogFiles(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g) {
        RedoLogGroupSetOracle redoLogGroupSetOracle = this.storageDesign.getRedoLogGroupSet();
        Iterator iterator = redoLogGroupSetOracle.iterator();
        int n = 0;
        boolean bl = false;
        while (iterator.hasNext()) {
            RedoLogGroupOracle redoLogGroupOracle = (RedoLogGroupOracle)iterator.next();
            if (redoLogGroupOracle.getDataBase() == null || !redoLogGroupOracle.getDataBase().toString().equalsIgnoreCase(dataBaseOraclev10g.toString())) continue;
            ++n;
            if (!bl) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append(COMMENT).append("    ").append("LOGFILE");
                bl = true;
            } else {
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, ',');
            }
            stringBuffer.append(NEWLINE).append(COMMENT).append("    ").append("    ");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "GROUP");
            this.appendStringWithSpace(stringBuffer, n);
            if (!"".equalsIgnoreCase(redoLogGroupOracle.getFileName())) {
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBDataBaseOraclev10g.appendString(stringBuffer, '\'');
                SSBDataBaseOraclev10g.appendString(stringBuffer, redoLogGroupOracle.getFileName());
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, '\'');
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "SIZE");
            this.appendStringWithSpace(stringBuffer, redoLogGroupOracle.getSize());
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, redoLogGroupOracle.getMeasureUnit());
            if (!redoLogGroupOracle.getReuse().equalsIgnoreCase("YES")) continue;
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "REUSE");
        }
    }

    private void appendMaxLogFiles(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g) {
        int n = dataBaseOraclev10g.getMaxLogFiles();
        stringBuffer.append(NEWLINE);
        stringBuffer.append(COMMENT).append("    ");
        SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "MAXLOGFILES");
        this.appendStringWithSpace(stringBuffer, n);
    }

    private void appendMaxLogMembers(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g) {
        int n = dataBaseOraclev10g.getMaxLogMembers();
        stringBuffer.append(NEWLINE);
        stringBuffer.append(COMMENT).append("    ");
        SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "MAXLOGMEMBERS");
        this.appendStringWithSpace(stringBuffer, n);
    }

    private void appendMaxLogHistory(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g) {
        int n = dataBaseOraclev10g.getMaxLogHistory();
        stringBuffer.append(NEWLINE);
        stringBuffer.append(COMMENT).append("    ");
        SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "MAXLOGHISTORY");
        this.appendStringWithSpace(stringBuffer, n);
    }

    private void appendMaxDataFiles(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g) {
        int n = dataBaseOraclev10g.getMaxDataFiles();
        stringBuffer.append(NEWLINE);
        stringBuffer.append(COMMENT).append("    ");
        SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "MAXDATAFILES");
        this.appendStringWithSpace(stringBuffer, n);
    }

    private void appendMaxInstances(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g) {
        int n = dataBaseOraclev10g.getMaxInstances();
        stringBuffer.append(NEWLINE);
        stringBuffer.append(COMMENT).append("    ");
        SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "MAXINSTANCES");
        this.appendStringWithSpace(stringBuffer, n);
    }

    private void appendArchiveLog(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g) {
        String string = dataBaseOraclev10g.getArchiveLog();
        if (string != null && string.equalsIgnoreCase("YES")) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append(COMMENT).append("    ");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "ARCHIVELOG");
        }
    }

    private void appendForceLogging(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g, boolean bl) {
        if ("NO".equalsIgnoreCase(dataBaseOraclev10g.getForceLogging())) {
            SSBDataBaseOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "FORCE");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
        }
    }

    private void appendCharacterSet(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g) {
        String string = dataBaseOraclev10g.getCharacterSet();
        if (!"".equalsIgnoreCase(string)) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append(COMMENT).append("    ").append("CHARACTER SET ").append(string);
        }
    }

    private void appendNationalCharacterSet(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g) {
        String string = dataBaseOraclev10g.getNationalCharacterSet();
        if (!"".equalsIgnoreCase(string)) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append(COMMENT).append("    ").append("NATIONAL CHARACTER SET ").append(string);
        }
    }

    private void appendDataFiles(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g) {
        DataFileSetOracle dataFileSetOracle = this.storageDesign.getDataFileSet();
        Iterator iterator = dataFileSetOracle.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            DataFileOracle dataFileOracle = (DataFileOracle)iterator.next();
            if (dataFileOracle.getDataBase() == null || !dataFileOracle.getDataBase().toString().equalsIgnoreCase(dataBaseOraclev10g.toString())) continue;
            if (!bl) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append(COMMENT).append("    ");
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "DATAFILE");
                bl = true;
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(NEWLINE);
            stringBuffer.append(COMMENT).append("    ").append("    ");
            SSBDataBaseOraclev10g.appendString(stringBuffer, '\'');
            SSBDataBaseOraclev10g.appendString(stringBuffer, dataFileOracle.getFileName());
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, '\'');
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "SIZE");
            this.appendStringWithSpace(stringBuffer, dataFileOracle.getSize());
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, dataFileOracle.getMeasureUnit());
            if (dataFileOracle.getReuse().equalsIgnoreCase("YES")) {
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "REUSE");
            }
            if (!"ON".equalsIgnoreCase(dataFileOracle.getAutoextend()) && !"OFF".equalsIgnoreCase(dataFileOracle.getAutoextend())) continue;
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "AUTOEXTEND");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, dataFileOracle.getAutoextend());
            if (!dataFileOracle.getAutoextend().equalsIgnoreCase("ON")) continue;
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
            this.appendStringWithSpace(stringBuffer, dataFileOracle.getNextBlockSize());
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "K");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "MAXSIZE");
            if (dataFileOracle.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                stringBuffer.append("UNLIMITED");
                continue;
            }
            stringBuffer.append(dataFileOracle.getMaxSize()).append("K");
        }
    }

    private void appendSysAuxDataFiles(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g) {
        Iterator iterator = dataBaseOraclev10g.getSysAuxFiles().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            DataFileOraclev10g dataFileOraclev10g = (DataFileOraclev10g)iterator.next();
            if (!bl) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append(COMMENT).append("    ");
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "SYSAUX");
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "DATAFILE");
                bl = true;
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(NEWLINE);
            stringBuffer.append(COMMENT).append("    ").append("    ");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(dataFileOraclev10g.getName()));
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "SIZE");
            this.appendStringWithSpace(stringBuffer, dataFileOraclev10g.getSize());
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, dataFileOraclev10g.getMeasureUnit());
            if (dataFileOraclev10g.getReuse().equalsIgnoreCase("YES")) {
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "REUSE");
            }
            if (!"ON".equalsIgnoreCase(dataFileOraclev10g.getAutoextend()) && !"OFF".equalsIgnoreCase(dataFileOraclev10g.getAutoextend())) continue;
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "AUTOEXTEND");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, dataFileOraclev10g.getAutoextend());
            if (!dataFileOraclev10g.getAutoextend().equalsIgnoreCase("ON")) continue;
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
            this.appendStringWithSpace(stringBuffer, dataFileOraclev10g.getNextBlockSize());
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "K");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "MAXSIZE");
            if (dataFileOraclev10g.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "UNLIMITED");
                continue;
            }
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, dataFileOraclev10g.getMaxSize());
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "K");
        }
    }

    private void appendDataFiles(StringBuffer stringBuffer, UndoTablespaceOraclev10g undoTablespaceOraclev10g, boolean bl) {
        Iterator iterator = undoTablespaceOraclev10g.getDfiles().iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            DataFileOracle dataFileOracle = (DataFileOracle)iterator.next();
            if (!bl2) {
                SSBDataBaseOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, COMMENT);
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "DATAFILE");
                bl2 = true;
            } else {
                stringBuffer.append(',');
            }
            SSBDataBaseOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, COMMENT);
            stringBuffer.append("    ");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, this.addQuotes(dataFileOracle.getFileName(), true));
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "SIZE");
            this.appendStringWithSpace(stringBuffer, dataFileOracle.getSize());
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, dataFileOracle.getMeasureUnit());
            if (dataFileOracle.getReuse().equalsIgnoreCase("YES")) {
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "REUSE");
            }
            if (!"ON".equalsIgnoreCase(dataFileOracle.getAutoextend()) && !"OFF".equalsIgnoreCase(dataFileOracle.getAutoextend())) continue;
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "AUTOEXTEND");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, dataFileOracle.getAutoextend());
            if (!dataFileOracle.getAutoextend().equalsIgnoreCase("ON")) continue;
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
            this.appendStringWithSpace(stringBuffer, dataFileOracle.getNextBlockSize());
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "K");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "MAXSIZE");
            if (dataFileOracle.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                stringBuffer.append("UNLIMITED");
                continue;
            }
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, dataFileOracle.getMaxSize());
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "K");
        }
    }

    private void appendExtentManagement(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g, boolean bl) {
        if (dataBaseOraclev10g.getExtentManagement().equalsIgnoreCase("LOCAL")) {
            SSBDataBaseOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "EXTENT");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "MANAGEMENT");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "LOCAL");
        }
    }

    private void appendTempTablespace(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g, boolean bl) {
        if (dataBaseOraclev10g.getTempTablespace() != null) {
            TemporaryTablespaceOraclev10g temporaryTablespaceOraclev10g = (TemporaryTablespaceOraclev10g)dataBaseOraclev10g.getTempTablespace();
            SSBDataBaseOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "DEFAULT");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "TEMPORARY");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(temporaryTablespaceOraclev10g.getName()));
            this.appendTempFile(stringBuffer, temporaryTablespaceOraclev10g, bl);
            this.appendExtent(stringBuffer, temporaryTablespaceOraclev10g, bl);
        }
    }

    private void appendTempFile(StringBuffer stringBuffer, TemporaryTablespaceOraclev10g temporaryTablespaceOraclev10g, boolean bl) {
        if (!"".equalsIgnoreCase(temporaryTablespaceOraclev10g.getFilename().trim())) {
            SSBDataBaseOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "TEMPFILE");
            SSBDataBaseOraclev10g.appendString(stringBuffer, '\'');
            SSBDataBaseOraclev10g.appendString(stringBuffer, temporaryTablespaceOraclev10g.getFilename());
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, '\'');
            if (temporaryTablespaceOraclev10g.getSize() != 0L) {
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "SIZE");
                this.appendStringWithSpace(stringBuffer, temporaryTablespaceOraclev10g.getSize());
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, temporaryTablespaceOraclev10g.getMeasureUnitSize());
            }
            if ("YES".equalsIgnoreCase(temporaryTablespaceOraclev10g.getReuse())) {
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "REUSE");
            }
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "AUTOEXTEND");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, temporaryTablespaceOraclev10g.getAutoextend());
            if (temporaryTablespaceOraclev10g.getAutoextend().equalsIgnoreCase("ON")) {
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, temporaryTablespaceOraclev10g.getNextBlockSize());
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "K");
                SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "MAXSIZE");
                if (temporaryTablespaceOraclev10g.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "UNLIMITED");
                } else {
                    SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, temporaryTablespaceOraclev10g.getMaxSize());
                    SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "K");
                }
            }
        }
    }

    private void appendExtent(StringBuffer stringBuffer, TemporaryTablespaceOraclev10g temporaryTablespaceOraclev10g, boolean bl) {
        if (temporaryTablespaceOraclev10g.getUniformSize() != 0L) {
            SSBDataBaseOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "EXTENT");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "MANAGEMENT");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "LOCAL");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "UNIFORM");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "SIZE");
            this.appendStringWithSpace(stringBuffer, temporaryTablespaceOraclev10g.getUniformSize());
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, temporaryTablespaceOraclev10g.getMeasureUnitUniformSize());
        }
    }

    private void appendUndoTablespace(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g, boolean bl) {
        if (dataBaseOraclev10g.getUndoTablespace() != null) {
            UndoTablespaceOraclev10g undoTablespaceOraclev10g = (UndoTablespaceOraclev10g)dataBaseOraclev10g.getUndoTablespace();
            SSBDataBaseOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "UNDO");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(undoTablespaceOraclev10g.getName()));
            this.appendDataFiles(stringBuffer, undoTablespaceOraclev10g, bl);
        }
    }

    private void appendTimeZone(StringBuffer stringBuffer, DataBaseOraclev10g dataBaseOraclev10g, boolean bl) {
        if (!"".equalsIgnoreCase(dataBaseOraclev10g.getTimeZone())) {
            SSBDataBaseOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "SET");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, "TIME_ZONE");
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, '=');
            SSBDataBaseOraclev10g.appendString(stringBuffer, '\'');
            SSBDataBaseOraclev10g.appendString(stringBuffer, dataBaseOraclev10g.getTimeZone());
            SSBDataBaseOraclev10g.appendStringWithSpace(stringBuffer, '\'');
        }
    }
}

