/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBClusterOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        ClusterOraclev10g clusterOraclev10g = (ClusterOraclev10g)object;
        this.storageDesign = clusterOraclev10g.getStorageDesign();
        this.appendComment(stringBuffer, clusterOraclev10g);
        SSBClusterOraclev10g.appendStringWithSpace(stringBuffer2, "CREATE");
        SSBClusterOraclev10g.appendStringWithSpace(stringBuffer2, "CLUSTER");
        SSBClusterOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(clusterOraclev10g.getLongName()));
        string = stringBuffer2.toString();
        this.appendColumns(stringBuffer2, clusterOraclev10g, bl);
        this.appendAttributes(stringBuffer2, clusterOraclev10g.getSegment(), bl);
        this.appendSize(stringBuffer2, clusterOraclev10g, bl);
        this.appendTableSpace(stringBuffer2, clusterOraclev10g, bl);
        this.appendIndex(stringBuffer2, clusterOraclev10g, bl);
        this.appendParallel(stringBuffer2, clusterOraclev10g, bl);
        this.appendRowDependencies(stringBuffer2, clusterOraclev10g, bl);
        this.appendCache(stringBuffer2, clusterOraclev10g, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        SSBClusterOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        DDLFileMaker.incrementCreateCluster();
    }

    private void appendRowDependencies(StringBuffer stringBuffer, ClusterOraclev10g clusterOraclev10g, boolean bl) {
        SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 1);
        if ("YES".equalsIgnoreCase(clusterOraclev10g.getRowDependency())) {
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "ROWDEPENDENCIES");
        } else {
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "NOROWDEPENDENCIES");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof ClusterOraclev10g && ((ClusterOraclev10g)object).isMarkedGenerate();
    }

    private void appendColumns(StringBuffer stringBuffer, ClusterOraclev10g clusterOraclev10g, boolean bl) {
        ClusterColumnSetOracle clusterColumnSetOracle = ((StorageDesignOracle)clusterOraclev10g.getStorageDesign()).getClusterColumnSet();
        Object[] objectArray = clusterColumnSetOracle.toArray();
        Arrays.sort(objectArray, new ColumnComparator());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        Iterator iterator = arrayList.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            ClusterColumnOracle clusterColumnOracle = (ClusterColumnOracle)iterator.next();
            if (clusterColumnOracle.getCluster() == null || !clusterColumnOracle.getCluster().equals(clusterOraclev10g)) continue;
            if (bl2) {
                SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, '(');
                bl2 = false;
            } else {
                SSBClusterOraclev10g.appendString(stringBuffer, ',');
                SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, ' ');
            }
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(clusterColumnOracle.getName()));
            String string = clusterColumnOracle.getDataType();
            if (string.startsWith("TIMESTAMP")) {
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "TIMESTAMP");
                if (!clusterColumnOracle.getLengthPrecision().trim().equalsIgnoreCase("")) {
                    stringBuffer.append('(').append(clusterColumnOracle.getLengthPrecision());
                    SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
                if (string.indexOf("WITH") <= -1) continue;
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, string.substring(10));
                continue;
            }
            if (string.equalsIgnoreCase("INTERVAL YEAR TO MONTH")) {
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "INTERVAL YEAR");
                if (!clusterColumnOracle.getLengthPrecision().trim().equalsIgnoreCase("")) {
                    stringBuffer.append('(').append(clusterColumnOracle.getLengthPrecision());
                    SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "TO MONTH");
                continue;
            }
            if (string.equalsIgnoreCase("INTERVAL DAY TO SECOND")) {
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "INTERVAL DAY");
                if (!clusterColumnOracle.getLengthPrecision().trim().equalsIgnoreCase("")) {
                    stringBuffer.append('(').append(clusterColumnOracle.getLengthPrecision());
                    SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "TO SECOND");
                if (clusterColumnOracle.getScale() <= 0) continue;
                stringBuffer.append('(').append(clusterColumnOracle.getScale());
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, ')');
                continue;
            }
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, string);
            if (string.indexOf("CHAR") > -1) {
                if (clusterColumnOracle.getLengthPrecision().trim().equalsIgnoreCase("")) continue;
                stringBuffer.append('(').append(clusterColumnOracle.getLengthPrecision());
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, ')');
                continue;
            }
            if (clusterColumnOracle.getLengthPrecision().trim().equalsIgnoreCase("")) continue;
            stringBuffer.append('(').append(clusterColumnOracle.getLengthPrecision());
            if (clusterColumnOracle.getScale() != 0) {
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, ',');
                stringBuffer.append(clusterColumnOracle.getScale());
            }
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
        if (!bl2) {
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendAttributes(StringBuffer stringBuffer, SegmentOracle segmentOracle, boolean bl) {
        if (segmentOracle != null && segmentOracle.isMarkedGenerate()) {
            SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getPCTFree());
            SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "PCTUSED");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getPCTUsed());
            if (segmentOracle.getInitrans() > 1) {
                SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "INITRANS");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getInitrans());
            }
            SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "STORAGE");
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 2);
            if (segmentOracle.getSCInitialExtent() > 0L) {
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getSCInitialExtent());
                SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 2);
            }
            if (segmentOracle.getSCNextExtent() > 0L) {
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getSCNextExtent());
                SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 2);
            }
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCPctIncrease());
            SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCMinExtents());
            SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, segmentOracle.getSCMaxExtents());
            SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCFreeLists());
            SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "FREELIST");
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "GROUPS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCFreelistGroups());
            SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, segmentOracle.getSCBufferPool());
            SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendSize(StringBuffer stringBuffer, ClusterOraclev10g clusterOraclev10g, boolean bl) {
        int n = clusterOraclev10g.getSize();
        if (n > 0) {
            SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "SIZE");
            this.appendStringWithSpace(stringBuffer, n);
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, clusterOraclev10g.getMeasureUnit());
        }
    }

    private void appendTableSpace(StringBuffer stringBuffer, ClusterOraclev10g clusterOraclev10g, boolean bl) {
        SegmentOracle segmentOracle;
        TableSpaceOracle tableSpaceOracle = clusterOraclev10g.getTableSpace();
        if (tableSpaceOracle == null && (segmentOracle = clusterOraclev10g.getSegment()) != null && segmentOracle.isMarkedGenerate()) {
            tableSpaceOracle = segmentOracle.getTableSpace();
        }
        if (tableSpaceOracle != null) {
            SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
    }

    private void appendIndex(StringBuffer stringBuffer, ClusterOraclev10g clusterOraclev10g, boolean bl) {
        if ("YES".equalsIgnoreCase(clusterOraclev10g.getIndexed())) {
            SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "INDEX");
        } else if (clusterOraclev10g.getHashKeys() >= 2) {
            SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 1);
            if ("YES".equalsIgnoreCase(clusterOraclev10g.getSingleTable())) {
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "SINGLE");
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "TABLE");
            }
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "HASHKEYS");
            this.appendStringWithSpace(stringBuffer, clusterOraclev10g.getHashKeys());
            if (!"".equalsIgnoreCase(clusterOraclev10g.getHashExpression())) {
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "HASH");
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "IS");
                SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, clusterOraclev10g.getHashExpression());
            }
        }
    }

    private void appendParallel(StringBuffer stringBuffer, ClusterOraclev10g clusterOraclev10g, boolean bl) {
        SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 1);
        if ("YES".equalsIgnoreCase(clusterOraclev10g.getParallel())) {
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "PARALLEL");
        } else {
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "NOPARALLEL");
        }
    }

    private void appendCache(StringBuffer stringBuffer, ClusterOraclev10g clusterOraclev10g, boolean bl) {
        SSBClusterOraclev10g.appendNewLine(stringBuffer, bl, 1);
        if ("YES".equalsIgnoreCase(clusterOraclev10g.getCache())) {
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "CACHE");
        } else {
            SSBClusterOraclev10g.appendStringWithSpace(stringBuffer, "NOCACHE");
        }
    }

    static class ColumnComparator
    implements Comparator {
        ColumnComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((ClusterColumnOracle)object).getPosition() > ((ClusterColumnOracle)object2).getPosition()) {
                return 1;
            }
            if (((ClusterColumnOracle)object).getPosition() < ((ClusterColumnOracle)object2).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

