/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterIndexOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBClusterIndexOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        ClusterIndexOraclev10g clusterIndexOraclev10g = (ClusterIndexOraclev10g)object;
        this.storageDesign = clusterIndexOraclev10g.getStorageDesign();
        this.appendComment(stringBuffer, clusterIndexOraclev10g);
        SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "CREATE");
        SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "INDEX");
        SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(clusterIndexOraclev10g.getLongName()));
        string = stringBuffer2.toString();
        this.appendCluster(stringBuffer2, clusterIndexOraclev10g, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        SSBClusterIndexOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        DDLFileMaker.incrementCreateIndex();
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof ClusterIndexOraclev10g) {
            ClusterOracle clusterOracle = ((ClusterIndexOraclev10g)object).getCluster();
            return clusterOracle != null && clusterOracle.isMarkedGenerate();
        }
        return false;
    }

    private void appendCluster(StringBuffer stringBuffer, ClusterIndexOraclev10g clusterIndexOraclev10g, boolean bl) {
        if (clusterIndexOraclev10g.getCluster() != null) {
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "CLUSTER");
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(clusterIndexOraclev10g.getCluster().getLongName()));
            this.appendIndexAttributes(stringBuffer, clusterIndexOraclev10g, bl);
        }
    }

    private void appendIndexAttributes(StringBuffer stringBuffer, ClusterIndexOraclev10g clusterIndexOraclev10g, boolean bl) {
        SegmentOracle segmentOracle;
        TableSpaceOracle tableSpaceOracle = clusterIndexOraclev10g.getTableSpace();
        if (tableSpaceOracle == null && (segmentOracle = clusterIndexOraclev10g.getSegment()) != null && segmentOracle.isMarkedGenerate()) {
            tableSpaceOracle = segmentOracle.getTableSpace();
        }
        if (tableSpaceOracle != null) {
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
        this.appendSegment(stringBuffer, clusterIndexOraclev10g.getSegment(), bl);
        if ("YES".equalsIgnoreCase(clusterIndexOraclev10g.getOnline())) {
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "ONLINE");
        }
        if ("YES".equalsIgnoreCase(clusterIndexOraclev10g.getLogging())) {
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
        } else if ("NO".equalsIgnoreCase(clusterIndexOraclev10g.getLogging())) {
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
        }
        if ("YES".equalsIgnoreCase(clusterIndexOraclev10g.getComputeStatistics())) {
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
        }
        SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
        if (clusterIndexOraclev10g.getCompress() > 0) {
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
            this.appendStringWithSpace(stringBuffer, clusterIndexOraclev10g.getCompress());
        } else {
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOCOMPRESS");
        }
        if ("YES".equalsIgnoreCase(clusterIndexOraclev10g.getReverse())) {
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "REVERSE");
        }
        SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
        if ("YES".equalsIgnoreCase(clusterIndexOraclev10g.getParallel())) {
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARALLEL");
            if (!"".equalsIgnoreCase(clusterIndexOraclev10g.getDegree())) {
                SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, clusterIndexOraclev10g.getDegree());
            }
        } else {
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOPARALLEL");
        }
    }

    private void appendSegment(StringBuffer stringBuffer, SegmentOracle segmentOracle, boolean bl) {
        if (segmentOracle != null && segmentOracle.isMarkedGenerate()) {
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getPCTFree());
            if (segmentOracle.getInitrans() > 2) {
                SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "INITRANS");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getInitrans());
            }
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORAGE");
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            if (segmentOracle.getSCInitialExtent() > 0L) {
                SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getSCInitialExtent());
                SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            }
            if (segmentOracle.getSCNextExtent() > 0L) {
                SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getSCNextExtent());
                SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            }
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCPctIncrease());
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCMinExtents());
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, segmentOracle.getSCMaxExtents());
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCFreeLists());
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "FREELIST");
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "GROUPS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCFreelistGroups());
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, segmentOracle.getSCBufferPool());
            SSBClusterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBClusterIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }
}

