/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHPlSqlStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.util.string.StringUtilities;

public abstract class SSBPlSqlSourceStorageObjectOracle
extends AbstractSSBOracle {
    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        PlSqlSourceStorageObjectOracle plSqlSourceStorageObjectOracle = (PlSqlSourceStorageObjectOracle)object;
        StringBuffer stringBuffer2 = new StringBuffer();
        if (plSqlSourceStorageObjectOracle.isMarkedGenerate()) {
            SSBPlSqlSourceStorageObjectOracle.appendNewLine(stringBuffer, bl, 0);
            if (plSqlSourceStorageObjectOracle.getSource().toUpperCase().indexOf(MOHPlSqlStorageObjectOracle.SPACE_WRAPPED) > -1) {
                SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(stringBuffer, "-- " + plSqlSourceStorageObjectOracle.getObjectTypeName());
                SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(stringBuffer, plSqlSourceStorageObjectOracle.getStorageDesign().getFormatedName(plSqlSourceStorageObjectOracle.getLongName()));
                SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(stringBuffer, "is" + MOHPlSqlStorageObjectOracle.SPACE_WRAPPED);
                SSBPlSqlSourceStorageObjectOracle.appendNewLine(stringBuffer, bl, 0);
            } else {
                this.appendComment(stringBuffer, plSqlSourceStorageObjectOracle);
                SSBPlSqlSourceStorageObjectOracle.appendString(stringBuffer2, plSqlSourceStorageObjectOracle.getSource());
                StringBuffer stringBuffer3 = new StringBuffer();
                this.appendCreateOrReplace(stringBuffer3, plSqlSourceStorageObjectOracle);
                this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer3.toString(), true);
                SSBPlSqlSourceStorageObjectOracle.appendNewLine(stringBuffer, bl, 0);
                SSBPlSqlSourceStorageObjectOracle.appendString(stringBuffer, "/");
                SSBPlSqlSourceStorageObjectOracle.appendNewLine(stringBuffer, bl, 0);
                this.appendPermissions(stringBuffer, plSqlSourceStorageObjectOracle);
            }
            this.incrementCreateObject(object);
        }
    }

    protected abstract void incrementCreateObject(Object var1);

    protected void appendPermissions(StringBuffer stringBuffer, PlSqlSourceStorageObjectOracle plSqlSourceStorageObjectOracle) {
        StorageDesignOracle storageDesignOracle = plSqlSourceStorageObjectOracle.getStorageDesignOracle();
        StringBuffer stringBuffer2 = new StringBuffer();
        PermissionsSetOracle permissionsSetOracle = storageDesignOracle.getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (!plSqlSourceStorageObjectOracle.equals(permissionsOracle.getPackage()) && !plSqlSourceStorageObjectOracle.equals(permissionsOracle.getProc()) && !plSqlSourceStorageObjectOracle.equals(permissionsOracle.getFunctionOracle()) || permissionsOracle.getUser() == null && permissionsOracle.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissionsOracle.getPrivileges())) {
                this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, plSqlSourceStorageObjectOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissionsOracle.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, plSqlSourceStorageObjectOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer stringBuffer, StringBuffer stringBuffer2, PermissionsOracle permissionsOracle, PlSqlSourceStorageObjectOracle plSqlSourceStorageObjectOracle, StorageDesignOracle storageDesignOracle, boolean bl) {
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        this.appendComment(stringBuffer2, permissionsOracle);
        SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(stringBuffer2, "GRANT");
        if (bl) {
            stringBuffer2.append(permissionsOracle.getPrivilegesWithGrantOption());
        } else {
            stringBuffer2.append(permissionsOracle.getPrivileges());
        }
        this.appendObject(stringBuffer2, plSqlSourceStorageObjectOracle, storageDesignOracle);
        this.appendTo(stringBuffer2, permissionsOracle, storageDesignOracle);
        if (bl) {
            this.appendGrantOption(stringBuffer2, permissionsOracle);
        }
        String string = stringBuffer2.toString();
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(';');
        stringBuffer2.append(NEWLINE);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
    }

    private void appendObject(StringBuffer stringBuffer, PlSqlSourceStorageObjectOracle plSqlSourceStorageObjectOracle, StorageDesign storageDesign) {
        stringBuffer.append(NEWLINE);
        SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(stringBuffer, "ON");
        SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(plSqlSourceStorageObjectOracle.getLongName()));
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOracle permissionsOracle, StorageDesign storageDesign) {
        SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(stringBuffer, "TO");
        if ("YES".equalsIgnoreCase(permissionsOracle.getPublic())) {
            SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else if (permissionsOracle.getUser() != null) {
            SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getUser().getName()));
        } else if (permissionsOracle.getRole() != null) {
            SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getRole().getName()));
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOracle permissionsOracle) {
        if (permissionsOracle.getRole() == null) {
            SSBPlSqlSourceStorageObjectOracle.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }
}

