/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBNoneTransferableFKOracle
extends AbstractSSBOracle {
    StorageDesign storageDesign;

    public SSBNoneTransferableFKOracle(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableProxy || object instanceof Table;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        if (((ModelIDObject)object).isMarkedGenerate()) {
            Object object2;
            Object object3;
            Table table = null;
            TableProxy tableProxy = null;
            if (object instanceof TableProxy) {
                tableProxy = (TableProxy)object;
                table = (Table)tableProxy.getObject();
                this.storageDesign = tableProxy.getStorageDesign();
            } else if (object instanceof Table) {
                table = (Table)object;
                object3 = table.getDesign();
                object2 = table.getSelectedRDBMSSite();
                this.storageDesign = ((Design)object3).getStorageDesign((RDBMSSite)object2, table);
                tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            }
            if (tableProxy != null && table != null && table.getDesign().getAppView().getSettings().isGenerateFKNoneTransferableTriggers()) {
                object3 = new StringBuffer();
                List list = SSBNoneTransferableFKOracle.getColumnsInOptionalFK(table);
                if (list.size() > 0) {
                    object2 = "create Non Transferable FK constraint UPDATE trigger for table " + this.storageDesign.getFormatedName(tableProxy.getLongName());
                    this.appendFKOptionalUpdateTrigger((StringBuffer)object3, tableProxy, list, true);
                    this.appendBlockDefinitionToBuffer(stringBuffer, (StringBuffer)object3, (String)object2, "/");
                    SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
                    SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementCreateTrigger();
                }
                if ((list = SSBNoneTransferableFKOracle.getColumnsInMandatoryFK(table)).size() > 0) {
                    object2 = "create Non Transferable FK constraint UPDATE trigger for table " + this.storageDesign.getFormatedName(tableProxy.getLongName());
                    this.appendFKMandatoryUpdateTrigger((StringBuffer)object3, tableProxy, list, true);
                    this.appendBlockDefinitionToBuffer(stringBuffer, (StringBuffer)object3, (String)object2, "/");
                    SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
                    SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementCreateTrigger();
                }
            }
        }
    }

    private void appendFKOptionalUpdateTrigger(StringBuffer stringBuffer, TableProxy tableProxy, List list, boolean bl) {
        String string = "FKNTO_";
        string = this.storageDesign.getFormatedName(string + this.getStringWithMaxLength(tableProxy.getName(), 30 - string.length()));
        if (tableProxy.getUserSchema() != null) {
            string = this.storageDesign.getFormatedName(tableProxy.getUserSchema().getName()) + '.' + string;
        }
        String string2 = "";
        boolean bl2 = true;
        for (Column column : list) {
            if (bl2) {
                string2 = this.storageDesign.getFormatedName(column.getName());
                bl2 = false;
                continue;
            }
            string2 = string2 + ", " + this.storageDesign.getFormatedName(column.getName());
        }
        SSBNoneTransferableFKOracle.appendStringWithSpace(stringBuffer, "CREATE OR REPLACE TRIGGER " + string);
        SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(stringBuffer, "BEFORE UPDATE OF " + string2);
        SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(stringBuffer, "ON " + this.storageDesign.getFormatedName(tableProxy.getLongName()));
        SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(stringBuffer, "FOR EACH ROW");
        SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(stringBuffer, "BEGIN");
        SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
        for (Column column : list) {
            String string3 = "";
            FKIndexAssociation fKIndexAssociation = column.getFKIndexAssociation();
            if (fKIndexAssociation != null && !fKIndexAssociation.isTransferable() && !fKIndexAssociation.isMandatory()) {
                string3 = fKIndexAssociation.getName();
            }
            SSBNoneTransferableFKOracle.appendStringWithSpace(stringBuffer, " IF :old." + this.storageDesign.getFormatedName(column.getName()) + " IS NOT NULL THEN");
            SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
            SSBNoneTransferableFKOracle.appendStringWithSpace(stringBuffer, "  raise_application_error(-20225,'Non Transferable FK constraint " + string3 + " on table " + tableProxy.getLongName() + " is violated');");
            SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
            SSBNoneTransferableFKOracle.appendStringWithSpace(stringBuffer, " END IF;");
            SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
        }
        SSBNoneTransferableFKOracle.appendStringWithSpace(stringBuffer, "END;");
    }

    private void appendFKMandatoryUpdateTrigger(StringBuffer stringBuffer, TableProxy tableProxy, List list, boolean bl) {
        String string = "FKNTM_";
        string = this.storageDesign.getFormatedName(string + this.getStringWithMaxLength(tableProxy.getName(), 30 - string.length()));
        if (tableProxy.getUserSchema() != null) {
            string = this.storageDesign.getFormatedName(tableProxy.getUserSchema().getName()) + "." + string;
        }
        String string2 = "";
        HashMap<String, FKIndexAssociation> hashMap = new HashMap<String, FKIndexAssociation>();
        String string3 = "";
        boolean bl2 = true;
        for (Column column : list) {
            Object v;
            FKIndexAssociation fKIndexAssociation;
            if (bl2) {
                string2 = this.storageDesign.getFormatedName(column.getName());
                bl2 = false;
            } else {
                string2 = string2 + ", " + this.storageDesign.getFormatedName(column.getName());
            }
            if ((fKIndexAssociation = column.getFKIndexAssociation()) == null || fKIndexAssociation.isTransferable() || fKIndexAssociation.isMandatory() || (v = hashMap.get(fKIndexAssociation.getObjectID())) != null) continue;
            hashMap.put(fKIndexAssociation.getObjectID(), fKIndexAssociation);
            if (hashMap.size() > 1) {
                string3 = string3 + " ," + fKIndexAssociation.getName();
                continue;
            }
            string3 = fKIndexAssociation.getName();
        }
        SSBNoneTransferableFKOracle.appendStringWithSpace(stringBuffer, "CREATE OR REPLACE TRIGGER " + string);
        SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(stringBuffer, "BEFORE UPDATE OF " + string2);
        SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(stringBuffer, "ON " + this.storageDesign.getFormatedName(tableProxy.getLongName()));
        SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(stringBuffer, "BEGIN");
        SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(stringBuffer, "  raise_application_error(-20225,'Non Transferable FK constraint " + string3 + " on table " + tableProxy.getLongName() + " is violated');");
        SSBNoneTransferableFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(stringBuffer, "END;");
    }

    public static List getColumnsInOptionalFK(Table table) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        FKIndexAssociation[] fKIndexAssociationArray = table.getFKAssociations();
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            FKIndexAssociation fKIndexAssociation = fKIndexAssociationArray[i];
            if (fKIndexAssociation.isMandatory() || fKIndexAssociation.isTransferable()) continue;
            for (Column column : fKIndexAssociation.getLocalFKIndex().getElementsCollection()) {
                arrayList.add(column);
            }
        }
        return arrayList;
    }

    public static List getColumnsInMandatoryFK(Table table) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        FKIndexAssociation[] fKIndexAssociationArray = table.getFKAssociations();
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            FKIndexAssociation fKIndexAssociation = fKIndexAssociationArray[i];
            if (!fKIndexAssociation.isMandatory() || fKIndexAssociation.isTransferable()) continue;
            for (Column column : fKIndexAssociation.getLocalFKIndex().getElementsCollection()) {
                arrayList.add(column);
            }
        }
        return arrayList;
    }
}

