/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBAutoIncrementColumnOracle
extends AbstractSSBOracle {
    private static final int MAX_OBJECT_LENGTH = 30;
    private static final String TRIGGER_SUFFIX = "TRG";
    private static final String SEQUENCE_SUFFIX = "SEQ";
    private StorageDesignOracle storageDesign;

    public SSBAutoIncrementColumnOracle(StorageDesignOracle storageDesignOracle) {
        this.storageDesign = storageDesignOracle;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableProxyOracle || object instanceof Table;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        if (object instanceof TableProxyOracle && ((TableProxyOracle)object).isMarkedGenerate() || object instanceof Table && ((Table)object).isMarkedGenerate()) {
            Table table = object instanceof Table ? (Table)object : (Table)((TableProxyOracle)object).getObject();
            for (Column column : table.getElementsCollection()) {
                if (!column.isAutoIncrementColumn()) continue;
                this.appendAutoIncrementSequenceAndTrigger(stringBuffer, column, bl);
            }
        }
    }

    public void appendAutoIncrementSequenceAndTrigger(StringBuffer stringBuffer, Column column, boolean bl) {
        SequenceOracle sequenceOracle;
        Settings settings = column.getDesign().getAppView().getSettings();
        String string = column.getAutoIncrementSequenceName();
        String string2 = column.getAutoIncrementTriggerName();
        SequenceOracle sequenceOracle2 = sequenceOracle = StringUtilities.isNotEmpty(string) ? (SequenceOracle)this.storageDesign.getSequenceSet().getByName(string) : null;
        if (sequenceOracle == null) {
            string = this.generateAutoIncrementObjectName(string, settings.getDefaultOracleSequenceName(), SEQUENCE_SUFFIX, column);
            this.appendAutoIncrementSequence(string, column, stringBuffer, bl);
        } else {
            string = sequenceOracle.getLongName();
        }
        if (column.isAutoIncrementGenerateTrigger() && (!StringUtilities.isNotEmpty(string2) || this.storageDesign.getTriggerSet().getByName(string2) == null)) {
            string2 = this.generateAutoIncrementObjectName(string2, settings.getDefaultOracleTriggerName(), TRIGGER_SUFFIX, column);
            this.appendAutoIncrementTrigger(string2, string, column, stringBuffer, bl);
        }
    }

    private String generateAutoIncrementObjectName(String string, String string2, String string3, Column column) {
        String string4;
        Table table = (Table)column.getParent();
        String string5 = table.getName();
        String string6 = table.getAbbreviation();
        String string7 = column.getName();
        String string8 = column.getAbbreviation();
        String string9 = table.getSchema();
        TableProxyOracle tableProxyOracle = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxyOracle != null) {
            string5 = tableProxyOracle.getName();
            ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)tableProxyOracle.getColumnProxy(column.getObjectID());
            if (columnProxyOracle != null) {
                string7 = columnProxyOracle.getName();
                UserOracle userOracle = columnProxyOracle.getAutoIncrementUser();
                if (userOracle != null) {
                    string9 = userOracle.getName();
                } else {
                    String string10 = tableProxyOracle.getLongName();
                    int n = string10.length() - string5.length() - 1;
                    if (n > 0) {
                        string9 = string10.substring(0, n);
                    }
                }
            }
        }
        if (StringUtilities.isNotEmpty(string)) {
            string4 = string;
        } else {
            if (!StringUtilities.isNotEmpty(string6)) {
                string6 = string5;
            }
            if (!StringUtilities.isNotEmpty(string8)) {
                string8 = string7;
            }
            if (StringUtilities.isNotEmpty(string2)) {
                string4 = string2.replaceAll("\\{table\\}", string5).replaceAll("\\{table abbr\\}", string6).replaceAll("\\{column\\}", string7).replaceAll("\\{column abbr\\}", string8);
            } else {
                string4 = string6 + '_' + string8;
                if (string4.length() + string3.length() + 1 <= 30) {
                    string4 = string4 + '_' + string3;
                }
            }
        }
        string4 = this.storageDesign.getFormatedName(this.getStringWithMaxLength(string4, 30));
        if (StringUtilities.isNotEmpty(string9)) {
            string4 = this.storageDesign.getFormatedName(string9) + '.' + string4;
        }
        return string4;
    }

    private void appendAutoIncrementSequence(String string, Column column, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = column.getAutoIncrementStartWith();
        Integer n = column.getAutoIncrementIncrementBy();
        String string3 = column.getAutoIncrementMaxValue();
        String string4 = column.getAutoIncrementMinValue();
        Integer n2 = column.getAutoIncrementCache();
        SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "CREATE");
        SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "SEQUENCE");
        SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, string);
        String string5 = stringBuffer2.toString();
        if (string2 != null && !"1".equals(string2)) {
            SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer2, bl, 0);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "START");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "WITH");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, string2);
        }
        if (n != null && n != 1) {
            SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer2, bl, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "INCREMENT");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "BY");
            this.appendStringWithSpace(stringBuffer2, n);
        }
        if (string4 != null) {
            SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer2, bl, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "MINVALUE");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, string4);
        }
        if (string3 != null) {
            SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer2, bl, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "MAXVALUE");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, string3);
        }
        if (column.isAutoIncrementCycle()) {
            SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer2, bl, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "CYCLE");
        }
        if (column.isAutoIncrementDisableCache()) {
            SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer2, bl, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "NOCACHE");
        } else if (n2 != null) {
            SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer2, bl, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "CACHE");
            this.appendStringWithSpace(stringBuffer2, n2);
        }
        if (column.isAutoIncrementOrder()) {
            SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer2, bl, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "ORDER");
        }
        this.appendToBuffer(stringBuffer, stringBuffer2, string5);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string5);
        SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer, bl, 0);
        DDLFileMaker.incrementCreateSequence();
    }

    private void appendAutoIncrementTrigger(String string, String string2, Column column, StringBuffer stringBuffer, boolean bl) {
        ColumnProxyOracle columnProxyOracle;
        Table table = (Table)column.getParent();
        TableProxyOracle tableProxyOracle = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxyOracle != null && (columnProxyOracle = (ColumnProxyOracle)tableProxyOracle.getColumnProxy(column.getObjectID())) != null) {
            StringBuffer stringBuffer2 = new StringBuffer();
            String string3 = this.storageDesign.getFormatedName(tableProxyOracle.getLongName());
            String string4 = this.storageDesign.getFormatedName(columnProxyOracle.getName());
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "CREATE");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "OR");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "REPLACE");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "TRIGGER");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, string);
            String string5 = stringBuffer2.toString();
            SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer2, bl, 0);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "BEFORE INSERT ON " + string3);
            SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer2, bl, 0);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "FOR EACH ROW");
            SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer2, bl, 0);
            if (!column.isAutoIncrementGenerateAlways()) {
                SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "WHEN (NEW." + string4 + " IS NULL)");
                SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer2, bl, 0);
            }
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "BEGIN");
            SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer2, bl, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(stringBuffer2, "SELECT " + string2 + ".NEXTVAL INTO :NEW." + string4 + " FROM DUAL;");
            SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer2, bl, 0);
            SSBAutoIncrementColumnOracle.appendString(stringBuffer2, "END");
            this.appendLineFinisher(stringBuffer2, bl);
            stringBuffer2.append("/");
            this.appendToBuffer(stringBuffer, stringBuffer2, string5, true);
            SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer, bl, 0);
            SSBAutoIncrementColumnOracle.appendNewLine(stringBuffer, bl, 0);
            DDLFileMaker.incrementCreateTrigger();
        }
    }
}

