/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;

public class SSBArcFK_CheckConstr
extends AbstractSSBOracle {
    private StorageDesign storageDesign;
    int arc_index = 0;

    public SSBArcFK_CheckConstr(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof FKArc;
    }

    public void appendArcConstraints(StringBuffer stringBuffer, TableProxy tableProxy, boolean bl) {
        Table table = (Table)tableProxy.getObject();
        if (table != null) {
            for (FKArc fKArc : table.getArcs()) {
                this.doAppend(stringBuffer, fKArc, bl);
            }
        }
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        FKArc fKArc = (FKArc)object;
        if (fKArc.isMarkedGenerate() && fKArc.getDesign().getAppView().getSettings().isGenerateFKArcTriggers()) {
            TableProxy tableProxy;
            Table table = fKArc.getTable();
            List list = this.getColumnsInArc(fKArc);
            if (table != null && fKArc.getFkeys().size() > 1 && list.size() > 1 && (tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID())) != null && tableProxy.isMarkedGenerate()) {
                this.arc_index = table.getArcs().indexOf(fKArc) + 1;
                this.appendComment(stringBuffer, fKArc);
                StringBuffer stringBuffer2 = new StringBuffer();
                String string = this.storageDesign.getFormatedName(tableProxy.getLongName());
                String string2 = "create Arc check constraint for table " + string;
                this.appendArcCheckCnstraint(stringBuffer2, fKArc, tableProxy, list, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, string2);
                SSBArcFK_CheckConstr.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
            }
        }
    }

    public static boolean validArc(FKArc fKArc) {
        return true;
    }

    private List getColumnsInArc(FKArc fKArc) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (FKIndexAssociation fKIndexAssociation : fKArc.getFkeys()) {
            for (Column column : fKIndexAssociation.getLocalFKIndex().getElementsCollection()) {
                arrayList.add(column);
            }
        }
        return arrayList;
    }

    private List getColumnsInArc(FKArc fKArc, FKIndexAssociation fKIndexAssociation) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (FKIndexAssociation fKIndexAssociation2 : fKArc.getFkeys()) {
            if (fKIndexAssociation2 == fKIndexAssociation) continue;
            for (Column column : fKIndexAssociation2.getLocalFKIndex().getElementsCollection()) {
                arrayList.add(column);
            }
        }
        return arrayList;
    }

    private void appendArcCheckCnstraint(StringBuffer stringBuffer, FKArc fKArc, TableProxy tableProxy, List list, boolean bl) {
        String string = this.storageDesign.getFormatedName(fKArc.getName());
        List list2 = fKArc.getFkeys();
        String string2 = this.storageDesign.getFormatedName(tableProxy.getLongName());
        SSBArcFK_CheckConstr.appendStringWithSpace(stringBuffer, "ALTER TABLE " + string2);
        SSBArcFK_CheckConstr.appendNewLine(stringBuffer, bl, 1);
        SSBArcFK_CheckConstr.appendStringWithSpace(stringBuffer, "ADD CONSTRAINT " + string + " CHECK (");
        SSBArcFK_CheckConstr.appendNewLine(stringBuffer, bl, 2);
        for (int i = 0; i < list2.size(); ++i) {
            String string3;
            Column column;
            int n;
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)list2.get(i);
            Column[] columnArray = fKIndexAssociation.getColumns();
            List list3 = this.getColumnsInArc(fKArc, fKIndexAssociation);
            SSBArcFK_CheckConstr.appendStringWithSpace(stringBuffer, "(");
            if (i > 0) {
                // empty if block
            }
            for (n = 0; n < columnArray.length; ++n) {
                column = columnArray[n];
                string3 = this.storageDesign.getFormatedName(column.getName());
                SSBArcFK_CheckConstr.appendString(stringBuffer, " (" + string3 + " IS NOT NULL) AND ");
                SSBArcFK_CheckConstr.appendNewLine(stringBuffer, bl, 2);
            }
            for (n = 0; n < list3.size(); ++n) {
                column = (Column)list3.get(n);
                string3 = this.storageDesign.getFormatedName(column.getName());
                SSBArcFK_CheckConstr.appendString(stringBuffer, " (" + string3 + " IS NULL) ");
                if (n >= list3.size() - 1) continue;
                SSBArcFK_CheckConstr.appendString(stringBuffer, " AND ");
                SSBArcFK_CheckConstr.appendNewLine(stringBuffer, bl, 2);
            }
            if (i >= list2.size() - 1) continue;
            SSBArcFK_CheckConstr.appendStringWithSpace(stringBuffer, ") OR");
            SSBArcFK_CheckConstr.appendNewLine(stringBuffer, bl, 2);
        }
        SSBArcFK_CheckConstr.appendStringWithSpace(stringBuffer, ") )");
    }
}

