/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.TriggerDB2v80;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTriggerDB2v80
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        TriggerDB2v80 triggerDB2v80 = (TriggerDB2v80)object;
        this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(object);
        this.appendComment(stringBuffer, triggerDB2v80);
        this.appendCreate(stringBuffer, triggerDB2v80);
        this.appendTriggeringTime(stringBuffer, triggerDB2v80, bl);
        this.appendAction(stringBuffer, triggerDB2v80);
        this.appendOnTable(stringBuffer, triggerDB2v80);
        this.appendReferencing(stringBuffer, triggerDB2v80, bl);
        this.appendScope(stringBuffer, triggerDB2v80, bl);
        this.appendCondition(stringBuffer, triggerDB2v80, bl);
        this.appendTriggeredAction(stringBuffer, triggerDB2v80, bl);
        SSBTriggerDB2v80.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        DDLFileMaker.incrementCreateTrigger();
        if (triggerDB2v80.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(stringBuffer, triggerDB2v80, bl);
        }
    }

    private void appendCommentOn(StringBuffer stringBuffer, TriggerDB2v80 triggerDB2v80, boolean bl) {
        SSBTriggerDB2v80.appendNewLine(stringBuffer, bl, 0);
        SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "COMMENT ON");
        SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "TRIGGER");
        SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(triggerDB2v80.getLongName()));
        SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "IS");
        SSBTriggerDB2v80.appendString(stringBuffer, '\'');
        SSBTriggerDB2v80.appendString(stringBuffer, triggerDB2v80.getCommentInRDBMS());
        SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, '\'');
        SSBTriggerDB2v80.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
    }

    private void appendCreate(StringBuffer stringBuffer, TriggerDB2v80 triggerDB2v80) {
        this.appendCreate(stringBuffer);
        SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "TRIGGER");
        if (triggerDB2v80.getOwner() != null) {
            SSBTriggerDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(triggerDB2v80.getOwner().getName()));
            SSBTriggerDB2v80.appendString(stringBuffer, ".");
        }
        SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(triggerDB2v80.getName()));
    }

    private void appendTriggeringTime(StringBuffer stringBuffer, TriggerDB2v80 triggerDB2v80, boolean bl) {
        SSBTriggerDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, triggerDB2v80.getTriggerTime());
    }

    private void appendAction(StringBuffer stringBuffer, TriggerDB2v80 triggerDB2v80) {
        SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, triggerDB2v80.getActions());
        if (triggerDB2v80.getActions().equalsIgnoreCase(Trigger.ACTION_TYPES[1]) && !triggerDB2v80.getColumns().equalsIgnoreCase("")) {
            SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "OF");
            SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, triggerDB2v80.getColumns());
        }
    }

    private void appendOnTable(StringBuffer stringBuffer, TriggerDB2v80 triggerDB2v80) {
        SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "ON");
        SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(triggerDB2v80.getTable().getName()));
    }

    private void appendReferencing(StringBuffer stringBuffer, TriggerDB2v80 triggerDB2v80, boolean bl) {
        if (!(triggerDB2v80.getRef_NEW_AS().equalsIgnoreCase("") && triggerDB2v80.getRef_OLD_AS().equalsIgnoreCase("") && triggerDB2v80.getNEW_TABLE_AS().equalsIgnoreCase("") && triggerDB2v80.getOLD_TABLE_AS().equalsIgnoreCase(""))) {
            SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "REFERENCING");
            if (!triggerDB2v80.getRef_NEW_AS().equalsIgnoreCase("")) {
                SSBTriggerDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "NEW");
                SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "AS");
                SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, triggerDB2v80.getRef_NEW_AS());
            }
            if (!triggerDB2v80.getRef_OLD_AS().equalsIgnoreCase("")) {
                SSBTriggerDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "OLD");
                SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "AS");
                SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, triggerDB2v80.getRef_OLD_AS());
            }
            if (!triggerDB2v80.getOLD_TABLE_AS().equalsIgnoreCase("")) {
                SSBTriggerDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "OLD TABLE");
                SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "AS");
                SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, triggerDB2v80.getOLD_TABLE_AS());
            }
            if (!triggerDB2v80.getNEW_TABLE_AS().equalsIgnoreCase("")) {
                SSBTriggerDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "NEW TABLE");
                SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "AS");
                SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, triggerDB2v80.getNEW_TABLE_AS());
            }
        }
    }

    private void appendScope(StringBuffer stringBuffer, TriggerDB2v80 triggerDB2v80, boolean bl) {
        SSBTriggerDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, triggerDB2v80.getScope());
        if (triggerDB2v80.isScopeForEachRow()) {
            this.appendMode(stringBuffer);
        }
    }

    private void appendMode(StringBuffer stringBuffer) {
        SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "MODE DB2SQL");
    }

    private void appendCondition(StringBuffer stringBuffer, TriggerDB2v80 triggerDB2v80, boolean bl) {
        if (!triggerDB2v80.getCondition().equalsIgnoreCase("")) {
            SSBTriggerDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "WHEN");
            SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, '(');
            SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, triggerDB2v80.getCondition());
            SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendTriggeredAction(StringBuffer stringBuffer, TriggerDB2v80 triggerDB2v80, boolean bl) {
        SSBTriggerDB2v80.appendNewLine(stringBuffer, bl, 1);
        if (triggerDB2v80.getBody().equalsIgnoreCase("")) {
            SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, "-- Empty body");
        } else {
            SSBTriggerDB2v80.appendStringWithSpace(stringBuffer, triggerDB2v80.getBody());
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TriggerDB2v80 && ((TriggerDB2v80)object).isMarkedGenerate() && ((TriggerDB2)object).getTable() != null;
    }
}

