/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.exports.ddl.db2.v80.SSBIndexDB2v80;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFK_CheckConstr;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeDB2;
import oracle.dbtools.crest.model.design.storage.db2.InstanceDescriptorColumnDB2;
import oracle.dbtools.crest.model.design.storage.db2.TablePartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnIdentityDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableDB2v80
extends AbstractSSBDB2 {
    private StorageDesignDB2v80 storageDesign;
    private SSBIndexDB2v80 ssbIndex = new SSBIndexDB2v80();
    private SSBArcFK_CheckConstr arcConstrHandler;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxy;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Table table = null;
        TableProxyDB2v80 tableProxyDB2v80 = null;
        if (object == null) {
            return;
        }
        if (object instanceof Table) {
            table = (Table)object;
            this.storageDesign = (StorageDesignDB2v80)this.getStorageDesign(object);
            tableProxyDB2v80 = (TableProxyDB2v80)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object instanceof TableProxyDB2v80) {
            tableProxyDB2v80 = (TableProxyDB2v80)object;
            table = (Table)tableProxyDB2v80.getObject();
            this.storageDesign = (StorageDesignDB2v80)this.getStorageDesign(object);
        }
        if (tableProxyDB2v80 != null && !tableProxyDB2v80.isMarkedGenerate()) {
            this.appendIndexes(stringBuffer, tableProxyDB2v80, bl);
            return;
        }
        if (table != null && table.getElementsCollection().size() > 0) {
            ColumnProxy[] columnProxyArray;
            if (tableProxyDB2v80 != null) {
                this.appendSetCurrentRules(stringBuffer, tableProxyDB2v80, bl);
            }
            if (tableProxyDB2v80 != null && tableProxyDB2v80.isCommentChanged()) {
                this.appendComment(stringBuffer, tableProxyDB2v80);
            } else {
                this.appendComment(stringBuffer, table);
            }
            if (tableProxyDB2v80 != null && tableProxyDB2v80.getName().length() > tableProxyDB2v80.getMaxNameLength()) {
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + tableProxyDB2v80.getMaxNameLength() + ")");
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
                DDLFileMaker.incrementErrors();
            }
            this.appendBeforeCreateScript(stringBuffer, bl, table);
            this.appendCreate(stringBuffer);
            if (tableProxyDB2v80 == null) {
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "TABLE");
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(table.getLongName()));
                this.appendElementList(stringBuffer, table, null, bl);
            } else {
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "TABLE");
                columnProxyArray = this.storageDesign.getFormatedName(tableProxyDB2v80.getLongName());
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, (String)columnProxyArray);
                this.appendElementList(stringBuffer, table, tableProxyDB2v80, bl);
                this.appendInDb(stringBuffer, tableProxyDB2v80, bl);
                this.appendPartitioningClause(stringBuffer, tableProxyDB2v80, bl);
                this.appendEditProc(stringBuffer, tableProxyDB2v80, bl);
                this.appendValidProc(stringBuffer, tableProxyDB2v80, bl);
                this.appendAudit(stringBuffer, tableProxyDB2v80, bl);
                this.appendObid(stringBuffer, tableProxyDB2v80, bl);
                this.appendDataCapture(stringBuffer, tableProxyDB2v80, bl);
                this.appendWithRestrict(stringBuffer, tableProxyDB2v80, bl);
                this.appendCcid(stringBuffer, tableProxyDB2v80, bl);
                this.appendVolatile(stringBuffer, tableProxyDB2v80, bl);
            }
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            DDLFileMaker.incrementCreateTable();
            this.appendAfterCreateScript(stringBuffer, bl, table);
            if (tableProxyDB2v80 != null) {
                this.appendLabelOn(stringBuffer, tableProxyDB2v80, bl);
                columnProxyArray = tableProxyDB2v80.getColumnProxies();
                for (int i = 0; i < columnProxyArray.length; ++i) {
                    this.appendLabelOnColumn(stringBuffer, (ColumnProxyDB2v80)columnProxyArray[i], bl);
                }
            }
            this.appendColumnCheckConstraints(stringBuffer, tableProxyDB2v80, bl);
            if (this.getArcConstrHandler() != null) {
                this.getArcConstrHandler().appendArcConstraints(stringBuffer, tableProxyDB2v80, bl);
            }
            if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendTableCommentOn(stringBuffer, table, tableProxyDB2v80, bl);
            }
            if (tableProxyDB2v80 != null) {
                this.appendIndexes(stringBuffer, tableProxyDB2v80, bl);
            }
        } else if (table != null) {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("-- Error - Table ");
            stringBuffer.append(this.storageDesign.getFormatedName(table.getName()));
            stringBuffer.append(" has no columns");
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendIndexes(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        Iterator iterator = tableProxyDB2.getIndexes().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.ssbIndex.canHandle(e)) continue;
            this.ssbIndex.doAppend(stringBuffer, e, bl);
        }
        this.appendIndexesForConstraints(stringBuffer, (Table)tableProxyDB2.getObject(), tableProxyDB2);
    }

    protected void appendTableCommentOn(StringBuffer stringBuffer, Table table, TableProxyDB2v80 tableProxyDB2v80, boolean bl) {
        block6: {
            block5: {
                if (tableProxyDB2v80 == null) break block5;
                this.appendCommentOn(stringBuffer, tableProxyDB2v80, bl);
                ColumnProxy[] columnProxyArray = tableProxyDB2v80.getColumnProxies();
                ColumnProxy columnProxy = null;
                for (int i = 0; i < columnProxyArray.length; ++i) {
                    String string;
                    columnProxy = columnProxyArray[i];
                    String string2 = "";
                    if (columnProxy.getCommentInRDBMS() != null && columnProxy.isCommentInRDBMSChanged()) {
                        string2 = columnProxy.getCommentInRDBMS();
                        string = columnProxy.getLongName();
                    } else {
                        string2 = columnProxy.getObject().getCommentInRDBMS();
                        string = ((Column)columnProxy.getObject()).getLongName();
                    }
                    if (string2.equalsIgnoreCase("")) continue;
                    SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
                    SSBTableDB2v80.appendStringWithSpace(stringBuffer, "COMMENT ON");
                    SSBTableDB2v80.appendStringWithSpace(stringBuffer, "COLUMN");
                    SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
                    SSBTableDB2v80.appendStringWithSpace(stringBuffer, "IS");
                    SSBTableDB2v80.appendString(stringBuffer, '\'');
                    SSBTableDB2v80.appendString(stringBuffer, string2);
                    SSBTableDB2v80.appendStringWithSpace(stringBuffer, '\'');
                    SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
                    this.appendLineFinisher(stringBuffer, bl);
                }
                break block6;
            }
            if (table == null) break block6;
            if (table.getCommentInRDBMS() != null && !"".equalsIgnoreCase(table.getCommentInRDBMS())) {
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "COMMENT ON");
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "TABLE");
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(table.getLongName()));
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "IS");
                SSBTableDB2v80.appendString(stringBuffer, '\'');
                SSBTableDB2v80.appendString(stringBuffer, table.getCommentInRDBMS());
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, '\'');
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
            }
            ContainedObject[] containedObjectArray = table.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Column column = (Column)containedObjectArray[i];
                if (column.getCommentInRDBMS() == null || "".equalsIgnoreCase(column.getCommentInRDBMS())) continue;
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "COMMENT ON");
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "COLUMN");
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(column.getLongName()));
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "IS");
                SSBTableDB2v80.appendString(stringBuffer, '\'');
                SSBTableDB2v80.appendString(stringBuffer, column.getCommentInRDBMS());
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, '\'');
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
            }
        }
    }

    private void appendSetCurrentRules(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        boolean bl2 = this.hasAUXTables(tableProxyDB2);
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, "SET CURRENT RULES");
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, '=');
        SSBTableDB2v80.appendString(stringBuffer, '\'');
        SSBTableDB2v80.appendString(stringBuffer, bl2 ? "DB2" : "STD");
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, '\'');
        this.appendLineFinisher(stringBuffer, bl);
    }

    private void appendElementList(StringBuffer stringBuffer, Table table, TableProxyDB2v80 tableProxyDB2v80, boolean bl) {
        List list = table.getAllNestedElements();
        Column column = null;
        ColumnProxyDB2v80 columnProxyDB2v80 = null;
        Object[] objectArray = null;
        if (tableProxyDB2v80 != null) {
            objectArray = tableProxyDB2v80.getInstDescriptorCols().toArray();
        }
        SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
        if (tableProxyDB2v80 == null || tableProxyDB2v80.getMaterializedQuery().equalsIgnoreCase("NO")) {
            if (list.size() == 0 && (objectArray == null || objectArray.length == 0)) {
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "-- No columns");
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    if (i == 0) {
                        SSBTableDB2v80.appendStringWithSpace(stringBuffer, '(');
                    } else {
                        this.appendComma(stringBuffer);
                    }
                    SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
                    column = (Column)list.get(i);
                    if (tableProxyDB2v80 == null) continue;
                    columnProxyDB2v80 = (ColumnProxyDB2v80)tableProxyDB2v80.getColumnProxy(column.getObjectID());
                    if (this.storageDesign.getFormatedName(columnProxyDB2v80.getName()).length() > columnProxyDB2v80.getMaxNameLength()) {
                        SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
                        SSBTableDB2v80.appendStringWithSpace(stringBuffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxyDB2v80.getMaxNameLength() + ")");
                        SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    if (columnProxyDB2v80.isCommentChanged() && !"".equalsIgnoreCase(columnProxyDB2v80.getComment())) {
                        this.appendComment(stringBuffer, columnProxyDB2v80);
                    } else if (!"".equalsIgnoreCase(columnProxyDB2v80.getObject().getComment())) {
                        this.appendComment(stringBuffer, columnProxyDB2v80.getObject());
                    }
                    this.appendColumnDefinition(stringBuffer, columnProxyDB2v80, bl);
                }
                InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = null;
                for (int i = 0; i < objectArray.length; ++i) {
                    instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)objectArray[i];
                    if (list.size() == 0 && i == 0) {
                        SSBTableDB2v80.appendString(stringBuffer, '(');
                    } else {
                        stringBuffer.append(", ");
                    }
                    SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
                    SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(instanceDescriptorColumnDB2.getName()));
                    SSBTableDB2v80.appendStringWithSpace(stringBuffer, instanceDescriptorColumnDB2.getDataType());
                }
                this.appendPKDefinition(stringBuffer, table, tableProxyDB2v80, bl);
                this.appendTableConstraintsDefinition(stringBuffer, table, bl);
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, ')');
            }
        } else {
            this.appendMaterializedQuery(stringBuffer, table, tableProxyDB2v80, bl);
        }
    }

    protected void appendColumnDefinition(StringBuffer stringBuffer, ColumnProxyDB2v80 columnProxyDB2v80, boolean bl) {
        SSBTableDB2v80.appendString(stringBuffer, ' ');
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyDB2v80.getName()));
        DistinctTypeDB2 distinctTypeDB2 = columnProxyDB2v80.getDistinctType();
        if (distinctTypeDB2 != null) {
            this.appendStringWithSpace(stringBuffer, distinctTypeDB2);
        } else {
            String string = columnProxyDB2v80.getDatatypeString();
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, string);
            if (string.equalsIgnoreCase("unknown")) {
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "--  ERROR: Datatype UNKNOWN is not allowed");
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 5);
                DDLFileMaker.incrementErrors();
            }
        }
        this.appendBitDataDefinition(stringBuffer, columnProxyDB2v80);
        this.appendNotNullDefinition(stringBuffer, columnProxyDB2v80);
        this.appendWithDefaultDefinition(stringBuffer, columnProxyDB2v80);
        this.appendIdentityDefinition(stringBuffer, columnProxyDB2v80, bl);
        this.appendColumnConstraints(stringBuffer, columnProxyDB2v80.getColumn(), columnProxyDB2v80);
        this.appendFieldProcDefinition(stringBuffer, columnProxyDB2v80);
    }

    protected void appendLabelOnColumn(StringBuffer stringBuffer, ColumnProxyDB2v80 columnProxyDB2v80, boolean bl) {
        if (!columnProxyDB2v80.getLabel().equalsIgnoreCase("")) {
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "LABEL");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "ON");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "COLUMN");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyDB2v80.getLongName()));
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "IS");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "'" + columnProxyDB2v80.getLabel() + "'");
            this.appendLineFinisher(stringBuffer, bl);
        }
    }

    protected void appendBitDataDefinition(StringBuffer stringBuffer, ColumnProxyDB2v80 columnProxyDB2v80) {
        String string = columnProxyDB2v80.getBitData();
        if (!"".equalsIgnoreCase(string)) {
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "FOR");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, string);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "DATA");
        }
    }

    protected void appendNotNullDefinition(StringBuffer stringBuffer, ColumnProxyDB2v80 columnProxyDB2v80) {
        if (!columnProxyDB2v80.getColumn().getNullsAllowed()) {
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "NOT NULL");
        }
    }

    private void appendWithDefaultDefinition(StringBuffer stringBuffer, ColumnProxyDB2v80 columnProxyDB2v80) {
        String string = columnProxyDB2v80.getDefaultValueConstant();
        boolean bl = columnProxyDB2v80.getStorageDesign().isOpen();
        String string2 = "";
        Column column = columnProxyDB2v80.getColumn();
        boolean bl2 = columnProxyDB2v80.getDefault();
        if (!bl) {
            string2 = column.getDefaultValue();
            bl2 = column.getUsesDefaultValue();
        } else {
            string2 = columnProxyDB2v80.getDefaultValue();
        }
        if (bl2) {
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "WITH");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "DEFAULT");
            if (!"".equalsIgnoreCase(string2)) {
                if (string2.equalsIgnoreCase(ColumnProxyDB2.getDefaultValueChoices()[1])) {
                    if (!"".equalsIgnoreCase(string)) {
                        String string3 = columnProxyDB2v80.getColumn().getDatatypeString("DB2/390 8");
                        String string4 = this.addQuotesToDefault(string3, string);
                        SSBTableDB2v80.appendStringWithSpace(stringBuffer, string4);
                    }
                } else if (string2.equalsIgnoreCase(ColumnProxyDB2.getDefaultValueChoices()[4])) {
                    SSBTableDB2v80.appendStringWithSpace(stringBuffer, string);
                } else {
                    String string5 = columnProxyDB2v80.getColumn().getDatatypeString("DB2/390 8");
                    String string6 = this.addQuotesToDefault(string5, string2);
                    SSBTableDB2v80.appendStringWithSpace(stringBuffer, string6);
                }
            }
        }
    }

    protected void appendIdentityDefinition(StringBuffer stringBuffer, ColumnProxyDB2v80 columnProxyDB2v80, boolean bl) {
        ColumnIdentityDB2v80 columnIdentityDB2v80;
        Column column = columnProxyDB2v80.getColumn();
        if (column.isIdentityColumn() && columnProxyDB2v80.isUseIdentity() && (columnIdentityDB2v80 = (ColumnIdentityDB2v80)columnProxyDB2v80.getColumnIdentity()) != null) {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "GENERATED");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, columnIdentityDB2v80.getGenerate());
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "AS");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "IDENTITY");
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, '(');
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "START");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "WITH");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, columnIdentityDB2v80.getStartWith());
            this.appendComma(stringBuffer);
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "INCREMENT");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "BY");
            this.appendStringWithSpace(stringBuffer, columnIdentityDB2v80.getIncrementBy());
            if (!"".equalsIgnoreCase(columnIdentityDB2v80.getMinValue().trim())) {
                this.appendComma(stringBuffer);
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 2);
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "MINVALUE");
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, columnIdentityDB2v80.getMinValue());
            }
            if (!"".equalsIgnoreCase(columnIdentityDB2v80.getMaxValue().trim())) {
                this.appendComma(stringBuffer);
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 2);
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "MAXVALUE");
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, columnIdentityDB2v80.getMaxValue());
            }
            if (columnIdentityDB2v80.isCycle()) {
                this.appendComma(stringBuffer);
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 2);
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "CYCLE");
            }
            this.appendComma(stringBuffer);
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 2);
            if (columnIdentityDB2v80.getCache() == 0) {
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "NO");
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "CACHE");
            } else {
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "CACHE");
                this.appendStringWithSpace(stringBuffer, columnIdentityDB2v80.getCache());
            }
            if (columnIdentityDB2v80.getOrder().equalsIgnoreCase("YES")) {
                this.appendComma(stringBuffer);
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 2);
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "ORDER");
            }
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendFieldProcDefinition(StringBuffer stringBuffer, ColumnProxyDB2v80 columnProxyDB2v80) {
        String string;
        if (!(columnProxyDB2v80.getDefault() || (string = columnProxyDB2v80.getProgram()) == null || string.trim().equals("") || string.trim().equalsIgnoreCase("NULL"))) {
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "FIELDPROC");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, string);
            String string2 = columnProxyDB2v80.getConstant();
            if (string2 != null && !string2.trim().equals("") && !string2.trim().equalsIgnoreCase("NULL")) {
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, '(');
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, string2);
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendColumnConstraints(StringBuffer stringBuffer, Column column, ColumnProxyDB2 columnProxyDB2) {
        String string;
        if (column.hasConstraintsDefined() && !"".equals(string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxyDB2.getName())))) {
            String string2 = column.getConstraintName();
            if (!string2.equals("") && string2.length() <= 18 || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "CHECK");
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, '(');
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, string);
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, ')');
            }
            if ("".equals(string2) || !"".equals(string2) && string2.length() > 128 || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "CHECK");
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, '(');
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, string);
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendPKDefinition(StringBuffer stringBuffer, Table table, TableProxyDB2 tableProxyDB2, boolean bl) {
        int n;
        DesignObject[] designObjectArray;
        KeyObject keyObject = table.getPK();
        if (keyObject != null && keyObject.isMarkedGenerate() && (designObjectArray = (Column[])keyObject.getElements()).length > 0) {
            this.appendComma(stringBuffer);
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            if (tableProxyDB2 != null) {
                SSBTableDB2v80.appendString(stringBuffer, ' ');
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(keyObject.getName()));
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBTableDB2v80.appendString(stringBuffer, '(');
                for (n = 0; n < designObjectArray.length; ++n) {
                    if (n != 0) {
                        this.appendComma(stringBuffer);
                    }
                    SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
                    SSBTableDB2v80.appendString(stringBuffer, " " + this.storageDesign.getFormatedName(((ContainedObject)designObjectArray[n]).getName()));
                }
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBTableDB2v80.appendString(stringBuffer, ')');
            }
        }
        if ((designObjectArray = (Index[])table.getKeys()).length > 0) {
            for (n = 0; n < designObjectArray.length; ++n) {
                Column[] columnArray;
                DesignObject designObject = designObjectArray[n];
                if (!((Index)designObject).getIndexState().equalsIgnoreCase("Unique Constraint") || !designObject.isMarkedGenerate() || (columnArray = (Column[])((ContainerObject)designObject).getElements()).length <= 0) continue;
                this.appendComma(stringBuffer);
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(designObject.getName()));
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "UNIQUE");
                SSBTableDB2v80.appendString(stringBuffer, '(');
                for (int i = 0; i < columnArray.length; ++i) {
                    if (i != 0) {
                        this.appendComma(stringBuffer);
                    }
                    stringBuffer.append(this.storageDesign.getFormatedName(columnArray[i].getName()));
                }
                SSBTableDB2v80.appendString(stringBuffer, ')');
            }
        }
    }

    private void appendTableConstraintsDefinition(StringBuffer stringBuffer, Table table, boolean bl) {
        for (TableLevelConstraint tableLevelConstraint : table.getCheckConstraints()) {
            this.appendComma(stringBuffer);
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendString(stringBuffer, ' ');
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableLevelConstraint.getName()));
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableDB2v80.appendString(stringBuffer, '(');
            SSBTableDB2v80.appendString(stringBuffer, tableLevelConstraint.getRule());
            SSBTableDB2v80.appendString(stringBuffer, ')');
        }
    }

    private void appendMaterializedQuery(StringBuffer stringBuffer, Table table, TableProxyDB2v80 tableProxyDB2v80, boolean bl) {
        if (tableProxyDB2v80 != null) {
            Column[] columnArray = (Column[])table.getElements();
            Column column = null;
            ColumnProxyDB2v80 columnProxyDB2v80 = null;
            for (int i = 0; i < columnArray.length; ++i) {
                if (i == 0) {
                    SSBTableDB2v80.appendStringWithSpace(stringBuffer, '(');
                } else {
                    this.appendComma(stringBuffer);
                }
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
                column = columnArray[i];
                columnProxyDB2v80 = (ColumnProxyDB2v80)tableProxyDB2v80.getColumnProxy(column.getObjectID());
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyDB2v80.getName()));
            }
            if (columnArray.length > 0) {
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, ')');
            }
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "AS");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, '(');
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, tableProxyDB2v80.getMqQueryDefinition());
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, ')');
            if (tableProxyDB2v80.getMqStatus().equalsIgnoreCase(TableProxyDB2v80.MQ_STATUS_STATES[1])) {
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "WITH");
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "NO");
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "DATA");
                this.appendCopyOptions(stringBuffer, tableProxyDB2v80, bl);
            } else {
                this.appendRefreshableTableOptions(stringBuffer, tableProxyDB2v80, bl);
            }
        }
    }

    private void appendRefreshableTableOptions(StringBuffer stringBuffer, TableProxyDB2v80 tableProxyDB2v80, boolean bl) {
        SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, "DATA");
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, "INITIALLY");
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, "DEFERRED");
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, "DATA");
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, "REFRESH");
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, "DEFERRED");
        SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, "MAINTAINED");
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, tableProxyDB2v80.getMqMaintenance());
        SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, tableProxyDB2v80.getMqQueryOptimization());
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, "QUERY");
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, "OPTIMIZATION");
    }

    private void appendCopyOptions(StringBuffer stringBuffer, TableProxyDB2v80 tableProxyDB2v80, boolean bl) {
        if (tableProxyDB2v80.getMqIdentityColumnAttr().equalsIgnoreCase(TableProxyDB2v80.MQ_IDENTITY_COLUMN_ATTR_STATES[0])) {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "EXCLUDING");
        } else {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "INCLUDING");
        }
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, "IDENTITY");
    }

    private void appendInDb(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        DataBaseDB2 dataBaseDB2 = tableProxyDB2.getDataBase();
        TableSpaceDB2 tableSpaceDB2 = tableProxyDB2.getTableSpace();
        if (tableSpaceDB2 != null) {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "IN");
            if (dataBaseDB2 != null) {
                SSBTableDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(dataBaseDB2.getLongName()));
                SSBTableDB2v80.appendString(stringBuffer, '.');
            }
            SSBTableDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(tableSpaceDB2.getLongName()));
        } else if (dataBaseDB2 != null) {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "IN");
            SSBTableDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(dataBaseDB2.getLongName()));
        }
    }

    private void appendPartitioningClause(StringBuffer stringBuffer, TableProxyDB2v80 tableProxyDB2v80, boolean bl) {
        if (tableProxyDB2v80.getPartitioned().equalsIgnoreCase("YES")) {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "BY");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, '(');
            StringTokenizer stringTokenizer = new StringTokenizer(tableProxyDB2v80.getPartitioningKey().trim(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                ColumnProxy columnProxy;
                String string = stringTokenizer.nextToken();
                String string2 = null;
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
                if ((columnProxy = tableProxyDB2v80.getColumnProxy(string)) == null) continue;
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()));
                if (string2 != null) {
                    SSBTableDB2v80.appendStringWithSpace(stringBuffer, string2);
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                this.appendComma(stringBuffer);
            }
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, ')');
            this.appendPartitions(stringBuffer, tableProxyDB2v80, bl);
        }
    }

    protected void appendPartitions(StringBuffer stringBuffer, TableProxyDB2v80 tableProxyDB2v80, boolean bl) {
        SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, '(');
        TablePartitionDB2[] tablePartitionDB2Array = tableProxyDB2v80.getPartitions();
        for (int i = 0; i < tablePartitionDB2Array.length; ++i) {
            TablePartitionDB2 tablePartitionDB2 = tablePartitionDB2Array[i];
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "PARTITION");
            this.appendStringWithSpace(stringBuffer, tablePartitionDB2.getPartNumber());
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "ENDING");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, '(');
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, tablePartitionDB2.getPartConstants());
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, ')');
            if (i >= tablePartitionDB2Array.length - 1) continue;
            this.appendComma(stringBuffer);
        }
        SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBTableDB2v80.appendStringWithSpace(stringBuffer, ')');
    }

    private void appendEditProc(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (!tableProxyDB2.getEditProc().equalsIgnoreCase("")) {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "EDITPROC");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, tableProxyDB2.getEditProc());
        }
    }

    private void appendValidProc(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (!tableProxyDB2.getValidProc().equalsIgnoreCase("")) {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "VALIDPROC");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, tableProxyDB2.getValidProc());
        }
    }

    private void appendAudit(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (!tableProxyDB2.getAudit().equalsIgnoreCase("NONE")) {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "AUDIT");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, tableProxyDB2.getAudit());
        }
    }

    private void appendObid(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (tableProxyDB2.getObid() > 0) {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "OBID");
            this.appendStringWithSpace(stringBuffer, tableProxyDB2.getObid());
        }
    }

    private void appendDataCapture(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (tableProxyDB2.getDataCapture()) {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "DATA CAPTURE");
            if (tableProxyDB2.getDataCapture()) {
                SSBTableDB2v80.appendStringWithSpace(stringBuffer, "CHANGES");
            }
        }
    }

    private void appendWithRestrict(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (tableProxyDB2.getDropRestrict()) {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "WITH RESTRICT ON DROP");
        }
    }

    private void appendCcid(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (!tableProxyDB2.getCcsid().equalsIgnoreCase("")) {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "CCSID");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, tableProxyDB2.getCcsid());
        }
    }

    private void appendVolatile(StringBuffer stringBuffer, TableProxyDB2v80 tableProxyDB2v80, boolean bl) {
        if (tableProxyDB2v80.getTableAccess().equalsIgnoreCase("YES")) {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "VOLATILE");
        } else {
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "NOT");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "VOLATILE");
        }
    }

    private void appendLabelOn(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (!tableProxyDB2.getLabel().equalsIgnoreCase("")) {
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "LABEL");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "ON");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "TABLE");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyDB2.getLongName()));
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "IS");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "'" + tableProxyDB2.getLabel() + "'");
            this.appendLineFinisher(stringBuffer, bl);
        }
    }

    private void appendColumnCheckConstraints(StringBuffer stringBuffer, TableProxy tableProxy, boolean bl) {
        ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            Column column = columnProxy.getColumn();
            if (!column.hasConstraintsDefined()) continue;
            String string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName()));
            String string2 = column.getConstraintName();
            if ("".equals(string) || "".equals(string2) || string2.length() >= 129) continue;
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "ALTER");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "TABLE");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "ADD");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, '(');
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, string);
            SSBTableDB2v80.appendStringWithSpace(stringBuffer, ')');
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendTableCommentOn(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        int n;
        this.appendCommentOn(stringBuffer, tableProxyDB2, bl);
        ColumnProxy[] columnProxyArray = tableProxyDB2.getColumnProxies();
        ArrayList<ColumnProxy> arrayList = new ArrayList<ColumnProxy>();
        for (n = 0; n < columnProxyArray.length; ++n) {
            if (this.isNotEmpty(columnProxyArray[n].getObject().getCommentInRDBMS())) {
                arrayList.add(columnProxyArray[n]);
                continue;
            }
            if (!this.isNotEmpty(columnProxyArray[n].getCommentInRDBMS())) continue;
            arrayList.add(columnProxyArray[n]);
        }
        n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                stringBuffer.append("COMMENT ON ");
                stringBuffer.append(this.storageDesign.getFormatedName(tableProxyDB2.getLongName()));
                SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
                stringBuffer.append('(');
            } else {
                stringBuffer.append(", ");
            }
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            String string = "";
            string = columnProxyArray[i].isCommentInRDBMSChanged() ? columnProxyArray[i].getCommentInRDBMS() : columnProxyArray[i].getObject().getCommentInRDBMS();
            stringBuffer.append(this.storageDesign.getFormatedName(columnProxyArray[i].getName())).append(" IS ").append('\'').append(string).append('\'');
            if (i != n - 1) continue;
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            stringBuffer.append(")");
            SSBTableDB2v80.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
        }
    }

    private boolean hasAUXTables(TableProxyDB2 tableProxyDB2) {
        try {
            Iterator iterator = ((AbstractStorageDesignDB2)tableProxyDB2.getStorageDesign()).getAUXTableSet().iterator();
            while (iterator.hasNext()) {
                AUXTableDB2 aUXTableDB2 = (AUXTableDB2)iterator.next();
                if (!tableProxyDB2.getName().trim().equalsIgnoreCase(aUXTableDB2.getTable().getName())) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void appendIndexesForConstraints(StringBuffer stringBuffer, Table table, TableProxy tableProxy) {
        KeyObject[] keyObjectArray = table.getKeys();
        boolean bl = table.getDesign().getDLSettings().isAutomaticPKGeneration();
        boolean bl2 = table.getDesign().getDLSettings().isAutomaticUKGeneration();
        boolean bl3 = table.getDesign().getDLSettings().isAutomaticFKGeneration();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            Index index;
            ContainedObject[] containedObjectArray;
            Index index2 = (Index)keyObjectArray[i];
            if (!(bl && "Primary Constraint".equals(index2.getIndexState()) || bl2 && "Unique Constraint".equals(index2.getIndexState())) && (!index2.isFK() || !bl3) || (containedObjectArray = index2.getElements()).length <= 0 || (index = this.getIndexForColumns(table, index2, containedObjectArray, false)) != null) continue;
            this.ssbIndex.appendIndexForConstraint(stringBuffer, index2, tableProxy, true);
        }
    }

    private Index getIndexForColumns(Table table, Index index, ContainedObject[] containedObjectArray, boolean bl) {
        Object[] objectArray = table.getIndexes().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObjectPlaceHolder designObjectPlaceHolder = (DesignObjectPlaceHolder)objectArray[i];
            Index index2 = (Index)designObjectPlaceHolder.getDesignObject();
            ContainedObject[] containedObjectArray2 = index2.getElements();
            if (containedObjectArray.length != containedObjectArray2.length) continue;
            boolean bl2 = false;
            for (int j = 0; j < containedObjectArray.length; ++j) {
                String string;
                if (containedObjectArray[j] != containedObjectArray2[j]) {
                    bl2 = true;
                    break;
                }
                if (!bl || "ASC".equalsIgnoreCase(string = index2.getColumnSortOrder(containedObjectArray2[j]).trim()) || "".equalsIgnoreCase(string)) continue;
                bl2 = true;
                break;
            }
            if (bl2 || index2 == index) continue;
            return index2;
        }
        return null;
    }

    public SSBArcFK_CheckConstr getArcConstrHandler() {
        if (this.arcConstrHandler == null && this.storageDesign != null) {
            this.arcConstrHandler = new SSBArcFK_CheckConstr(this.storageDesign);
        }
        return this.arcConstrHandler;
    }
}

