/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBStorageGroupDB2v80
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof StorageGroupDB2 && ((StorageGroupDB2)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StorageGroupDB2 storageGroupDB2 = (StorageGroupDB2)object;
        if (!storageGroupDB2.isNullInstance()) {
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(object);
            if (storageGroupDB2.getVolumes() == null || "".equalsIgnoreCase(storageGroupDB2.getVolumes().trim())) {
                SSBStorageGroupDB2v80.appendNewLine(stringBuffer, bl, 0);
                stringBuffer.append("-- Warning - STOGROUP ");
                stringBuffer.append(this.storageDesign.getFormatedName(storageGroupDB2.getName()));
                stringBuffer.append(" has no volumes");
                SSBStorageGroupDB2v80.appendNewLine(stringBuffer, bl, 0);
                stringBuffer.append("-- Volumes are set to SMS managed ('*')");
                SSBStorageGroupDB2v80.appendNewLine(stringBuffer, bl, 0);
                stringBuffer.append("-- If the database is not SMS Managed");
                SSBStorageGroupDB2v80.appendNewLine(stringBuffer, bl, 0);
                stringBuffer.append("-- the volumes will not be accepted");
                SSBStorageGroupDB2v80.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, storageGroupDB2);
                this.appendCreate(stringBuffer);
                SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, "STOGROUP");
                SSBStorageGroupDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(storageGroupDB2.getLongName()));
                this.appendVolumes(stringBuffer, "'*'", bl);
                this.appendVCat(stringBuffer, storageGroupDB2, bl);
                SSBStorageGroupDB2v80.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
                DDLFileMaker.incrementCreateStoGroup();
                DDLFileMaker.incrementWarnings();
            } else {
                this.appendComment(stringBuffer, storageGroupDB2);
                this.appendCreate(stringBuffer);
                SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, "STOGROUP");
                SSBStorageGroupDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(storageGroupDB2.getLongName()));
                this.appendVolumes(stringBuffer, storageGroupDB2, bl);
                this.appendVCat(stringBuffer, storageGroupDB2, bl);
                SSBStorageGroupDB2v80.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
                DDLFileMaker.incrementCreateStoGroup();
                this.appendUsePrivileges(stringBuffer, storageGroupDB2, bl);
            }
        }
    }

    private void appendVolumes(StringBuffer stringBuffer, StorageGroupDB2 storageGroupDB2, boolean bl) {
        if (!"".equalsIgnoreCase(storageGroupDB2.getVolumes())) {
            SSBStorageGroupDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, "VOLUMES");
            SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, '(');
            if (storageGroupDB2.isSMSManaged()) {
                SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, storageGroupDB2.getAsteriskVolumes());
            } else {
                SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, storageGroupDB2.getVolumesNames());
            }
            SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendVolumes(StringBuffer stringBuffer, String string, boolean bl) {
        SSBStorageGroupDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, "VOLUMES");
        SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, '(');
        SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, string);
        SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, ')');
    }

    private void appendVCat(StringBuffer stringBuffer, StorageGroupDB2 storageGroupDB2, boolean bl) {
        if (storageGroupDB2.getVCat() != null) {
            SSBStorageGroupDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, "VCAT");
            SSBStorageGroupDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(storageGroupDB2.getVCat().getName()));
        }
    }

    private void appendUsePrivileges(StringBuffer stringBuffer, StorageGroupDB2 storageGroupDB2, boolean bl) {
        if (!storageGroupDB2.getUsers().equalsIgnoreCase("")) {
            SSBStorageGroupDB2v80.appendNewLine(stringBuffer, bl, 0);
            SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, "GRANT");
            SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, "USE");
            SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, "OF");
            SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, "STOGROUP");
            SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(storageGroupDB2.getName()));
            SSBStorageGroupDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, "TO");
            SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, storageGroupDB2.getUserNames());
            if ("YES".equalsIgnoreCase(storageGroupDB2.getGrantOption())) {
                SSBStorageGroupDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBStorageGroupDB2v80.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
            }
            SSBStorageGroupDB2v80.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            SSBStorageGroupDB2v80.appendNewLine(stringBuffer, bl, 0);
        }
    }
}

