/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.SequenceDB2v80;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSequenceDB2v80
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        SequenceDB2v80 sequenceDB2v80 = (SequenceDB2v80)object;
        this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(object);
        this.appendComment(stringBuffer, sequenceDB2v80);
        this.appendCreateSequnce(stringBuffer, sequenceDB2v80, bl);
        DDLFileMaker.incrementCreateSequence();
        SSBSequenceDB2v80.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        if (sequenceDB2v80.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(stringBuffer, sequenceDB2v80, bl);
        }
    }

    private void appendCommentOn(StringBuffer stringBuffer, SequenceDB2v80 sequenceDB2v80, boolean bl) {
        SSBSequenceDB2v80.appendNewLine(stringBuffer, bl, 0);
        SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "COMMENT ON");
        SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "SEQUENCE");
        SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(sequenceDB2v80.getLongName()));
        SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "IS");
        SSBSequenceDB2v80.appendString(stringBuffer, '\'');
        SSBSequenceDB2v80.appendString(stringBuffer, sequenceDB2v80.getCommentInRDBMS());
        SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, '\'');
        SSBSequenceDB2v80.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
    }

    private void appendCreateSequnce(StringBuffer stringBuffer, SequenceDB2v80 sequenceDB2v80, boolean bl) {
        SSBSequenceDB2v80.appendNewLine(stringBuffer, bl, 0);
        this.appendCreate(stringBuffer);
        SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "SEQUENCE");
        SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(sequenceDB2v80.getLongName()));
        SSBSequenceDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "AS");
        SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, sequenceDB2v80.getDatatype());
        SSBSequenceDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "START");
        SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "WITH");
        this.appendStringWithSpace(stringBuffer, sequenceDB2v80.getStartWith());
        if (sequenceDB2v80.getIncrementBy() != 1) {
            this.appendComma(stringBuffer);
            SSBSequenceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "INCREMENT");
            SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "BY");
            this.appendStringWithSpace(stringBuffer, sequenceDB2v80.getIncrementBy());
        }
        if (!"".equalsIgnoreCase(sequenceDB2v80.getMinValue().trim()) && !"NO".equalsIgnoreCase(sequenceDB2v80.getMinValue().trim())) {
            this.appendComma(stringBuffer);
            SSBSequenceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "MINVALUE");
            SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, sequenceDB2v80.getMinValue());
        }
        if (!"".equalsIgnoreCase(sequenceDB2v80.getMaxValue().trim()) && !"NO".equalsIgnoreCase(sequenceDB2v80.getMaxValue().trim())) {
            this.appendComma(stringBuffer);
            SSBSequenceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "MAXVALUE");
            SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, sequenceDB2v80.getMaxValue());
        }
        if (sequenceDB2v80.getCycle().trim().equalsIgnoreCase("YES")) {
            this.appendComma(stringBuffer);
            SSBSequenceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "CYCLE");
        }
        if (sequenceDB2v80.getCache() != 20) {
            this.appendComma(stringBuffer);
            SSBSequenceDB2v80.appendNewLine(stringBuffer, bl, 1);
            if (sequenceDB2v80.getCache() == 0) {
                SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "NO");
                SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "CACHE");
            } else {
                SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "CACHE");
                this.appendStringWithSpace(stringBuffer, sequenceDB2v80.getCache());
            }
        }
        if (sequenceDB2v80.getOrder().equalsIgnoreCase("YES")) {
            this.appendComma(stringBuffer);
            SSBSequenceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBSequenceDB2v80.appendStringWithSpace(stringBuffer, "ORDER");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SequenceDB2v80 && ((SequenceDB2v80)object).isMarkedGenerate();
    }
}

