/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDataBaseDB2v80
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;
    private static final String INDEX_BP = "INDEXBP";
    private static final String CCSID = "CCSID";

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DataBaseDB2 && ((DataBaseDB2)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        DataBaseDB2 dataBaseDB2 = (DataBaseDB2)object;
        if (!dataBaseDB2.isNullInstance()) {
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(object);
            this.appendComment(stringBuffer, dataBaseDB2);
            this.appendCreate(stringBuffer);
            SSBDataBaseDB2v80.appendStringWithSpace(stringBuffer, "DATABASE");
            SSBDataBaseDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(dataBaseDB2.getLongName()));
            this.appendBufferPool(stringBuffer, dataBaseDB2, bl);
            this.appendIndexBufferPool(stringBuffer, dataBaseDB2, bl);
            this.appendType(stringBuffer, dataBaseDB2, bl);
            this.appendStogroup(stringBuffer, dataBaseDB2, bl);
            this.appendCcsid(stringBuffer, dataBaseDB2, bl);
            SSBDataBaseDB2v80.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            DDLFileMaker.incrementCreateDatabase();
        }
    }

    protected void appendBufferPool(StringBuffer stringBuffer, DataBaseDB2 dataBaseDB2, boolean bl) {
        BufferPoolDB2 bufferPoolDB2 = dataBaseDB2.getBufferPool();
        if (bufferPoolDB2 != null) {
            SSBDataBaseDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseDB2v80.appendStringWithSpace(stringBuffer, "BUFFERPOOL");
            SSBDataBaseDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(bufferPoolDB2.getName()));
        }
    }

    protected void appendIndexBufferPool(StringBuffer stringBuffer, DataBaseDB2 dataBaseDB2, boolean bl) {
        BufferPoolDB2 bufferPoolDB2 = dataBaseDB2.getIndexBufferPool();
        if (bufferPoolDB2 != null) {
            SSBDataBaseDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseDB2v80.appendStringWithSpace(stringBuffer, INDEX_BP);
            SSBDataBaseDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(bufferPoolDB2.getName()));
        }
    }

    protected void appendType(StringBuffer stringBuffer, DataBaseDB2 dataBaseDB2, boolean bl) {
        if (!dataBaseDB2.getType().equalsIgnoreCase("USUAL")) {
            SSBDataBaseDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseDB2v80.appendStringWithSpace(stringBuffer, "AS");
            SSBDataBaseDB2v80.appendStringWithSpace(stringBuffer, dataBaseDB2.getType());
            if (!dataBaseDB2.getMember().trim().equalsIgnoreCase("")) {
                SSBDataBaseDB2v80.appendStringWithSpace(stringBuffer, "FOR");
                SSBDataBaseDB2v80.appendString(stringBuffer, dataBaseDB2.getMember());
            }
        }
    }

    protected void appendStogroup(StringBuffer stringBuffer, DataBaseDB2 dataBaseDB2, boolean bl) {
        StorageGroupDB2 storageGroupDB2 = dataBaseDB2.getStorageGroup();
        if (storageGroupDB2 != null) {
            SSBDataBaseDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseDB2v80.appendStringWithSpace(stringBuffer, "STOGROUP");
            SSBDataBaseDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(storageGroupDB2.getName()));
        }
    }

    protected void appendCcsid(StringBuffer stringBuffer, DataBaseDB2 dataBaseDB2, boolean bl) {
        String string = dataBaseDB2.getType();
        if (!(string.equalsIgnoreCase("WORKFILE") || string.equalsIgnoreCase("TEMP") || "".equalsIgnoreCase(dataBaseDB2.getCcsid()))) {
            SSBDataBaseDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseDB2v80.appendStringWithSpace(stringBuffer, CCSID);
            SSBDataBaseDB2v80.appendString(stringBuffer, dataBaseDB2.getCcsid());
        }
    }
}

