/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBAUXTableIndexDB2v80
extends SQLStatementBuilder {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof AUXTableIndexDB2 && ((AUXTableIndexDB2)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        AUXTableIndexDB2 aUXTableIndexDB2 = (AUXTableIndexDB2)object;
        this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(object);
        this.appendComment(stringBuffer, aUXTableIndexDB2);
        this.appendCreate(stringBuffer);
        this.appendUnique(stringBuffer, aUXTableIndexDB2);
        SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "INDEX");
        SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(aUXTableIndexDB2.getLongName()));
        this.appendTable(stringBuffer, aUXTableIndexDB2, bl);
        this.appendUsingBlock(stringBuffer, aUXTableIndexDB2.getStorageTemplate(), bl);
        this.appendFreeBlock(stringBuffer, aUXTableIndexDB2.getStorageTemplate(), bl);
        this.appendGbpCacheBlock(stringBuffer, aUXTableIndexDB2.getStorageTemplate(), bl);
        this.appendBufferPool(stringBuffer, aUXTableIndexDB2, bl);
        this.appendClose(stringBuffer, aUXTableIndexDB2, bl);
        this.appendCopy(stringBuffer, aUXTableIndexDB2, bl);
        this.appendPieceSize(stringBuffer, aUXTableIndexDB2, bl);
        SSBAUXTableIndexDB2v80.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        DDLFileMaker.incrementCreateIndex();
    }

    protected void appendUnique(StringBuffer stringBuffer, AUXTableIndexDB2 aUXTableIndexDB2) {
        if (aUXTableIndexDB2.isUnique()) {
            SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "UNIQUE");
        }
    }

    protected void appendTable(StringBuffer stringBuffer, AUXTableIndexDB2 aUXTableIndexDB2, boolean bl) {
        AUXTableDB2 aUXTableDB2 = aUXTableIndexDB2.getAuxTable();
        if (aUXTableDB2 != null) {
            SSBAUXTableIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "ON");
            SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(aUXTableDB2.getLongName()));
        }
    }

    protected void appendUsingBlock(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, boolean bl) {
        if (storageTemplateDB2 != null) {
            VCatDB2 vCatDB2 = storageTemplateDB2.getVCat();
            if (vCatDB2 != null) {
                SSBAUXTableIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
                SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "USING");
                SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "VCAT");
                SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(vCatDB2.getName()));
            } else {
                StorageGroupDB2 storageGroupDB2 = storageTemplateDB2.getStorageGroup();
                if (storageGroupDB2 != null) {
                    SSBAUXTableIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "USING");
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "STOGROUP");
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(storageGroupDB2.getLongName()));
                    SSBAUXTableIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "PRIQTY");
                    this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getSgPriqty());
                    SSBAUXTableIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "SECQTY");
                    this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getSgSeqty());
                    SSBAUXTableIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "ERASE");
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, storageTemplateDB2.isSgErase() ? "YES" : "NO");
                }
            }
        }
    }

    protected void appendFreeBlock(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, boolean bl) {
        if (storageTemplateDB2 != null) {
            if (storageTemplateDB2.getFreePage() > 0) {
                SSBAUXTableIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
                SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "FREEPAGE");
                this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getFreePage());
            }
            if (storageTemplateDB2.getPctFree() > 0) {
                SSBAUXTableIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
                SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "PCTFREE");
                this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getPctFree());
            }
        }
    }

    protected void appendGbpCacheBlock(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, boolean bl) {
        if (storageTemplateDB2 != null && !"".equalsIgnoreCase(storageTemplateDB2.getGbCache())) {
            SSBAUXTableIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "GBPCACHE");
            SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, storageTemplateDB2.getGbCache());
        }
    }

    protected void appendBufferPool(StringBuffer stringBuffer, AUXTableIndexDB2 aUXTableIndexDB2, boolean bl) {
        BufferPoolDB2 bufferPoolDB2 = aUXTableIndexDB2.getBufferPool();
        if (bufferPoolDB2 != null) {
            SSBAUXTableIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "BUFFERPOOL");
            SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(bufferPoolDB2.getLongName()));
        }
    }

    protected void appendClose(StringBuffer stringBuffer, AUXTableIndexDB2 aUXTableIndexDB2, boolean bl) {
        SSBAUXTableIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "CLOSE");
        SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, aUXTableIndexDB2.isClose() ? "YES" : "NO");
    }

    protected void appendCopy(StringBuffer stringBuffer, AUXTableIndexDB2 aUXTableIndexDB2, boolean bl) {
        SSBAUXTableIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "COPY");
        SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, aUXTableIndexDB2.isCopy() ? "YES" : "NO");
    }

    protected void appendPieceSize(StringBuffer stringBuffer, AUXTableIndexDB2 aUXTableIndexDB2, boolean bl) {
        if (!aUXTableIndexDB2.getPieceSize().equalsIgnoreCase("0")) {
            SSBAUXTableIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, "PIECESIZE");
            SSBAUXTableIndexDB2v80.appendStringWithSpace(stringBuffer, aUXTableIndexDB2.getPieceSize());
        }
    }
}

