/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.db2.v80.SSBAUXTableIndexDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBAUXTableDB2v80
extends SQLStatementBuilder {
    private AbstractStorageDesignDB2 storageDesign;
    private SSBAUXTableIndexDB2v80 ssbIndex = new SSBAUXTableIndexDB2v80();

    @Override
    public boolean canHandle(Object object) {
        return object instanceof AUXTableDB2 && ((AUXTableDB2)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        AUXTableDB2 aUXTableDB2 = (AUXTableDB2)object;
        this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(object);
        this.appendComment(stringBuffer, aUXTableDB2);
        this.appendSetCurrentRules(stringBuffer, bl);
        this.appendCreate(stringBuffer);
        SSBAUXTableDB2v80.appendStringWithSpace(stringBuffer, "AUX TABLE");
        SSBAUXTableDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(aUXTableDB2.getLongName()));
        this.appendIN(stringBuffer, aUXTableDB2, bl);
        this.appendStores(stringBuffer, aUXTableDB2, bl);
        SSBAUXTableDB2v80.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        DDLFileMaker.incrementCreateAuxTable();
        this.appendIndexes(stringBuffer, aUXTableDB2, bl);
    }

    private void appendSetCurrentRules(StringBuffer stringBuffer, boolean bl) {
        SSBAUXTableDB2v80.appendStringWithSpace(stringBuffer, "SET CURRENT RULES");
        SSBAUXTableDB2v80.appendStringWithSpace(stringBuffer, '=');
        SSBAUXTableDB2v80.appendString(stringBuffer, '\'');
        SSBAUXTableDB2v80.appendString(stringBuffer, "DB2");
        SSBAUXTableDB2v80.appendStringWithSpace(stringBuffer, '\'');
        this.appendLineFinisher(stringBuffer, bl);
    }

    private void appendIN(StringBuffer stringBuffer, AUXTableDB2 aUXTableDB2, boolean bl) {
        DataBaseDB2 dataBaseDB2 = aUXTableDB2.getDatabase();
        TableSpaceDB2 tableSpaceDB2 = aUXTableDB2.getTableSpace();
        if (tableSpaceDB2 != null) {
            SSBAUXTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBAUXTableDB2v80.appendStringWithSpace(stringBuffer, "IN");
            if (dataBaseDB2 != null) {
                SSBAUXTableDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(dataBaseDB2.getLongName()));
                SSBAUXTableDB2v80.appendString(stringBuffer, '.');
            }
            SSBAUXTableDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(tableSpaceDB2.getLongName()));
        }
    }

    private void appendStores(StringBuffer stringBuffer, AUXTableDB2 aUXTableDB2, boolean bl) {
        TableProxyDB2 tableProxyDB2 = aUXTableDB2.getTable();
        ColumnProxyDB2 columnProxyDB2 = aUXTableDB2.getColumn();
        if (tableProxyDB2 != null && columnProxyDB2 != null) {
            SSBAUXTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBAUXTableDB2v80.appendStringWithSpace(stringBuffer, "STORES");
            SSBAUXTableDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxyDB2.getLongName()));
            SSBAUXTableDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBAUXTableDB2v80.appendStringWithSpace(stringBuffer, "COLUMN");
            SSBAUXTableDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(columnProxyDB2.getName()));
            if (aUXTableDB2.getPartNumber() > 0) {
                SSBAUXTableDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBAUXTableDB2v80.appendStringWithSpace(stringBuffer, "PART");
                this.appendString(stringBuffer, aUXTableDB2.getPartNumber());
            }
        }
    }

    private void appendIndexes(StringBuffer stringBuffer, AUXTableDB2 aUXTableDB2, boolean bl) {
        for (Object e : aUXTableDB2.getAuxIndexes()) {
            if (!this.ssbIndex.canHandle(e)) continue;
            this.ssbIndex.doAppend(stringBuffer, e, bl);
        }
    }
}

