/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBViewDB2v70
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof TableView && ((TableView)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableViewProxyDB2 && ((TableViewProxyDB2)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        TableView tableView = null;
        TableViewProxyDB2 tableViewProxyDB2 = null;
        if (object instanceof TableView) {
            tableView = (TableView)object;
            if (this.getStorageDesign(tableView) instanceof AbstractStorageDesignDB2) {
                this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(tableView);
                tableViewProxyDB2 = (TableViewProxyDB2)this.storageDesign.getProxy(tableView);
            }
        } else {
            tableViewProxyDB2 = (TableViewProxyDB2)object;
            tableView = (TableView)tableViewProxyDB2.getObject();
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(tableView);
        }
        if (!tableView.isValidSQL()) {
            SSBViewDB2v70.appendStringWithSpace(stringBuffer, "--  ERROR: Invalid View " + tableView.getName());
            DDLFileMaker.incrementErrors();
            SSBViewDB2v70.appendNewLine(stringBuffer, bl, 0);
            SSBViewDB2v70.appendNewLine(stringBuffer, bl, 0);
            return;
        }
        if (tableViewProxyDB2 != null) {
            this.appendBeforeCreateScript(stringBuffer, bl, tableView);
            if (tableViewProxyDB2.isCommentChanged()) {
                this.appendComment(stringBuffer, tableViewProxyDB2);
            } else {
                this.appendComment(stringBuffer, tableView);
            }
            String string = tableViewProxyDB2.getDefinition();
            string = string.trim();
            if (string.endsWith(";")) {
                string = string.substring(0, string.length() - 1).trim();
            }
            if (!"".equalsIgnoreCase(string)) {
                int n;
                String string2 = "";
                boolean bl2 = false;
                if (Token.getFirstToken(string).equalsIgnoreCase("CREATE") && (n = string.toUpperCase().indexOf("VIEW")) > -1) {
                    int n2;
                    int n3;
                    string2 = string.substring(0, n + 4);
                    String string3 = (string = string.substring(n + 4).trim()).replaceAll("[\t\n\f\r\u000b]+", " ");
                    String string4 = Token.getFirstName(string3, '\"', '\"');
                    int n4 = string4.indexOf(40);
                    if (n4 > -1) {
                        string4 = string4.substring(0, n4);
                    }
                    if ((n3 = string4.indexOf(46)) > -1) {
                        string4 = string4.substring(n3 + 1);
                    }
                    if ((n2 = string.indexOf(string4, n3)) > -1 && (string = string.substring(n2 + string4.length())).startsWith("\"")) {
                        string = string.substring(1);
                    }
                    if ((string = string.trim()).toUpperCase().startsWith("AS")) {
                        string = string.substring(2).trim();
                    } else if (string.startsWith("(")) {
                        bl2 = true;
                    }
                }
                if (!Token.startsWithString(string2, "CREATE")) {
                    string2 = "CREATE VIEW";
                }
                String string5 = this.storageDesign.isOpen() ? tableViewProxyDB2.getLongName() : tableView.getLongName();
                string2 = string2 + ' ' + this.storageDesign.getFormatedName(string5);
                string = bl2 ? string2 + ' ' + string : string2 + ' ' + "AS" + NEWLINE + string;
                SSBViewDB2v70.appendStringWithSpace(stringBuffer, string);
                this.appendCheckOption(stringBuffer, tableViewProxyDB2, bl);
                SSBViewDB2v70.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
                DDLFileMaker.incrementCreateView();
                this.appendAfterCreateScript(stringBuffer, bl, tableView);
                if (tableView.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendViewCommentOn(this.storageDesign, stringBuffer, tableView, tableViewProxyDB2, bl);
                }
                this.appendLabelOn(stringBuffer, tableViewProxyDB2, bl);
            } else {
                SSBViewDB2v70.appendStringWithSpace(stringBuffer, "--  ERROR: Invalid View " + tableView.getName() + " with empty body");
                DDLFileMaker.incrementErrors();
            }
            SSBViewDB2v70.appendNewLine(stringBuffer, bl, 0);
            SSBViewDB2v70.appendNewLine(stringBuffer, bl, 0);
        } else {
            if (tableView.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendViewCommentOn(this.storageDesign, stringBuffer, tableView, tableViewProxyDB2, bl);
            }
            DDLFileMaker.incrementCreateView();
        }
    }

    protected String appendOwner(String string, TableViewProxyDB2 tableViewProxyDB2) {
        String string2 = string;
        String string3 = Token.getTokenAfter(string2, "VIEW");
        if (string3.indexOf(46) == -1 && tableViewProxyDB2.getOwner() != null && !tableViewProxyDB2.getOwner().getName().equalsIgnoreCase("[Implicit]")) {
            String string4 = this.storageDesign.getFormatedName(tableViewProxyDB2.getOwner().getName());
            string2 = this.appendOwner(string2, string3, string4);
        }
        return string2;
    }

    protected void appendCheckOption(StringBuffer stringBuffer, TableViewProxyDB2 tableViewProxyDB2, boolean bl) {
        String string;
        if (!tableViewProxyDB2.getDefinition().equalsIgnoreCase("") && tableViewProxyDB2.getCheckOption() && stringBuffer.indexOf(string = "WITH " + tableViewProxyDB2.getCheckOptionScope() + ' ' + "CHECK OPTION") == -1) {
            SSBViewDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBViewDB2v70.appendStringWithSpace(stringBuffer, string);
        }
    }

    private void appendLabelOn(StringBuffer stringBuffer, TableViewProxyDB2 tableViewProxyDB2, boolean bl) {
        if (!tableViewProxyDB2.getLabelOn().equalsIgnoreCase("")) {
            SSBViewDB2v70.appendStringWithSpace(stringBuffer, "LABEL");
            SSBViewDB2v70.appendStringWithSpace(stringBuffer, "ON");
            SSBViewDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableViewProxyDB2.getLongName()));
            SSBViewDB2v70.appendStringWithSpace(stringBuffer, "IS");
            SSBViewDB2v70.appendStringWithSpace(stringBuffer, "'" + tableViewProxyDB2.getLabelOn() + "'");
            this.appendLineFinisher(stringBuffer, bl);
        }
    }
}

