/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTriggerDB2v70
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        TriggerDB2 triggerDB2 = (TriggerDB2)object;
        this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(triggerDB2);
        this.appendComment(stringBuffer, triggerDB2);
        this.appendCreate(stringBuffer, triggerDB2);
        this.appendTriggeringTime(stringBuffer, triggerDB2, bl);
        this.appendAction(stringBuffer, triggerDB2);
        this.appendOnTable(stringBuffer, triggerDB2);
        this.appendReferencing(stringBuffer, triggerDB2, bl);
        this.appendScope(stringBuffer, triggerDB2, bl);
        this.appendCondition(stringBuffer, triggerDB2, bl);
        this.appendTriggeredAction(stringBuffer, triggerDB2, bl);
        SSBTriggerDB2v70.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        DDLFileMaker.incrementCreateTrigger();
        if (triggerDB2.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(stringBuffer, triggerDB2, bl);
        }
    }

    private void appendCommentOn(StringBuffer stringBuffer, TriggerDB2 triggerDB2, boolean bl) {
        SSBTriggerDB2v70.appendNewLine(stringBuffer, bl, 0);
        SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "COMMENT ON");
        SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "TRIGGER");
        SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(triggerDB2.getLongName()));
        SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "IS");
        SSBTriggerDB2v70.appendString(stringBuffer, '\'');
        SSBTriggerDB2v70.appendString(stringBuffer, triggerDB2.getCommentInRDBMS());
        SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, '\'');
        SSBTriggerDB2v70.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
    }

    private void appendCreate(StringBuffer stringBuffer, TriggerDB2 triggerDB2) {
        this.appendCreate(stringBuffer);
        SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "TRIGGER");
        if (triggerDB2.getOwner() != null) {
            SSBTriggerDB2v70.appendString(stringBuffer, this.storageDesign.getFormatedName(triggerDB2.getOwner().getName()));
            SSBTriggerDB2v70.appendString(stringBuffer, ".");
        }
        SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(triggerDB2.getName()));
    }

    private void appendTriggeringTime(StringBuffer stringBuffer, TriggerDB2 triggerDB2, boolean bl) {
        SSBTriggerDB2v70.appendNewLine(stringBuffer, bl, 1);
        SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, triggerDB2.getTriggerTime());
    }

    private void appendAction(StringBuffer stringBuffer, TriggerDB2 triggerDB2) {
        SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, triggerDB2.getActions());
        if (triggerDB2.getActions().equalsIgnoreCase(Trigger.ACTION_TYPES[1]) && !triggerDB2.getColumns().equalsIgnoreCase("")) {
            SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "OF");
            SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, triggerDB2.getColumns());
        }
    }

    private void appendOnTable(StringBuffer stringBuffer, TriggerDB2 triggerDB2) {
        SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "ON");
        SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(triggerDB2.getTable().getName()));
    }

    private void appendReferencing(StringBuffer stringBuffer, TriggerDB2 triggerDB2, boolean bl) {
        if (!(triggerDB2.getRef_NEW_AS().equalsIgnoreCase("") && triggerDB2.getRef_OLD_AS().equalsIgnoreCase("") && triggerDB2.getNEW_TABLE_AS().equalsIgnoreCase("") && triggerDB2.getOLD_TABLE_AS().equalsIgnoreCase(""))) {
            SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "REFERENCING");
            if (!triggerDB2.getRef_NEW_AS().equalsIgnoreCase("")) {
                SSBTriggerDB2v70.appendNewLine(stringBuffer, bl, 1);
                SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "NEW");
                SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "AS");
                SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, triggerDB2.getRef_NEW_AS());
            }
            if (!triggerDB2.getRef_OLD_AS().equalsIgnoreCase("")) {
                SSBTriggerDB2v70.appendNewLine(stringBuffer, bl, 1);
                SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "OLD");
                SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "AS");
                SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, triggerDB2.getRef_OLD_AS());
            }
            if (!triggerDB2.getOLD_TABLE_AS().equalsIgnoreCase("")) {
                SSBTriggerDB2v70.appendNewLine(stringBuffer, bl, 1);
                SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "OLD TABLE");
                SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "AS");
                SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, triggerDB2.getOLD_TABLE_AS());
            }
            if (!triggerDB2.getNEW_TABLE_AS().equalsIgnoreCase("")) {
                SSBTriggerDB2v70.appendNewLine(stringBuffer, bl, 1);
                SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "NEW TABLE");
                SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "AS");
                SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, triggerDB2.getNEW_TABLE_AS());
            }
        }
    }

    private void appendScope(StringBuffer stringBuffer, TriggerDB2 triggerDB2, boolean bl) {
        SSBTriggerDB2v70.appendNewLine(stringBuffer, bl, 1);
        SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, triggerDB2.getScope());
        if (triggerDB2.isScopeForEachRow()) {
            this.appendMode(stringBuffer);
        }
    }

    private void appendMode(StringBuffer stringBuffer) {
        SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "MODE DB2SQL");
    }

    private void appendCondition(StringBuffer stringBuffer, TriggerDB2 triggerDB2, boolean bl) {
        if (!triggerDB2.getCondition().equalsIgnoreCase("")) {
            SSBTriggerDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "WHEN");
            SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, '(');
            SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, triggerDB2.getCondition());
            SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendTriggeredAction(StringBuffer stringBuffer, TriggerDB2 triggerDB2, boolean bl) {
        SSBTriggerDB2v70.appendNewLine(stringBuffer, bl, 1);
        if (triggerDB2.getBody().equalsIgnoreCase("")) {
            SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, "-- Empty body");
        } else {
            SSBTriggerDB2v70.appendStringWithSpace(stringBuffer, triggerDB2.getBody());
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TriggerDB2 && ((TriggerDB2)object).isMarkedGenerate() && ((TriggerDB2)object).getTable() != null;
    }
}

