/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSynonymDB2v70
extends SQLStatementBuilder {
    private static final String SET_CURRENT_SQLID = "SET CURRENT SQLID";
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SynonymDB2 && ((SynonymDB2)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        SynonymDB2 synonymDB2;
        if (object instanceof SynonymDB2 && (synonymDB2 = (SynonymDB2)object) != null) {
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(synonymDB2);
            this.appendComment(stringBuffer, synonymDB2);
            if (synonymDB2.getOwner() != null) {
                if (!synonymDB2.getOwner().isNullInstance()) {
                    SSBSynonymDB2v70.appendStringWithSpace(stringBuffer, SET_CURRENT_SQLID);
                    SSBSynonymDB2v70.appendStringWithSpace(stringBuffer, "=");
                    stringBuffer.append(" '");
                    SSBSynonymDB2v70.appendString(stringBuffer, this.storageDesign.getFormatedName(synonymDB2.getOwner().getName()));
                    stringBuffer.append("'");
                    this.appendLineFinisher(stringBuffer, bl);
                } else {
                    SSBSynonymDB2v70.appendStringWithSpace(stringBuffer, SET_CURRENT_SQLID);
                    SSBSynonymDB2v70.appendStringWithSpace(stringBuffer, "= USER");
                    this.appendLineFinisher(stringBuffer, bl);
                }
            }
            this.appendCreate(stringBuffer);
            SSBSynonymDB2v70.appendStringWithSpace(stringBuffer, "SYNONYM");
            SSBSynonymDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(synonymDB2.getName()));
            SSBSynonymDB2v70.appendNewLine(stringBuffer, bl, 1);
            if (synonymDB2.getTable() != null) {
                SSBSynonymDB2v70.appendStringWithSpace(stringBuffer, "FOR");
                SSBSynonymDB2v70.appendString(stringBuffer, this.storageDesign.getFormatedName(synonymDB2.getTable().getLongName()));
            } else if (synonymDB2.getView() != null) {
                SSBSynonymDB2v70.appendStringWithSpace(stringBuffer, "FOR");
                SSBSynonymDB2v70.appendString(stringBuffer, this.storageDesign.getFormatedName(synonymDB2.getView().getLongName()));
            } else if (synonymDB2.getAlias() != null) {
                SSBSynonymDB2v70.appendStringWithSpace(stringBuffer, "FOR");
                SSBSynonymDB2v70.appendString(stringBuffer, this.storageDesign.getFormatedName(synonymDB2.getAlias().getLongName()));
            }
            SSBSynonymDB2v70.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            DDLFileMaker.incrementCreateSynomym();
        }
    }
}

