/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;

public class SSBDropView
extends SQLStatementBuilder {
    @Override
    public boolean canHandle(Object object) {
        if (object instanceof TableView && ((TableView)object).isDropEnabled()) {
            return true;
        }
        return object instanceof TableViewProxy && ((TableViewProxy)object).isDropEnabled();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StorageDesign storageDesign;
        StringBuffer stringBuffer2 = new StringBuffer();
        ModelIDObject modelIDObject = null;
        if (object == null) {
            return;
        }
        modelIDObject = (ModelIDObject)object;
        TableView tableView = null;
        if (object instanceof TableViewProxy) {
            storageDesign = ((TableViewProxy)object).getStorageDesign();
            tableView = (TableView)((TableViewProxy)object).getObject();
        } else {
            Design design = modelIDObject.getDesign();
            RDBMSSite rDBMSSite = modelIDObject.getSelectedRDBMSSite();
            storageDesign = design.getStorageDesign(rDBMSSite);
            tableView = (TableView)object;
        }
        this.appendBeforeDropScript(stringBuffer2, bl, tableView);
        this.appendDrop(stringBuffer2);
        SSBDropView.appendStringWithSpace(stringBuffer2, "VIEW");
        SSBDropView.appendStringWithSpace(stringBuffer2, storageDesign.getFormatedName(modelIDObject.getLongName()));
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        SSBDropView.appendNewLine(stringBuffer2, bl, 0);
        if (object instanceof TableViewProxyDB2 || object instanceof TableViewProxyUDB) {
            AbstractSSBDB2.appendLineFinisherUDB(stringBuffer2, bl);
        } else {
            this.appendLineFinisher(stringBuffer2, bl);
        }
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
    }
}

