/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;

public class SSBDropTable
extends SQLStatementBuilder {
    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isDropEnabled()) {
            return true;
        }
        return object instanceof TableProxy && ((TableProxy)object).isDropEnabled() && !((TableProxy)object).shouldBeDroppedIndirectly();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StorageDesign storageDesign;
        StringBuffer stringBuffer2 = new StringBuffer();
        ModelIDObject modelIDObject = null;
        if (object == null) {
            return;
        }
        modelIDObject = (ModelIDObject)object;
        Table table = null;
        TableProxy tableProxy = null;
        if (object instanceof TableProxy) {
            tableProxy = (TableProxy)modelIDObject;
            storageDesign = tableProxy.getStorageDesign();
            table = (Table)tableProxy.getObject();
        } else {
            Design design = modelIDObject.getDesign();
            RDBMSSite rDBMSSite = modelIDObject.getSelectedRDBMSSite();
            storageDesign = design.getStorageDesign(rDBMSSite);
            table = (Table)object;
        }
        this.appendBeforeDropScript(stringBuffer, bl, table);
        this.appendDrop(stringBuffer2);
        if (tableProxy instanceof TableProxyOracle && ((TableProxyOracle)tableProxy).getSnapshot() != null) {
            SSBDropTable.appendStringWithSpace(stringBuffer2, "MATERIALIZED VIEW");
        } else {
            SSBDropTable.appendStringWithSpace(stringBuffer2, "TABLE");
        }
        SSBDropTable.appendStringWithSpace(stringBuffer2, storageDesign.getFormatedName(modelIDObject.getLongName()));
        if (tableProxy instanceof TableProxyOracle) {
            SSBDropTable.appendStringWithSpace(stringBuffer2, "CASCADE CONSTRAINTS");
        }
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        SSBDropTable.appendNewLine(stringBuffer2, bl, 0);
        if (tableProxy instanceof TableProxyDB2 || tableProxy instanceof TableProxyUDB) {
            AbstractSSBDB2.appendLineFinisherUDB(stringBuffer2, bl);
        } else {
            this.appendLineFinisher(stringBuffer2, bl);
        }
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
    }
}

