/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;

public class SSBDropIndex
extends SQLStatementBuilder {
    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && !((Index)object).isFK() && ((Index)object).isDropEnabled() && !((Index)object).shouldBeDroppedIndirectly()) {
            return true;
        }
        return object instanceof IndexProxy && !((IndexProxy)object).getIndex().isFK() && ((IndexProxy)object).isDropEnabled() && !((IndexProxy)object).shouldBeDroppedIndirectly();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        ModelIDObject modelIDObject = null;
        if (object == null) {
            return;
        }
        if (object instanceof Index || object instanceof IndexProxy) {
            StorageDesign storageDesign;
            modelIDObject = (ModelIDObject)object;
            if (modelIDObject instanceof IndexProxy) {
                storageDesign = ((IndexProxy)modelIDObject).getStorageDesign();
            } else {
                Design design = modelIDObject.getDesign();
                RDBMSSite rDBMSSite = modelIDObject.getSelectedRDBMSSite();
                storageDesign = design.getStorageDesign(rDBMSSite);
            }
            this.appendDrop(stringBuffer2);
            SSBDropIndex.appendStringWithSpace(stringBuffer2, "INDEX");
            SSBDropIndex.appendStringWithSpace(stringBuffer2, storageDesign.getFormatedName(modelIDObject instanceof IndexProxyOracle ? ((IndexProxyOracle)modelIDObject).getUserNameAndName() : modelIDObject.getLongName()));
            this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
            SSBDropIndex.appendNewLine(stringBuffer2, bl, 0);
            if (object instanceof IndexProxyDB2 || object instanceof IndexProxyUDB) {
                AbstractSSBDB2.appendLineFinisherUDB(stringBuffer2, bl);
            } else {
                this.appendLineFinisher(stringBuffer2, bl);
            }
            this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        }
    }
}

