/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBDataBaseDB2v70;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBFKeyDB2v70;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBStorageGroupDB2v70;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBTableDB2v70;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBTableSpaceDB2v70;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBViewDB2v70;

public class DDLGenerator {
    public static final String TYPE_DROP_GEN = "DropGen";
    private String label = "Default";
    private SQLStatementBuilder first;

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    protected void initChainOfResponsibility() {
        this.append(new SSBTableDB2v70());
        this.append(new SSBFKeyDB2v70());
        this.append(new SSBDataBaseDB2v70());
        this.append(new SSBStorageGroupDB2v70());
        this.append(new SSBTableSpaceDB2v70());
        this.append(new SSBViewDB2v70());
    }

    public SQLStatementBuilder getFirst() {
        if (this.first == null) {
            this.initChainOfResponsibility();
        }
        return this.first;
    }

    public String getDDLFor(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendDDLFor(stringBuffer, object);
        return stringBuffer.toString();
    }

    public StringBuffer appendDDLFor(StringBuffer stringBuffer, Object object) {
        SQLStatementBuilder sQLStatementBuilder = this.getFirst();
        if (sQLStatementBuilder == null) {
            stringBuffer.append("DDL Generator not initialized");
        } else if (sQLStatementBuilder != null) {
            sQLStatementBuilder.appendTo(stringBuffer, object, true);
        }
        return stringBuffer;
    }

    public void append(SQLStatementBuilder sQLStatementBuilder) {
        if (this.first == null) {
            this.first = sQLStatementBuilder;
        } else {
            this.first.append(sQLStatementBuilder);
        }
        sQLStatementBuilder.setDDLGenerator(this);
    }

    public void clearTemporaryObjects() {
        for (SQLStatementBuilder sQLStatementBuilder = this.getFirst(); sQLStatementBuilder != null; sQLStatementBuilder = sQLStatementBuilder.getSuccessor()) {
            sQLStatementBuilder.clearTemporaryObjects();
        }
    }
}

