/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import oracle.dbtools.crest.exports.ddl.DDLException;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.util.exceptions.DDLExceptionList;

public class DDLAdvancedGenerator {
    private DDLExceptionList ddlExceptionList = null;
    private static final int STRING_LENGTH = 70;

    public void addAdvanceHeader(StringBuffer stringBuffer) {
        this.appendDescription(stringBuffer);
        stringBuffer.append("REM Package definition");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("CREATE OR REPLACE PACKAGE adv_scripting AS");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("TYPE masked_errors IS TABLE OF NUMBER INDEX BY BINARY_INTEGER;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" skip_errors masked_errors;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" start_step NUMBER;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" stop_step NUMBER;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" log_options NUMBER;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("/*");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" log_options := 1 - log executed steps only + status + errors");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("log_options := 2 - option 1 + comments ");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("log_options := 3 - option 1 + executed statement ");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" */");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" PROCEDURE EXEC_STATEMENT (");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("  current_step NUMBER,");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("  sql_statement VARCHAR2,");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("  comments VARCHAR2);");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" PROCEDURE INIT_STEPS(");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("  start_step_in NUMBER,");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("  stop_step_in NUMBER,");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("  log_option_in NUMBER);");
        stringBuffer.append(this.newline());
        stringBuffer.append("  PROCEDURE STOP_EXECUTION(tablename IN VARCHAR2);");
        stringBuffer.append(this.newline());
        stringBuffer.append("  FUNCTION GET_START_STEP RETURN NUMBER;");
        stringBuffer.append(this.newline());
        stringBuffer.append("  FUNCTION GET_STOP_STEP RETURN NUMBER;");
        stringBuffer.append(this.newline());
        stringBuffer.append("END adv_scripting;");
        stringBuffer.append(this.newline());
        stringBuffer.append("/");
        stringBuffer.append(this.newline());
        stringBuffer.append("REM Package body definition");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("CREATE OR REPLACE PACKAGE BODY adv_scripting AS");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("    FUNCTION GET_START_STEP RETURN NUMBER");
        stringBuffer.append(this.newline());
        stringBuffer.append(" IS");
        stringBuffer.append(this.newline());
        stringBuffer.append(" BEGIN");
        stringBuffer.append(this.newline());
        stringBuffer.append("  RETURN start_step;");
        stringBuffer.append(this.newline());
        stringBuffer.append(" END;");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("    FUNCTION GET_STOP_STEP RETURN NUMBER");
        stringBuffer.append(this.newline());
        stringBuffer.append(" IS");
        stringBuffer.append(this.newline());
        stringBuffer.append(" BEGIN");
        stringBuffer.append(this.newline());
        stringBuffer.append("  RETURN stop_step;");
        stringBuffer.append(this.newline());
        stringBuffer.append(" END;");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("    PROCEDURE STOP_EXECUTION(tablename IN VARCHAR2)");
        stringBuffer.append(this.newline());
        stringBuffer.append(" IS");
        stringBuffer.append(this.newline());
        stringBuffer.append("  msg varchar2(2000) := 'Script execution is interrupted because manual maintenance for table ';");
        stringBuffer.append(this.newline());
        stringBuffer.append("  BEGIN");
        stringBuffer.append(this.newline());
        stringBuffer.append("   DBMS_OUTPUT.PUT_LINE(msg||tablename||' is required');");
        stringBuffer.append(this.newline());
        stringBuffer.append("   raise_application_error(-20222,msg||tablename||' is required');");
        stringBuffer.append(this.newline());
        stringBuffer.append("  END;");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("PROCEDURE EXEC_STATEMENT (");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append(" current_step NUMBER,");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append(" sql_statement VARCHAR2,");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append(" comments VARCHAR2) IS");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" err_num NUMBER;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" err_msg VARCHAR2(250);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append(" out_msg VARCHAR2(1000);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append(" raise_again boolean;");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append(" error_fl boolean;");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append(" st_time VARCHAR2(25);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append(" end_time VARCHAR2(25);");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("  BEGIN");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" if current_step >= start_step and (stop_step=0 OR current_step <= stop_step) then");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("  raise_again := false;");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("  err_num:=0;");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("  error_fl:=false;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("  begin");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("st_time:= to_char(sysdate,'yyyymmdd hh24:mi:ss');");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("   execute immediate (sql_statement);");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("end_time:= to_char(sysdate,'yyyymmdd hh24:mi:ss');");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("  EXCEPTION");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("     WHEN OTHERS THEN");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("  err_num := SQLCODE;");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("  err_msg := SUBSTR(SQLERRM, 1, 250);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("end_time:= to_char(sysdate,'yyyymmdd hh24:mi:ss');");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("error_fl:=true;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" if err_num=0  then");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("  out_msg:=' Ok ';");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("elsif skip_errors.EXISTS(err_num) then");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append(" out_msg:= ' Masked error '|| err_num;");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("else ");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append(" raise_again := true;");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append(" out_msg:=' Error ' ||err_num;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" end if;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" DBMS_OUTPUT.PUT_LINE('Step '||current_step||out_msg||'  time: '||st_time||' - '||end_time);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if log_options = 2 then");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("  DBMS_OUTPUT.PUT_LINE( comments);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("elsif log_options = 3 then ");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" DBMS_OUTPUT.PUT_LINE( substr(sql_statement,1,250) );");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("end if;");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if err_num<>0 then");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("  DBMS_OUTPUT.PUT_LINE('');");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("  DBMS_OUTPUT.PUT_LINE(err_msg);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("end if;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" DBMS_OUTPUT.PUT_LINE('');");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" DBMS_OUTPUT.PUT_LINE('');");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if raise_again then");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append(" RAISE;");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("end if;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("end; ");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if not error_fl then");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("out_msg:=' Ok ';");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" DBMS_OUTPUT.PUT_LINE('Step '||current_step||out_msg||'  time: '||st_time||' - '||end_time);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if log_options = 2 then");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" DBMS_OUTPUT.PUT_LINE( comments);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("elsif log_options = 3 then ");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" DBMS_OUTPUT.PUT_LINE( substr(sql_statement,1,250) );");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("end if;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("DBMS_OUTPUT.PUT_LINE('');");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("DBMS_OUTPUT.PUT_LINE('');");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("end if;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("end if;");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("END;");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("PROCEDURE INIT_STEPS(");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("start_step_in NUMBER,");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("stop_step_in NUMBER,");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("log_option_in NUMBER) IS");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("BEGIN");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" start_step := start_step_in;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" stop_step := stop_step_in;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append(" log_options := log_option_in;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("END;");
        stringBuffer.append(this.newline());
        stringBuffer.append("BEGIN ");
        stringBuffer.append(this.newline());
        stringBuffer.append(" start_step :=0;");
        stringBuffer.append(this.newline());
        stringBuffer.append(" stop_step :=0;");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- dynamic settings - depends on log options set in Oracle SQL Developer Modeler");
        stringBuffer.append(this.newline());
        stringBuffer.append("log_options := 2;");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- dynamic settings - depends on list of errors to skip set in Oracle SQL Developer Modeler");
        this.appendDDLExceptionList(stringBuffer);
        stringBuffer.append(this.newline());
        stringBuffer.append("END adv_scripting;");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("/");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("-- static part");
        stringBuffer.append(this.newline());
        if (DDLGenerationOptions.getDDLType() == 1) {
            stringBuffer.append(this.newline());
            stringBuffer.append("define start_in = 0;");
            stringBuffer.append(this.newline());
            stringBuffer.append("define stop_in = 0;");
            stringBuffer.append(this.newline());
            stringBuffer.append("define log_option_in = 1;");
            stringBuffer.append(this.newline());
            stringBuffer.append(this.newline());
            stringBuffer.append("accept start_in NUMBER PROMPT 'Enter start step>'");
            stringBuffer.append(this.newline());
            stringBuffer.append(this.newline());
            stringBuffer.append("accept stop_in NUMBER PROMPT 'Enter stop step>'");
            stringBuffer.append(this.newline());
            stringBuffer.append(this.newline());
            stringBuffer.append("accept log_file PROMPT 'Enter log file>'");
            stringBuffer.append(this.newline());
            stringBuffer.append(this.newline());
            stringBuffer.append("PROMPT Enter log option :");
            stringBuffer.append(this.newline());
            stringBuffer.append("PROMPT log option := 1 - logs executed steps only + status + errors");
            stringBuffer.append(this.newline());
            stringBuffer.append("PROMPT log option := 2 - option 1 + comments");
            stringBuffer.append(this.newline());
            stringBuffer.append("PROMPT log option := 3 - option 1 + executed statement");
            stringBuffer.append(this.newline());
            stringBuffer.append("accept log_option_in NUMBER PROMPT 'Enter log option - 1,2 or 3>'");
            stringBuffer.append(this.newline());
        } else {
            stringBuffer.append(this.newline());
            stringBuffer.append("define start_in = &1;");
            stringBuffer.append(this.newline());
            stringBuffer.append("define stop_in = &2;");
            stringBuffer.append(this.newline());
            stringBuffer.append("define log_file = &3;");
            stringBuffer.append(this.newline());
            stringBuffer.append("define log_option_in = &4;");
            stringBuffer.append(this.newline());
        }
        stringBuffer.append(this.newline());
        stringBuffer.append("SET SERVEROUTPUT ON");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("SET SERVEROUTPUT ON FORMAT WRAP");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("set termout off");
        stringBuffer.append(this.newline());
        stringBuffer.append("set verify off");
        stringBuffer.append(this.newline());
        stringBuffer.append("set feedback off");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("begin");
        stringBuffer.append(this.newline());
        stringBuffer.append(" DBMS_OUTPUT.ENABLE(500000);");
        stringBuffer.append(this.newline());
        stringBuffer.append("end;");
        stringBuffer.append(this.newline());
        stringBuffer.append("/");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("execute adv_scripting.INIT_STEPS(&start_in,&stop_in,&log_option_in)");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("spool &log_file");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("WHENEVER SQLERROR EXIT 22 COMMIT");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
    }

    private void appendDDLExceptionList(StringBuffer stringBuffer) {
        if (this.getDDLExceptionList() != null) {
            for (DDLException dDLException : this.getDDLExceptionList().getDDLExceptions()) {
                if (!dDLException.isSelected()) continue;
                stringBuffer.append(this.newline());
                stringBuffer.append("--");
                String string = dDLException.getDescription();
                if (string.length() > 70) {
                    string = string.substring(0, 70);
                }
                stringBuffer.append(string);
                stringBuffer.append(this.newline());
                stringBuffer.append("skip_errors(").append(dDLException.getNumber()).append(")");
                stringBuffer.append(":=").append(dDLException.getNumber()).append(";");
            }
        }
    }

    public DDLExceptionList getDDLExceptionList() {
        return this.ddlExceptionList;
    }

    public void setDDLExceptionList(DDLExceptionList dDLExceptionList) {
        this.ddlExceptionList = dDLExceptionList;
    }

    public String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public String newTab() {
        return "    ";
    }

    public void addStatementFinisher(StringBuffer stringBuffer) {
        stringBuffer.append("spool off");
        stringBuffer.append(this.newline());
        if (DDLGenerationOptions.getDDLType() == 1) {
            stringBuffer.append("set termout on");
            stringBuffer.append(this.newline());
            stringBuffer.append("set verify on");
            stringBuffer.append(this.newline());
            stringBuffer.append("set feedback on");
            stringBuffer.append(this.newline());
        } else {
            stringBuffer.append("exit ;");
            stringBuffer.append(this.newline());
        }
    }

    public void unloadStatement(StringBuffer stringBuffer) {
        stringBuffer.append("CREATE OR REPLACE AND COMPILE JAVA SOURCE NAMED \"ODM_JAVA_SP\" AS");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.io.BufferedOutputStream;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.io.BufferedWriter;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.io.File;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.io.FileOutputStream;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.io.IOException;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.io.InputStream;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.io.OutputStream;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.io.OutputStreamWriter;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.io.Reader;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.io.Writer;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.sql.Connection;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.sql.ResultSet;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.sql.ResultSetMetaData;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.sql.SQLException;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.sql.Statement;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import java.sql.Types;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import oracle.jdbc.*;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import oracle.sql.BFILE;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import oracle.sql.OPAQUE;");
        stringBuffer.append(this.newline());
        stringBuffer.append("import oracle.xdb.XMLType;");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("public class ODM_JAVA_SP {");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("public static void save_to_file_01(String query, String fileName, int writeMode)");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("throws SQLException, IOException");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("{");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("File file = openFile(fileName, writeMode);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("Writer fout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)), 32768);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("Connection conn = null;");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("Statement stmt = null;");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("ResultSet rset = null;");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("try {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("int extraFileCount = 0;");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("OracleDriver ora = new OracleDriver();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("conn = ora.defaultConnection();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("stmt = conn.createStatement();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("rset = stmt.executeQuery(query);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("ResultSetMetaData rsmd = rset.getMetaData();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("int colCount = rsmd.getColumnCount();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("while ( rset.next() ) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("for ( int i = 1; i <= colCount; i++ ) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("int sqlType = rsmd.getColumnType(i);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if ((sqlType == Types.CHAR) || (sqlType == Types.VARCHAR)) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("String charString = rset.getString(i);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if (charString != null) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("charString = \"\\\"\" + charString.replaceAll(\"\\\"\", \"\\\"\\\"\") + \"\\\"\";");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("fout.write(charString);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("} else if (sqlType == Types.CLOB) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("Reader reader = rset.getCharacterStream(i);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if (reader != null) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("String clobFilePath = getExtraFilePath(fileName, ++extraFileCount, \"txt\");");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("File clobFile = openFile(clobFilePath, writeMode);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("Writer writer = new BufferedWriter(");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("new OutputStreamWriter(new FileOutputStream(clobFile)), 32768);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("int character = reader.read();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("while (character >= 0) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("writer.write(character);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("character = reader.read();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("reader.close();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("writer.close();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("fout.write(getFileName(clobFilePath));");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("} else if ((sqlType == Types.BLOB) ||");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("           (sqlType == OracleTypes.OPAQUE)) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("String ext = \"bin\";");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("InputStream inputStream = null;");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if (sqlType == OracleTypes.OPAQUE) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("ext = \"xml\";");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("OPAQUE opaque = ((OracleResultSet) rset).getOPAQUE(i);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if (opaque != null) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("XMLType xmlType = XMLType.createXML(opaque);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("inputStream = xmlType.getInputStream();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("} else {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("inputStream = rset.getBinaryStream(i);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if (inputStream != null) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("String blobFilePath = getExtraFilePath(fileName, ++extraFileCount, ext);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("File blobFile = openFile(blobFilePath, writeMode);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("OutputStream outputStream = new BufferedOutputStream(");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("     new FileOutputStream(blobFile), 32768);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("int dataByte = inputStream.read();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("while (dataByte >= 0) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("outputStream.write(dataByte);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("dataByte = inputStream.read();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("inputStream.close();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("outputStream.close();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("fout.write(getFileName(blobFilePath));");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("} else if (sqlType == OracleTypes.BFILE) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("BFILE bfile = ((OracleResultSet) rset).getBFILE(i);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if (bfile != null) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("fout.write(\"'\" + bfile.getDirAlias() + \"', '\"+ bfile.getName() + \"'\");");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("} else {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("String charString = rset.getString(i);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if (charString != null) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("fout.write(charString);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("fout.write(\"|\");");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("fout.write(\"|@*|\\r\\n\");");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("finally {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("    fout.close();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("    if(rset!=null) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("        rset.close();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("    }");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("    if(stmt!=null) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("        stmt.close();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("    }");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("    if(conn!=null) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("        conn.commit();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("        conn.close();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("    }");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("private static String getExtraFilePath(String baseFilePath, int extraFileNum, String extension)");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("{");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("int lastDot = baseFilePath.lastIndexOf('.');");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if (lastDot >= 0) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("baseFilePath = baseFilePath.substring(0, lastDot);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("return baseFilePath + '.' + extraFileNum + '.' + extension;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("private static String getFileName(String filePath)");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("{");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("int lastIndex = filePath.lastIndexOf('/');");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if (lastIndex >= 0) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("filePath = filePath.substring(lastIndex + 1);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("lastIndex = filePath.lastIndexOf('\\\\');");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if (lastIndex >= 0) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("filePath = filePath.substring(lastIndex + 1);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("lastIndex = filePath.lastIndexOf(':');");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if (lastIndex >= 0) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("filePath = filePath.substring(lastIndex + 1);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("return filePath;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("private static File openFile(String fileName, int writeMode)");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("{");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("File file = new File(fileName);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if (writeMode != 1) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("if (file.exists()) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("throw new RuntimeException(\"File \" + fileName + \" already exists\");");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("try {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("file.createNewFile();");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("} catch (IOException e) {");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("throw new RuntimeException(\"File \" + fileName + \" cannot be created \" + e);");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
        stringBuffer.append("return file;");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("}");
        stringBuffer.append(this.newline());
        stringBuffer.append("}");
        stringBuffer.append(this.newline());
        stringBuffer.append("/");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("create or replace procedure cwd_query_to_file( query in varchar2,file_name in varchar2, write_mode in number )");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("as");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("language java");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("name 'ODM_JAVA_SP.save_to_file_01( java.lang.String,java.lang.String,int)';");
        stringBuffer.append(this.newline());
        stringBuffer.append("/");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
    }

    private void appendDescription(StringBuffer stringBuffer) {
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("--  ODM advanced script with support for");
        stringBuffer.append(this.newline());
        if (DDLGenerationOptions.getDDLType() == 1) {
            stringBuffer.append("--  interactive (SQL/Plus or SQLDeveloper)");
        } else {
            stringBuffer.append("--  command line (SQL/Plus only)");
        }
        stringBuffer.append(this.newline());
        stringBuffer.append("--  settings of input parameters for:");
        stringBuffer.append(this.newline());
        stringBuffer.append("--  start step, stop step, log file and log level (1,2 or 3)");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- ");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- ");
        stringBuffer.append(this.newline());
        stringBuffer.append("--  In order to have this script successfully executed,");
        stringBuffer.append(this.newline());
        stringBuffer.append("--  the following grants should be given to the user");
        stringBuffer.append(this.newline());
        stringBuffer.append("--  that executes the script (SCOTT in the examples below):");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- ");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- grant connect, resource to SCOTT;");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- grant unlimited tablespace to SCOTT;");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- grant create any table to SCOTT;");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- grant create any trigger to SCOTT;");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- grant drop any table to SCOTT;");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- grant create view to SCOTT;");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- grant create sequence to SCOTT;");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- grant create snapshot to SCOTT;");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- grant QUERY REWRITE TO SCOTT;");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- grant create any directory to SCOTT;");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- grant drop any directory to SCOTT;");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- begin");
        stringBuffer.append(this.newline());
        stringBuffer.append("--  Dbms_Java.grant_Permission('SCOTT', 'java.io.FilePermission',");
        stringBuffer.append(this.newline());
        stringBuffer.append("--  '<<ALL FILES>>', 'read ,write, execute, delete');");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- end;");
        stringBuffer.append(this.newline());
        stringBuffer.append("-- /");
        stringBuffer.append(this.newline());
        if (DDLGenerationOptions.getDDLType() == 2) {
            stringBuffer.append(this.newline());
            stringBuffer.append("-- ");
            stringBuffer.append(this.newline());
            stringBuffer.append("-- ");
            stringBuffer.append(this.newline());
            stringBuffer.append("-- The script can be executed as follows (all parameters are required):");
            stringBuffer.append(this.newline());
            stringBuffer.append("--");
            stringBuffer.append(this.newline());
            stringBuffer.append("-- sqlplus user/passw@name @script_name start_step stop_st log_file log_level");
            stringBuffer.append(this.newline());
            stringBuffer.append("--");
            stringBuffer.append(this.newline());
            stringBuffer.append("-- Examples:");
            stringBuffer.append(this.newline());
            stringBuffer.append("--");
            stringBuffer.append(this.newline());
            stringBuffer.append("-- sqlplus scott/tiger@orcl @e:\\adv_script.sql 0 0 e:\\adv_script.log 2");
            stringBuffer.append(this.newline());
            stringBuffer.append("--");
            stringBuffer.append(this.newline());
            stringBuffer.append("-- the execution will start from the begining of the script");
            stringBuffer.append(this.newline());
            stringBuffer.append("-- and there is no restriction on step on which execution will stop");
            stringBuffer.append(this.newline());
            stringBuffer.append("--");
            stringBuffer.append(this.newline());
            stringBuffer.append("-- sqlplus scott/tiger@orcl @e:\\adv_script.sql 50 200 e:\\adv_script.log 1");
            stringBuffer.append(this.newline());
            stringBuffer.append("--");
            stringBuffer.append(this.newline());
            stringBuffer.append("-- all steps between 50 and 200 (including) will be executed");
            stringBuffer.append(this.newline());
        }
        stringBuffer.append("--");
        stringBuffer.append(this.newline());
    }
}

