/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.cubeviews;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.cubeviews.CVExportOptions;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class CubeViewsExporter {
    public static String EXPORT_FROM_LOGICAL = "Export From Logical";
    public static String EXPORT_FROM_RELATIONAL = "Export From Relational";
    public static String[] EXPORT_TYPE = new String[]{EXPORT_FROM_LOGICAL, EXPORT_FROM_RELATIONAL};
    private StringBuffer content = new StringBuffer();
    private ApplicationView appView;
    private static final Logger LOGGER = new Logger(CubeViewsExporter.class);
    private MultidimensionalDesign mdmDesign;
    private String schema = "CVSAMPLE";
    private String indent = "   ";
    private String exportType = EXPORT_FROM_LOGICAL;
    private Map processedAttributes = new TreeMap();
    private Map processedMeasures = new TreeMap();
    private Map attrMap = new TreeMap();
    private Map measuresMap = new TreeMap();
    private List sortedMeasures = new ArrayList();
    private List tracedMeasures = new ArrayList();
    private StorageDesign storDesign;
    private RelationalDesign physDesign;
    private Design design;
    List measureDependencies;
    boolean cyclicRef = false;

    public CubeViewsExporter(ApplicationView applicationView) {
        this.appView = applicationView;
        this.design = applicationView.getCurrentDesign();
    }

    public void export() {
        CVExportOptions cVExportOptions = new CVExportOptions(this.getApplicationView());
        boolean bl = cVExportOptions.showDialog();
        if (bl) {
            this.mdmDesign = cVExportOptions.getMultidimensionalDesign();
            this.schema = cVExportOptions.getSchema();
            this.storDesign = cVExportOptions.getStorageDesign();
            this.physDesign = cVExportOptions.getPhysicalDesign();
            if (this.mdmDesign != null) {
                this.prepareContent();
                this.saveOutput();
            }
        } else {
            ApplicationView.log(Messages.getString("CubeViewsExporter.ExportCanceled"));
        }
    }

    private void prepareContent() {
        this.addXMLVersion(this.content);
        this.addDBA4ALL_Title(this.content);
        this.addOlapBegin(this.content);
        this.addAttributes(this.content);
        this.addJoins(this.content);
        this.addLevels(this.content);
        this.addHierarchies(this.content);
        this.addDimensions(this.content);
        this.addMeasures(this.content);
        this.addFacts(this.content);
        this.addCubeModels(this.content);
        this.addOlapEnd(this.content);
    }

    private void addDBA4ALL_Title(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("<!-- ************************************************************************************** -->\n");
        stringBuffer.append("<!-- This file contains IBM Cube Views metadata generated by Oracle SQL Developer Modeler  -->\n");
        stringBuffer.append("<!-- After creating the database objects and enabling them for Cube Views,  \t\t\t\t-->\n");
        stringBuffer.append("<!-- you should then import this metadata XML file in IBM Cube Views v8.2   \t\t\t\t-->\n");
        stringBuffer.append("<!-- ************************************************************************************** -->\n");
    }

    private void addXMLVersion(StringBuffer stringBuffer) {
        stringBuffer.append(MDConfiguration.getDefaultInstance().get("xml.documenttype")).append("\n");
    }

    private void addOlapBegin(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("<olap:metadata xmlns:olap=\"http://www.ibm.com/olap\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" version=\"8.2.0.1.0\">\n");
    }

    private void addOlapEnd(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("</olap:metadata>\n");
    }

    private void addAttributes(StringBuffer stringBuffer) {
        Object object;
        AbstractMDObject abstractMDObject;
        stringBuffer.append("\n");
        stringBuffer.append("<!-- *********************** Attributes **************** -->\n");
        TreeMap<String, DesignObject> treeMap = new TreeMap<String, DesignObject>();
        Iterator iterator = this.mdmDesign.getLevelSet().iterator();
        while (iterator.hasNext()) {
            abstractMDObject = (Level)iterator.next();
            object = null;
            ContainerObject containerObject = ((Level)abstractMDObject).getLevelEntity();
            object = containerObject != null ? containerObject.getElementsCollection().iterator() : ((Level)abstractMDObject).getAllAttributes().iterator();
            while (object.hasNext()) {
                DesignObject designObject = (DesignObject)object.next();
                Object v = treeMap.get(this.getObjectId(designObject));
                if (v != null) continue;
                this.addAttribute(stringBuffer, designObject);
                treeMap.put(designObject.getObjectID(), designObject);
            }
        }
        iterator = this.mdmDesign.getCubeSet().iterator();
        while (iterator.hasNext()) {
            abstractMDObject = (Cube)iterator.next();
            object = ((Cube)abstractMDObject).getFactEntity();
            if (object == null) continue;
            for (DesignObject designObject : ((ContainerObject)object).getElementsCollection()) {
                this.addAttribute(stringBuffer, designObject);
            }
        }
    }

    private void addAttribute(StringBuffer stringBuffer, DesignObject designObject) {
        String string = designObject.getName();
        if (this.isProcessed(designObject)) {
            string = designObject instanceof Attribute ? string + " (" + ((Attribute)designObject).getContainerWithKeyObject().getName() + ")" : string + " (" + ((CalculatedAttribute)designObject).getLevel().getName() + ")";
        }
        this.processedAttributes.put(designObject.getName(), string);
        this.attrMap.put(this.getObjectId(designObject), string);
        String string2 = this.schema;
        stringBuffer.append(this.indent + "<attribute name=\"" + string + "\" schema=\"" + string2 + "\" businessName=\"" + designObject.getName() + "\">\n");
        this.addDataType(stringBuffer, designObject);
        this.addSQLExpression(stringBuffer, designObject);
        stringBuffer.append(this.indent + "</attribute>\n");
    }

    private void addJoins(StringBuffer stringBuffer) {
        AbstractMDObject abstractMDObject;
        stringBuffer.append("\n");
        stringBuffer.append("<!-- *********************** Joins **************** -->\n");
        Iterator iterator = this.mdmDesign.getDimensionSet().iterator();
        while (iterator.hasNext()) {
            abstractMDObject = (Dimension)iterator.next();
            for (AbstractMDObject abstractMDObject2 : ((Dimension)abstractMDObject).getAllLevels()) {
                for (Link link : abstractMDObject2.getOutgoingLinks()) {
                    if (link.getRollupLink() == null || link.getRollupLink().getChildToParentAttributes().size() <= 0) continue;
                    this.addJoin(stringBuffer, link);
                }
            }
        }
        iterator = this.mdmDesign.getCubeSet().iterator();
        while (iterator.hasNext()) {
            abstractMDObject = (Cube)iterator.next();
            for (AbstractMDObject abstractMDObject2 : abstractMDObject.getOutgoingLinks()) {
                if (((Link)abstractMDObject2).getRollupLink() == null || ((Link)abstractMDObject2).getRollupLink().getChildToParentAttributes().size() <= 0) continue;
                this.addJoin(stringBuffer, (Link)abstractMDObject2);
            }
        }
    }

    private void addJoin(StringBuffer stringBuffer, Link link) {
        String string = link.getName();
        String string2 = this.getSchema(link);
        RollupLink rollupLink = link.getRollupLink();
        Level level = null;
        if (link.getTargetMDObject() instanceof Dimension) {
            level = ((Dimension)link.getTargetMDObject()).getBaseLevel();
        } else if (link.getTargetMDObject() instanceof Level) {
            level = (Level)link.getTargetMDObject();
        }
        if (level != null && level.getLevelKey().size() == rollupLink.getChildToParentAttributes().size()) {
            stringBuffer.append(this.indent + "<join name=\"" + string + "\" schema=\"" + string2 + "\" businessName=\"" + string + "\" type=\"inner\" cardinality=\"n:1\">\n");
            List list = rollupLink.getChildToParentAttributes();
            for (int i = 0; i < list.size(); ++i) {
                DesignObject designObject = (DesignObject)list.get(i);
                ModelIDObject modelIDObject = this.getCorrespondentObject(designObject);
                String string3 = (String)this.attrMap.get(designObject.getObjectID());
                if (string3 == null) {
                    string3 = modelIDObject.getName();
                }
                DesignObject designObject2 = (DesignObject)level.getLevelKey().get(i);
                ModelIDObject modelIDObject2 = this.getCorrespondentObject(designObject2);
                String string4 = (String)this.attrMap.get(designObject2.getObjectID());
                String string5 = this.schema;
                String string6 = this.schema;
                if (string4 == null) {
                    string4 = modelIDObject2.getName();
                }
                if (string4 == null || string3 == null) continue;
                stringBuffer.append(this.indent + this.indent + "<attributeJoin operator=\"=\">\n");
                stringBuffer.append(this.indent + this.indent + this.indent + "<leftAttributeRef name=\"" + string3 + "\" schema=\"" + string5 + "\"/>\n");
                stringBuffer.append(this.indent + this.indent + this.indent + "<rightAttributeRef name=\"" + string4 + "\" schema=\"" + string6 + "\"/>\n");
                stringBuffer.append(this.indent + this.indent + "</attributeJoin>\n");
            }
            stringBuffer.append(this.indent + "</join>\n");
        }
    }

    private String getObjectId(ModelIDObject modelIDObject) {
        if (modelIDObject instanceof CalculatedAttribute) {
            return ((CalculatedAttribute)modelIDObject).getLevel().getName() + modelIDObject.getObjectID();
        }
        return modelIDObject.getObjectID();
    }

    private ContainerObject getEntity(DesignObject designObject) {
        if (designObject instanceof Attribute) {
            return ((ContainedObjectWithDomain)designObject).getContainerWithKeyObject();
        }
        if (designObject instanceof CalculatedAttribute) {
            return ((CalculatedAttribute)designObject).getLevel().getLevelEntity();
        }
        return null;
    }

    private void addSQLExpression(StringBuffer stringBuffer, DesignObject designObject) {
        if (designObject instanceof Attribute) {
            stringBuffer.append(this.indent + this.indent + "<sqlExpression template=\"{$$1}\">\n");
            ModelIDObject modelIDObject = this.getCorrespondentObject(designObject);
            String string = this.getSchema(designObject);
            String string2 = modelIDObject.getName();
            String string3 = this.getCorrespondentObject(this.getEntity(designObject)).getName();
            stringBuffer.append(this.indent + this.indent + this.indent + "<column name=\"" + string2 + "\" tableSchema=\"" + string + "\" tableName=\"" + string3 + "\"/>\n");
        } else if (designObject instanceof CalculatedAttribute) {
            String string;
            Object object;
            Level level = ((CalculatedAttribute)designObject).getLevel();
            String string4 = ((CalculatedAttribute)designObject).getFunction();
            List list = level.getAllAttributes();
            ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
            int n = 0;
            for (DesignObject designObject2 : list) {
                if (designObject2 == designObject || string4.indexOf((String)(object = "\"" + designObject2.getName().trim() + "\"")) <= -1) continue;
                string = "{$$" + Integer.toString(++n) + "}";
                arrayList.add(designObject2);
                string4 = this.replace(string4, (String)object, string);
            }
            if (n > 0) {
                string4 = StringUtilities.encodeAttributeValue(string4);
                stringBuffer.append(this.indent + this.indent + "<sqlExpression template=\"" + string4 + "\">\n");
                for (DesignObject designObject2 : arrayList) {
                    if (!(designObject2 instanceof Attribute)) continue;
                    object = this.getCorrespondentObject(designObject2);
                    string = this.getSchema(designObject2);
                    String string5 = ((ModelObject)object).getName();
                    String string6 = this.getCorrespondentObject(this.getEntity(designObject2)).getName();
                    stringBuffer.append(this.indent + this.indent + this.indent + "<column name=\"" + string5 + "\" tableSchema=\"" + string + "\" tableName=\"" + string6 + "\"/>\n");
                }
            }
        }
        stringBuffer.append(this.indent + this.indent + "</sqlExpression>\n");
    }

    private void addMeasureSQLExpression(StringBuffer stringBuffer, Measure measure) {
        String string;
        Object object;
        Collection collection;
        Cube cube = measure.getCube();
        String string2 = measure.getFormula();
        if (!measure.isFormula()) {
            if (measure.getMeasureFact() != null) {
                ContainedObject containedObject = measure.getMeasureFact();
                stringBuffer.append(this.indent + this.indent + "<sqlExpression template=\"{$$1}\">\n");
                ModelIDObject modelIDObject = this.getCorrespondentObject(containedObject);
                String string3 = this.getSchema(containedObject);
                String string4 = modelIDObject.getName();
                String string5 = this.getCorrespondentObject(this.getEntity(containedObject)).getName();
                stringBuffer.append(this.indent + this.indent + this.indent + "<column name=\"" + string4 + "\" tableSchema=\"" + string3 + "\" tableName=\"" + string5 + "\"/>\n");
                stringBuffer.append(this.indent + this.indent + "</sqlExpression>\n");
            }
            return;
        }
        int n = 0;
        ArrayList arrayList = new ArrayList();
        if (cube.getFactEntity() != null) {
            collection = cube.getFactEntity().getElementsCollection();
            for (Object object3 : collection) {
                String object22;
                if (object3 == measure || string2.indexOf(object22 = "\"" + ((DesignObject)object3).getName().trim() + "\"") <= -1) continue;
                object = "{$$" + Integer.toString(++n) + "}";
                arrayList.add(object3);
                string2 = this.replace(string2, object22, (String)object);
            }
        }
        collection = cube.getMeasures();
        ArrayList arrayList2 = new ArrayList();
        for (Measure measure2 : collection) {
            if (measure2 == measure || string2.indexOf((String)(object = "\"" + measure2.getName().trim() + "\"")) <= -1) continue;
            string = "{$$" + Integer.toString(++n) + "}";
            arrayList2.add(measure2);
            string2 = this.replace(string2, (String)object, string);
        }
        if (n > 0) {
            Object object3;
            string2 = StringUtilities.encodeAttributeValue(string2);
            stringBuffer.append(this.indent + this.indent + "<sqlExpression template=\"" + string2 + "\">\n");
            for (DesignObject designObject : arrayList) {
                if (!(designObject instanceof Attribute)) continue;
                object = this.getCorrespondentObject(designObject);
                string = this.getSchema(designObject);
                String string3 = ((ModelObject)object).getName();
                String string4 = this.getCorrespondentObject(this.getEntity(designObject)).getName();
                stringBuffer.append(this.indent + this.indent + this.indent + "<column name=\"" + string3 + "\" tableSchema=\"" + string + "\" tableName=\"" + string4 + "\"/>\n");
            }
            object3 = arrayList2.iterator();
            while (object3.hasNext()) {
                Measure measure3 = (Measure)object3.next();
                object = this.schema;
                string = measure3.getName();
                stringBuffer.append(this.indent + this.indent + this.indent + "<measureRef name=\"" + string + "\" schema=\"" + (String)object + "\"/>\n");
            }
        }
        stringBuffer.append(this.indent + this.indent + "</sqlExpression>\n");
    }

    private String replace(String string, String string2, String string3) {
        String string4 = string2.trim();
        String string5 = string;
        int n = string5.indexOf(string4);
        int n2 = string4.length();
        while (n > -1) {
            String string6 = n == 0 ? "" : string5.substring(0, n);
            int n3 = string6.length() + string3.length();
            string5 = string6 + string3 + string5.substring(n + n2);
            n = string5.indexOf(string4, n3);
        }
        return string5;
    }

    private ModelIDObject getCorrespondentObject(ModelIDObject modelIDObject) {
        if (this.storDesign != null) {
            Column column;
            if (modelIDObject instanceof Entity) {
                Table table = ((Entity)modelIDObject).getEngTable(this.physDesign);
                if (table != null) {
                    TableProxy tableProxy = (TableProxy)this.storDesign.getTableProxySet().getProxy(table.getObjectID());
                    return tableProxy;
                }
            } else if (modelIDObject instanceof Attribute && (column = ((Attribute)modelIDObject).getEngColumn(this.physDesign)) != null) {
                return this.storDesign.getColumnProxySet().getProxy(column.getObjectID());
            }
        } else {
            if (modelIDObject instanceof Entity) {
                Table table = ((Entity)modelIDObject).getEngTable(this.physDesign);
                if (table == null) {
                    return modelIDObject;
                }
                return table;
            }
            if (modelIDObject instanceof Attribute) {
                Column column = ((Attribute)modelIDObject).getEngColumn(this.physDesign);
                if (column == null) {
                    return modelIDObject;
                }
                return column;
            }
        }
        return modelIDObject;
    }

    private String getSchema(ModelIDObject modelIDObject) {
        StorageObject storageObject;
        ModelIDObject modelIDObject2;
        if (modelIDObject instanceof TableProxy) {
            StorageObject storageObject2 = ((TableProxy)modelIDObject).getUserSchema();
            if (storageObject2 != null) {
                return storageObject2.getName();
            }
        } else if (modelIDObject instanceof Entity) {
            StorageObject storageObject3;
            ModelIDObject modelIDObject3 = this.getCorrespondentObject(modelIDObject);
            if (modelIDObject3 instanceof TableProxy && (storageObject3 = ((TableProxy)modelIDObject3).getUserSchema()) != null) {
                return storageObject3.getName();
            }
        } else if (modelIDObject instanceof Attribute) {
            StorageObject storageObject4;
            ModelIDObject modelIDObject4 = this.getCorrespondentObject(((Attribute)modelIDObject).getContainerWithKeyObject());
            if (modelIDObject4 instanceof TableProxy && (storageObject4 = ((TableProxy)modelIDObject4).getUserSchema()) != null) {
                return storageObject4.getName();
            }
        } else if (modelIDObject instanceof CalculatedAttribute && (modelIDObject2 = this.getCorrespondentObject(((CalculatedAttribute)modelIDObject).getLevel().getLevelEntity())) instanceof TableProxy && (storageObject = ((TableProxy)modelIDObject2).getUserSchema()) != null) {
            return storageObject.getName();
        }
        return this.schema;
    }

    private boolean isProcessed(DesignObject designObject) {
        return this.processedAttributes.get(designObject.getName()) != null;
    }

    private void addLevels(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("<!-- *********************** Levels **************** -->\n");
        Iterator iterator = this.mdmDesign.getLevelSet().iterator();
        while (iterator.hasNext()) {
            Level level = (Level)iterator.next();
            this.addLevel(stringBuffer, level);
        }
    }

    private void addLevel(StringBuffer stringBuffer, Level level) {
        String string = level.getName();
        String string2 = this.getSchema(level);
        stringBuffer.append(this.indent + "<level name=\"" + string + "\" schema=\"" + string2 + "\" businessName=\"" + level.getName() + "\" funcDep=\"no\" funcDepName=\"\">\n");
        List list = level.getLevelKey();
        this.addAttributeRefs(stringBuffer, list, "levelKeyRef");
        DesignObject designObject = level.getDefaultAttribute();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(level.getDescriptiveAttributes());
        if (designObject != null) {
            arrayList.remove(designObject);
            ArrayList<DesignObject> arrayList2 = new ArrayList<DesignObject>();
            arrayList2.add(designObject);
            this.addAttributeRefs(stringBuffer, arrayList2, "defaultAttributeRef");
        } else if (arrayList.size() > 0) {
            designObject = (DesignObject)arrayList.get(0);
            arrayList.remove(designObject);
            ArrayList<DesignObject> arrayList3 = new ArrayList<DesignObject>();
            arrayList3.add(designObject);
            this.addAttributeRefs(stringBuffer, arrayList3, "defaultAttributeRef");
        } else if (level.getLevelKey().size() > 0) {
            designObject = (DesignObject)level.getLevelKey().get(0);
            ArrayList<DesignObject> arrayList4 = new ArrayList<DesignObject>();
            arrayList4.add(designObject);
            this.addAttributeRefs(stringBuffer, arrayList4, "defaultAttributeRef");
        }
        this.addAttributeRefs(stringBuffer, arrayList, "relatedAttributeRef");
        stringBuffer.append(this.indent + "</level>\n");
    }

    private void addAttributeRefs(StringBuffer stringBuffer, List list, String string) {
        for (DesignObject designObject : list) {
            ModelIDObject modelIDObject = this.getCorrespondentObject(designObject);
            String string2 = (String)this.attrMap.get(this.getObjectId(designObject));
            if (string2 == null) {
                string2 = modelIDObject.getName();
            }
            String string3 = this.schema;
            stringBuffer.append(this.indent + this.indent + "<" + string + " name=\"" + string2 + "\" schema=\"" + string3 + "\"/>\n");
        }
    }

    private void addObjectRefs(StringBuffer stringBuffer, List list, String string) {
        for (DesignObject designObject : list) {
            String string2 = designObject.getName();
            String string3 = this.getSchema(designObject);
            stringBuffer.append(this.indent + this.indent + "<" + string + " name=\"" + string2 + "\" schema=\"" + string3 + "\"/>\n");
        }
    }

    private void addHierarchies(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("<!-- *********************** Hierarchies **************** -->\n");
        Iterator iterator = this.mdmDesign.getHierarchySet().iterator();
        while (iterator.hasNext()) {
            Hierarchy hierarchy = (Hierarchy)iterator.next();
            this.addHierarchy(stringBuffer, hierarchy);
        }
    }

    private void addHierarchy(StringBuffer stringBuffer, Hierarchy hierarchy) {
        String string = hierarchy.getName();
        String string2 = this.getSchema(hierarchy);
        stringBuffer.append(this.indent + "<hierarchy name=\"" + string + "\" schema=\"" + string2 + "\" businessName=\"" + hierarchy.getName() + "\" type=\"balanced\" deployment=\"standard\">\n");
        List list = hierarchy.getLevels();
        this.addObjectRefs(stringBuffer, list, "levelRef");
        stringBuffer.append(this.indent + "</hierarchy>\n");
    }

    private void addDimensions(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("<!-- *********************** Dimensions **************** -->\n");
        Iterator iterator = this.mdmDesign.getDimensionSet().iterator();
        while (iterator.hasNext()) {
            Dimension dimension = (Dimension)iterator.next();
            this.addDimension(stringBuffer, dimension);
        }
    }

    private void addDimension(StringBuffer stringBuffer, Dimension dimension) {
        String string = dimension.getName();
        String string2 = this.getSchema(dimension);
        String string3 = "regular";
        if (dimension.isTimeDimension()) {
            string3 = "time";
        }
        stringBuffer.append(this.indent + "<dimension name=\"" + string + "\" schema=\"" + string2 + "\" businessName=\"" + dimension.getName() + "\" type=\"" + string3 + "\">\n");
        List list = dimension.getAllAttributes();
        this.addAttributeRefs(stringBuffer, list, "attributeRef");
        for (Level level : dimension.getAllLevels()) {
            for (Link link : level.getOutgoingLinks()) {
                if (link.getRollupLink() == null || link.getRollupLink().getChildToParentAttributes().size() <= 0) continue;
                this.addJoinRef(stringBuffer, link);
            }
        }
        list = new ArrayList();
        dimension.getHierarchies().addAllElementsTo(list);
        this.addObjectRefs(stringBuffer, list, "hierarchyRef");
        list = dimension.getAllLevels();
        this.addObjectRefs(stringBuffer, list, "levelRef");
        stringBuffer.append(this.indent + "</dimension>\n");
    }

    private void addJoinRef(StringBuffer stringBuffer, Link link) {
        String string = link.getName();
        String string2 = this.getSchema(link);
        stringBuffer.append(this.indent + this.indent + "<joinRef name=\"" + string + "\" schema=\"" + string2 + "\"/>\n");
    }

    private void addMeasures(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("<!-- *********************** Measures **************** -->\n");
        Iterator iterator = this.mdmDesign.getCubeSet().iterator();
        while (iterator.hasNext()) {
            Cube cube = (Cube)iterator.next();
            this.sortMeasures(cube.getMeasures());
            for (Measure measure : this.sortedMeasures) {
                this.addMeasure(stringBuffer, measure);
            }
        }
    }

    private void addMeasure(StringBuffer stringBuffer, Measure measure) {
        String string = measure.getName();
        if (this.processedMeasures.get(string) != null) {
            string = string + " (" + measure.getCube().getName() + ")";
        }
        this.processedMeasures.put(measure.getName(), string);
        this.measuresMap.put(measure.getObjectID(), string);
        String string2 = this.schema;
        stringBuffer.append(this.indent + "<measure name=\"" + string + "\" schema=\"" + string2 + "\" businessName=\"" + measure.getName() + "\">\n");
        this.addMeasureSQLExpression(stringBuffer, measure);
        this.addAggregations(stringBuffer, measure);
        stringBuffer.append(this.indent + "</measure>\n");
    }

    private void addAggregations(StringBuffer stringBuffer, Measure measure) {
        for (Measure.AggregateFunction aggregateFunction : measure.getAggregateFunctions()) {
            if ("".equalsIgnoreCase(aggregateFunction.name)) continue;
            stringBuffer.append(this.indent + this.indent + "<aggregation function=\"" + aggregateFunction.name + "\">\n");
            stringBuffer.append(this.indent + this.indent + "</aggregation>\n");
        }
    }

    private void addFacts(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("<!-- *********************** Facts **************** -->\n");
        Iterator iterator = this.mdmDesign.getCubeSet().iterator();
        while (iterator.hasNext()) {
            Cube cube = (Cube)iterator.next();
            this.addFact(stringBuffer, cube);
        }
    }

    private void addFact(StringBuffer stringBuffer, Cube cube) {
        String string = cube.getName();
        String string2 = this.getSchema(cube);
        stringBuffer.append(this.indent + "<facts name=\"" + string + "\" schema=\"" + string2 + "\" businessName=\"" + string + "\">\n");
        this.addMeasureRefs(stringBuffer, cube);
        this.addAttributeRefs(stringBuffer, this.getFKAttributes(cube), "attributeRef");
        stringBuffer.append(this.indent + "</facts>\n");
    }

    private List getFKAttributes(Cube cube) {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        if (cube.getFactEntity() != null) {
            for (Attribute attribute : cube.getFactEntity().getElementsCollection()) {
                if (!attribute.isFKAttribute()) continue;
                arrayList.add(attribute);
            }
        }
        return arrayList;
    }

    private void addCubeModels(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("<!-- *********************** CubeModels **************** -->\n");
        Iterator iterator = this.mdmDesign.getCubeSet().iterator();
        while (iterator.hasNext()) {
            Cube cube = (Cube)iterator.next();
            this.addCubeModel(stringBuffer, cube);
        }
    }

    private void addCubeModel(StringBuffer stringBuffer, Cube cube) {
        String string = cube.getName();
        String string2 = this.getSchema(cube);
        stringBuffer.append(this.indent + "<cubeModel name=\"" + string + "\" schema=\"" + string2 + "\" businessName=\"" + string + "\">\n");
        stringBuffer.append(this.indent + this.indent + "<factsRef name=\"" + string + "\" schema=\"" + string2 + "\"" + "/>\n");
        for (Dimension dimension : cube.getDimensions()) {
            string = dimension.getName();
            string2 = this.getSchema(dimension);
            stringBuffer.append(this.indent + this.indent + "<dimensionInfo>\n");
            stringBuffer.append(this.indent + this.indent + this.indent + "<dimensionRef name=\"" + string + "\" schema=\"" + string2 + "\"" + "/>\n");
            Link link = cube.getFirstLinkToTarget(dimension);
            if (link != null && link.getRollupLink() != null && link.getRollupLink().getChildToParentAttributes().size() > 0) {
                this.addJoinRef(stringBuffer, link);
            }
            stringBuffer.append(this.indent + this.indent + "</dimensionInfo>\n");
        }
        stringBuffer.append(this.indent + "</cubeModel>\n");
    }

    private void addMeasureRefs(StringBuffer stringBuffer, Cube cube) {
        for (Measure measure : cube.getMeasures()) {
            String string = measure.getName();
            if (this.measuresMap.get(measure.getObjectID()) != null) {
                string = (String)this.measuresMap.get(measure.getObjectID());
            }
            String string2 = this.schema;
            stringBuffer.append(this.indent + this.indent + "<measureRef name=\"" + string + "\" schema=\"" + string2 + "\"/>\n");
        }
    }

    private void addDataType(StringBuffer stringBuffer, DesignObject designObject) {
        MDDataType mDDataType = null;
        String string = "no";
        if (!(designObject instanceof Measure)) {
            if (designObject instanceof Attribute) {
                mDDataType = (MDDataType)((Attribute)designObject).getDataType("DB2/UDB 8.1");
                if (((Attribute)designObject).getNullsAllowed()) {
                    string = "yes";
                }
            } else if (designObject instanceof CalculatedAttribute) {
                // empty if block
            }
        }
        if (mDDataType != null) {
            String string2 = "0";
            String string3 = "0";
            String string4 = "SYSIBM";
            String string5 = mDDataType.getName();
            if (mDDataType.isPacked()) {
                string2 = String.valueOf(mDDataType.getPrecision());
                string3 = String.valueOf(mDDataType.getScale());
            } else {
                string2 = mDDataType.getSize();
            }
            stringBuffer.append(this.indent + this.indent + "<datatype schema=\"" + string4 + "\" name=\"" + string5 + "\" length=\"" + string2 + "\" scale=\"" + string3 + "\" nullable=\"" + string + "\"/>\n");
        }
    }

    public void saveOutput() {
        try {
            Object object;
            URLFilter uRLFilter = new URLFilter(){

                public boolean accept(URL uRL) {
                    File file = new File(uRL.getPath());
                    return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("CubeViewsExporter.XMLFiles");
                }
            };
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setSelectionScope(0);
            uRLChooser.setSelectionMode(0);
            uRLChooser.setShowJarsAsDirs(false);
            uRLChooser.setURLFilter(uRLFilter);
            String string = this.getApplicationView().getSettings().getDefaultSavePath();
            if (string != null) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
            } else {
                object = this.getApplicationView().getUserHomeDirectory();
                if (object != null) {
                    uRLChooser.setSelectedURL((URL)object);
                }
            }
            object = this.design.getName() + ".xml";
            uRLChooser.setFileNameURL((String)object);
            int n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("CubeViewsExporter.SaveToXMLFile"));
            if (n == 0) {
                File file = new File(uRLChooser.getSelectedURL().getPath());
                if (file != null && this.saveOutput(file)) {
                    ApplicationView.log(Messages.getString("CubeViewsExporter.ExportedOk"));
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CubeViewsExporter.ExportedOk"));
                } else {
                    ApplicationView.log(Messages.getString("CubeViewsExporter.ExportCanceled"));
                }
            } else {
                ApplicationView.log(Messages.getString("CubeViewsExporter.ExportCanceled"));
            }
        }
        catch (IOException iOException) {
            LOGGER.error("", iOException);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("CubeViewsExporter.CanNotWriteToFile"), iOException.getMessage()}, Messages.getString("CubeViewsExporter.WriteError"), 0);
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("CubeViewsExporter.UnexpectedError"), throwable.getMessage()}, Messages.getString("CubeViewsExporter.WriteError"), 0);
        }
    }

    private ApplicationView getApplicationView() {
        return this.appView;
    }

    protected boolean saveOutput(File file) throws IOException {
        int n;
        if (file.exists() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("CubeViewsExporter.FileExists"), file.getAbsolutePath()), Messages.getString("CubeViewsExporter.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
            return false;
        }
        file.getParentFile().mkdirs();
        file.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        outputStreamWriter.write(this.content.toString());
        outputStreamWriter.close();
        return true;
    }

    public void setTempStatusMessage(String string) {
        this.appView.setTempStatusMessage(string);
    }

    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    public String getExportType() {
        return this.exportType;
    }

    public void setExportType(String string) {
        this.exportType = string;
    }

    private List getMeasureDependencies(List list) {
        ArrayList<MeasureDependence> arrayList = new ArrayList<MeasureDependence>();
        for (Measure measure : list) {
            MeasureDependence measureDependence = new MeasureDependence(measure);
            if (!measure.isFormula()) {
                arrayList.add(measureDependence);
                continue;
            }
            String string = measure.getFormula();
            for (Measure measure2 : list) {
                String string2;
                if (measure2 == measure || string.indexOf(string2 = "\"" + measure2.getName().trim() + "\"") <= -1) continue;
                measureDependence.dependOn.add(measure2);
            }
            arrayList.add(measureDependence);
        }
        return arrayList;
    }

    private void sortMeasures(List list) {
        this.sortedMeasures.clear();
        this.tracedMeasures.clear();
        this.cyclicRef = false;
        this.measureDependencies = this.getMeasureDependencies(list);
        for (Measure measure : list) {
            this.addToSorted(measure);
            if (!this.cyclicRef) continue;
            return;
        }
    }

    private void addToSorted(Measure measure) {
        if (this.sortedMeasures.contains(measure)) {
            return;
        }
        MeasureDependence measureDependence = this.getMeasureDependence(measure, this.measureDependencies);
        if (measureDependence == null) {
            this.sortedMeasures.add(measure);
            this.tracedMeasures.add(measure);
            return;
        }
        if (measureDependence.dependOn.size() == 0) {
            this.sortedMeasures.add(measure);
            this.tracedMeasures.add(measure);
            return;
        }
        this.tracedMeasures.add(measure);
        for (Measure measure2 : measureDependence.dependOn) {
            if (this.tracedMeasures.contains(measure2) && !this.sortedMeasures.contains(measure2)) {
                this.cyclicRef = true;
                JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("CubeViewsExporter.CyclicReferenceForMeasure"), measure2.getCube().getName(), measure2.getName()), Messages.getString("CubeViewsExporter.TheListOfMeasuresWillNotBeComplete"), 0, 0, null, new String[]{Messages.getString("CubeViewsExporter.Ok")}, Messages.getString("CubeViewsExporter.Ok"));
                return;
            }
            if (this.sortedMeasures.contains(measure2)) continue;
            this.addToSorted(measure2);
            if (!this.cyclicRef) continue;
            return;
        }
        this.sortedMeasures.add(measure);
    }

    private MeasureDependence getMeasureDependence(Measure measure, List list) {
        for (MeasureDependence measureDependence : list) {
            if (measureDependence.measure != measure) continue;
            return measureDependence;
        }
        return null;
    }

    class MeasureDependence {
        Measure measure;
        List dependOn = new ArrayList();

        MeasureDependence(Measure measure) {
            this.measure = measure;
        }
    }
}

