/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.cubeviews;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.ide.Ide;

public class CVExportOptions
extends CustomDialog {
    private File logicalFile = null;
    private JDialog dialog;
    private boolean result;
    private DefaultListModel listModel;
    private static final int FIELD_WIDTH = 200;
    private static final int FIELD_HEIGHT = 20;
    private Dimension prefDimension = new Dimension(200, 20);
    private JTextField tfSchema;
    private JComboBox cbMDM;
    private JComboBox cbRelDes;
    private JComboBox cbStorage;
    private Design design;
    private RelationalDesign physicalDesign;
    private StorageDesign storageDesign;
    private MultidimensionalDesign multidimensionalDesign;
    private String schema = "";

    public CVExportOptions(ApplicationView applicationView) {
        super(applicationView);
        this.setLayout(new BorderLayout());
        this.result = false;
        this.design = this.getApplicationView().getCurrentDesign();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        JLabel jLabel = new JLabel(Messages.getString("CVExportOptions.DefaultSchema"));
        jLabel.setPreferredSize(this.prefDimension);
        jLabel.setToolTipText(Messages.getString("CVExportOptions.UsedForDimensionalObjectsAndTables"));
        this.tfSchema = new JTextField("");
        this.tfSchema.setPreferredSize(this.prefDimension);
        this.tfSchema.setToolTipText(Messages.getString("CVExportOptions.UsedForDimensionalObjectsAndTables"));
        JPanel jPanel3 = this.newRow(jLabel, this.tfSchema);
        jPanel2.add(jPanel3);
        MultidimensionalDesign multidimensionalDesign = this.design.getMultidimensionalDesign();
        JLabel jLabel2 = new JLabel(Messages.getString("CVExportOptions.DimensionalModel"));
        jLabel2.setPreferredSize(this.prefDimension);
        this.cbMDM = new JComboBox<Object>(this.design.getMultidimensionalDesigns().toArray());
        this.cbMDM.setFont(this.cbMDM.getFont().deriveFont(0));
        this.cbMDM.setPreferredSize(this.prefDimension);
        this.cbMDM.setSelectedItem(multidimensionalDesign);
        jPanel3 = this.newRow(jLabel2, this.cbMDM);
        jPanel2.add(jPanel3);
        JLabel jLabel3 = new JLabel(Messages.getString("CVExportOptions.RelationalModel"));
        ArrayList arrayList = new ArrayList();
        arrayList.add(null);
        this.design.getRelationalDesigns().addAllElementsTo(arrayList);
        jLabel3.setPreferredSize(this.prefDimension);
        this.cbRelDes = new JComboBox<Object>(arrayList.toArray());
        this.cbRelDes.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbRelDes.setPreferredSize(this.prefDimension);
        this.cbRelDes.setSelectedItem(null);
        jPanel3 = this.newRow(jLabel3, this.cbRelDes);
        jPanel2.add(jPanel3);
        JLabel jLabel4 = new JLabel(Messages.getString("CVExportOptions.PhysicalDB2UDBModel"));
        jLabel4.setPreferredSize(this.prefDimension);
        this.cbStorage = new JComboBox();
        this.cbStorage.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbStorage.setPreferredSize(this.prefDimension);
        this.cbStorage.setSelectedItem(null);
        jPanel3 = this.newRow(jLabel4, this.cbStorage);
        jPanel2.add(jPanel3);
        this.cbRelDes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = CVExportOptions.this.cbRelDes.getSelectedItem();
                if (object != null && object instanceof RelationalDesign) {
                    RelationalDesign relationalDesign = (RelationalDesign)object;
                    ArrayList<StorageDesign> arrayList = new ArrayList<StorageDesign>();
                    arrayList.add(null);
                    StorageDesign[] storageDesignArray = relationalDesign.getStorageDesignFactory().getOpenStorageDesigns();
                    for (int i = 0; i < storageDesignArray.length; ++i) {
                        StorageDesign storageDesign = storageDesignArray[i];
                        if (!(storageDesign instanceof StorageDesignUDB)) continue;
                        arrayList.add(storageDesign);
                    }
                    CVExportOptions.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                } else if (object == null) {
                    CVExportOptions.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
                }
            }
        });
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(Messages.getString("CVExportOptions.OK"));
        jButton.setMnemonic(79);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CVExportOptions.this.result = CVExportOptions.this.checkSettings();
                if (CVExportOptions.this.result) {
                    CVExportOptions.this.close();
                }
            }
        });
        jPanel4.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("CVExportOptions.Cancel"));
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CVExportOptions.this.result = false;
                CVExportOptions.this.close();
            }
        });
        jPanel4.add(jButton2);
        JButton jButton3 = new JButton(this.getHelpAction());
        jButton3.setMnemonic(72);
        jPanel4.add(jButton3);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "South");
        this.add(jPanel);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("CVExportOptions.CubeViewsMetadataExportOptions"));
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.setModal(true);
            this.dialog.pack();
            this.dialog.setResizable(false);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "EXPORT_CUBE_VIEWS_METADATA_DIALOG";
    }

    public boolean showDialog() {
        this.getDialog().setVisible(true);
        return this.result;
    }

    public File getLogicalFile() {
        return this.logicalFile;
    }

    public Object[] getRelationalFiles() {
        return this.listModel.toArray();
    }

    private boolean checkSettings() {
        this.schema = this.tfSchema.getText();
        if ("".equalsIgnoreCase(this.schema)) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CVExportOptions.SetDefaultSchema"), Messages.getString("CVExportOptions.Warning"), 2);
            return false;
        }
        this.physicalDesign = (RelationalDesign)this.cbRelDes.getSelectedItem();
        this.storageDesign = (StorageDesign)this.cbStorage.getSelectedItem();
        this.multidimensionalDesign = (MultidimensionalDesign)this.cbMDM.getSelectedItem();
        return true;
    }

    private JPanel newRow(JLabel jLabel, Component component) {
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(component);
        return jPanel;
    }

    public RelationalDesign getPhysicalDesign() {
        return this.physicalDesign;
    }

    public String getSchema() {
        return this.schema;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return this.multidimensionalDesign;
    }
}

