/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.List;
import oracle.dbtools.crest.exports.csv.CSVConstants;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.model.design.Design;

public abstract class ExportHandler
implements CSVConstants {
    private CSVExporter csvExporter;

    public ExportHandler(CSVExporter cSVExporter) {
        this.csvExporter = cSVExporter;
    }

    public abstract void Export();

    public abstract String getFileName();

    protected void saveToFile(List list) {
        try {
            File file = new File(this.csvExporter.getExportFolder(), this.getFileName());
            file.getParentFile().mkdirs();
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file)));
            for (String string : list) {
                printWriter.println(string);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CSVExporter getCsvExporter() {
        return this.csvExporter;
    }

    public Design getDesign() {
        return this.csvExporter.getDesign();
    }

    protected String quotedString(String string) {
        if (string != null && !"".equalsIgnoreCase(string)) {
            return "\"" + string + "\"";
        }
        return "";
    }

    protected String quotedIfHasSpatias(String string) {
        if (string != null && !"".equalsIgnoreCase(string)) {
            if (!string.equals(string.trim())) {
                return "'" + string + "'";
            }
            return string;
        }
        return "";
    }

    protected String replaceString(String string) {
        if (string != null && !"".equalsIgnoreCase(string)) {
            String string2 = string.replaceAll("[\n]", "|||");
            string2 = string2.replaceAll("[\r]", "|||");
            string2 = string2.replaceAll("[\"]", "''");
            return string2;
        }
        return "";
    }

    protected String replaceAndQuoteString(String string) {
        if (string != null && !"".equalsIgnoreCase(string)) {
            return "\"" + this.replaceString(string) + "\"";
        }
        return "";
    }
}

