/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;

public class EHValueRanges
extends ExportHandler {
    private List elements = new ArrayList();

    public EHValueRanges(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        Iterator iterator;
        Iterator iterator2;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DataElement_ID").append(",");
        stringBuffer.append("Num_DataElement_ID").append(",");
        stringBuffer.append("Type").append(",");
        stringBuffer.append("Sequence").append(",");
        stringBuffer.append("Begin_Value").append(",");
        stringBuffer.append("End_Value").append(",");
        stringBuffer.append("Short_Description").append(",");
        stringBuffer.append("Container_Name").append(",");
        stringBuffer.append("DataElement_Name");
        arrayList.add(stringBuffer.toString());
        LogicalDesign logicalDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logicalDesign)) {
            iterator2 = logicalDesign.getAttributeSet().iterator();
            while (iterator2.hasNext()) {
                this.elements.add(iterator2.next());
            }
        }
        iterator2 = this.getDesign().getRelationalDesigns().iterator();
        while (iterator2.hasNext()) {
            ModelIDObject modelIDObject = (RelationalDesign)iterator2.next();
            if (!this.getCsvExporter().isModelSelected((DesignPart)modelIDObject)) continue;
            iterator = ((RelationalDesign)modelIDObject).getColumnSet().iterator();
            while (iterator.hasNext()) {
                this.elements.add(iterator.next());
            }
        }
        for (ModelIDObject modelIDObject : this.elements) {
            iterator = ((ContainedObject)modelIDObject).getAVTs().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                ++n;
                AVT aVT = (AVT)iterator.next();
                stringBuffer = new StringBuffer();
                stringBuffer.append(modelIDObject.getObjectID()).append(",");
                stringBuffer.append(modelIDObject.getNumID()).append(",");
                if (modelIDObject instanceof Attribute) {
                    stringBuffer.append("Attribute").append(",");
                } else {
                    stringBuffer.append("Column").append(",");
                }
                stringBuffer.append(n).append(",");
                stringBuffer.append(this.quotedIfHasSpatias(aVT.getBeginValue())).append(",");
                stringBuffer.append(this.quotedIfHasSpatias(aVT.getEndValue())).append(",");
                stringBuffer.append(this.replaceAndQuoteString(aVT.getDescription())).append(",");
                stringBuffer.append(((ContainedObject)modelIDObject).getContainer().getName()).append(",");
                stringBuffer.append(((ContainedObject)modelIDObject).getName()).append(",");
                arrayList.add(stringBuffer.toString());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Value_Ranges.csv";
    }
}

